/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.sv;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;

public class TestSwedishAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new SwedishAnalyzer().close();
    }

    public void testBasics() throws IOException {
        SwedishAnalyzer a = new SwedishAnalyzer();
        TestSwedishAnalyzer.checkOneTerm((Analyzer)a, (String)"jaktkarlarne", (String)"jaktkarl");
        TestSwedishAnalyzer.checkOneTerm((Analyzer)a, (String)"jaktkarlens", (String)"jaktkarl");
        TestSwedishAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"och", (String[])new String[0]);
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestSwedishAnalyzer.asSet((Object[])new String[]{"jaktkarlarne"}), false);
        SwedishAnalyzer a = new SwedishAnalyzer(SwedishAnalyzer.getDefaultStopSet(), exclusionSet);
        TestSwedishAnalyzer.checkOneTerm((Analyzer)a, (String)"jaktkarlarne", (String)"jaktkarlarne");
        TestSwedishAnalyzer.checkOneTerm((Analyzer)a, (String)"jaktkarlens", (String)"jaktkarl");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        SwedishAnalyzer analyzer = new SwedishAnalyzer();
        TestSwedishAnalyzer.checkRandomData((Random)TestSwedishAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

