/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

public abstract class BaseSynonymParserTestCase
extends BaseTokenStreamTestCase {
    public static void assertEntryEquals(SynonymMap synonynMap, String word, boolean includeOrig, String[] synonyms) throws Exception {
        word = word.replace(' ', '\u0000');
        BytesRef value = (BytesRef)Util.get((FST)synonynMap.fst, (IntsRef)Util.toUTF32((CharSequence)new CharsRef(word), (IntsRefBuilder)new IntsRefBuilder()));
        BaseSynonymParserTestCase.assertNotNull((String)("No synonyms found for: " + word), (Object)value);
        ByteArrayDataInput bytesReader = new ByteArrayDataInput(value.bytes, value.offset, value.length);
        int code = bytesReader.readVInt();
        boolean keepOrig = (code & 1) == 0;
        BaseSynonymParserTestCase.assertEquals((String)("Include original different than expected. Expected " + includeOrig + " was " + keepOrig), (Object)includeOrig, (Object)keepOrig);
        int count = code >>> 1;
        BaseSynonymParserTestCase.assertEquals((String)("Invalid synonym count. Expected " + synonyms.length + " was " + count), (long)synonyms.length, (long)count);
        HashSet<String> synonymSet = new HashSet<String>(Arrays.asList(synonyms));
        BytesRef scratchBytes = new BytesRef();
        for (int i = 0; i < count; ++i) {
            synonynMap.words.get(bytesReader.readVInt(), scratchBytes);
            String synonym = scratchBytes.utf8ToString().replace('\u0000', ' ');
            BaseSynonymParserTestCase.assertTrue((String)("Unexpected synonym found: " + synonym), (boolean)synonymSet.contains(synonym));
        }
    }

    public static void assertEntryAbsent(SynonymMap synonynMap, String word) throws IOException {
        word = word.replace(' ', '\u0000');
        BytesRef value = (BytesRef)Util.get((FST)synonynMap.fst, (IntsRef)Util.toUTF32((CharSequence)new CharsRef(word), (IntsRefBuilder)new IntsRefBuilder()));
        BaseSynonymParserTestCase.assertNull((String)("There should be no synonyms for: " + word), (Object)value);
    }

    public static void assertEntryEquals(SynonymMap synonynMap, String word, boolean includeOrig, String synonym) throws Exception {
        BaseSynonymParserTestCase.assertEntryEquals(synonynMap, word, includeOrig, new String[]{synonym});
    }

    public static void assertAnalyzesToPositions(Analyzer a, String input, String[] output, String[] types, int[] posIncrements, int[] posLengths) throws IOException {
        BaseSynonymParserTestCase.assertAnalyzesTo((Analyzer)a, (String)input, (String[])output, null, null, (String[])types, (int[])posIncrements, (int[])posLengths);
    }
}

