/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.synonym.BaseSynonymParserTestCase;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;

public class TestSolrSynonymParser
extends BaseSynonymParserTestCase {
    public void testSimple() throws Exception {
        String testFile = "i-pod, ipod, ipoooood\nfoo => foo bar\nfoo => baz\nthis test, that testing";
        Object analyzer = new MockAnalyzer(TestSolrSynonymParser.random());
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        parser.parse((Reader)new StringReader(testFile));
        final SynonymMap map = parser.build();
        analyzer.close();
        analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, true);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSolrSynonymParser.assertAnalyzesTo((Analyzer)analyzer, (String)"ball", (String[])new String[]{"ball"}, (int[])new int[]{1});
        TestSolrSynonymParser.assertAnalyzesTo((Analyzer)analyzer, (String)"i-pod", (String[])new String[]{"i-pod", "ipod", "ipoooood"}, (int[])new int[]{1, 0, 0});
        TestSolrSynonymParser.assertAnalyzesTo((Analyzer)analyzer, (String)"foo", (String[])new String[]{"foo", "baz", "bar"}, (int[])new int[]{1, 0, 1});
        TestSolrSynonymParser.assertAnalyzesTo((Analyzer)analyzer, (String)"this test", (String[])new String[]{"this", "that", "test", "testing"}, (int[])new int[]{1, 0, 1, 0});
        analyzer.close();
    }

    public void testInvalidDoubleMap() throws Exception {
        String testFile = "a => b => c";
        MockAnalyzer analyzer = new MockAnalyzer(TestSolrSynonymParser.random());
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        TestSolrSynonymParser.expectThrows(ParseException.class, () -> parser.parse((Reader)new StringReader(testFile)));
        analyzer.close();
    }

    public void testInvalidAnalyzesToNothingOutput() throws Exception {
        String testFile = "a => 1";
        MockAnalyzer analyzer = new MockAnalyzer(TestSolrSynonymParser.random(), MockTokenizer.SIMPLE, false);
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        TestSolrSynonymParser.expectThrows(ParseException.class, () -> parser.parse((Reader)new StringReader(testFile)));
        analyzer.close();
    }

    public void testInvalidAnalyzesToNothingInput() throws Exception {
        String testFile = "1 => a";
        MockAnalyzer analyzer = new MockAnalyzer(TestSolrSynonymParser.random(), MockTokenizer.SIMPLE, false);
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        TestSolrSynonymParser.expectThrows(ParseException.class, () -> parser.parse((Reader)new StringReader(testFile)));
        analyzer.close();
    }

    public void testInvalidPositionsInput() throws Exception {
        String testFile = "testola => the test";
        EnglishAnalyzer analyzer = new EnglishAnalyzer();
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        TestSolrSynonymParser.expectThrows(ParseException.class, () -> parser.parse((Reader)new StringReader(testFile)));
        analyzer.close();
    }

    public void testInvalidPositionsOutput() throws Exception {
        String testFile = "the test => testola";
        EnglishAnalyzer analyzer = new EnglishAnalyzer();
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        TestSolrSynonymParser.expectThrows(ParseException.class, () -> parser.parse((Reader)new StringReader(testFile)));
        analyzer.close();
    }

    public void testEscapedStuff() throws Exception {
        String testFile = "a\\=>a => b\\=>b\na\\,a => b\\,b";
        Object analyzer = new MockAnalyzer(TestSolrSynonymParser.random(), MockTokenizer.KEYWORD, false);
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        parser.parse((Reader)new StringReader(testFile));
        final SynonymMap map = parser.build();
        analyzer.close();
        analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.KEYWORD, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, false));
            }
        };
        TestSolrSynonymParser.assertAnalyzesTo((Analyzer)analyzer, (String)"ball", (String[])new String[]{"ball"}, (int[])new int[]{1});
        TestSolrSynonymParser.assertAnalyzesTo((Analyzer)analyzer, (String)"a=>a", (String[])new String[]{"b=>b"}, (int[])new int[]{1});
        TestSolrSynonymParser.assertAnalyzesTo((Analyzer)analyzer, (String)"a,a", (String[])new String[]{"b,b"}, (int[])new int[]{1});
        analyzer.close();
    }

    public void testPositionLengthAndTypeSimple() throws Exception {
        String testFile = "spider man, spiderman";
        Object analyzer = new MockAnalyzer(TestSolrSynonymParser.random());
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        parser.parse((Reader)new StringReader(testFile));
        final SynonymMap map = parser.build();
        analyzer.close();
        analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, true);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSolrSynonymParser.assertAnalyzesToPositions((Analyzer)analyzer, "spider man", new String[]{"spider", "spiderman", "man"}, new String[]{"word", "SYNONYM", "word"}, new int[]{1, 0, 1}, new int[]{1, 2, 1});
    }

    public void testParseSimple() throws Exception {
        String testFile = "spider man, spiderman\nusa,united states,u s a,united states of america\nmystyped, mistyped => mistyped\nfoo => foo bar\nfoo => baz";
        MockAnalyzer analyzer = new MockAnalyzer(TestSolrSynonymParser.random());
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        parser.parse((Reader)new StringReader(testFile));
        SynonymMap map = parser.build();
        analyzer.close();
        TestSolrSynonymParser.assertEntryEquals(map, "spiderman", true, "spider man");
        TestSolrSynonymParser.assertEntryEquals(map, "spider man", true, "spiderman");
        TestSolrSynonymParser.assertEntryEquals(map, "usa", true, new String[]{"united states", "u s a", "united states of america"});
        TestSolrSynonymParser.assertEntryEquals(map, "united states", true, new String[]{"usa", "u s a", "united states of america"});
        TestSolrSynonymParser.assertEntryEquals(map, "u s a", true, new String[]{"usa", "united states", "united states of america"});
        TestSolrSynonymParser.assertEntryEquals(map, "united states of america", true, new String[]{"usa", "u s a", "united states"});
        TestSolrSynonymParser.assertEntryEquals(map, "mistyped", false, "mistyped");
        TestSolrSynonymParser.assertEntryEquals(map, "mystyped", false, "mistyped");
        TestSolrSynonymParser.assertEntryEquals(map, "foo", false, new String[]{"foo bar", "baz"});
        TestSolrSynonymParser.assertEntryAbsent(map, "baz");
        TestSolrSynonymParser.assertEntryAbsent(map, "bar");
    }
}

