/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.pattern.PatternTokenizerFactory;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;
import org.apache.lucene.analysis.util.StringMockResourceLoader;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.Version;

public class TestSynonymFilterFactory
extends BaseTokenStreamFactoryTestCase {
    static final String TOK_SYN_ARG_VAL = "argument";
    static final String TOK_FOO_ARG_VAL = "foofoofoo";

    private void checkSolrSynonyms(TokenFilterFactory factory) throws Exception {
        StringReader reader = new StringReader("GB");
        MockTokenizer stream = TestSynonymFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = factory.create((TokenStream)stream);
        TestSynonymFilterFactory.assertTrue((boolean)(stream instanceof SynonymFilter));
        TestSynonymFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"GB", "gib", "gigabyte", "gigabytes"}, (int[])new int[]{1, 0, 0, 0});
    }

    private void checkWordnetSynonyms(TokenFilterFactory factory) throws Exception {
        StringReader reader = new StringReader("second");
        MockTokenizer stream = TestSynonymFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = factory.create((TokenStream)stream);
        TestSynonymFilterFactory.assertTrue((boolean)(stream instanceof SynonymFilter));
        TestSynonymFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"second", "2nd", "two"}, (int[])new int[]{1, 0, 0});
    }

    public void testSynonyms() throws Exception {
        this.checkSolrSynonyms(this.tokenFilterFactory("Synonym", "synonyms", "synonyms.txt"));
    }

    public void testEmptySynonyms() throws Exception {
        StringReader reader = new StringReader("GB");
        MockTokenizer stream = TestSynonymFilterFactory.whitespaceMockTokenizer((Reader)reader);
        stream = this.tokenFilterFactory("Synonym", Version.LATEST, new StringMockResourceLoader(""), "synonyms", "synonyms.txt").create((TokenStream)stream);
        TestSynonymFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"GB"});
    }

    public void testFormat() throws Exception {
        this.checkSolrSynonyms(this.tokenFilterFactory("Synonym", "synonyms", "synonyms.txt", "format", "solr"));
        this.checkWordnetSynonyms(this.tokenFilterFactory("Synonym", "synonyms", "synonyms-wordnet.txt", "format", "wordnet"));
        this.checkSolrSynonyms(this.tokenFilterFactory("Synonym", "synonyms", "synonyms.txt", "format", SolrSynonymParser.class.getName()));
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestSynonymFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Synonym", "synonyms", "synonyms.txt", "bogusArg", "bogusValue"));
        TestSynonymFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }

    public void testAnalyzer() throws Exception {
        String analyzer = CJKAnalyzer.class.getName();
        String tokenizerFactory = PatternTokenizerFactory.class.getName();
        TokenFilterFactory factory = null;
        factory = this.tokenFilterFactory("Synonym", "synonyms", "synonyms2.txt", "analyzer", analyzer);
        TestSynonymFilterFactory.assertNotNull((Object)factory);
        IllegalArgumentException expected = (IllegalArgumentException)TestSynonymFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Synonym", "synonyms", "synonyms.txt", "analyzer", analyzer, "tokenizerFactory", tokenizerFactory));
        TestSynonymFilterFactory.assertTrue((boolean)expected.getMessage().contains("Analyzer and TokenizerFactory can't be specified both"));
    }

    public void testTokenizerFactoryArguments() throws Exception {
        String clazz = PatternTokenizerFactory.class.getName();
        TokenFilterFactory factory = null;
        factory = this.tokenFilterFactory("Synonym", "synonyms", "synonyms.txt", "tokenizerFactory", clazz, "pattern", "(.*)", "group", "0");
        TestSynonymFilterFactory.assertNotNull((Object)factory);
        factory = this.tokenFilterFactory("Synonym", "synonyms", "synonyms.txt", "tokenizerFactory", clazz, "tokenizerFactory.pattern", "(.*)", "tokenizerFactory.group", "0");
        TestSynonymFilterFactory.assertNotNull((Object)factory);
        TestSynonymFilterFactory.expectThrows(Exception.class, () -> this.tokenFilterFactory("Synonym", "synonyms", "synonyms.txt", "tokenizerFactory", clazz));
        TestSynonymFilterFactory.expectThrows(Exception.class, () -> this.tokenFilterFactory("Synonym", "synonyms", "synonyms.txt", "tokenizerFactory", clazz, "tokenizerFactory.pattern", "(.*)", "tokenizerFactory.bogusbogusbogus", "bogus", "tokenizerFactory.group", "0"));
    }
}

