/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockGraphTokenFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.FlattenGraphFilter;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymGraphFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.AutomatonTestUtil;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Util;

public class TestSynonymGraphFilter
extends BaseTokenStreamTestCase {
    private SynonymGraphFilter synFilter;
    private FlattenGraphFilter flattenFilter;

    public void testBasicKeepOrigOneOutput() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a b", (String[])new String[]{"c", "x", "a", "b"}, (int[])new int[]{0, 2, 2, 4}, (int[])new int[]{1, 5, 3, 5}, (String[])new String[]{"word", "SYNONYM", "word", "word"}, (int[])new int[]{1, 1, 0, 1}, (int[])new int[]{1, 2, 1, 1});
        a.close();
    }

    public void testMixedKeepOrig() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x", true);
        this.add(b, "e f", "y", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a b c e f g", (String[])new String[]{"c", "x", "a", "b", "c", "y", "g"}, (int[])new int[]{0, 2, 2, 4, 6, 8, 12}, (int[])new int[]{1, 5, 3, 5, 7, 11, 13}, (String[])new String[]{"word", "SYNONYM", "word", "word", "word", "SYNONYM", "word"}, (int[])new int[]{1, 1, 0, 1, 1, 1, 1}, (int[])new int[]{1, 2, 1, 1, 1, 1, 1});
        a.close();
    }

    public void testNoParseAfterBuffer() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "b a", "x", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"b b b", (String[])new String[]{"b", "b", "b"}, (int[])new int[]{0, 2, 4}, (int[])new int[]{1, 3, 5}, (String[])new String[]{"word", "word", "word"}, (int[])new int[]{1, 1, 1}, (int[])new int[]{1, 1, 1});
        a.close();
    }

    public void testOneInputMultipleOutputKeepOrig() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x", true);
        this.add(b, "a b", "y", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a b c", (String[])new String[]{"c", "x", "y", "a", "b", "c"}, (int[])new int[]{0, 2, 2, 2, 4, 6}, (int[])new int[]{1, 5, 5, 3, 5, 7}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "word", "word", "word"}, (int[])new int[]{1, 1, 0, 0, 1, 1, 1, 1}, (int[])new int[]{1, 2, 2, 1, 1, 1, 1, 1});
        a.close();
    }

    public void testPositionLengthAndTypeSimple() throws Exception {
        String testFile = "spider man, spiderman";
        Analyzer analyzer = this.solrSynsToAnalyzer(testFile);
        TestSynonymGraphFilter.assertAnalyzesToPositions((Analyzer)analyzer, (String)"spider man", (String[])new String[]{"spiderman", "spider", "man"}, (String[])new String[]{"SYNONYM", "word", "word"}, (int[])new int[]{1, 0, 1}, (int[])new int[]{2, 1, 1});
    }

    public void testEscapedStuff() throws Exception {
        String testFile = "a\\=>a => b\\=>b\na\\,a => b\\,b";
        Analyzer analyzer = this.solrSynsToAnalyzer(testFile);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"ball", (String[])new String[]{"ball"}, (int[])new int[]{1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"a=>a", (String[])new String[]{"b=>b"}, (int[])new int[]{1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"a,a", (String[])new String[]{"b,b"}, (int[])new int[]{1});
        analyzer.close();
    }

    public void testInvalidAnalyzesToNothingOutput() throws Exception {
        String testFile = "a => 1";
        MockAnalyzer analyzer = new MockAnalyzer(TestSynonymGraphFilter.random(), MockTokenizer.SIMPLE, false);
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        try {
            parser.parse((Reader)new StringReader(testFile));
            TestSynonymGraphFilter.fail((String)"didn't get expected exception");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        analyzer.close();
    }

    public void testInvalidDoubleMap() throws Exception {
        String testFile = "a => b => c";
        MockAnalyzer analyzer = new MockAnalyzer(TestSynonymGraphFilter.random());
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        try {
            parser.parse((Reader)new StringReader(testFile));
            TestSynonymGraphFilter.fail((String)"didn't get expected exception");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        analyzer.close();
    }

    public void testSimple() throws Exception {
        String testFile = "i-pod, ipod, ipoooood\nfoo => foo bar\nfoo => baz\nthis test, that testing";
        Analyzer analyzer = this.solrSynsToAnalyzer(testFile);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"ball", (String[])new String[]{"ball"}, (int[])new int[]{1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"i-pod", (String[])new String[]{"ipod", "ipoooood", "i-pod"}, (int[])new int[]{1, 0, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"foo", (String[])new String[]{"foo", "baz", "bar"}, (int[])new int[]{1, 0, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"this test", (String[])new String[]{"that", "this", "testing", "test"}, (int[])new int[]{1, 0, 1, 0});
        analyzer.close();
    }

    public void testBufferLength() throws Exception {
        String testFile = "c => 8 2 5 6 7\nf c e d f, 1\nc g a f d, 6 5 5\ne c => 4\ng => 5\na g b f e => 5 0 7 7\nb => 1";
        Analyzer analyzer = this.solrSynsToAnalyzer(testFile);
        String doc = "b c g a f b d";
        String[] expected = new String[]{"1", "8", "2", "5", "6", "7", "5", "a", "f", "1", "d"};
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)doc, (String[])expected);
    }

    private Analyzer solrSynsToAnalyzer(String syns) throws IOException, ParseException {
        MockAnalyzer analyzer = new MockAnalyzer(TestSynonymGraphFilter.random());
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        parser.parse((Reader)new StringReader(syns));
        analyzer.close();
        return this.getFlattenAnalyzer((SynonymMap.Builder)parser, true);
    }

    public void testMoreThanOneLookAhead() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b c d", "x", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a b c e", (String[])new String[]{"a", "b", "c", "e"}, (int[])new int[]{0, 2, 4, 6}, (int[])new int[]{1, 3, 5, 7}, (String[])new String[]{"word", "word", "word", "word"}, (int[])new int[]{1, 1, 1, 1}, (int[])new int[]{1, 1, 1, 1});
        a.close();
    }

    public void testLookaheadAfterParse() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "b b", "x", true);
        this.add(b, "b", "y", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"b a b b", (String[])new String[]{"y", "b", "a", "x", "b", "b"}, (int[])new int[]{0, 0, 2, 4, 4, 6}, (int[])new int[]{1, 1, 3, 7, 5, 7}, null, (int[])new int[]{1, 0, 1, 1, 0, 1}, (int[])new int[]{1, 1, 1, 2, 1, 1}, (boolean)true);
    }

    public void testLookaheadSecondParse() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "b b b", "x", true);
        this.add(b, "b", "y", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"b b", (String[])new String[]{"y", "b", "y", "b"}, (int[])new int[]{0, 0, 2, 2}, (int[])new int[]{1, 1, 3, 3}, null, (int[])new int[]{1, 0, 1, 0}, (int[])new int[]{1, 1, 1, 1}, (boolean)true);
    }

    public void testOneInputMultipleOutputNoKeepOrig() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x", false);
        this.add(b, "a b", "y", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a b c", (String[])new String[]{"c", "x", "y", "c"}, (int[])new int[]{0, 2, 2, 6}, (int[])new int[]{1, 5, 5, 7}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "word"}, (int[])new int[]{1, 1, 0, 1}, (int[])new int[]{1, 1, 1, 1});
        a.close();
    }

    public void testOneInputMultipleOutputMixedKeepOrig() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x", true);
        this.add(b, "a b", "y", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a b c", (String[])new String[]{"c", "x", "y", "a", "b", "c"}, (int[])new int[]{0, 2, 2, 2, 4, 6}, (int[])new int[]{1, 5, 5, 3, 5, 7}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "word", "word", "word"}, (int[])new int[]{1, 1, 0, 0, 1, 1, 1, 1}, (int[])new int[]{1, 2, 2, 1, 1, 1, 1, 1});
        a.close();
    }

    public void testSynAtEnd() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c d e a b", (String[])new String[]{"c", "d", "e", "x", "a", "b"}, (int[])new int[]{0, 2, 4, 6, 6, 8}, (int[])new int[]{1, 3, 5, 9, 7, 9}, (String[])new String[]{"word", "word", "word", "SYNONYM", "word", "word"}, (int[])new int[]{1, 1, 1, 1, 0, 1}, (int[])new int[]{1, 1, 1, 2, 1, 1});
        a.close();
    }

    public void testTwoSynsInARow() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a", "x", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a a b", (String[])new String[]{"c", "x", "x", "b"}, (int[])new int[]{0, 2, 4, 6}, (int[])new int[]{1, 3, 5, 7}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "word"}, (int[])new int[]{1, 1, 1, 1}, (int[])new int[]{1, 1, 1, 1});
        a.close();
    }

    public void testBasicKeepOrigTwoOutputs() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x y", true);
        this.add(b, "a b", "m n o", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a b d", (String[])new String[]{"c", "x", "m", "a", "y", "n", "o", "b", "d"}, (int[])new int[]{0, 2, 2, 2, 2, 2, 2, 4, 6}, (int[])new int[]{1, 5, 5, 3, 5, 5, 5, 5, 7}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "word", "SYNONYM", "SYNONYM", "SYNONYM", "word", "word"}, (int[])new int[]{1, 1, 0, 0, 1, 1, 1, 1, 1}, (int[])new int[]{1, 1, 2, 4, 4, 1, 2, 1, 1});
        a.close();
    }

    public void testNoCaptureIfNoMatch() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x y", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c d d", (String[])new String[]{"c", "d", "d"}, (int[])new int[]{0, 2, 4}, (int[])new int[]{1, 3, 5}, (String[])new String[]{"word", "word", "word"}, (int[])new int[]{1, 1, 1}, (int[])new int[]{1, 1, 1});
        TestSynonymGraphFilter.assertEquals((long)0L, (long)this.synFilter.getCaptureCount());
        a.close();
    }

    public void testBasicNotKeepOrigOneOutput() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a b", (String[])new String[]{"c", "x"}, (int[])new int[]{0, 2}, (int[])new int[]{1, 5}, (String[])new String[]{"word", "SYNONYM"}, (int[])new int[]{1, 1}, (int[])new int[]{1, 1});
        a.close();
    }

    public void testBasicNoKeepOrigTwoOutputs() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x y", false);
        this.add(b, "a b", "m n o", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a b d", (String[])new String[]{"c", "x", "m", "y", "n", "o", "d"}, (int[])new int[]{0, 2, 2, 2, 2, 2, 6}, (int[])new int[]{1, 5, 5, 5, 5, 5, 7}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "SYNONYM", "SYNONYM", "SYNONYM", "word"}, (int[])new int[]{1, 1, 0, 1, 1, 1, 1}, (int[])new int[]{1, 1, 2, 3, 1, 1, 1});
        a.close();
    }

    public void testIgnoreCase() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x y", false);
        this.add(b, "a b", "m n o", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c A B D", (String[])new String[]{"c", "x", "m", "y", "n", "o", "D"}, (int[])new int[]{0, 2, 2, 2, 2, 2, 6}, (int[])new int[]{1, 5, 5, 5, 5, 5, 7}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "SYNONYM", "SYNONYM", "SYNONYM", "word"}, (int[])new int[]{1, 1, 0, 1, 1, 1, 1}, (int[])new int[]{1, 1, 2, 3, 1, 1, 1});
        a.close();
    }

    public void testDoNotIgnoreCase() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x y", false);
        this.add(b, "a b", "m n o", false);
        Analyzer a = this.getAnalyzer(b, false);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c A B D", (String[])new String[]{"c", "A", "B", "D"}, (int[])new int[]{0, 2, 4, 6}, (int[])new int[]{1, 3, 5, 7}, (String[])new String[]{"word", "word", "word", "word"}, (int[])new int[]{1, 1, 1, 1}, (int[])new int[]{1, 1, 1, 1});
        a.close();
    }

    public void testBufferedFinish1() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b c", "m n o", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a b", (String[])new String[]{"c", "a", "b"}, (int[])new int[]{0, 2, 4}, (int[])new int[]{1, 3, 5}, (String[])new String[]{"word", "word", "word"}, (int[])new int[]{1, 1, 1}, (int[])new int[]{1, 1, 1});
        a.close();
    }

    public void testBufferedFinish2() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "m n o", false);
        this.add(b, "d e", "m n o", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a d", (String[])new String[]{"c", "a", "d"}, (int[])new int[]{0, 2, 4}, (int[])new int[]{1, 3, 5}, (String[])new String[]{"word", "word", "word"}, (int[])new int[]{1, 1, 1}, (int[])new int[]{1, 1, 1});
        a.close();
    }

    public void testCanReuse() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b", "x", true);
        Analyzer a = this.getAnalyzer(b, true);
        for (int i = 0; i < 10; ++i) {
            TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c a b", (String[])new String[]{"c", "x", "a", "b"}, (int[])new int[]{0, 2, 2, 4}, (int[])new int[]{1, 5, 3, 5}, (String[])new String[]{"word", "SYNONYM", "word", "word"}, (int[])new int[]{1, 1, 0, 1}, (int[])new int[]{1, 2, 1, 1});
        }
        a.close();
    }

    public void testManyToOne() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b c", "z", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a b c d", (String[])new String[]{"z", "a", "b", "c", "d"}, (int[])new int[]{0, 0, 2, 4, 6}, (int[])new int[]{5, 1, 3, 5, 7}, (String[])new String[]{"SYNONYM", "word", "word", "word", "word"}, (int[])new int[]{1, 0, 1, 1, 1}, (int[])new int[]{3, 1, 1, 1, 1});
        a.close();
    }

    public void testBufferAfterMatch() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "a b c d", "x", true);
        this.add(b, "a b", "y", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"f a b c e", (String[])new String[]{"f", "y", "c", "e"}, (int[])new int[]{0, 2, 6, 8}, (int[])new int[]{1, 5, 7, 9}, (String[])new String[]{"word", "SYNONYM", "word", "word"}, (int[])new int[]{1, 1, 1, 1}, (int[])new int[]{1, 1, 1, 1});
        a.close();
    }

    public void testZeroSyns() throws Exception {
        MockTokenizer tokenizer = new MockTokenizer();
        tokenizer.setReader((Reader)new StringReader("aa bb"));
        try {
            new SynonymGraphFilter((TokenStream)tokenizer, new SynonymMap.Builder(true).build(), true);
            TestSynonymGraphFilter.fail((String)"did not hit expected exception");
        }
        catch (IllegalArgumentException iae) {
            TestSynonymGraphFilter.assertEquals((Object)"fst must be non-null", (Object)iae.getMessage());
        }
    }

    public void testOutputHangsOffEnd() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add(b, "a", "a b", false);
        Analyzer a = this.getFlattenAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a", (String[])new String[]{"a", "b"}, (int[])new int[]{0, 0}, (int[])new int[]{1, 1}, null, (int[])new int[]{1, 1}, (int[])new int[]{1, 1}, (boolean)true);
        a.close();
    }

    public void testDedup() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add(b, "a b", "ab", false);
        this.add(b, "a b", "ab", false);
        this.add(b, "a b", "ab", false);
        Analyzer a = this.getFlattenAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a b", (String[])new String[]{"ab"}, (int[])new int[]{1});
        a.close();
    }

    public void testNoDedup() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(false);
        boolean keepOrig = false;
        this.add(b, "a b", "ab", false);
        this.add(b, "a b", "ab", false);
        this.add(b, "a b", "ab", false);
        Analyzer a = this.getFlattenAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a b", (String[])new String[]{"ab", "ab", "ab"}, (int[])new int[]{1, 0, 0});
        a.close();
    }

    public void testMatching() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add(b, "a b", "ab", false);
        this.add(b, "a c", "ac", false);
        this.add(b, "a", "aa", false);
        this.add(b, "b", "bb", false);
        this.add(b, "z x c v", "zxcv", false);
        this.add(b, "x c", "xc", false);
        Analyzer a = this.getFlattenAnalyzer(b, true);
        TestSynonymGraphFilter.checkOneTerm((Analyzer)a, (String)"$", (String)"$");
        TestSynonymGraphFilter.checkOneTerm((Analyzer)a, (String)"a", (String)"aa");
        TestSynonymGraphFilter.checkOneTerm((Analyzer)a, (String)"b", (String)"bb");
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a $", (String[])new String[]{"aa", "$"}, (int[])new int[]{1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"$ a", (String[])new String[]{"$", "aa"}, (int[])new int[]{1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a a", (String[])new String[]{"aa", "aa"}, (int[])new int[]{1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"z x c v", (String[])new String[]{"zxcv"}, (int[])new int[]{1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"z x c $", (String[])new String[]{"z", "xc", "$"}, (int[])new int[]{1, 1, 1});
        a.close();
    }

    public void testBasic1() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        this.add(b, "a", "foo", true);
        this.add(b, "a b", "bar fee", true);
        this.add(b, "b c", "dog collar", true);
        this.add(b, "c d", "dog harness holder extras", true);
        this.add(b, "m c e", "dog barks loudly", false);
        this.add(b, "i j k", "feep", true);
        this.add(b, "e f", "foo bar", false);
        this.add(b, "e f", "baz bee", false);
        this.add(b, "z", "boo", false);
        this.add(b, "y", "bee", true);
        Analyzer a = this.getFlattenAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a b c", (String[])new String[]{"bar", "a", "fee", "b", "c"}, (int[])new int[]{1, 0, 1, 0, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"x a b c d", (String[])new String[]{"x", "bar", "a", "fee", "b", "dog", "c", "harness", "d", "holder", "extras"}, (int[])new int[]{1, 1, 0, 1, 0, 1, 0, 1, 0, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a b a", (String[])new String[]{"bar", "a", "fee", "b", "foo", "a"}, (int[])new int[]{1, 0, 1, 0, 1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c d c d", (String[])new String[]{"dog", "c", "harness", "d", "holder", "extras", "dog", "c", "harness", "d", "holder", "extras"}, (int[])new int[]{1, 0, 1, 0, 1, 1, 1, 0, 1, 0, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"e f", (String[])new String[]{"foo", "baz", "bar", "bee"}, (int[])new int[]{1, 0, 1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"g i j k g", (String[])new String[]{"g", "feep", "i", "j", "k", "g"}, (int[])new int[]{1, 1, 0, 1, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a m c e x", (String[])new String[]{"foo", "a", "dog", "barks", "loudly", "x"}, (int[])new int[]{1, 0, 1, 1, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"c d m c e x", (String[])new String[]{"dog", "c", "harness", "d", "holder", "extras", "dog", "barks", "loudly", "x"}, (int[])new int[]{1, 0, 1, 0, 1, 1, 1, 1, 1, 1});
        TestSynonymGraphFilter.assertTrue((this.synFilter.getCaptureCount() > 0 ? 1 : 0) != 0);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"p q r s t", (String[])new String[]{"p", "q", "r", "s", "t"}, (int[])new int[]{1, 1, 1, 1, 1});
        TestSynonymGraphFilter.assertEquals((long)0L, (long)this.synFilter.getCaptureCount());
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"p q z y t", (String[])new String[]{"p", "q", "boo", "bee", "y", "t"}, (int[])new int[]{1, 1, 1, 1, 0, 1});
        TestSynonymGraphFilter.assertTrue((this.synFilter.getCaptureCount() > 0 ? 1 : 0) != 0);
    }

    public void testBasic2() throws Exception {
        boolean keepOrig = true;
        do {
            keepOrig = !keepOrig;
            SynonymMap.Builder b = new SynonymMap.Builder(true);
            this.add(b, "aaa", "aaaa1 aaaa2 aaaa3", keepOrig);
            this.add(b, "bbb", "bbbb1 bbbb2", keepOrig);
            Analyzer a = this.getFlattenAnalyzer(b, true);
            if (keepOrig) {
                TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"xyzzy bbb pot of gold", (String[])new String[]{"xyzzy", "bbbb1", "bbb", "bbbb2", "pot", "of", "gold"}, (int[])new int[]{1, 1, 0, 1, 1, 1, 1});
                TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"xyzzy aaa pot of gold", (String[])new String[]{"xyzzy", "aaaa1", "aaa", "aaaa2", "aaaa2", "pot", "of", "gold"}, (int[])new int[]{1, 1, 0, 1, 1, 1, 1, 1});
                continue;
            }
            TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"xyzzy bbb pot of gold", (String[])new String[]{"xyzzy", "bbbb1", "bbbb2", "pot", "of", "gold"}, (int[])new int[]{1, 1, 1, 1, 1, 1});
            TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"xyzzy aaa pot of gold", (String[])new String[]{"xyzzy", "aaaa1", "aaaa2", "aaaa3", "pot", "of", "gold"}, (int[])new int[]{1, 1, 1, 1, 1, 1, 1});
        } while (keepOrig);
    }

    public void testFlattenedGraph() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder();
        this.add(b, "wtf", "what the fudge", true);
        Analyzer a = this.getFlattenAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"wtf happened", (String[])new String[]{"what", "wtf", "the", "fudge", "happened"}, (int[])new int[]{0, 0, 0, 0, 4}, (int[])new int[]{3, 3, 3, 3, 12}, null, (int[])new int[]{1, 0, 1, 1, 1}, (int[])new int[]{1, 3, 1, 1, 1}, (boolean)true);
        BaseDirectoryWrapper dir = TestSynonymGraphFilter.newDirectory();
        RandomIndexWriter w = new RandomIndexWriter(TestSynonymGraphFilter.random(), (Directory)dir, a);
        Document doc = new Document();
        doc.add((IndexableField)TestSynonymGraphFilter.newTextField((String)"field", (String)"wtf happened", (Field.Store)Field.Store.NO));
        w.addDocument((Iterable)doc);
        DirectoryReader r = w.getReader();
        w.close();
        IndexSearcher s = TestSynonymGraphFilter.newSearcher((IndexReader)r);
        TestSynonymGraphFilter.assertEquals((long)0L, (long)s.count((Query)new PhraseQuery("field", new String[]{"what", "happened"})));
        TestSynonymGraphFilter.assertEquals((long)0L, (long)s.count((Query)new PhraseQuery("field", new String[]{"wtf", "happened"})));
        TestSynonymGraphFilter.assertEquals((long)1L, (long)s.count((Query)new PhraseQuery("field", new String[]{"what", "the", "fudge", "happened"})));
        TestSynonymGraphFilter.assertEquals((long)1L, (long)s.count((Query)new PhraseQuery("field", new String[]{"wtf", "the"})));
        IOUtils.close((Closeable[])new Closeable[]{r, dir});
    }

    private String randomNonEmptyString() {
        String s;
        while ((s = TestUtil.randomUnicodeString((Random)TestSynonymGraphFilter.random()).trim()).length() == 0 || s.indexOf(0) != -1) {
        }
        return s;
    }

    public void testRandomGraphAfter() throws Exception {
        int numIters = TestSynonymGraphFilter.atLeast((int)3);
        for (int i = 0; i < numIters; ++i) {
            SynonymMap.Builder b = new SynonymMap.Builder(TestSynonymGraphFilter.random().nextBoolean());
            int numEntries = TestSynonymGraphFilter.atLeast((int)10);
            for (int j = 0; j < numEntries; ++j) {
                this.add(b, this.randomNonEmptyString(), this.randomNonEmptyString(), TestSynonymGraphFilter.random().nextBoolean());
            }
            final SynonymMap map = b.build();
            final boolean ignoreCase = TestSynonymGraphFilter.random().nextBoolean();
            final boolean doFlatten = TestSynonymGraphFilter.random().nextBoolean();
            Analyzer analyzer = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
                    SynonymGraphFilter syns = new SynonymGraphFilter((TokenStream)tokenizer, map, ignoreCase);
                    MockGraphTokenFilter graph = new MockGraphTokenFilter(LuceneTestCase.random(), (TokenStream)syns);
                    if (doFlatten) {
                        graph = new FlattenGraphFilter((TokenStream)graph);
                    }
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)graph);
                }
            };
            TestSynonymGraphFilter.checkRandomData((Random)TestSynonymGraphFilter.random(), (Analyzer)analyzer, (int)100);
            analyzer.close();
        }
    }

    public void testEmptyStringInput() throws IOException {
        int numIters = TestSynonymGraphFilter.atLeast((int)10);
        for (int i = 0; i < numIters; ++i) {
            SynonymMap.Builder b = new SynonymMap.Builder(TestSynonymGraphFilter.random().nextBoolean());
            int numEntries = TestSynonymGraphFilter.atLeast((int)10);
            for (int j = 0; j < numEntries; ++j) {
                this.add(b, this.randomNonEmptyString(), this.randomNonEmptyString(), TestSynonymGraphFilter.random().nextBoolean());
            }
            boolean ignoreCase = TestSynonymGraphFilter.random().nextBoolean();
            Analyzer analyzer = this.getAnalyzer(b, ignoreCase);
            TestSynonymGraphFilter.checkAnalysisConsistency((Random)TestSynonymGraphFilter.random(), (Analyzer)analyzer, (boolean)TestSynonymGraphFilter.random().nextBoolean(), (String)"");
            analyzer.close();
        }
    }

    public void testRandom2() throws Exception {
        int numIters = TestSynonymGraphFilter.atLeast((int)3);
        for (int i = 0; i < numIters; ++i) {
            SynonymMap.Builder b = new SynonymMap.Builder(TestSynonymGraphFilter.random().nextBoolean());
            int numEntries = TestSynonymGraphFilter.atLeast((int)10);
            for (int j = 0; j < numEntries; ++j) {
                this.add(b, this.randomNonEmptyString(), this.randomNonEmptyString(), TestSynonymGraphFilter.random().nextBoolean());
            }
            boolean ignoreCase = TestSynonymGraphFilter.random().nextBoolean();
            boolean doFlatten = TestSynonymGraphFilter.random().nextBoolean();
            Analyzer analyzer = doFlatten ? this.getFlattenAnalyzer(b, ignoreCase) : this.getAnalyzer(b, ignoreCase);
            TestSynonymGraphFilter.checkRandomData((Random)TestSynonymGraphFilter.random(), (Analyzer)analyzer, (int)100);
            analyzer.close();
        }
    }

    public void testRandomHuge() throws Exception {
        int numIters = TestSynonymGraphFilter.atLeast((int)3);
        for (int i = 0; i < numIters; ++i) {
            SynonymMap.Builder b = new SynonymMap.Builder(TestSynonymGraphFilter.random().nextBoolean());
            int numEntries = TestSynonymGraphFilter.atLeast((int)10);
            if (VERBOSE) {
                System.out.println("TEST: iter=" + i + " numEntries=" + numEntries);
            }
            for (int j = 0; j < numEntries; ++j) {
                this.add(b, this.randomNonEmptyString(), this.randomNonEmptyString(), TestSynonymGraphFilter.random().nextBoolean());
            }
            boolean ignoreCase = TestSynonymGraphFilter.random().nextBoolean();
            boolean doFlatten = TestSynonymGraphFilter.random().nextBoolean();
            Analyzer analyzer = doFlatten ? this.getFlattenAnalyzer(b, ignoreCase) : this.getAnalyzer(b, ignoreCase);
            TestSynonymGraphFilter.checkRandomData((Random)TestSynonymGraphFilter.random(), (Analyzer)analyzer, (int)100, (int)1024);
            analyzer.close();
        }
    }

    public void testEmptyTerm() throws IOException {
        int numIters = TestSynonymGraphFilter.atLeast((int)10);
        for (int i = 0; i < numIters; ++i) {
            SynonymMap.Builder b = new SynonymMap.Builder(TestSynonymGraphFilter.random().nextBoolean());
            int numEntries = TestSynonymGraphFilter.atLeast((int)10);
            for (int j = 0; j < numEntries; ++j) {
                this.add(b, this.randomNonEmptyString(), this.randomNonEmptyString(), TestSynonymGraphFilter.random().nextBoolean());
            }
            boolean ignoreCase = TestSynonymGraphFilter.random().nextBoolean();
            Analyzer analyzer = this.getAnalyzer(b, ignoreCase);
            TestSynonymGraphFilter.checkAnalysisConsistency((Random)TestSynonymGraphFilter.random(), (Analyzer)analyzer, (boolean)TestSynonymGraphFilter.random().nextBoolean(), (String)"");
            analyzer.close();
        }
    }

    public void testVanishingTermsNoFlatten() throws Exception {
        String testFile = "aaa => aaaa1 aaaa2 aaaa3\nbbb => bbbb1 bbbb2\n";
        Analyzer analyzer = this.solrSynsToAnalyzer(testFile);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"xyzzy bbb pot of gold", (String[])new String[]{"xyzzy", "bbbb1", "bbbb2", "pot", "of", "gold"});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"xyzzy aaa pot of gold", (String[])new String[]{"xyzzy", "aaaa1", "aaaa2", "aaaa3", "pot", "of", "gold"});
        analyzer.close();
    }

    public void testVanishingTermsWithFlatten() throws Exception {
        String testFile = "aaa => aaaa1 aaaa2 aaaa3\nbbb => bbbb1 bbbb2\n";
        Analyzer analyzer = this.solrSynsToAnalyzer(testFile);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"xyzzy bbb pot of gold", (String[])new String[]{"xyzzy", "bbbb1", "bbbb2", "pot", "of", "gold"});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"xyzzy aaa pot of gold", (String[])new String[]{"xyzzy", "aaaa1", "aaaa2", "aaaa3", "pot", "of", "gold"});
        analyzer.close();
    }

    public void testBuilderDedup() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add(b, "a b", "ab", false);
        this.add(b, "a b", "ab", false);
        this.add(b, "a b", "ab", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a b", (String[])new String[]{"ab"}, (int[])new int[]{1});
        a.close();
    }

    public void testBuilderNoDedup() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(false);
        boolean keepOrig = false;
        this.add(b, "a b", "ab", false);
        this.add(b, "a b", "ab", false);
        this.add(b, "a b", "ab", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a b", (String[])new String[]{"ab", "ab", "ab"}, (int[])new int[]{1, 0, 0});
        a.close();
    }

    public void testRecursion1() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add(b, "zoo", "zoo", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"zoo zoo $ zoo", (String[])new String[]{"zoo", "zoo", "$", "zoo"}, (int[])new int[]{1, 1, 1, 1});
        a.close();
    }

    public void testRecursion2() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add(b, "zoo", "zoo", false);
        this.add(b, "zoo", "zoo zoo", false);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"zoo zoo $ zoo", (String[])new String[]{"zoo", "zoo", "zoo", "zoo", "zoo", "zoo", "$", "zoo", "zoo", "zoo"}, (int[])new int[]{1, 0, 1, 1, 0, 1, 1, 1, 0, 1});
        a.close();
    }

    public void testRecursion3() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = true;
        this.add(b, "zoo zoo", "zoo", true);
        Analyzer a = this.getFlattenAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"zoo zoo $ zoo", (String[])new String[]{"zoo", "zoo", "zoo", "$", "zoo"}, (int[])new int[]{1, 0, 1, 1, 1});
        a.close();
    }

    public void testRecursion4() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = true;
        this.add(b, "zoo zoo", "zoo", true);
        this.add(b, "zoo", "zoo zoo", true);
        Analyzer a = this.getFlattenAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"zoo zoo $ zoo", (String[])new String[]{"zoo", "zoo", "zoo", "$", "zoo", "zoo", "zoo"}, (int[])new int[]{1, 0, 1, 1, 1, 0, 1});
        a.close();
    }

    public void testKeepOrig() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = true;
        this.add(b, "a b", "ab", true);
        this.add(b, "a c", "ac", true);
        this.add(b, "a", "aa", true);
        this.add(b, "b", "bb", true);
        this.add(b, "z x c v", "zxcv", true);
        this.add(b, "x c", "xc", true);
        Analyzer a = this.getAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"$", (String[])new String[]{"$"}, (int[])new int[]{1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a", (String[])new String[]{"aa", "a"}, (int[])new int[]{1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a", (String[])new String[]{"aa", "a"}, (int[])new int[]{1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"$ a", (String[])new String[]{"$", "aa", "a"}, (int[])new int[]{1, 1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a $", (String[])new String[]{"aa", "a", "$"}, (int[])new int[]{1, 0, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"$ a !", (String[])new String[]{"$", "aa", "a", "!"}, (int[])new int[]{1, 1, 0, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a a", (String[])new String[]{"aa", "a", "aa", "a"}, (int[])new int[]{1, 0, 1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"b", (String[])new String[]{"bb", "b"}, (int[])new int[]{1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"z x c v", (String[])new String[]{"zxcv", "z", "x", "c", "v"}, (int[])new int[]{1, 0, 1, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"z x c $", (String[])new String[]{"z", "xc", "x", "c", "$"}, (int[])new int[]{1, 1, 0, 1, 1});
        a.close();
    }

    public void testNonPreservingMultiwordSynonyms() throws Exception {
        String testFile = "aaa => two words\nbbb => one two, very many multiple words\nee ff, gg, h i j k, h i => one\ncc dd => usa,united states,u s a,united states of america";
        Analyzer analyzer = this.solrSynsToAnalyzer(testFile);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"aaa", (String[])new String[]{"two", "words"}, (int[])new int[]{0, 0}, (int[])new int[]{3, 3}, (String[])new String[]{"SYNONYM", "SYNONYM"}, (int[])new int[]{1, 1}, (int[])new int[]{1, 1});
        TestSynonymGraphFilter.assertAnalyzesToPositions((Analyzer)analyzer, (String)"amazing aaa", (String[])new String[]{"amazing", "two", "words"}, (String[])new String[]{"word", "SYNONYM", "SYNONYM"}, (int[])new int[]{1, 1, 1}, (int[])new int[]{1, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"p bbb s", (String[])new String[]{"p", "one", "very", "two", "many", "multiple", "words", "s"}, (int[])new int[]{0, 2, 2, 2, 2, 2, 2, 6}, (int[])new int[]{1, 5, 5, 5, 5, 5, 5, 7}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "SYNONYM", "SYNONYM", "SYNONYM", "SYNONYM", "word"}, (int[])new int[]{1, 1, 0, 1, 0, 1, 1, 1}, (int[])new int[]{1, 1, 1, 3, 1, 1, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"p ee ff s", (String[])new String[]{"p", "one", "s"}, (int[])new int[]{0, 2, 8}, (int[])new int[]{1, 7, 9}, (String[])new String[]{"word", "SYNONYM", "word"}, (int[])new int[]{1, 1, 1}, (int[])new int[]{1, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"p h i j s", (String[])new String[]{"p", "one", "j", "s"}, (int[])new int[]{0, 2, 6, 8}, (int[])new int[]{1, 5, 7, 9}, (String[])new String[]{"word", "SYNONYM", "word", "word"}, (int[])new int[]{1, 1, 1, 1}, (int[])new int[]{1, 1, 1, 1});
        analyzer.close();
    }

    private Analyzer getAnalyzer(SynonymMap.Builder b, final boolean ignoreCase) throws IOException {
        final SynonymMap map = b.build();
        return new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                SynonymGraphFilter synFilter = new SynonymGraphFilter((TokenStream)tokenizer, map, ignoreCase);
                TestSynonymGraphFilter.this.flattenFilter = null;
                TestSynonymGraphFilter.this.synFilter = synFilter;
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)synFilter);
            }
        };
    }

    private Analyzer getFlattenAnalyzer(SynonymMap.Builder b, final boolean ignoreCase) throws IOException {
        final SynonymMap map = b.build();
        return new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, true);
                SynonymGraphFilter synFilter = new SynonymGraphFilter((TokenStream)tokenizer, map, ignoreCase);
                FlattenGraphFilter flattenFilter = new FlattenGraphFilter((TokenStream)synFilter);
                TestSynonymGraphFilter.this.synFilter = synFilter;
                TestSynonymGraphFilter.this.flattenFilter = flattenFilter;
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)flattenFilter);
            }
        };
    }

    private void add(SynonymMap.Builder b, String input, String output, boolean keepOrig) {
        if (VERBOSE) {
            // empty if block
        }
        CharsRefBuilder inputCharsRef = new CharsRefBuilder();
        SynonymMap.Builder.join((String[])input.split(" +"), (CharsRefBuilder)inputCharsRef);
        CharsRefBuilder outputCharsRef = new CharsRefBuilder();
        SynonymMap.Builder.join((String[])output.split(" +"), (CharsRefBuilder)outputCharsRef);
        b.add(inputCharsRef.get(), outputCharsRef.get(), keepOrig);
    }

    private char[] randomBinaryChars(int minLen, int maxLen, double bias, char base) {
        int len = TestUtil.nextInt((Random)TestSynonymGraphFilter.random(), (int)minLen, (int)maxLen);
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            char ch = TestSynonymGraphFilter.random().nextDouble() < bias ? base : (char)(base + '\u0001');
            chars[i] = ch;
        }
        return chars;
    }

    private static String toTokenString(char[] chars) {
        StringBuilder b = new StringBuilder();
        for (char c : chars) {
            if (b.length() > 0) {
                b.append(' ');
            }
            b.append(c);
        }
        return b.toString();
    }

    public void testRandomSyns() throws Exception {
        int synCount = TestSynonymGraphFilter.atLeast((int)10);
        double bias = TestSynonymGraphFilter.random().nextDouble();
        boolean dedup = TestSynonymGraphFilter.random().nextBoolean();
        boolean flatten = TestSynonymGraphFilter.random().nextBoolean();
        SynonymMap.Builder b = new SynonymMap.Builder(dedup);
        ArrayList<OneSyn> syns = new ArrayList<OneSyn>();
        if (VERBOSE) {
            System.out.println("TEST: make " + synCount + " syns");
            System.out.println("  bias for a over b=" + bias);
            System.out.println("  dedup=" + dedup);
            System.out.println("  flatten=" + flatten);
        }
        int maxSynLength = 0;
        for (int i = 0; i < synCount; ++i) {
            OneSyn syn = new OneSyn();
            syn.in = this.randomBinaryChars(1, 5, bias, 'a');
            syn.out = this.randomBinaryChars(1, 5, 0.5, 'x');
            syn.keepOrig = TestSynonymGraphFilter.random().nextBoolean();
            syns.add(syn);
            maxSynLength = Math.max(maxSynLength, syn.in.length);
            if (VERBOSE) {
                System.out.println("  " + syn);
            }
            this.add(b, TestSynonymGraphFilter.toTokenString(syn.in), TestSynonymGraphFilter.toTokenString(syn.out), syn.keepOrig);
        }
        int maxFlattenLookahead = 0;
        if (flatten) {
            for (int i = 0; i < synCount; ++i) {
                OneSyn syn1 = (OneSyn)syns.get(i);
                int count = syn1.out.length;
                boolean keepOrig = syn1.keepOrig;
                for (int j = 0; j < synCount; ++j) {
                    OneSyn syn2 = (OneSyn)syns.get(i);
                    keepOrig |= syn2.keepOrig;
                    if (!syn1.in.equals(syn2.in)) continue;
                    count += syn2.out.length;
                }
                if (keepOrig) {
                    count += syn1.in.length;
                }
                maxFlattenLookahead = Math.max(maxFlattenLookahead, count);
            }
        }
        Analyzer aNoFlattened = VERBOSE ? this.getAnalyzer(b, true) : null;
        Analyzer a = flatten ? this.getFlattenAnalyzer(b, true) : this.getAnalyzer(b, true);
        int iters = TestSynonymGraphFilter.atLeast((int)20);
        for (int iter = 0; iter < iters; ++iter) {
            String doc = TestSynonymGraphFilter.toTokenString(this.randomBinaryChars(50, 100, bias, 'a'));
            if (VERBOSE) {
                System.out.println("TEST: iter=" + iter + " doc=" + doc);
            }
            Automaton expected = this.slowSynFilter(doc, syns, flatten);
            if (VERBOSE) {
                System.out.println("  expected:\n" + expected.toDot());
                if (flatten) {
                    Automaton unflattened = this.toAutomaton(aNoFlattened.tokenStream("field", (Reader)new StringReader(doc)));
                    System.out.println("  actual unflattened:\n" + unflattened.toDot());
                }
            }
            Automaton actual = this.toAutomaton(a.tokenStream("field", (Reader)new StringReader(doc)));
            if (VERBOSE) {
                System.out.println("  actual:\n" + actual.toDot());
            }
            TestSynonymGraphFilter.assertTrue((String)("maxLookaheadUsed=" + this.synFilter.getMaxLookaheadUsed() + " maxSynLength=" + maxSynLength), (this.synFilter.getMaxLookaheadUsed() <= maxSynLength ? 1 : 0) != 0);
            if (flatten) {
                TestSynonymGraphFilter.assertTrue((String)("flatten maxLookaheadUsed=" + this.flattenFilter.getMaxLookaheadUsed() + " maxFlattenLookahead=" + maxFlattenLookahead), (this.flattenFilter.getMaxLookaheadUsed() <= maxFlattenLookahead ? 1 : 0) != 0);
            }
            TestSynonymGraphFilter.checkAnalysisConsistency((Random)TestSynonymGraphFilter.random(), (Analyzer)a, (boolean)TestSynonymGraphFilter.random().nextBoolean(), (String)doc);
            try {
                actual = Operations.determinize((Automaton)actual, (int)50000);
            }
            catch (TooComplexToDeterminizeException tctde) {
                TestSynonymGraphFilter.assertTrue((boolean)this.approxEquals(actual, expected));
                continue;
            }
            try {
                expected = Operations.determinize((Automaton)expected, (int)50000);
            }
            catch (TooComplexToDeterminizeException tctde) {
                TestSynonymGraphFilter.assertTrue((boolean)this.approxEquals(actual, expected));
                continue;
            }
            TestSynonymGraphFilter.assertTrue((boolean)this.approxEquals(actual, expected));
            TestSynonymGraphFilter.assertTrue((boolean)Operations.sameLanguage((Automaton)actual, (Automaton)expected));
        }
        a.close();
    }

    private boolean approxEquals(Automaton actual, Automaton expected) {
        boolean b1 = this.approxSubsetOf(actual, expected);
        boolean b2 = this.approxSubsetOf(expected, actual);
        return b1 && b2;
    }

    private boolean approxSubsetOf(Automaton a1, Automaton a2) {
        AutomatonTestUtil.RandomAcceptedStrings ras = new AutomatonTestUtil.RandomAcceptedStrings(a1);
        for (int i = 0; i < 2000; ++i) {
            int[] ints = ras.getRandomAcceptedString(TestSynonymGraphFilter.random());
            IntsRef path = new IntsRef(ints, 0, ints.length);
            if (TestSynonymGraphFilter.accepts(a2, path)) continue;
            throw new RuntimeException("a2 does not accept " + path);
        }
        return true;
    }

    private static boolean accepts(Automaton a, IntsRef path) {
        HashSet<Integer> states = new HashSet<Integer>();
        states.add(0);
        Transition t = new Transition();
        for (int i = 0; i < path.length; ++i) {
            int digit = path.ints[path.offset + i];
            HashSet<Integer> nextStates = new HashSet<Integer>();
            Iterator iterator = states.iterator();
            while (iterator.hasNext()) {
                int state = (Integer)iterator.next();
                int count = a.initTransition(state, t);
                for (int j = 0; j < count; ++j) {
                    a.getNextTransition(t);
                    if (digit < t.min || digit > t.max) continue;
                    nextStates.add(t.dest);
                }
            }
            states = nextStates;
            if (!states.isEmpty()) continue;
            return false;
        }
        Iterator iterator = states.iterator();
        while (iterator.hasNext()) {
            int state = (Integer)iterator.next();
            if (!a.isAccept(state)) continue;
            return true;
        }
        return false;
    }

    private Automaton slowSynFilter(String doc, List<OneSyn> syns, boolean flatten) {
        String[] tokens = doc.split(" +");
        if (VERBOSE) {
            System.out.println("  doc has " + tokens.length + " tokens");
        }
        int i = 0;
        Automaton.Builder a = new Automaton.Builder();
        int lastState = a.createState();
        while (i < tokens.length) {
            assert (tokens[i].length() == 1);
            if (VERBOSE) {
                System.out.println("    i=" + i);
            }
            ArrayList<OneSyn> matches = new ArrayList<OneSyn>();
            for (OneSyn syn : syns) {
                if (i + syn.in.length > tokens.length) continue;
                boolean match = true;
                for (int j = 0; j < syn.in.length; ++j) {
                    if (tokens[i + j].charAt(0) == syn.in[j]) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                if (!matches.isEmpty()) {
                    if (syn.in.length < ((OneSyn)matches.get((int)0)).in.length) continue;
                    if (syn.in.length > ((OneSyn)matches.get((int)0)).in.length) {
                        matches.clear();
                    }
                }
                matches.add(syn);
            }
            int nextState = a.createState();
            if (!matches.isEmpty()) {
                if (VERBOSE) {
                    System.out.println("  matches @ i=" + i + ": " + matches);
                }
                boolean keepOrig = false;
                for (OneSyn syn : matches) {
                    keepOrig |= syn.keepOrig;
                }
                ArrayList<Integer> flatStates = flatten ? new ArrayList<Integer>() : null;
                if (keepOrig) {
                    TestSynonymGraphFilter.addSidePath(a, lastState, nextState, ((OneSyn)matches.get((int)0)).in, flatStates);
                }
                for (OneSyn syn : matches) {
                    TestSynonymGraphFilter.addSidePath(a, lastState, nextState, syn.out, flatStates);
                }
                i += ((OneSyn)matches.get((int)0)).in.length;
            } else {
                a.addTransition(lastState, nextState, (int)tokens[i].charAt(0));
                ++i;
            }
            lastState = nextState;
        }
        a.setAccept(lastState, true);
        return this.topoSort(a.finish());
    }

    private static void addSidePath(Automaton.Builder a, int startState, int endState, char[] tokens, List<Integer> flatStates) {
        int lastState = startState;
        for (int i = 0; i < tokens.length; ++i) {
            int nextState;
            if (i == tokens.length - 1) {
                nextState = endState;
            } else if (flatStates == null || i >= flatStates.size()) {
                nextState = a.createState();
                if (flatStates != null) {
                    assert (i == flatStates.size());
                    flatStates.add(nextState);
                }
            } else {
                nextState = flatStates.get(i);
            }
            a.addTransition(lastState, nextState, (int)tokens[i]);
            lastState = nextState;
        }
    }

    private Automaton toAutomaton(TokenStream ts) throws IOException {
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)ts.addAttribute(PositionIncrementAttribute.class);
        PositionLengthAttribute posLenAtt = (PositionLengthAttribute)ts.addAttribute(PositionLengthAttribute.class);
        CharTermAttribute termAtt = (CharTermAttribute)ts.addAttribute(CharTermAttribute.class);
        ts.reset();
        Automaton a = new Automaton();
        int srcNode = -1;
        int destNode = -1;
        int state = a.createState();
        while (ts.incrementToken()) {
            assert (termAtt.length() == 1);
            char c = termAtt.charAt(0);
            int posInc = posIncAtt.getPositionIncrement();
            if (posInc != 0) {
                srcNode += posInc;
                while (state < srcNode) {
                    state = a.createState();
                }
            }
            destNode = srcNode + posLenAtt.getPositionLength();
            while (state < destNode) {
                state = a.createState();
            }
            a.addTransition(srcNode, destNode, (int)c);
        }
        ts.end();
        ts.close();
        a.finishState();
        a.setAccept(destNode, true);
        return a;
    }

    private Automaton topoSort(Automaton in) {
        int[] newToOld = Operations.topoSortStates((Automaton)in);
        int[] oldToNew = new int[newToOld.length];
        Automaton.Builder a = new Automaton.Builder();
        for (int i = 0; i < newToOld.length; ++i) {
            a.createState();
            oldToNew[newToOld[i]] = i;
            if (!in.isAccept(newToOld[i])) continue;
            a.setAccept(i, true);
        }
        Transition t = new Transition();
        for (int i = 0; i < newToOld.length; ++i) {
            int count = in.initTransition(newToOld[i], t);
            for (int j = 0; j < count; ++j) {
                in.getNextTransition(t);
                a.addTransition(i, oldToNew[t.dest], t.min, t.max);
            }
        }
        return a.finish();
    }

    public void testPositionLengthAndType() throws Exception {
        String testFile = "spider man, spiderman\nusa,united states,u s a,united states of america";
        MockAnalyzer analyzer = new MockAnalyzer(TestSynonymGraphFilter.random());
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)analyzer);
        parser.parse((Reader)new StringReader(testFile));
        analyzer.close();
        SynonymMap map = parser.build();
        analyzer = this.getFlattenAnalyzer((SynonymMap.Builder)parser, true);
        BytesRef value = (BytesRef)Util.get((FST)map.fst, (IntsRef)Util.toUTF32((CharSequence)new CharsRef("usa"), (IntsRefBuilder)new IntsRefBuilder()));
        ByteArrayDataInput bytesReader = new ByteArrayDataInput(value.bytes, value.offset, value.length);
        int code = bytesReader.readVInt();
        int count = code >>> 1;
        int[] synonymsIdxs = new int[count];
        for (int i = 0; i < count; ++i) {
            synonymsIdxs[i] = bytesReader.readVInt();
        }
        BytesRef scratchBytes = new BytesRef();
        map.words.get(synonymsIdxs[2], scratchBytes);
        int synonymLength = 1;
        for (int i = scratchBytes.offset; i < scratchBytes.offset + scratchBytes.length; ++i) {
            if (scratchBytes.bytes[i] != 0) continue;
            ++synonymLength;
        }
        TestSynonymGraphFilter.assertEquals((long)count, (long)3L);
        TestSynonymGraphFilter.assertEquals((long)synonymLength, (long)4L);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"spider man", (String[])new String[]{"spiderman", "spider", "man"}, (int[])new int[]{0, 0, 7}, (int[])new int[]{10, 6, 10}, (String[])new String[]{"SYNONYM", "word", "word"}, (int[])new int[]{1, 0, 1}, (int[])new int[]{2, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesToPositions((Analyzer)analyzer, (String)"amazing spider man", (String[])new String[]{"amazing", "spiderman", "spider", "man"}, (String[])new String[]{"word", "SYNONYM", "word", "word"}, (int[])new int[]{1, 1, 0, 1}, (int[])new int[]{1, 2, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"the united states of america is wealthy", (String[])new String[]{"the", "usa", "united", "u", "united", "states", "s", "states", "a", "of", "america", "is", "wealthy"}, (int[])new int[]{0, 4, 4, 4, 4, 11, 11, 11, 18, 18, 21, 29, 32}, (int[])new int[]{3, 28, 10, 10, 10, 28, 17, 17, 28, 20, 28, 31, 39}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "SYNONYM", "word", "SYNONYM", "SYNONYM", "word", "SYNONYM", "word", "word", "word", "word"}, (int[])new int[]{1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1}, (int[])new int[]{1, 4, 1, 1, 1, 3, 1, 1, 2, 1, 1, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesToPositions((Analyzer)analyzer, (String)"spiderman", (String[])new String[]{"spider", "spiderman", "man"}, (String[])new String[]{"SYNONYM", "word", "SYNONYM"}, (int[])new int[]{1, 0, 1}, (int[])new int[]{1, 2, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"spiderman enemies", (String[])new String[]{"spider", "spiderman", "man", "enemies"}, (int[])new int[]{0, 0, 0, 10}, (int[])new int[]{9, 9, 9, 17}, (String[])new String[]{"SYNONYM", "word", "SYNONYM", "word"}, (int[])new int[]{1, 0, 1, 1}, (int[])new int[]{1, 2, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"the usa is wealthy", (String[])new String[]{"the", "united", "u", "united", "usa", "states", "s", "states", "a", "of", "america", "is", "wealthy"}, (int[])new int[]{0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 8, 11}, (int[])new int[]{3, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 10, 18}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "SYNONYM", "word", "SYNONYM", "SYNONYM", "SYNONYM", "SYNONYM", "SYNONYM", "SYNONYM", "word", "word"}, (int[])new int[]{1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1}, (int[])new int[]{1, 1, 1, 1, 4, 3, 1, 1, 2, 1, 1, 1, 1});
        TestSynonymGraphFilter.assertGraphStrings((Analyzer)analyzer, (String)"the usa is wealthy", (String[])new String[]{"the usa is wealthy", "the united states is wealthy", "the u s a is wealthy", "the united states of america is wealthy", "the u states is wealthy", "the u states a is wealthy", "the u s of america is wealthy", "the u states of america is wealthy", "the united s a is wealthy", "the united states a is wealthy", "the united s of america is wealthy"});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"the united states is wealthy", (String[])new String[]{"the", "usa", "u", "united", "united", "s", "states", "states", "a", "of", "america", "is", "wealthy"}, (int[])new int[]{0, 4, 4, 4, 4, 11, 11, 11, 11, 11, 11, 18, 21}, (int[])new int[]{3, 17, 10, 10, 10, 17, 17, 17, 17, 17, 17, 20, 28}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "SYNONYM", "word", "SYNONYM", "SYNONYM", "word", "SYNONYM", "SYNONYM", "SYNONYM", "word", "word"}, (int[])new int[]{1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1}, (int[])new int[]{1, 4, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1}, (boolean)false);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"the united states of balance", (String[])new String[]{"the", "usa", "u", "united", "united", "s", "states", "states", "a", "of", "america", "of", "balance"}, (int[])new int[]{0, 4, 4, 4, 4, 11, 11, 11, 11, 11, 11, 18, 21}, (int[])new int[]{3, 17, 10, 10, 10, 17, 17, 17, 17, 17, 17, 20, 28}, (String[])new String[]{"word", "SYNONYM", "SYNONYM", "SYNONYM", "word", "SYNONYM", "SYNONYM", "word", "SYNONYM", "SYNONYM", "SYNONYM", "word", "word"}, (int[])new int[]{1, 1, 0, 0, 0, 1, 0, 0, 1, 0, 1, 1, 1}, (int[])new int[]{1, 4, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1});
        analyzer.close();
    }

    public void testMultiwordOffsets() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = true;
        this.add(b, "national hockey league", "nhl", true);
        Analyzer a = this.getFlattenAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"national hockey league", (String[])new String[]{"nhl", "national", "hockey", "league"}, (int[])new int[]{0, 0, 9, 16}, (int[])new int[]{22, 8, 15, 22}, (int[])new int[]{1, 0, 1, 1});
        a.close();
    }

    public void testIncludeOrig() throws Exception {
        SynonymMap.Builder b = new SynonymMap.Builder(true);
        boolean keepOrig = true;
        this.add(b, "a b", "ab", true);
        this.add(b, "a c", "ac", true);
        this.add(b, "a", "aa", true);
        this.add(b, "b", "bb", true);
        this.add(b, "z x c v", "zxcv", true);
        this.add(b, "x c", "xc", true);
        Analyzer a = this.getFlattenAnalyzer(b, true);
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"$", (String[])new String[]{"$"}, (int[])new int[]{1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a", (String[])new String[]{"aa", "a"}, (int[])new int[]{1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a", (String[])new String[]{"aa", "a"}, (int[])new int[]{1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"$ a", (String[])new String[]{"$", "aa", "a"}, (int[])new int[]{1, 1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a $", (String[])new String[]{"aa", "a", "$"}, (int[])new int[]{1, 0, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"$ a !", (String[])new String[]{"$", "aa", "a", "!"}, (int[])new int[]{1, 1, 0, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"a a", (String[])new String[]{"aa", "a", "aa", "a"}, (int[])new int[]{1, 0, 1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"b", (String[])new String[]{"bb", "b"}, (int[])new int[]{1, 0});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"z x c v", (String[])new String[]{"zxcv", "z", "x", "c", "v"}, (int[])new int[]{1, 0, 1, 1, 1});
        TestSynonymGraphFilter.assertAnalyzesTo((Analyzer)a, (String)"z x c $", (String[])new String[]{"z", "xc", "x", "c", "$"}, (int[])new int[]{1, 1, 0, 1, 1});
        a.close();
    }

    public void testUpperCase() throws IOException {
        this.assertMapping("word", "synonym");
        this.assertMapping("word".toUpperCase(Locale.ROOT), "synonym");
    }

    private void assertMapping(String inputString, String outputString) throws IOException {
        SynonymMap.Builder builder = new SynonymMap.Builder(false);
        CharsRef input = SynonymMap.Builder.join((String[])inputString.toLowerCase(Locale.ROOT).split(" "), (CharsRefBuilder)new CharsRefBuilder());
        CharsRef output = SynonymMap.Builder.join((String[])outputString.split(" "), (CharsRefBuilder)new CharsRefBuilder());
        builder.add(input, output, true);
        CustomAnalyzer analyzer = new CustomAnalyzer(builder.build());
        TokenStream tokenStream = analyzer.tokenStream("field", inputString);
        TestSynonymGraphFilter.assertTokenStreamContents((TokenStream)tokenStream, (String[])new String[]{outputString, inputString});
    }

    static class CustomAnalyzer
    extends Analyzer {
        private SynonymMap synonymMap;

        CustomAnalyzer(SynonymMap synonymMap) {
            this.synonymMap = synonymMap;
        }

        protected Analyzer.TokenStreamComponents createComponents(String s) {
            MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
            SynonymGraphFilter tokenStream = new SynonymGraphFilter((TokenStream)tokenizer, this.synonymMap, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)tokenStream);
        }
    }

    private static class OneSyn {
        char[] in;
        char[] out;
        boolean keepOrig;

        private OneSyn() {
        }

        public String toString() {
            return TestSynonymGraphFilter.toTokenString(this.in) + " --> " + TestSynonymGraphFilter.toTokenString(this.out) + " (keepOrig=" + this.keepOrig + ")";
        }
    }
}

