/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockGraphTokenFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.synonym.SolrSynonymParser;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public class TestSynonymMapFilter
extends BaseTokenStreamTestCase {
    private SynonymMap.Builder b;
    private Tokenizer tokensIn;
    private SynonymFilter tokensOut;
    private CharTermAttribute termAtt;
    private PositionIncrementAttribute posIncrAtt;
    private PositionLengthAttribute posLenAtt;
    private OffsetAttribute offsetAtt;

    private void add(String input, String output, boolean keepOrig) {
        if (VERBOSE) {
            System.out.println("  add input=" + input + " output=" + output + " keepOrig=" + keepOrig);
        }
        CharsRefBuilder inputCharsRef = new CharsRefBuilder();
        SynonymMap.Builder.join((String[])input.split(" +"), (CharsRefBuilder)inputCharsRef);
        CharsRefBuilder outputCharsRef = new CharsRefBuilder();
        SynonymMap.Builder.join((String[])output.split(" +"), (CharsRefBuilder)outputCharsRef);
        this.b.add(inputCharsRef.get(), outputCharsRef.get(), keepOrig);
    }

    private void assertEquals(CharTermAttribute term, String expected) {
        TestSynonymMapFilter.assertEquals((long)expected.length(), (long)term.length());
        char[] buffer = term.buffer();
        for (int chIDX = 0; chIDX < expected.length(); ++chIDX) {
            TestSynonymMapFilter.assertEquals((long)expected.charAt(chIDX), (long)buffer[chIDX]);
        }
    }

    private void verify(String input, String output) throws Exception {
        if (VERBOSE) {
            System.out.println("TEST: verify input=" + input + " expectedOutput=" + output);
        }
        this.tokensIn.setReader((Reader)new StringReader(input));
        this.tokensOut.reset();
        String[] expected = output.split(" ");
        int expectedUpto = 0;
        while (this.tokensOut.incrementToken()) {
            if (VERBOSE) {
                System.out.println("  incr token=" + this.termAtt.toString() + " posIncr=" + this.posIncrAtt.getPositionIncrement() + " startOff=" + this.offsetAtt.startOffset() + " endOff=" + this.offsetAtt.endOffset());
            }
            TestSynonymMapFilter.assertTrue((expectedUpto < expected.length ? 1 : 0) != 0);
            int startOffset = this.offsetAtt.startOffset();
            int endOffset = this.offsetAtt.endOffset();
            String[] expectedAtPos = expected[expectedUpto++].split("/");
            for (int atPos = 0; atPos < expectedAtPos.length; ++atPos) {
                int expectedPosLen;
                int expectedEndOffset;
                String expectedToken;
                if (atPos > 0) {
                    TestSynonymMapFilter.assertTrue((boolean)this.tokensOut.incrementToken());
                    if (VERBOSE) {
                        System.out.println("  incr token=" + this.termAtt.toString() + " posIncr=" + this.posIncrAtt.getPositionIncrement() + " startOff=" + this.offsetAtt.startOffset() + " endOff=" + this.offsetAtt.endOffset());
                    }
                }
                int colonIndex = expectedAtPos[atPos].indexOf(58);
                int underbarIndex = expectedAtPos[atPos].indexOf(95);
                if (colonIndex != -1) {
                    expectedToken = expectedAtPos[atPos].substring(0, colonIndex);
                    if (underbarIndex != -1) {
                        expectedEndOffset = Integer.parseInt(expectedAtPos[atPos].substring(1 + colonIndex, underbarIndex));
                        expectedPosLen = Integer.parseInt(expectedAtPos[atPos].substring(1 + underbarIndex));
                    } else {
                        expectedEndOffset = Integer.parseInt(expectedAtPos[atPos].substring(1 + colonIndex));
                        expectedPosLen = 1;
                    }
                } else {
                    expectedToken = expectedAtPos[atPos];
                    expectedEndOffset = endOffset;
                    expectedPosLen = 1;
                }
                TestSynonymMapFilter.assertEquals((Object)expectedToken, (Object)this.termAtt.toString());
                TestSynonymMapFilter.assertEquals((long)(atPos == 0 ? 1L : 0L), (long)this.posIncrAtt.getPositionIncrement());
                TestSynonymMapFilter.assertEquals((long)startOffset, (long)this.offsetAtt.startOffset());
                TestSynonymMapFilter.assertEquals((long)expectedEndOffset, (long)this.offsetAtt.endOffset());
                TestSynonymMapFilter.assertEquals((long)expectedPosLen, (long)this.posLenAtt.getPositionLength());
            }
        }
        this.tokensOut.end();
        this.tokensOut.close();
        if (VERBOSE) {
            System.out.println("  incr: END");
        }
        TestSynonymMapFilter.assertEquals((long)expectedUpto, (long)expected.length);
    }

    public void testDontKeepOrig() throws Exception {
        this.b = new SynonymMap.Builder(true);
        this.add("a b", "foo", false);
        final SynonymMap map = this.b.build();
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, false));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"a b c", (String[])new String[]{"foo", "c"}, (int[])new int[]{0, 4}, (int[])new int[]{3, 5}, null, (int[])new int[]{1, 1}, (int[])new int[]{1, 1}, (boolean)true);
        TestSynonymMapFilter.checkAnalysisConsistency((Random)TestSynonymMapFilter.random(), (Analyzer)analyzer, (boolean)false, (String)"a b c");
        analyzer.close();
    }

    public void testDoKeepOrig() throws Exception {
        this.b = new SynonymMap.Builder(true);
        this.add("a b", "foo", true);
        final SynonymMap map = this.b.build();
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, false));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"a b c", (String[])new String[]{"a", "foo", "b", "c"}, (int[])new int[]{0, 0, 2, 4}, (int[])new int[]{1, 3, 3, 5}, null, (int[])new int[]{1, 0, 1, 1}, (int[])new int[]{1, 2, 1, 1}, (boolean)true);
        TestSynonymMapFilter.checkAnalysisConsistency((Random)TestSynonymMapFilter.random(), (Analyzer)analyzer, (boolean)false, (String)"a b c");
        analyzer.close();
    }

    public void testBasic() throws Exception {
        this.b = new SynonymMap.Builder(true);
        this.add("a", "foo", true);
        this.add("a b", "bar fee", true);
        this.add("b c", "dog collar", true);
        this.add("c d", "dog harness holder extras", true);
        this.add("m c e", "dog barks loudly", false);
        this.add("i j k", "feep", true);
        this.add("e f", "foo bar", false);
        this.add("e f", "baz bee", false);
        this.add("z", "boo", false);
        this.add("y", "bee", true);
        this.tokensIn = new MockTokenizer(MockTokenizer.WHITESPACE, true);
        this.tokensIn.setReader((Reader)new StringReader("a"));
        this.tokensIn.reset();
        TestSynonymMapFilter.assertTrue((boolean)this.tokensIn.incrementToken());
        TestSynonymMapFilter.assertFalse((boolean)this.tokensIn.incrementToken());
        this.tokensIn.end();
        this.tokensIn.close();
        this.tokensOut = new SynonymFilter((TokenStream)this.tokensIn, this.b.build(), true);
        this.termAtt = (CharTermAttribute)this.tokensOut.addAttribute(CharTermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.tokensOut.addAttribute(PositionIncrementAttribute.class);
        this.posLenAtt = (PositionLengthAttribute)this.tokensOut.addAttribute(PositionLengthAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.tokensOut.addAttribute(OffsetAttribute.class);
        this.verify("a b c", "a/bar b/fee c");
        this.verify("x a b c d", "x a/bar b/fee c/dog d/harness holder extras");
        this.verify("a b a", "a/bar b/fee a/foo");
        this.verify("c d c d", "c/dog d/harness c/holder/dog d/extras/harness holder extras");
        this.verify("e f", "foo/baz bar/bee");
        this.verify("g i j k g", "g i/feep:7_3 j k g");
        this.verify("a m c e x", "a/foo dog barks loudly x");
        this.verify("c d m c e x", "c/dog d/harness holder/dog extras/barks loudly x");
        TestSynonymMapFilter.assertTrue((this.tokensOut.getCaptureCount() > 0 ? 1 : 0) != 0);
        this.verify("p q r s t", "p q r s t");
        TestSynonymMapFilter.assertEquals((long)0L, (long)this.tokensOut.getCaptureCount());
        this.verify("p q z y t", "p q boo y/bee t");
        TestSynonymMapFilter.assertEquals((long)0L, (long)this.tokensOut.getCaptureCount());
    }

    private String getRandomString(char start, int alphabetSize, int length) {
        assert (alphabetSize <= 26);
        char[] s = new char[2 * length];
        for (int charIDX = 0; charIDX < length; ++charIDX) {
            s[2 * charIDX] = (char)(start + TestSynonymMapFilter.random().nextInt(alphabetSize));
            s[2 * charIDX + 1] = 32;
        }
        return new String(s);
    }

    public String slowSynMatcher(String doc, List<OneSyn> syns, int maxOutputLength) {
        int inputIDX;
        TestSynonymMapFilter.assertTrue((doc.length() % 2 == 0 ? 1 : 0) != 0);
        int numInputs = doc.length() / 2;
        boolean[] keepOrigs = new boolean[numInputs];
        boolean[] hasMatch = new boolean[numInputs];
        Arrays.fill(keepOrigs, false);
        String[] outputs = new String[numInputs + maxOutputLength];
        OneSyn[] matches = new OneSyn[numInputs];
        for (OneSyn syn : syns) {
            int idx = -1;
            while ((idx = doc.indexOf(syn.in, 1 + idx)) != -1) {
                TestSynonymMapFilter.assertTrue((idx % 2 == 0 ? 1 : 0) != 0);
                int matchIDX = idx / 2;
                TestSynonymMapFilter.assertTrue((syn.in.length() % 2 == 1 ? 1 : 0) != 0);
                if (matches[matchIDX] == null) {
                    matches[matchIDX] = syn;
                    continue;
                }
                if (syn.in.length() > matches[matchIDX].in.length()) {
                    matches[matchIDX] = syn;
                    continue;
                }
                TestSynonymMapFilter.assertTrue((syn.in.length() < matches[matchIDX].in.length() ? 1 : 0) != 0);
            }
        }
        for (inputIDX = 0; inputIDX < numInputs; ++inputIDX) {
            OneSyn match = matches[inputIDX];
            if (match == null) continue;
            int synInLength = (1 + match.in.length()) / 2;
            for (int nextInputIDX = inputIDX + 1; nextInputIDX < numInputs && nextInputIDX < inputIDX + synInLength; ++nextInputIDX) {
                matches[nextInputIDX] = null;
            }
        }
        for (inputIDX = 0; inputIDX < numInputs; ++inputIDX) {
            OneSyn syn;
            syn = matches[inputIDX];
            if (syn == null) continue;
            for (int idx = 0; idx < (1 + syn.in.length()) / 2; ++idx) {
                hasMatch[inputIDX + idx] = true;
                int n = inputIDX + idx;
                keepOrigs[n] = keepOrigs[n] | syn.keepOrig;
            }
            for (String synOut : syn.out) {
                String[] synOutputs = synOut.split(" ");
                TestSynonymMapFilter.assertEquals((long)synOutputs.length, (long)((1 + synOut.length()) / 2));
                int matchEnd = inputIDX + synOutputs.length;
                int synUpto = 0;
                for (int matchIDX = inputIDX; matchIDX < matchEnd; ++matchIDX) {
                    int posLen;
                    int endOffset;
                    outputs[matchIDX] = outputs[matchIDX] == null ? synOutputs[synUpto++] : outputs[matchIDX] + "/" + synOutputs[synUpto++];
                    if (matchIDX >= numInputs) continue;
                    if (synOutputs.length == 1) {
                        endOffset = inputIDX * 2 + syn.in.length();
                        posLen = syn.keepOrig ? (1 + syn.in.length()) / 2 : 1;
                    } else {
                        endOffset = matchIDX * 2 + 1;
                        posLen = 1;
                    }
                    outputs[matchIDX] = outputs[matchIDX] + ":" + endOffset + "_" + posLen;
                }
            }
        }
        StringBuilder sb = new StringBuilder();
        String[] inputTokens = doc.split(" ");
        int limit = inputTokens.length + maxOutputLength;
        for (int inputIDX2 = 0; inputIDX2 < limit; ++inputIDX2) {
            boolean posHasOutput = false;
            if (inputIDX2 >= numInputs && outputs[inputIDX2] == null) break;
            if (inputIDX2 < numInputs && (!hasMatch[inputIDX2] || keepOrigs[inputIDX2])) {
                TestSynonymMapFilter.assertTrue((inputTokens[inputIDX2].length() != 0 ? 1 : 0) != 0);
                sb.append(inputTokens[inputIDX2]);
                posHasOutput = true;
            }
            if (outputs[inputIDX2] != null) {
                if (posHasOutput) {
                    sb.append('/');
                }
                sb.append(outputs[inputIDX2]);
            } else if (!posHasOutput) continue;
            if (inputIDX2 >= limit - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public void testRandom() throws Exception {
        int alphabetSize = TestUtil.nextInt((Random)TestSynonymMapFilter.random(), (int)2, (int)7);
        int docLen = TestSynonymMapFilter.atLeast((int)3000);
        String document = this.getRandomString('a', alphabetSize, docLen);
        if (VERBOSE) {
            System.out.println("TEST: doc=" + document);
        }
        int numSyn = TestSynonymMapFilter.atLeast((int)5);
        HashMap<String, OneSyn> synMap = new HashMap<String, OneSyn>();
        ArrayList<OneSyn> syns = new ArrayList<OneSyn>();
        boolean dedup = TestSynonymMapFilter.random().nextBoolean();
        if (VERBOSE) {
            System.out.println("  dedup=" + dedup);
        }
        this.b = new SynonymMap.Builder(dedup);
        for (int synIDX = 0; synIDX < numSyn; ++synIDX) {
            String synIn = this.getRandomString('a', alphabetSize, TestUtil.nextInt((Random)TestSynonymMapFilter.random(), (int)1, (int)5)).trim();
            OneSyn s = (OneSyn)synMap.get(synIn);
            if (s == null) {
                s = new OneSyn();
                s.in = synIn;
                syns.add(s);
                s.out = new ArrayList<String>();
                synMap.put(synIn, s);
                s.keepOrig = TestSynonymMapFilter.random().nextBoolean();
            }
            String synOut = this.getRandomString('0', 10, TestUtil.nextInt((Random)TestSynonymMapFilter.random(), (int)1, (int)5)).trim();
            s.out.add(synOut);
            this.add(synIn, synOut, s.keepOrig);
            if (!VERBOSE) continue;
            System.out.println("  syns[" + synIDX + "] = " + s.in + " -> " + s.out + " keepOrig=" + s.keepOrig);
        }
        this.tokensIn = new MockTokenizer(MockTokenizer.WHITESPACE, true);
        this.tokensIn.setReader((Reader)new StringReader("a"));
        this.tokensIn.reset();
        TestSynonymMapFilter.assertTrue((boolean)this.tokensIn.incrementToken());
        TestSynonymMapFilter.assertFalse((boolean)this.tokensIn.incrementToken());
        this.tokensIn.end();
        this.tokensIn.close();
        this.tokensOut = new SynonymFilter((TokenStream)this.tokensIn, this.b.build(), true);
        this.termAtt = (CharTermAttribute)this.tokensOut.addAttribute(CharTermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.tokensOut.addAttribute(PositionIncrementAttribute.class);
        this.posLenAtt = (PositionLengthAttribute)this.tokensOut.addAttribute(PositionLengthAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.tokensOut.addAttribute(OffsetAttribute.class);
        if (dedup) {
            this.pruneDups(syns);
        }
        String expected = this.slowSynMatcher(document, syns, 5);
        if (VERBOSE) {
            System.out.println("TEST: expected=" + expected);
        }
        this.verify(document, expected);
    }

    private void pruneDups(List<OneSyn> syns) {
        HashSet<String> seen = new HashSet<String>();
        for (OneSyn syn : syns) {
            int idx = 0;
            while (idx < syn.out.size()) {
                String out = syn.out.get(idx);
                if (!seen.contains(out)) {
                    seen.add(out);
                    ++idx;
                    continue;
                }
                syn.out.remove(idx);
            }
            seen.clear();
        }
    }

    private String randomNonEmptyString() {
        String s;
        while ((s = TestUtil.randomUnicodeString((Random)TestSynonymMapFilter.random()).trim()).length() == 0 || s.indexOf(0) != -1) {
        }
        return s;
    }

    public void testRandom2() throws Exception {
        int numIters = TestSynonymMapFilter.atLeast((int)3);
        for (int i = 0; i < numIters; ++i) {
            this.b = new SynonymMap.Builder(TestSynonymMapFilter.random().nextBoolean());
            int numEntries = TestSynonymMapFilter.atLeast((int)10);
            for (int j = 0; j < numEntries; ++j) {
                this.add(this.randomNonEmptyString(), this.randomNonEmptyString(), TestSynonymMapFilter.random().nextBoolean());
            }
            final SynonymMap map = this.b.build();
            final boolean ignoreCase = TestSynonymMapFilter.random().nextBoolean();
            Analyzer analyzer = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, ignoreCase));
                }
            };
            TestSynonymMapFilter.checkRandomData((Random)TestSynonymMapFilter.random(), (Analyzer)analyzer, (int)100);
            analyzer.close();
        }
    }

    public void testRandom2GraphAfter() throws Exception {
        int numIters = TestSynonymMapFilter.atLeast((int)3);
        Random random = TestSynonymMapFilter.random();
        for (int i = 0; i < numIters; ++i) {
            this.b = new SynonymMap.Builder(random.nextBoolean());
            int numEntries = TestSynonymMapFilter.atLeast((int)10);
            for (int j = 0; j < numEntries; ++j) {
                this.add(this.randomNonEmptyString(), this.randomNonEmptyString(), random.nextBoolean());
            }
            final SynonymMap map = this.b.build();
            final boolean ignoreCase = random.nextBoolean();
            Analyzer analyzer = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
                    SynonymFilter syns = new SynonymFilter((TokenStream)tokenizer, map, ignoreCase);
                    MockGraphTokenFilter graph = new MockGraphTokenFilter(LuceneTestCase.random(), (TokenStream)syns);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)graph);
                }
            };
            TestSynonymMapFilter.checkRandomData((Random)random, (Analyzer)analyzer, (int)100);
            analyzer.close();
        }
    }

    public void testEmptyTerm() throws IOException {
        Random random = TestSynonymMapFilter.random();
        int numIters = TestSynonymMapFilter.atLeast((int)10);
        for (int i = 0; i < numIters; ++i) {
            this.b = new SynonymMap.Builder(random.nextBoolean());
            int numEntries = TestSynonymMapFilter.atLeast((int)10);
            for (int j = 0; j < numEntries; ++j) {
                this.add(this.randomNonEmptyString(), this.randomNonEmptyString(), random.nextBoolean());
            }
            final SynonymMap map = this.b.build();
            final boolean ignoreCase = random.nextBoolean();
            Analyzer analyzer = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    KeywordTokenizer tokenizer = new KeywordTokenizer();
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, ignoreCase));
                }
            };
            TestSynonymMapFilter.checkAnalysisConsistency((Random)random, (Analyzer)analyzer, (boolean)random.nextBoolean(), (String)"");
            analyzer.close();
        }
    }

    public void testRandomHuge() throws Exception {
        Random random = TestSynonymMapFilter.random();
        int numIters = TestSynonymMapFilter.atLeast((int)3);
        for (int i = 0; i < numIters; ++i) {
            this.b = new SynonymMap.Builder(random.nextBoolean());
            int numEntries = TestSynonymMapFilter.atLeast((int)10);
            if (VERBOSE) {
                System.out.println("TEST: iter=" + i + " numEntries=" + numEntries);
            }
            for (int j = 0; j < numEntries; ++j) {
                this.add(this.randomNonEmptyString(), this.randomNonEmptyString(), random.nextBoolean());
            }
            final SynonymMap map = this.b.build();
            final boolean ignoreCase = random.nextBoolean();
            Analyzer analyzer = new Analyzer(){

                protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                    MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
                    return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, ignoreCase));
                }
            };
            TestSynonymMapFilter.checkRandomData((Random)random, (Analyzer)analyzer, (int)100, (int)1024);
            analyzer.close();
        }
    }

    public void testVanishingTerms() throws Exception {
        String testFile = "aaa => aaaa1 aaaa2 aaaa3\nbbb => bbbb1 bbbb2\n";
        MockAnalyzer synAnalyzer = new MockAnalyzer(TestSynonymMapFilter.random());
        SolrSynonymParser parser = new SolrSynonymParser(true, true, (Analyzer)synAnalyzer);
        parser.parse((Reader)new StringReader(testFile));
        final SynonymMap map = parser.build();
        synAnalyzer.close();
        Analyzer analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, true);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"xyzzy bbb pot of gold", (String[])new String[]{"xyzzy", "bbbb1", "pot", "bbbb2", "of", "gold"});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)analyzer, (String)"xyzzy aaa pot of gold", (String[])new String[]{"xyzzy", "aaaa1", "pot", "aaaa2", "of", "aaaa3", "gold"});
        analyzer.close();
    }

    public void testBasic2() throws Exception {
        this.b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add("aaa", "aaaa1 aaaa2 aaaa3", false);
        this.add("bbb", "bbbb1 bbbb2", false);
        this.tokensIn = new MockTokenizer(MockTokenizer.WHITESPACE, true);
        this.tokensIn.setReader((Reader)new StringReader("a"));
        this.tokensIn.reset();
        TestSynonymMapFilter.assertTrue((boolean)this.tokensIn.incrementToken());
        TestSynonymMapFilter.assertFalse((boolean)this.tokensIn.incrementToken());
        this.tokensIn.end();
        this.tokensIn.close();
        this.tokensOut = new SynonymFilter((TokenStream)this.tokensIn, this.b.build(), true);
        this.termAtt = (CharTermAttribute)this.tokensOut.addAttribute(CharTermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.tokensOut.addAttribute(PositionIncrementAttribute.class);
        this.posLenAtt = (PositionLengthAttribute)this.tokensOut.addAttribute(PositionLengthAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.tokensOut.addAttribute(OffsetAttribute.class);
        this.verify("xyzzy bbb pot of gold", "xyzzy bbbb1 pot/bbbb2 of gold");
        this.verify("xyzzy aaa pot of gold", "xyzzy aaaa1 pot/aaaa2 of/aaaa3 gold");
    }

    public void testMatching() throws Exception {
        this.b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add("a b", "ab", false);
        this.add("a c", "ac", false);
        this.add("a", "aa", false);
        this.add("b", "bb", false);
        this.add("z x c v", "zxcv", false);
        this.add("x c", "xc", false);
        final SynonymMap map = this.b.build();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSynonymMapFilter.checkOneTerm((Analyzer)a, (String)"$", (String)"$");
        TestSynonymMapFilter.checkOneTerm((Analyzer)a, (String)"a", (String)"aa");
        TestSynonymMapFilter.checkOneTerm((Analyzer)a, (String)"b", (String)"bb");
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"a $", (String[])new String[]{"aa", "$"}, (int[])new int[]{1, 1});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"$ a", (String[])new String[]{"$", "aa"}, (int[])new int[]{1, 1});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"a a", (String[])new String[]{"aa", "aa"}, (int[])new int[]{1, 1});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"z x c v", (String[])new String[]{"zxcv"}, (int[])new int[]{1});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"z x c $", (String[])new String[]{"z", "xc", "$"}, (int[])new int[]{1, 1, 1});
        a.close();
    }

    public void testRepeatsOff() throws Exception {
        this.b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add("a b", "ab", false);
        this.add("a b", "ab", false);
        this.add("a b", "ab", false);
        final SynonymMap map = this.b.build();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"a b", (String[])new String[]{"ab"}, (int[])new int[]{1});
        a.close();
    }

    public void testRepeatsOn() throws Exception {
        this.b = new SynonymMap.Builder(false);
        boolean keepOrig = false;
        this.add("a b", "ab", false);
        this.add("a b", "ab", false);
        this.add("a b", "ab", false);
        final SynonymMap map = this.b.build();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"a b", (String[])new String[]{"ab", "ab", "ab"}, (int[])new int[]{1, 0, 0});
        a.close();
    }

    public void testRecursion() throws Exception {
        this.b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add("zoo", "zoo", false);
        final SynonymMap map = this.b.build();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"zoo zoo $ zoo", (String[])new String[]{"zoo", "zoo", "$", "zoo"}, (int[])new int[]{1, 1, 1, 1});
        a.close();
    }

    public void testRecursion2() throws Exception {
        this.b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add("zoo", "zoo", false);
        this.add("zoo", "zoo zoo", false);
        final SynonymMap map = this.b.build();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"zoo zoo $ zoo", (String[])new String[]{"zoo", "zoo", "zoo", "zoo", "zoo", "$", "zoo", "zoo", "zoo", "zoo"}, (int[])new int[]{1, 0, 1, 0, 0, 1, 0, 1, 0, 1});
        a.close();
    }

    public void testOutputHangsOffEnd() throws Exception {
        this.b = new SynonymMap.Builder(true);
        boolean keepOrig = false;
        this.add("a", "a b", false);
        this.tokensIn = new MockTokenizer(MockTokenizer.WHITESPACE, true);
        this.tokensIn.setReader((Reader)new StringReader("a"));
        this.tokensIn.reset();
        TestSynonymMapFilter.assertTrue((boolean)this.tokensIn.incrementToken());
        TestSynonymMapFilter.assertFalse((boolean)this.tokensIn.incrementToken());
        this.tokensIn.end();
        this.tokensIn.close();
        this.tokensOut = new SynonymFilter((TokenStream)this.tokensIn, this.b.build(), true);
        this.termAtt = (CharTermAttribute)this.tokensOut.addAttribute(CharTermAttribute.class);
        this.posIncrAtt = (PositionIncrementAttribute)this.tokensOut.addAttribute(PositionIncrementAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.tokensOut.addAttribute(OffsetAttribute.class);
        this.posLenAtt = (PositionLengthAttribute)this.tokensOut.addAttribute(PositionLengthAttribute.class);
        this.verify("a", "a b:1");
    }

    public void testIncludeOrig() throws Exception {
        this.b = new SynonymMap.Builder(true);
        boolean keepOrig = true;
        this.add("a b", "ab", true);
        this.add("a c", "ac", true);
        this.add("a", "aa", true);
        this.add("b", "bb", true);
        this.add("z x c v", "zxcv", true);
        this.add("x c", "xc", true);
        final SynonymMap map = this.b.build();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"$", (String[])new String[]{"$"}, (int[])new int[]{1});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"a", (String[])new String[]{"a", "aa"}, (int[])new int[]{1, 0});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"a", (String[])new String[]{"a", "aa"}, (int[])new int[]{1, 0});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"$ a", (String[])new String[]{"$", "a", "aa"}, (int[])new int[]{1, 1, 0});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"a $", (String[])new String[]{"a", "aa", "$"}, (int[])new int[]{1, 0, 1});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"$ a !", (String[])new String[]{"$", "a", "aa", "!"}, (int[])new int[]{1, 1, 0, 1});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"a a", (String[])new String[]{"a", "aa", "a", "aa"}, (int[])new int[]{1, 0, 1, 0});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"b", (String[])new String[]{"b", "bb"}, (int[])new int[]{1, 0});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"z x c v", (String[])new String[]{"z", "zxcv", "x", "c", "v"}, (int[])new int[]{1, 0, 1, 1, 1});
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"z x c $", (String[])new String[]{"z", "x", "xc", "c", "$"}, (int[])new int[]{1, 1, 0, 1, 1});
        a.close();
    }

    public void testRecursion3() throws Exception {
        this.b = new SynonymMap.Builder(true);
        boolean keepOrig = true;
        this.add("zoo zoo", "zoo", true);
        final SynonymMap map = this.b.build();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"zoo zoo $ zoo", (String[])new String[]{"zoo", "zoo", "zoo", "$", "zoo"}, (int[])new int[]{1, 0, 1, 1, 1});
        a.close();
    }

    public void testRecursion4() throws Exception {
        this.b = new SynonymMap.Builder(true);
        boolean keepOrig = true;
        this.add("zoo zoo", "zoo", true);
        this.add("zoo", "zoo zoo", true);
        final SynonymMap map = this.b.build();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"zoo zoo $ zoo", (String[])new String[]{"zoo", "zoo", "zoo", "$", "zoo", "zoo", "zoo"}, (int[])new int[]{1, 0, 1, 1, 1, 0, 1});
        a.close();
    }

    public void testMultiwordOffsets() throws Exception {
        this.b = new SynonymMap.Builder(true);
        boolean keepOrig = true;
        this.add("national hockey league", "nhl", true);
        final SynonymMap map = this.b.build();
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, true));
            }
        };
        TestSynonymMapFilter.assertAnalyzesTo((Analyzer)a, (String)"national hockey league", (String[])new String[]{"national", "nhl", "hockey", "league"}, (int[])new int[]{0, 0, 9, 16}, (int[])new int[]{8, 22, 15, 22}, (int[])new int[]{1, 0, 1, 1});
        a.close();
    }

    public void testEmpty() throws Exception {
        MockTokenizer tokenizer = new MockTokenizer();
        tokenizer.setReader((Reader)new StringReader("aa bb"));
        IllegalArgumentException expected = (IllegalArgumentException)TestSynonymMapFilter.expectThrows(IllegalArgumentException.class, () -> TestSynonymMapFilter.lambda$testEmpty$0((Tokenizer)tokenizer));
        TestSynonymMapFilter.assertEquals((Object)"fst must be non-null", (Object)expected.getMessage());
    }

    private static /* synthetic */ void lambda$testEmpty$0(Tokenizer tokenizer) throws Throwable {
        new SynonymFilter((TokenStream)tokenizer, new SynonymMap.Builder(true).build(), true);
    }

    private static class OneSyn {
        String in;
        List<String> out;
        boolean keepOrig;

        private OneSyn() {
        }
    }
}

