/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.synonym.SynonymFilter;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.analysis.synonym.WordnetSynonymParser;

public class TestWordnetSynonymParser
extends BaseTokenStreamTestCase {
    String synonymsFile = "s(100000001,1,'woods',n,1,0).\ns(100000001,2,'wood',n,1,0).\ns(100000001,3,'forest',n,1,0).\ns(100000002,1,'wolfish',n,1,0).\ns(100000002,2,'ravenous',n,1,0).\ns(100000003,1,'king',n,1,1).\ns(100000003,2,'baron',n,1,1).\ns(100000004,1,'king''s evil',n,1,1).\ns(100000004,2,'king''s meany',n,1,1).\n";

    public void testSynonyms() throws Exception {
        Object analyzer = new MockAnalyzer(TestWordnetSynonymParser.random());
        WordnetSynonymParser parser = new WordnetSynonymParser(true, true, (Analyzer)analyzer);
        parser.parse((Reader)new StringReader(this.synonymsFile));
        final SynonymMap map = parser.build();
        analyzer.close();
        analyzer = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new SynonymFilter((TokenStream)tokenizer, map, false));
            }
        };
        TestWordnetSynonymParser.assertAnalyzesTo((Analyzer)analyzer, (String)"Lost in the woods", (String[])new String[]{"Lost", "in", "the", "woods", "wood", "forest"}, (int[])new int[]{0, 5, 8, 12, 12, 12}, (int[])new int[]{4, 7, 11, 17, 17, 17}, (int[])new int[]{1, 1, 1, 1, 0, 0});
        TestWordnetSynonymParser.assertAnalyzesTo((Analyzer)analyzer, (String)"king", (String[])new String[]{"king", "baron"});
        TestWordnetSynonymParser.assertAnalyzesTo((Analyzer)analyzer, (String)"king's evil", (String[])new String[]{"king's", "king's", "evil", "meany"});
        analyzer.close();
    }
}

