/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.util.Version;

public class TestThaiAnalyzer
extends BaseTokenStreamTestCase {
    public void setUp() throws Exception {
        super.setUp();
        TestThaiAnalyzer.assumeTrue((String)"JRE does not support Thai dictionary-based BreakIterator", (boolean)ThaiTokenizer.DBBI_AVAILABLE);
    }

    public void testOffsets() throws Exception {
        ThaiAnalyzer analyzer = new ThaiAnalyzer(CharArraySet.EMPTY_SET);
        TestThaiAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e15\u0e49\u0e2d\u0e07\u0e41\u0e2a\u0e14\u0e07\u0e27\u0e48\u0e32\u0e07\u0e32\u0e19\u0e14\u0e35", (String[])new String[]{"\u0e01\u0e32\u0e23", "\u0e17\u0e35\u0e48", "\u0e44\u0e14\u0e49", "\u0e15\u0e49\u0e2d\u0e07", "\u0e41\u0e2a\u0e14\u0e07", "\u0e27\u0e48\u0e32", "\u0e07\u0e32\u0e19", "\u0e14\u0e35"}, (int[])new int[]{0, 3, 6, 9, 13, 17, 20, 23}, (int[])new int[]{3, 6, 9, 13, 17, 20, 23, 25});
        analyzer.close();
    }

    public void testStopWords() throws Exception {
        ThaiAnalyzer analyzer = new ThaiAnalyzer();
        TestThaiAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e15\u0e49\u0e2d\u0e07\u0e41\u0e2a\u0e14\u0e07\u0e27\u0e48\u0e32\u0e07\u0e32\u0e19\u0e14\u0e35", (String[])new String[]{"\u0e41\u0e2a\u0e14\u0e07", "\u0e07\u0e32\u0e19", "\u0e14\u0e35"}, (int[])new int[]{13, 20, 23}, (int[])new int[]{17, 23, 25}, (int[])new int[]{5, 2, 1});
        analyzer.close();
    }

    public void testPositionIncrements() throws Exception {
        ThaiAnalyzer analyzer = new ThaiAnalyzer(StopAnalyzer.ENGLISH_STOP_WORDS_SET);
        TestThaiAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e15\u0e49\u0e2d\u0e07 the \u0e41\u0e2a\u0e14\u0e07\u0e27\u0e48\u0e32\u0e07\u0e32\u0e19\u0e14\u0e35", (String[])new String[]{"\u0e01\u0e32\u0e23", "\u0e17\u0e35\u0e48", "\u0e44\u0e14\u0e49", "\u0e15\u0e49\u0e2d\u0e07", "\u0e41\u0e2a\u0e14\u0e07", "\u0e27\u0e48\u0e32", "\u0e07\u0e32\u0e19", "\u0e14\u0e35"}, (int[])new int[]{0, 3, 6, 9, 18, 22, 25, 28}, (int[])new int[]{3, 6, 9, 13, 22, 25, 28, 30}, (int[])new int[]{1, 1, 1, 1, 2, 1, 1, 1});
        TestThaiAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e15\u0e49\u0e2d\u0e07the \u0e41\u0e2a\u0e14\u0e07\u0e27\u0e48\u0e32\u0e07\u0e32\u0e19\u0e14\u0e35", (String[])new String[]{"\u0e01\u0e32\u0e23", "\u0e17\u0e35\u0e48", "\u0e44\u0e14\u0e49", "\u0e15\u0e49\u0e2d\u0e07", "\u0e41\u0e2a\u0e14\u0e07", "\u0e27\u0e48\u0e32", "\u0e07\u0e32\u0e19", "\u0e14\u0e35"}, (int[])new int[]{0, 3, 6, 9, 17, 21, 24, 27}, (int[])new int[]{3, 6, 9, 13, 21, 24, 27, 29}, (int[])new int[]{1, 1, 1, 1, 2, 1, 1, 1});
        analyzer.close();
    }

    public void testReusableTokenStream() throws Exception {
        ThaiAnalyzer analyzer = new ThaiAnalyzer(CharArraySet.EMPTY_SET);
        TestThaiAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"", (String[])new String[0]);
        TestThaiAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e15\u0e49\u0e2d\u0e07\u0e41\u0e2a\u0e14\u0e07\u0e27\u0e48\u0e32\u0e07\u0e32\u0e19\u0e14\u0e35", (String[])new String[]{"\u0e01\u0e32\u0e23", "\u0e17\u0e35\u0e48", "\u0e44\u0e14\u0e49", "\u0e15\u0e49\u0e2d\u0e07", "\u0e41\u0e2a\u0e14\u0e07", "\u0e27\u0e48\u0e32", "\u0e07\u0e32\u0e19", "\u0e14\u0e35"});
        TestThaiAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"\u0e1a\u0e23\u0e34\u0e29\u0e31\u0e17\u0e0a\u0e37\u0e48\u0e2d XY&Z - \u0e04\u0e38\u0e22\u0e01\u0e31\u0e1a xyz@demo.com", (String[])new String[]{"\u0e1a\u0e23\u0e34\u0e29\u0e31\u0e17", "\u0e0a\u0e37\u0e48\u0e2d", "xy", "z", "\u0e04\u0e38\u0e22", "\u0e01\u0e31\u0e1a", "xyz", "demo.com"});
        analyzer.close();
    }

    public void testRandomStrings() throws Exception {
        ThaiAnalyzer analyzer = new ThaiAnalyzer();
        TestThaiAnalyzer.checkRandomData((Random)TestThaiAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }

    public void testRandomHugeStrings() throws Exception {
        ThaiAnalyzer analyzer = new ThaiAnalyzer();
        TestThaiAnalyzer.checkRandomData((Random)TestThaiAnalyzer.random(), (Analyzer)analyzer, (int)(100 * RANDOM_MULTIPLIER), (int)8192);
        analyzer.close();
    }

    public void testAttributeReuse() throws Exception {
        ThaiAnalyzer analyzer = new ThaiAnalyzer();
        TokenStream ts = analyzer.tokenStream("dummy", "\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22");
        TestThaiAnalyzer.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"\u0e20\u0e32\u0e29\u0e32", "\u0e44\u0e17\u0e22"});
        ts = analyzer.tokenStream("dummy", "\u0e20\u0e32\u0e29\u0e32\u0e44\u0e17\u0e22");
        ts.addAttribute(FlagsAttribute.class);
        TestThaiAnalyzer.assertTokenStreamContents((TokenStream)ts, (String[])new String[]{"\u0e20\u0e32\u0e29\u0e32", "\u0e44\u0e17\u0e22"});
        analyzer.close();
    }

    public void testDigits() throws Exception {
        ThaiAnalyzer a = new ThaiAnalyzer();
        TestThaiAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0e51\u0e52\u0e53\u0e54", (String)"1234");
        a.close();
    }

    @Deprecated
    public void testDigitsBackCompat() throws Exception {
        ThaiAnalyzer a = new ThaiAnalyzer();
        a.setVersion(Version.LUCENE_5_3_0);
        TestThaiAnalyzer.checkOneTerm((Analyzer)a, (String)"\u0e51\u0e52\u0e53\u0e54", (String)"\u0e51\u0e52\u0e53\u0e54");
        a.close();
    }

    public void testTwoSentences() throws Exception {
        ThaiAnalyzer analyzer = new ThaiAnalyzer(CharArraySet.EMPTY_SET);
        TestThaiAnalyzer.assertAnalyzesTo((Analyzer)analyzer, (String)"This is a test. \u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e15\u0e49\u0e2d\u0e07\u0e41\u0e2a\u0e14\u0e07\u0e27\u0e48\u0e32\u0e07\u0e32\u0e19\u0e14\u0e35", (String[])new String[]{"this", "is", "a", "test", "\u0e01\u0e32\u0e23", "\u0e17\u0e35\u0e48", "\u0e44\u0e14\u0e49", "\u0e15\u0e49\u0e2d\u0e07", "\u0e41\u0e2a\u0e14\u0e07", "\u0e27\u0e48\u0e32", "\u0e07\u0e32\u0e19", "\u0e14\u0e35"}, (int[])new int[]{0, 5, 8, 10, 16, 19, 22, 25, 29, 33, 36, 39}, (int[])new int[]{4, 7, 9, 14, 19, 22, 25, 29, 33, 36, 39, 41});
        analyzer.close();
    }
}

