/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.th;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.th.ThaiTokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestThaiTokenizerFactory
extends BaseTokenStreamFactoryTestCase {
    public void testWordBreak() throws Exception {
        TestThaiTokenizerFactory.assumeTrue((String)"JRE does not support Thai dictionary-based BreakIterator", (boolean)ThaiTokenizer.DBBI_AVAILABLE);
        Tokenizer tokenizer = this.tokenizerFactory("Thai", new String[0]).create(TestThaiTokenizerFactory.newAttributeFactory());
        tokenizer.setReader((Reader)new StringReader("\u0e01\u0e32\u0e23\u0e17\u0e35\u0e48\u0e44\u0e14\u0e49\u0e15\u0e49\u0e2d\u0e07\u0e41\u0e2a\u0e14\u0e07\u0e27\u0e48\u0e32\u0e07\u0e32\u0e19\u0e14\u0e35"));
        TestThaiTokenizerFactory.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"\u0e01\u0e32\u0e23", "\u0e17\u0e35\u0e48", "\u0e44\u0e14\u0e49", "\u0e15\u0e49\u0e2d\u0e07", "\u0e41\u0e2a\u0e14\u0e07", "\u0e27\u0e48\u0e32", "\u0e07\u0e32\u0e19", "\u0e14\u0e35"});
    }

    public void testBogusArguments() throws Exception {
        TestThaiTokenizerFactory.assumeTrue((String)"JRE does not support Thai dictionary-based BreakIterator", (boolean)ThaiTokenizer.DBBI_AVAILABLE);
        IllegalArgumentException expected = (IllegalArgumentException)TestThaiTokenizerFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("Thai", "bogusArg", "bogusValue"));
        TestThaiTokenizerFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

