/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tr;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestApostropheFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testApostrophes() throws Exception {
        StringReader reader = new StringReader("T\u00fcrkiye'de 2003'te Van G\u00f6l\u00fc'n\u00fc g\u00f6rd\u00fcm");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("Apostrophe", new String[0]).create((TokenStream)stream);
        TestApostropheFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"T\u00fcrkiye", "2003", "Van", "G\u00f6l\u00fc", "g\u00f6rd\u00fcm"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestApostropheFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Apostrophe", "bogusArg", "bogusValue"));
        TestApostropheFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameter(s):"));
    }
}

