/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tr;

import java.io.IOException;
import java.util.Collection;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;

public class TestTurkishAnalyzer
extends BaseTokenStreamTestCase {
    public void testResourcesAvailable() {
        new TurkishAnalyzer().close();
    }

    public void testBasics() throws IOException {
        TurkishAnalyzer a = new TurkishAnalyzer();
        TestTurkishAnalyzer.checkOneTerm((Analyzer)a, (String)"a\u011fac\u0131", (String)"a\u011fa\u00e7");
        TestTurkishAnalyzer.checkOneTerm((Analyzer)a, (String)"a\u011fa\u00e7", (String)"a\u011fa\u00e7");
        TestTurkishAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"dolay\u0131", (String[])new String[0]);
        TestTurkishAnalyzer.checkOneTerm((Analyzer)a, (String)"K\u0131br\u0131s'ta", (String)"k\u0131br\u0131s");
        TestTurkishAnalyzer.assertAnalyzesTo((Analyzer)a, (String)"Van G\u00f6l\u00fc'ne", (String[])new String[]{"van", "g\u00f6l"});
        a.close();
    }

    public void testExclude() throws IOException {
        CharArraySet exclusionSet = new CharArraySet((Collection)TestTurkishAnalyzer.asSet((Object[])new String[]{"a\u011fac\u0131"}), false);
        TurkishAnalyzer a = new TurkishAnalyzer(TurkishAnalyzer.getDefaultStopSet(), exclusionSet);
        TestTurkishAnalyzer.checkOneTerm((Analyzer)a, (String)"a\u011fac\u0131", (String)"a\u011fac\u0131");
        TestTurkishAnalyzer.checkOneTerm((Analyzer)a, (String)"a\u011fa\u00e7", (String)"a\u011fa\u00e7");
        a.close();
    }

    public void testRandomStrings() throws Exception {
        TurkishAnalyzer analyzer = new TurkishAnalyzer();
        TestTurkishAnalyzer.checkRandomData((Random)TestTurkishAnalyzer.random(), (Analyzer)analyzer, (int)(1000 * RANDOM_MULTIPLIER));
        analyzer.close();
    }
}

