/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tr;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.tr.TurkishLowerCaseFilter;

public class TestTurkishLowerCaseFilter
extends BaseTokenStreamTestCase {
    public void testTurkishLowerCaseFilter() throws Exception {
        MockTokenizer stream = TestTurkishLowerCaseFilter.whitespaceMockTokenizer((String)"\u0130STANBUL \u0130ZM\u0130R ISPARTA");
        TurkishLowerCaseFilter filter = new TurkishLowerCaseFilter((TokenStream)stream);
        TestTurkishLowerCaseFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"istanbul", "izmir", "\u0131sparta"});
    }

    public void testDecomposed() throws Exception {
        MockTokenizer stream = TestTurkishLowerCaseFilter.whitespaceMockTokenizer((String)"I\u0307STANBUL I\u0307ZMI\u0307R ISPARTA");
        TurkishLowerCaseFilter filter = new TurkishLowerCaseFilter((TokenStream)stream);
        TestTurkishLowerCaseFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"istanbul", "izmir", "\u0131sparta"});
    }

    public void testDecomposed2() throws Exception {
        MockTokenizer stream = TestTurkishLowerCaseFilter.whitespaceMockTokenizer((String)"I\u0316\u0307STANBUL I\u0307ZMI\u0307R I\u0316SPARTA");
        TurkishLowerCaseFilter filter = new TurkishLowerCaseFilter((TokenStream)stream);
        TestTurkishLowerCaseFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"i\u0316stanbul", "izmir", "\u0131\u0316sparta"});
    }

    public void testDecomposed3() throws Exception {
        MockTokenizer stream = TestTurkishLowerCaseFilter.whitespaceMockTokenizer((String)"I\u0307");
        TurkishLowerCaseFilter filter = new TurkishLowerCaseFilter((TokenStream)stream);
        TestTurkishLowerCaseFilter.assertTokenStreamContents((TokenStream)filter, (String[])new String[]{"i"});
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new TurkishLowerCaseFilter((TokenStream)tokenizer));
            }
        };
        TestTurkishLowerCaseFilter.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

