/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tr;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestTurkishLowerCaseFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testCasing() throws Exception {
        StringReader reader = new StringReader("A\u011eACI");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("TurkishLowerCase", new String[0]).create((TokenStream)stream);
        TestTurkishLowerCaseFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"a\u011fac\u0131"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestTurkishLowerCaseFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("TurkishLowerCase", "bogusArg", "bogusValue"));
        TestTurkishLowerCaseFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

