/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilterFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.miscellaneous.RemoveDuplicatesTokenFilterFactory;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.Version;

public class TestAnalysisSPILoader
extends LuceneTestCase {
    private Map<String, String> versionArgOnly() {
        return new HashMap<String, String>(){
            {
                this.put("luceneMatchVersion", Version.LATEST.toString());
            }
        };
    }

    public void testLookupTokenizer() {
        TestAnalysisSPILoader.assertSame(WhitespaceTokenizerFactory.class, TokenizerFactory.forName((String)"Whitespace", this.versionArgOnly()).getClass());
        TestAnalysisSPILoader.assertSame(WhitespaceTokenizerFactory.class, TokenizerFactory.forName((String)"WHITESPACE", this.versionArgOnly()).getClass());
        TestAnalysisSPILoader.assertSame(WhitespaceTokenizerFactory.class, TokenizerFactory.forName((String)"whitespace", this.versionArgOnly()).getClass());
    }

    public void testBogusLookupTokenizer() {
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> TokenizerFactory.forName((String)"sdfsdfsdfdsfsdfsdf", new HashMap()));
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> TokenizerFactory.forName((String)"!(**#$U*#$*", new HashMap()));
    }

    public void testLookupTokenizerClass() {
        TestAnalysisSPILoader.assertSame(WhitespaceTokenizerFactory.class, (Object)TokenizerFactory.lookupClass((String)"Whitespace"));
        TestAnalysisSPILoader.assertSame(WhitespaceTokenizerFactory.class, (Object)TokenizerFactory.lookupClass((String)"WHITESPACE"));
        TestAnalysisSPILoader.assertSame(WhitespaceTokenizerFactory.class, (Object)TokenizerFactory.lookupClass((String)"whitespace"));
    }

    public void testBogusLookupTokenizerClass() {
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> TokenizerFactory.lookupClass((String)"sdfsdfsdfdsfsdfsdf"));
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> TokenizerFactory.lookupClass((String)"!(**#$U*#$*"));
    }

    public void testAvailableTokenizers() {
        TestAnalysisSPILoader.assertTrue((boolean)TokenizerFactory.availableTokenizers().contains("whitespace"));
    }

    public void testLookupTokenFilter() {
        TestAnalysisSPILoader.assertSame(LowerCaseFilterFactory.class, TokenFilterFactory.forName((String)"Lowercase", this.versionArgOnly()).getClass());
        TestAnalysisSPILoader.assertSame(LowerCaseFilterFactory.class, TokenFilterFactory.forName((String)"LOWERCASE", this.versionArgOnly()).getClass());
        TestAnalysisSPILoader.assertSame(LowerCaseFilterFactory.class, TokenFilterFactory.forName((String)"lowercase", this.versionArgOnly()).getClass());
        TestAnalysisSPILoader.assertSame(RemoveDuplicatesTokenFilterFactory.class, TokenFilterFactory.forName((String)"RemoveDuplicates", this.versionArgOnly()).getClass());
        TestAnalysisSPILoader.assertSame(RemoveDuplicatesTokenFilterFactory.class, TokenFilterFactory.forName((String)"REMOVEDUPLICATES", this.versionArgOnly()).getClass());
        TestAnalysisSPILoader.assertSame(RemoveDuplicatesTokenFilterFactory.class, TokenFilterFactory.forName((String)"removeduplicates", this.versionArgOnly()).getClass());
    }

    public void testBogusLookupTokenFilter() {
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> TokenFilterFactory.forName((String)"sdfsdfsdfdsfsdfsdf", new HashMap()));
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> TokenFilterFactory.forName((String)"!(**#$U*#$*", new HashMap()));
    }

    public void testLookupTokenFilterClass() {
        TestAnalysisSPILoader.assertSame(LowerCaseFilterFactory.class, (Object)TokenFilterFactory.lookupClass((String)"Lowercase"));
        TestAnalysisSPILoader.assertSame(LowerCaseFilterFactory.class, (Object)TokenFilterFactory.lookupClass((String)"LOWERCASE"));
        TestAnalysisSPILoader.assertSame(LowerCaseFilterFactory.class, (Object)TokenFilterFactory.lookupClass((String)"lowercase"));
        TestAnalysisSPILoader.assertSame(RemoveDuplicatesTokenFilterFactory.class, (Object)TokenFilterFactory.lookupClass((String)"RemoveDuplicates"));
        TestAnalysisSPILoader.assertSame(RemoveDuplicatesTokenFilterFactory.class, (Object)TokenFilterFactory.lookupClass((String)"REMOVEDUPLICATES"));
        TestAnalysisSPILoader.assertSame(RemoveDuplicatesTokenFilterFactory.class, (Object)TokenFilterFactory.lookupClass((String)"removeduplicates"));
    }

    public void testBogusLookupTokenFilterClass() {
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> TokenFilterFactory.lookupClass((String)"sdfsdfsdfdsfsdfsdf"));
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> TokenFilterFactory.lookupClass((String)"!(**#$U*#$*"));
    }

    public void testAvailableTokenFilters() {
        TestAnalysisSPILoader.assertTrue((boolean)TokenFilterFactory.availableTokenFilters().contains("lowercase"));
        TestAnalysisSPILoader.assertTrue((boolean)TokenFilterFactory.availableTokenFilters().contains("removeduplicates"));
    }

    public void testLookupCharFilter() {
        TestAnalysisSPILoader.assertSame(HTMLStripCharFilterFactory.class, CharFilterFactory.forName((String)"HTMLStrip", this.versionArgOnly()).getClass());
        TestAnalysisSPILoader.assertSame(HTMLStripCharFilterFactory.class, CharFilterFactory.forName((String)"HTMLSTRIP", this.versionArgOnly()).getClass());
        TestAnalysisSPILoader.assertSame(HTMLStripCharFilterFactory.class, CharFilterFactory.forName((String)"htmlstrip", this.versionArgOnly()).getClass());
    }

    public void testBogusLookupCharFilter() {
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> CharFilterFactory.forName((String)"sdfsdfsdfdsfsdfsdf", new HashMap()));
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> CharFilterFactory.forName((String)"!(**#$U*#$*", new HashMap()));
    }

    public void testLookupCharFilterClass() {
        TestAnalysisSPILoader.assertSame(HTMLStripCharFilterFactory.class, (Object)CharFilterFactory.lookupClass((String)"HTMLStrip"));
        TestAnalysisSPILoader.assertSame(HTMLStripCharFilterFactory.class, (Object)CharFilterFactory.lookupClass((String)"HTMLSTRIP"));
        TestAnalysisSPILoader.assertSame(HTMLStripCharFilterFactory.class, (Object)CharFilterFactory.lookupClass((String)"htmlstrip"));
    }

    public void testBogusLookupCharFilterClass() {
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> CharFilterFactory.lookupClass((String)"sdfsdfsdfdsfsdfsdf"));
        TestAnalysisSPILoader.expectThrows(IllegalArgumentException.class, () -> CharFilterFactory.lookupClass((String)"!(**#$U*#$*"));
    }

    public void testAvailableCharFilters() {
        TestAnalysisSPILoader.assertTrue((boolean)CharFilterFactory.availableCharFilters().contains("htmlstrip"));
    }
}

