/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.text.BreakIterator;
import java.text.CharacterIterator;
import java.util.Locale;
import java.util.Random;
import org.apache.lucene.analysis.util.CharArrayIterator;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public class TestCharArrayIterator
extends LuceneTestCase {
    public void testWordInstance() {
        this.doTests(CharArrayIterator.newWordInstance());
    }

    public void testConsumeWordInstance() {
        BreakIterator bi = BreakIterator.getWordInstance(Locale.getDefault());
        CharArrayIterator ci = CharArrayIterator.newWordInstance();
        for (int i = 0; i < 10000; ++i) {
            char[] text = TestUtil.randomUnicodeString((Random)TestCharArrayIterator.random()).toCharArray();
            ci.setText(text, 0, text.length);
            this.consume(bi, (CharacterIterator)ci);
        }
    }

    public void testSentenceInstance() {
        this.doTests(CharArrayIterator.newSentenceInstance());
    }

    public void testConsumeSentenceInstance() {
        BreakIterator bi = BreakIterator.getSentenceInstance(Locale.getDefault());
        CharArrayIterator ci = CharArrayIterator.newSentenceInstance();
        for (int i = 0; i < 10000; ++i) {
            char[] text = TestUtil.randomUnicodeString((Random)TestCharArrayIterator.random()).toCharArray();
            ci.setText(text, 0, text.length);
            this.consume(bi, (CharacterIterator)ci);
        }
    }

    private void doTests(CharArrayIterator ci) {
        ci.setText("testing".toCharArray(), 0, "testing".length());
        TestCharArrayIterator.assertEquals((long)0L, (long)ci.getBeginIndex());
        TestCharArrayIterator.assertEquals((long)7L, (long)ci.getEndIndex());
        TestCharArrayIterator.assertEquals((long)0L, (long)ci.getIndex());
        TestCharArrayIterator.assertEquals((long)116L, (long)ci.current());
        TestCharArrayIterator.assertEquals((long)101L, (long)ci.next());
        TestCharArrayIterator.assertEquals((long)103L, (long)ci.last());
        TestCharArrayIterator.assertEquals((long)110L, (long)ci.previous());
        TestCharArrayIterator.assertEquals((long)116L, (long)ci.first());
        TestCharArrayIterator.assertEquals((long)65535L, (long)ci.previous());
        ci.setText("testing".toCharArray(), 0, "testing".length());
        ci.next();
        TestCharArrayIterator.assertEquals((long)116L, (long)ci.first());
        TestCharArrayIterator.assertEquals((long)ci.getBeginIndex(), (long)ci.getIndex());
        ci.setText(new char[0], 0, 0);
        TestCharArrayIterator.assertEquals((long)65535L, (long)ci.first());
        ci.setText("testing".toCharArray(), 0, "testing".length());
        TestCharArrayIterator.assertEquals((long)103L, (long)ci.last());
        TestCharArrayIterator.assertEquals((long)ci.getIndex(), (long)(ci.getEndIndex() - 1));
        ci.setText(new char[0], 0, 0);
        TestCharArrayIterator.assertEquals((long)65535L, (long)ci.last());
        TestCharArrayIterator.assertEquals((long)ci.getEndIndex(), (long)ci.getIndex());
        ci.setText("testing".toCharArray(), 0, "testing".length());
        TestCharArrayIterator.assertEquals((long)116L, (long)ci.current());
        ci.last();
        ci.next();
        TestCharArrayIterator.assertEquals((long)65535L, (long)ci.current());
        ci.setText("te".toCharArray(), 0, 2);
        TestCharArrayIterator.assertEquals((long)101L, (long)ci.next());
        TestCharArrayIterator.assertEquals((long)1L, (long)ci.getIndex());
        TestCharArrayIterator.assertEquals((long)65535L, (long)ci.next());
        TestCharArrayIterator.assertEquals((long)ci.getEndIndex(), (long)ci.getIndex());
        ci.setText("test".toCharArray(), 0, "test".length());
        TestCharArrayIterator.expectThrows(IllegalArgumentException.class, () -> ci.setIndex(5));
        char[] text = "testing".toCharArray();
        ci.setText(text, 0, text.length);
        ci.next();
        CharArrayIterator ci2 = ci.clone();
        TestCharArrayIterator.assertEquals((long)ci.getIndex(), (long)ci2.getIndex());
        TestCharArrayIterator.assertEquals((long)ci.next(), (long)ci2.next());
        TestCharArrayIterator.assertEquals((long)ci.last(), (long)ci2.last());
    }

    private void consume(BreakIterator bi, CharacterIterator ci) {
        bi.setText(ci);
        while (bi.next() != -1) {
        }
    }
}

