/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.KeywordTokenizer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.ElisionFilter;

public class TestElision
extends BaseTokenStreamTestCase {
    public void testElision() throws Exception {
        String test = "Plop, juste pour voir l'embrouille avec O'brian. M'enfin.";
        StandardTokenizer tokenizer = new StandardTokenizer(TestElision.newAttributeFactory());
        tokenizer.setReader((Reader)new StringReader(test));
        CharArraySet articles = new CharArraySet((Collection)TestElision.asSet((Object[])new String[]{"l", "M"}), false);
        ElisionFilter filter = new ElisionFilter((TokenStream)tokenizer, articles);
        List<String> tas = this.filter((TokenFilter)filter);
        TestElision.assertEquals((Object)"embrouille", (Object)tas.get(4));
        TestElision.assertEquals((Object)"O'brian", (Object)tas.get(6));
        TestElision.assertEquals((Object)"enfin", (Object)tas.get(7));
    }

    private List<String> filter(TokenFilter filter) throws IOException {
        ArrayList<String> tas = new ArrayList<String>();
        CharTermAttribute termAtt = (CharTermAttribute)filter.getAttribute(CharTermAttribute.class);
        filter.reset();
        while (filter.incrementToken()) {
            tas.add(termAtt.toString());
        }
        filter.end();
        filter.close();
        return tas;
    }

    public void testEmptyTerm() throws IOException {
        Analyzer a = new Analyzer(){

            protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
                KeywordTokenizer tokenizer = new KeywordTokenizer();
                return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new ElisionFilter((TokenStream)tokenizer, FrenchAnalyzer.DEFAULT_ARTICLES));
            }
        };
        TestElision.checkOneTerm((Analyzer)a, (String)"", (String)"");
        a.close();
    }
}

