/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestElisionFilterFactory
extends BaseTokenStreamFactoryTestCase {
    public void testElision() throws Exception {
        StringReader reader = new StringReader("l'avion");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("Elision", "articles", "frenchArticles.txt").create((TokenStream)stream);
        TestElisionFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"avion"});
    }

    public void testDefaultArticles() throws Exception {
        StringReader reader = new StringReader("l'avion");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("Elision", new String[0]).create((TokenStream)stream);
        TestElisionFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"avion"});
    }

    public void testCaseInsensitive() throws Exception {
        StringReader reader = new StringReader("L'avion");
        MockTokenizer stream = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        ((Tokenizer)stream).setReader((Reader)reader);
        stream = this.tokenFilterFactory("Elision", "articles", "frenchArticles.txt", "ignoreCase", "true").create((TokenStream)stream);
        TestElisionFilterFactory.assertTokenStreamContents((TokenStream)stream, (String[])new String[]{"avion"});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestElisionFilterFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenFilterFactory("Elision", "bogusArg", "bogusValue"));
        TestElisionFilterFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

