/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.util.FilesystemResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.analysis.util.StringMockResourceLoader;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;

public class TestFilesystemResourceLoader
extends LuceneTestCase {
    private void assertNotFound(ResourceLoader rl) throws Exception {
        TestFilesystemResourceLoader.expectThrows(IOException.class, () -> IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{rl.openResource("this-directory-really-really-really-should-not-exist/foo/bar.txt")}));
        TestFilesystemResourceLoader.expectThrows(RuntimeException.class, () -> rl.newInstance("org.apache.lucene.analysis.FooBarFilterFactory", TokenFilterFactory.class));
    }

    private void assertClasspathDelegation(ResourceLoader rl) throws Exception {
        CharArraySet set = WordlistLoader.getSnowballWordSet((Reader)new InputStreamReader(rl.openResource("org/apache/lucene/analysis/snowball/english_stop.txt"), StandardCharsets.UTF_8));
        TestFilesystemResourceLoader.assertTrue((boolean)set.contains((CharSequence)"you"));
        TestFilesystemResourceLoader.assertEquals((Object)"org.apache.lucene.analysis.util.RollingCharBuffer", (Object)rl.newInstance("org.apache.lucene.analysis.util.RollingCharBuffer", Object.class).getClass().getName());
    }

    public void testBaseDir() throws Exception {
        Path base = TestFilesystemResourceLoader.createTempDir((String)"fsResourceLoaderBase");
        BufferedWriter os = Files.newBufferedWriter(base.resolve("template.txt"), StandardCharsets.UTF_8, new OpenOption[0]);
        try {
            os.write("foobar\n");
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{os});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{os});
        FilesystemResourceLoader rl = new FilesystemResourceLoader(base);
        TestFilesystemResourceLoader.assertEquals((Object)"foobar", WordlistLoader.getLines((InputStream)rl.openResource("template.txt"), (Charset)StandardCharsets.UTF_8).get(0));
        String fullPath = base.resolve("template.txt").toAbsolutePath().toString();
        TestFilesystemResourceLoader.assertEquals((Object)"foobar", WordlistLoader.getLines((InputStream)rl.openResource(fullPath), (Charset)StandardCharsets.UTF_8).get(0));
        this.assertClasspathDelegation((ResourceLoader)rl);
        this.assertNotFound((ResourceLoader)rl);
    }

    public void testDelegation() throws Exception {
        FilesystemResourceLoader rl = new FilesystemResourceLoader(TestFilesystemResourceLoader.createTempDir((String)"empty"), (ResourceLoader)new StringMockResourceLoader("foobar\n"));
        TestFilesystemResourceLoader.assertEquals((Object)"foobar", WordlistLoader.getLines((InputStream)rl.openResource("template.txt"), (Charset)StandardCharsets.UTF_8).get(0));
    }
}

