/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.Random;
import org.apache.lucene.analysis.util.RollingCharBuffer;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public class TestRollingCharBuffer
extends LuceneTestCase {
    public void test() throws Exception {
        int ITERS = TestRollingCharBuffer.atLeast((int)1000);
        RollingCharBuffer buffer = new RollingCharBuffer();
        Random random = TestRollingCharBuffer.random();
        for (int iter = 0; iter < ITERS; ++iter) {
            int stringLen = random.nextBoolean() ? random.nextInt(50) : random.nextInt(20000);
            String s = stringLen == 0 ? "" : TestUtil.randomUnicodeString((Random)random, (int)stringLen);
            if (VERBOSE) {
                System.out.println("\nTEST: iter=" + iter + " s.length()=" + s.length());
            }
            buffer.reset((Reader)new StringReader(s));
            int nextRead = 0;
            int availCount = 0;
            while (nextRead < s.length()) {
                if (VERBOSE) {
                    System.out.println("  cycle nextRead=" + nextRead + " avail=" + availCount);
                }
                if (availCount == 0 || random.nextBoolean()) {
                    if (VERBOSE) {
                        System.out.println("    new char");
                    }
                    TestRollingCharBuffer.assertEquals((long)s.charAt(nextRead), (long)buffer.get(nextRead));
                    ++nextRead;
                    ++availCount;
                } else if (random.nextBoolean()) {
                    int pos = TestUtil.nextInt((Random)random, (int)(nextRead - availCount), (int)(nextRead - 1));
                    if (VERBOSE) {
                        System.out.println("    old char pos=" + pos);
                    }
                    TestRollingCharBuffer.assertEquals((long)s.charAt(pos), (long)buffer.get(pos));
                } else {
                    int length = availCount == 1 ? 1 : TestUtil.nextInt((Random)random, (int)1, (int)availCount);
                    int start = length == availCount ? nextRead - availCount : nextRead - availCount + random.nextInt(availCount - length);
                    if (VERBOSE) {
                        System.out.println("    slice start=" + start + " length=" + length);
                    }
                    TestRollingCharBuffer.assertEquals((Object)s.substring(start, start + length), (Object)new String(buffer.get(start, length)));
                }
                if (availCount <= 0 || random.nextInt(20) != 17) continue;
                int toFree = random.nextInt(availCount);
                if (VERBOSE) {
                    System.out.println("    free " + toFree + " (avail=" + (availCount - toFree) + ")");
                }
                buffer.freeBefore(nextRead - (availCount - toFree));
                availCount -= toFree;
            }
        }
    }
}

