/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.wikipedia;

import java.io.Reader;
import java.io.StringReader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.BaseTokenStreamFactoryTestCase;

public class TestWikipediaTokenizerFactory
extends BaseTokenStreamFactoryTestCase {
    public void testTokenizer() throws Exception {
        StringReader reader = new StringReader("This is a [[Category:foo]]");
        Tokenizer tokenizer = this.tokenizerFactory("Wikipedia", new String[0]).create(TestWikipediaTokenizerFactory.newAttributeFactory());
        tokenizer.setReader((Reader)reader);
        TestWikipediaTokenizerFactory.assertTokenStreamContents((TokenStream)tokenizer, (String[])new String[]{"This", "is", "a", "foo"}, (int[])new int[]{0, 5, 8, 21}, (int[])new int[]{4, 7, 9, 24}, (String[])new String[]{"<ALPHANUM>", "<ALPHANUM>", "<ALPHANUM>", "c"}, (int[])new int[]{1, 1, 1, 1});
    }

    public void testBogusArguments() throws Exception {
        IllegalArgumentException expected = (IllegalArgumentException)TestWikipediaTokenizerFactory.expectThrows(IllegalArgumentException.class, () -> this.tokenizerFactory("Wikipedia", "bogusArg", "bogusValue"));
        TestWikipediaTokenizerFactory.assertTrue((boolean)expected.getMessage().contains("Unknown parameters"));
    }
}

