/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import java.text.Collator;
import java.util.Locale;
import java.util.Random;
import org.apache.lucene.collation.CollationDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public class TestCollationDocValuesField
extends LuceneTestCase {
    public void testBasic() throws Exception {
        BaseDirectoryWrapper dir = TestCollationDocValuesField.newDirectory();
        RandomIndexWriter iw = new RandomIndexWriter(TestCollationDocValuesField.random(), (Directory)dir);
        Document doc = new Document();
        Field field = TestCollationDocValuesField.newField((String)"field", (String)"", (FieldType)StringField.TYPE_STORED);
        CollationDocValuesField collationField = new CollationDocValuesField("collated", Collator.getInstance(Locale.ENGLISH));
        doc.add((IndexableField)field);
        doc.add((IndexableField)collationField);
        field.setStringValue("ABC");
        collationField.setStringValue("ABC");
        iw.addDocument((Iterable)doc);
        field.setStringValue("abc");
        collationField.setStringValue("abc");
        iw.addDocument((Iterable)doc);
        DirectoryReader ir = iw.getReader();
        iw.close();
        IndexSearcher is = TestCollationDocValuesField.newSearcher((IndexReader)ir);
        SortField sortField = new SortField("collated", SortField.Type.STRING);
        TopFieldDocs td = is.search((Query)new MatchAllDocsQuery(), 5, new Sort(sortField));
        TestCollationDocValuesField.assertEquals((Object)"abc", (Object)ir.document(td.scoreDocs[0].doc).get("field"));
        TestCollationDocValuesField.assertEquals((Object)"ABC", (Object)ir.document(td.scoreDocs[1].doc).get("field"));
        ir.close();
        dir.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRanges() throws Exception {
        BaseDirectoryWrapper dir = TestCollationDocValuesField.newDirectory();
        RandomIndexWriter iw = new RandomIndexWriter(TestCollationDocValuesField.random(), (Directory)dir);
        Document doc = new Document();
        Field field = TestCollationDocValuesField.newField((String)"field", (String)"", (FieldType)StringField.TYPE_STORED);
        Collator collator = Collator.getInstance(Locale.getDefault());
        if (TestCollationDocValuesField.random().nextBoolean()) {
            collator.setStrength(0);
        }
        CollationDocValuesField collationField = new CollationDocValuesField("collated", collator);
        doc.add((IndexableField)field);
        doc.add((IndexableField)collationField);
        int numDocs = TestCollationDocValuesField.atLeast((int)500);
        for (int i = 0; i < numDocs; ++i) {
            String value = TestUtil.randomSimpleString((Random)TestCollationDocValuesField.random());
            field.setStringValue(value);
            collationField.setStringValue(value);
            iw.addDocument((Iterable)doc);
        }
        DirectoryReader ir = iw.getReader();
        iw.close();
        IndexSearcher is = TestCollationDocValuesField.newSearcher((IndexReader)ir);
        int numChecks = TestCollationDocValuesField.atLeast((int)100);
        try {
            for (int i = 0; i < numChecks; ++i) {
                String start = TestUtil.randomSimpleString((Random)TestCollationDocValuesField.random());
                String end = TestUtil.randomSimpleString((Random)TestCollationDocValuesField.random());
                BytesRef lowerVal = new BytesRef(collator.getCollationKey(start).toByteArray());
                BytesRef upperVal = new BytesRef(collator.getCollationKey(end).toByteArray());
                this.doTestRanges(is, start, end, lowerVal, upperVal, collator);
            }
        }
        finally {
            ir.close();
            dir.close();
        }
    }

    private void doTestRanges(IndexSearcher is, String startPoint, String endPoint, BytesRef startBR, BytesRef endBR, Collator collator) throws Exception {
        SortedDocValues dvs = MultiDocValues.getSortedValues((IndexReader)is.getIndexReader(), (String)"collated");
        for (int docID = 0; docID < is.getIndexReader().maxDoc(); ++docID) {
            Document doc = is.doc(docID);
            String s = doc.getField("field").stringValue();
            boolean collatorAccepts = TestCollationDocValuesField.collate((Collator)collator, (String)s, (String)startPoint) >= 0 && TestCollationDocValuesField.collate((Collator)collator, (String)s, (String)endPoint) <= 0;
            BytesRef br = dvs.get(docID);
            boolean luceneAccepts = br.compareTo(startBR) >= 0 && br.compareTo(endBR) <= 0;
            TestCollationDocValuesField.assertEquals((String)(startPoint + " <= " + s + " <= " + endPoint), (Object)collatorAccepts, (Object)luceneAccepts);
        }
    }
}

