/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.collation;

import java.text.Collator;
import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CollationTestBase;
import org.apache.lucene.collation.CollationKeyAnalyzer;
import org.apache.lucene.util.BytesRef;

public class TestCollationKeyAnalyzer
extends CollationTestBase {
    private Collator collator = Collator.getInstance(new Locale("ar"));
    private Analyzer analyzer;
    private BytesRef firstRangeBeginning = new BytesRef(this.collator.getCollationKey(this.firstRangeBeginningOriginal).toByteArray());
    private BytesRef firstRangeEnd = new BytesRef(this.collator.getCollationKey(this.firstRangeEndOriginal).toByteArray());
    private BytesRef secondRangeBeginning = new BytesRef(this.collator.getCollationKey(this.secondRangeBeginningOriginal).toByteArray());
    private BytesRef secondRangeEnd = new BytesRef(this.collator.getCollationKey(this.secondRangeEndOriginal).toByteArray());

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new CollationKeyAnalyzer(this.collator);
    }

    public void tearDown() throws Exception {
        this.analyzer.close();
        super.tearDown();
    }

    public void testFarsiRangeFilterCollating() throws Exception {
        this.testFarsiRangeFilterCollating(this.analyzer, this.firstRangeBeginning, this.firstRangeEnd, this.secondRangeBeginning, this.secondRangeEnd);
    }

    public void testFarsiRangeQueryCollating() throws Exception {
        this.testFarsiRangeQueryCollating(this.analyzer, this.firstRangeBeginning, this.firstRangeEnd, this.secondRangeBeginning, this.secondRangeEnd);
    }

    public void testFarsiTermRangeQuery() throws Exception {
        this.testFarsiTermRangeQuery(this.analyzer, this.firstRangeBeginning, this.firstRangeEnd, this.secondRangeBeginning, this.secondRangeEnd);
    }

    public void testThreadSafe() throws Exception {
        int iters = 20 * RANDOM_MULTIPLIER;
        for (int i = 0; i < iters; ++i) {
            Collator collator = Collator.getInstance(Locale.GERMAN);
            collator.setStrength(0);
            CollationKeyAnalyzer analyzer = new CollationKeyAnalyzer(collator);
            this.assertThreadSafe((Analyzer)analyzer);
            analyzer.close();
        }
    }
}

