/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.analyzing;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharacterUtils;
import org.apache.lucene.analysis.MockBytesAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.queryparser.analyzing.AnalyzingQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;

public class TestAnalyzingQueryParser
extends LuceneTestCase {
    private static final String FIELD = "field";
    private Analyzer a;
    private String[] wildcardInput;
    private String[] wildcardExpected;
    private String[] prefixInput;
    private String[] prefixExpected;
    private String[] rangeInput;
    private String[] rangeExpected;
    private String[] fuzzyInput;
    private String[] fuzzyExpected;
    private Map<String, String> wildcardEscapeHits = new TreeMap<String, String>();
    private Map<String, String> wildcardEscapeMisses = new TreeMap<String, String>();

    public void setUp() throws Exception {
        super.setUp();
        this.wildcardInput = new String[]{"*bersetzung \u00fcber*ung", "M\u00f6tley Cr\u00fce M\u00f6tl?* Cr\u00fc?", "Ren\u00e9e Zellweger Ren?? Zellw?ger"};
        this.wildcardExpected = new String[]{"*bersetzung uber*ung", "motley crue motl?* cru?", "renee zellweger ren?? zellw?ger"};
        this.prefixInput = new String[]{"\u00fcbersetzung \u00fcbersetz*", "M\u00f6tley Cr\u00fce M\u00f6tl* cr\u00fc*", "Ren\u00e9? Zellw*"};
        this.prefixExpected = new String[]{"ubersetzung ubersetz*", "motley crue motl* cru*", "rene? zellw*"};
        this.rangeInput = new String[]{"[aa TO bb]", "{Ana\u00efs TO Zo\u00e9}"};
        this.rangeExpected = new String[]{"[aa TO bb]", "{anais TO zoe}"};
        this.fuzzyInput = new String[]{"\u00dcbersetzung \u00dcbersetzung~0.9", "M\u00f6tley Cr\u00fce M\u00f6tley~0.75 Cr\u00fce~0.5", "Ren\u00e9e Zellweger Ren\u00e9e~0.9 Zellweger~"};
        this.fuzzyExpected = new String[]{"ubersetzung ubersetzung~1", "motley crue motley~1 crue~2", "renee zellweger renee~0 zellweger~2"};
        this.wildcardEscapeHits.put("m\u00f6*tley", "moatley");
        this.wildcardEscapeHits.put("m\u00f6\\*tl*y", "mo*tley");
        this.wildcardEscapeHits.put("m\u00f6\\\\*tley", "mo\\atley");
        this.wildcardEscapeHits.put("m\u00f6\\??ley", "mo?tley");
        this.wildcardEscapeMisses.put("m\u00f6\\*tl*y", "moatley");
        this.a = new ASCIIAnalyzer();
    }

    public void testWildcardAlone() throws ParseException {
        TestAnalyzingQueryParser.expectThrows(ParseException.class, () -> this.getAnalyzedQuery("*", this.a, false));
        String qString = this.parseWithAnalyzingQueryParser("*", this.a, true);
        TestAnalyzingQueryParser.assertEquals((String)"Every word", (Object)"*", (Object)qString);
    }

    public void testWildCardEscapes() throws ParseException, IOException {
        Query q;
        for (Map.Entry<String, String> entry : this.wildcardEscapeHits.entrySet()) {
            q = this.getAnalyzedQuery(entry.getKey(), this.a, false);
            TestAnalyzingQueryParser.assertEquals((String)("WildcardEscapeHits: " + entry.getKey()), (Object)true, (Object)this.isAHit(q, entry.getValue(), this.a));
        }
        for (Map.Entry<String, String> entry : this.wildcardEscapeMisses.entrySet()) {
            q = this.getAnalyzedQuery(entry.getKey(), this.a, false);
            TestAnalyzingQueryParser.assertEquals((String)("WildcardEscapeMisses: " + entry.getKey()), (Object)false, (Object)this.isAHit(q, entry.getValue(), this.a));
        }
    }

    public void testWildCardQueryNoLeadingAllowed() {
        TestAnalyzingQueryParser.expectThrows(ParseException.class, () -> this.parseWithAnalyzingQueryParser(this.wildcardInput[0], this.a, false));
    }

    public void testWildCardQuery() throws ParseException {
        for (int i = 0; i < this.wildcardInput.length; ++i) {
            TestAnalyzingQueryParser.assertEquals((String)("Testing wildcards with analyzer " + this.a.getClass() + ", input string: " + this.wildcardInput[i]), (Object)this.wildcardExpected[i], (Object)this.parseWithAnalyzingQueryParser(this.wildcardInput[i], this.a, true));
        }
    }

    public void testPrefixQuery() throws ParseException {
        for (int i = 0; i < this.prefixInput.length; ++i) {
            TestAnalyzingQueryParser.assertEquals((String)("Testing prefixes with analyzer " + this.a.getClass() + ", input string: " + this.prefixInput[i]), (Object)this.prefixExpected[i], (Object)this.parseWithAnalyzingQueryParser(this.prefixInput[i], this.a, false));
        }
    }

    public void testRangeQuery() throws ParseException {
        for (int i = 0; i < this.rangeInput.length; ++i) {
            TestAnalyzingQueryParser.assertEquals((String)("Testing ranges with analyzer " + this.a.getClass() + ", input string: " + this.rangeInput[i]), (Object)this.rangeExpected[i], (Object)this.parseWithAnalyzingQueryParser(this.rangeInput[i], this.a, false));
        }
    }

    public void testFuzzyQuery() throws ParseException {
        for (int i = 0; i < this.fuzzyInput.length; ++i) {
            TestAnalyzingQueryParser.assertEquals((String)("Testing fuzzys with analyzer " + this.a.getClass() + ", input string: " + this.fuzzyInput[i]), (Object)this.fuzzyExpected[i], (Object)this.parseWithAnalyzingQueryParser(this.fuzzyInput[i], this.a, false));
        }
    }

    private String parseWithAnalyzingQueryParser(String s, Analyzer a, boolean allowLeadingWildcard) throws ParseException {
        Query q = this.getAnalyzedQuery(s, a, allowLeadingWildcard);
        return q.toString(FIELD);
    }

    private Query getAnalyzedQuery(String s, Analyzer a, boolean allowLeadingWildcard) throws ParseException {
        AnalyzingQueryParser qp = new AnalyzingQueryParser(FIELD, a);
        qp.setAllowLeadingWildcard(allowLeadingWildcard);
        Query q = qp.parse(s);
        return q;
    }

    public void testByteTerms() throws Exception {
        String s = "\u0e40\u0e02";
        MockBytesAnalyzer analyzer = new MockBytesAnalyzer();
        AnalyzingQueryParser qp = new AnalyzingQueryParser(FIELD, (Analyzer)analyzer);
        Query q = qp.parse("[\u0e40\u0e02 TO \u0e40\u0e02]");
        TestAnalyzingQueryParser.assertEquals((Object)true, (Object)this.isAHit(q, s, (Analyzer)analyzer));
    }

    private boolean isAHit(Query q, String content, Analyzer analyzer) throws IOException {
        BaseDirectoryWrapper ramDir = TestAnalyzingQueryParser.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(TestAnalyzingQueryParser.random(), (Directory)ramDir, analyzer);
        Document doc = new Document();
        FieldType fieldType = new FieldType();
        fieldType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        fieldType.setTokenized(true);
        fieldType.setStored(true);
        Field field = new Field(FIELD, content, fieldType);
        doc.add((IndexableField)field);
        writer.addDocument((Iterable)doc);
        writer.close();
        DirectoryReader ir = DirectoryReader.open((Directory)ramDir);
        IndexSearcher is = new IndexSearcher((IndexReader)ir);
        int hits = is.search((Query)q, (int)10).totalHits;
        ir.close();
        ramDir.close();
        return hits == 1;
    }

    static final class ASCIIAnalyzer
    extends Analyzer {
        ASCIIAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer result = new MockTokenizer(MockTokenizer.WHITESPACE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)result, (TokenStream)new FoldingFilter((TokenStream)result));
        }

        protected TokenStream normalize(String fieldName, TokenStream in) {
            return new FoldingFilter((TokenStream)new LowercaseFilter(in));
        }
    }

    static final class LowercaseFilter
    extends TokenFilter {
        final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

        LowercaseFilter(TokenStream input) {
            super(input);
        }

        public final boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                CharacterUtils.toLowerCase((char[])this.termAtt.buffer(), (int)0, (int)this.termAtt.length());
                return true;
            }
            return false;
        }
    }

    static final class FoldingFilter
    extends TokenFilter {
        final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

        public FoldingFilter(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                char[] term = this.termAtt.buffer();
                block6: for (int i = 0; i < term.length; ++i) {
                    switch (term[i]) {
                        case '\u00fc': {
                            term[i] = 117;
                            continue block6;
                        }
                        case '\u00f6': {
                            term[i] = 111;
                            continue block6;
                        }
                        case '\u00e9': {
                            term[i] = 101;
                            continue block6;
                        }
                        case '\u00ef': {
                            term[i] = 105;
                        }
                    }
                }
                return true;
            }
            return false;
        }
    }
}

