/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.BaseTokenStreamTestCase;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.search.Query;

public class TestMultiAnalyzer
extends BaseTokenStreamTestCase {
    private static int multiToken = 0;

    public void testMultiAnalyzer() throws ParseException {
        QueryParser qp = new QueryParser("", (Analyzer)new MultiAnalyzer());
        TestMultiAnalyzer.assertEquals((Object)"foo", (Object)qp.parse("foo").toString());
        TestMultiAnalyzer.assertEquals((Object)"foo", (Object)qp.parse("\"foo\"").toString());
        TestMultiAnalyzer.assertEquals((Object)"foo foobar", (Object)qp.parse("foo foobar").toString());
        TestMultiAnalyzer.assertEquals((Object)"\"foo foobar\"", (Object)qp.parse("\"foo foobar\"").toString());
        TestMultiAnalyzer.assertEquals((Object)"\"foo foobar blah\"", (Object)qp.parse("\"foo foobar blah\"").toString());
        TestMultiAnalyzer.assertEquals((Object)"Synonym(multi multi2) foo", (Object)qp.parse("multi foo").toString());
        TestMultiAnalyzer.assertEquals((Object)"foo Synonym(multi multi2)", (Object)qp.parse("foo multi").toString());
        TestMultiAnalyzer.assertEquals((Object)"Synonym(multi multi2) Synonym(multi multi2)", (Object)qp.parse("multi multi").toString());
        TestMultiAnalyzer.assertEquals((Object)"+(foo Synonym(multi multi2)) +(bar Synonym(multi multi2))", (Object)qp.parse("+(foo multi) +(bar multi)").toString());
        TestMultiAnalyzer.assertEquals((Object)"+(foo Synonym(multi multi2)) field:\"bar (multi multi2)\"", (Object)qp.parse("+(foo multi) field:\"bar multi\"").toString());
        TestMultiAnalyzer.assertEquals((Object)"\"(multi multi2) foo\"", (Object)qp.parse("\"multi foo\"").toString());
        TestMultiAnalyzer.assertEquals((Object)"\"foo (multi multi2)\"", (Object)qp.parse("\"foo multi\"").toString());
        TestMultiAnalyzer.assertEquals((Object)"\"foo (multi multi2) foobar (multi multi2)\"", (Object)qp.parse("\"foo multi foobar multi\"").toString());
        TestMultiAnalyzer.assertEquals((Object)"Synonym(field:multi field:multi2) field:foo", (Object)qp.parse("field:multi field:foo").toString());
        TestMultiAnalyzer.assertEquals((Object)"field:\"(multi multi2) foo\"", (Object)qp.parse("field:\"multi foo\"").toString());
        TestMultiAnalyzer.assertEquals((Object)"Synonym(multi2 multi3 triplemulti)", (Object)qp.parse("triplemulti").toString());
        TestMultiAnalyzer.assertEquals((Object)"foo Synonym(multi2 multi3 triplemulti) foobar", (Object)qp.parse("foo triplemulti foobar").toString());
        TestMultiAnalyzer.assertEquals((Object)"\"(multi multi2) foo\"~10", (Object)qp.parse("\"multi foo\"~10").toString());
        TestMultiAnalyzer.assertEquals((Object)"(\"(multi multi2) foo\")^2.0", (Object)qp.parse("\"multi foo\"^2").toString());
        qp.setPhraseSlop(99);
        TestMultiAnalyzer.assertEquals((Object)"\"(multi multi2) foo\"~99 bar", (Object)qp.parse("\"multi foo\" bar").toString());
        TestMultiAnalyzer.assertEquals((Object)"\"(multi multi2) foo\"~99 \"foo bar\"~2", (Object)qp.parse("\"multi foo\" \"foo bar\"~2").toString());
        qp.setPhraseSlop(0);
        qp.setDefaultOperator(QueryParserBase.AND_OPERATOR);
        TestMultiAnalyzer.assertEquals((Object)"+Synonym(multi multi2) +foo", (Object)qp.parse("multi foo").toString());
    }

    public void testMultiAnalyzerWithSubclassOfQueryParser() throws ParseException {
        DumbQueryParser qp = new DumbQueryParser("", new MultiAnalyzer());
        qp.setPhraseSlop(99);
        TestMultiAnalyzer.assertEquals((Object)"\"foo bar\"~99", (Object)qp.getSuperFieldQuery("", "foo bar", true).toString());
        TestMultiAnalyzer.assertEquals((Object)"\"(multi multi2) bar\"~99", (Object)qp.getSuperFieldQuery("", "multi bar", true).toString());
        TestMultiAnalyzer.assertEquals((Object)"\"(multi multi2) foo\"~99 bar", (Object)qp.parse("\"multi foo\" bar").toString());
    }

    public void testPosIncrementAnalyzer() throws ParseException {
        QueryParser qp = new QueryParser("", (Analyzer)new PosIncrementAnalyzer());
        TestMultiAnalyzer.assertEquals((Object)"quick brown", (Object)qp.parse("the quick brown").toString());
        TestMultiAnalyzer.assertEquals((Object)"quick brown fox", (Object)qp.parse("the quick brown fox").toString());
    }

    private static final class DumbQueryWrapper
    extends Query {
        private Query q;

        public DumbQueryWrapper(Query q) {
            this.q = Objects.requireNonNull(q);
        }

        public String toString(String f) {
            return this.q.toString(f);
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && Objects.equals(this.q, ((DumbQueryWrapper)((Object)other)).q);
        }

        public int hashCode() {
            return this.classHash() & this.q.hashCode();
        }
    }

    private static final class DumbQueryParser
    extends QueryParser {
        public DumbQueryParser(String f, Analyzer a) {
            super(f, a);
        }

        public Query getSuperFieldQuery(String f, String t, boolean quoted) throws ParseException {
            return super.getFieldQuery(f, t, quoted);
        }

        protected Query getFieldQuery(String f, String t, boolean quoted) throws ParseException {
            return new DumbQueryWrapper(this.getSuperFieldQuery(f, t, quoted));
        }
    }

    private static final class TestPosIncrementFilter
    extends TokenFilter {
        CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

        public TestPosIncrementFilter(TokenStream in) {
            super(in);
        }

        public final boolean incrementToken() throws IOException {
            while (this.input.incrementToken()) {
                if (this.termAtt.toString().equals("the")) continue;
                if (this.termAtt.toString().equals("quick")) {
                    this.posIncrAtt.setPositionIncrement(2);
                    return true;
                }
                this.posIncrAtt.setPositionIncrement(1);
                return true;
            }
            return false;
        }
    }

    private static class PosIncrementAnalyzer
    extends Analyzer {
        private PosIncrementAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer result = new MockTokenizer(MockTokenizer.WHITESPACE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)result, (TokenStream)new TestPosIncrementFilter((TokenStream)result));
        }
    }

    private static final class TestFilter
    extends TokenFilter {
        private String prevType;
        private int prevStartOffset;
        private int prevEndOffset;
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

        public TestFilter(TokenStream in) {
            super(in);
        }

        public final boolean incrementToken() throws IOException {
            if (multiToken > 0) {
                this.termAtt.setEmpty().append("multi" + (multiToken + 1));
                this.offsetAtt.setOffset(this.prevStartOffset, this.prevEndOffset);
                this.typeAtt.setType(this.prevType);
                this.posIncrAtt.setPositionIncrement(0);
                multiToken--;
                return true;
            }
            boolean next = this.input.incrementToken();
            if (!next) {
                return false;
            }
            this.prevType = this.typeAtt.type();
            this.prevStartOffset = this.offsetAtt.startOffset();
            this.prevEndOffset = this.offsetAtt.endOffset();
            String text = this.termAtt.toString();
            if (text.equals("triplemulti")) {
                multiToken = 2;
                return true;
            }
            if (text.equals("multi")) {
                multiToken = 1;
                return true;
            }
            return true;
        }

        public void reset() throws IOException {
            super.reset();
            this.prevType = null;
            this.prevStartOffset = 0;
            this.prevEndOffset = 0;
        }
    }

    private static class MultiAnalyzer
    extends Analyzer {
        private MultiAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer result = new MockTokenizer(MockTokenizer.WHITESPACE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)result, (TokenStream)new TestFilter((TokenStream)result));
        }
    }
}

