/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockSynonymFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.util.QueryParserTestBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;

public class TestMultiFieldQueryParser
extends LuceneTestCase {
    public void testStopwordsParsing() throws Exception {
        this.assertStopQueryEquals("one", "b:one t:one");
        this.assertStopQueryEquals("one stop", "b:one t:one");
        this.assertStopQueryEquals("one (stop)", "b:one t:one");
        this.assertStopQueryEquals("one ((stop))", "b:one t:one");
        this.assertStopQueryEquals("stop", "");
        this.assertStopQueryEquals("(stop)", "");
        this.assertStopQueryEquals("((stop))", "");
    }

    private void assertStopQueryEquals(String qtxt, String expectedRes) throws Exception {
        String[] fields = new String[]{"b", "t"};
        BooleanClause.Occur[] occur = new BooleanClause.Occur[]{BooleanClause.Occur.SHOULD, BooleanClause.Occur.SHOULD};
        QueryParserTestBase.QPTestAnalyzer a = new QueryParserTestBase.QPTestAnalyzer();
        MultiFieldQueryParser mfqp = new MultiFieldQueryParser(fields, (Analyzer)a);
        Query q = mfqp.parse(qtxt);
        TestMultiFieldQueryParser.assertEquals((Object)expectedRes, (Object)q.toString());
        q = MultiFieldQueryParser.parse((String)qtxt, (String[])fields, (BooleanClause.Occur[])occur, (Analyzer)a);
        TestMultiFieldQueryParser.assertEquals((Object)expectedRes, (Object)q.toString());
    }

    public void testSimple() throws Exception {
        String[] fields = new String[]{"b", "t"};
        MultiFieldQueryParser mfqp = new MultiFieldQueryParser(fields, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        Query q = mfqp.parse("one");
        TestMultiFieldQueryParser.assertEquals((Object)"b:one t:one", (Object)q.toString());
        q = mfqp.parse("one two");
        TestMultiFieldQueryParser.assertEquals((Object)"(b:one t:one) (b:two t:two)", (Object)q.toString());
        q = mfqp.parse("+one +two");
        TestMultiFieldQueryParser.assertEquals((Object)"+(b:one t:one) +(b:two t:two)", (Object)q.toString());
        q = mfqp.parse("+one -two -three");
        TestMultiFieldQueryParser.assertEquals((Object)"+(b:one t:one) -(b:two t:two) -(b:three t:three)", (Object)q.toString());
        q = mfqp.parse("one^2 two");
        TestMultiFieldQueryParser.assertEquals((Object)"(b:one t:one)^2.0 (b:two t:two)", (Object)q.toString());
        q = mfqp.parse("one~ two");
        TestMultiFieldQueryParser.assertEquals((Object)"(b:one~2 t:one~2) (b:two t:two)", (Object)q.toString());
        q = mfqp.parse("one~0.8 two^2");
        TestMultiFieldQueryParser.assertEquals((Object)"(b:one~0 t:one~0) (b:two t:two)^2.0", (Object)q.toString());
        q = mfqp.parse("one* two*");
        TestMultiFieldQueryParser.assertEquals((Object)"(b:one* t:one*) (b:two* t:two*)", (Object)q.toString());
        q = mfqp.parse("[a TO c] two");
        TestMultiFieldQueryParser.assertEquals((Object)"(b:[a TO c] t:[a TO c]) (b:two t:two)", (Object)q.toString());
        q = mfqp.parse("w?ldcard");
        TestMultiFieldQueryParser.assertEquals((Object)"b:w?ldcard t:w?ldcard", (Object)q.toString());
        q = mfqp.parse("\"foo bar\"");
        TestMultiFieldQueryParser.assertEquals((Object)"b:\"foo bar\" t:\"foo bar\"", (Object)q.toString());
        q = mfqp.parse("\"aa bb cc\" \"dd ee\"");
        TestMultiFieldQueryParser.assertEquals((Object)"(b:\"aa bb cc\" t:\"aa bb cc\") (b:\"dd ee\" t:\"dd ee\")", (Object)q.toString());
        q = mfqp.parse("\"foo bar\"~4");
        TestMultiFieldQueryParser.assertEquals((Object)"b:\"foo bar\"~4 t:\"foo bar\"~4", (Object)q.toString());
        q = mfqp.parse("b:\"foo bar\"~4");
        TestMultiFieldQueryParser.assertEquals((Object)"b:\"foo bar\"~4", (Object)q.toString());
        q = mfqp.parse("one f:two");
        TestMultiFieldQueryParser.assertEquals((Object)"(b:one t:one) f:two", (Object)q.toString());
        mfqp.setDefaultOperator(QueryParserBase.AND_OPERATOR);
        q = mfqp.parse("one two");
        TestMultiFieldQueryParser.assertEquals((Object)"+(b:one t:one) +(b:two t:two)", (Object)q.toString());
        q = mfqp.parse("\"aa bb cc\" \"dd ee\"");
        TestMultiFieldQueryParser.assertEquals((Object)"+(b:\"aa bb cc\" t:\"aa bb cc\") +(b:\"dd ee\" t:\"dd ee\")", (Object)q.toString());
    }

    public void testBoostsSimple() throws Exception {
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("b", Float.valueOf(5.0f));
        boosts.put("t", Float.valueOf(10.0f));
        String[] fields = new String[]{"b", "t"};
        MultiFieldQueryParser mfqp = new MultiFieldQueryParser(fields, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()), boosts);
        Query q = mfqp.parse("one");
        TestMultiFieldQueryParser.assertEquals((Object)"(b:one)^5.0 (t:one)^10.0", (Object)q.toString());
        q = mfqp.parse("one AND two");
        TestMultiFieldQueryParser.assertEquals((Object)"+((b:one)^5.0 (t:one)^10.0) +((b:two)^5.0 (t:two)^10.0)", (Object)q.toString());
        q = mfqp.parse("one OR two");
        TestMultiFieldQueryParser.assertEquals((Object)"((b:one)^5.0 (t:one)^10.0) ((b:two)^5.0 (t:two)^10.0)", (Object)q.toString());
        q = mfqp.parse("one AND two AND foo:test");
        TestMultiFieldQueryParser.assertEquals((Object)"+((b:one)^5.0 (t:one)^10.0) +((b:two)^5.0 (t:two)^10.0) +foo:test", (Object)q.toString());
        q = mfqp.parse("one^3 AND two^4");
        TestMultiFieldQueryParser.assertEquals((Object)"+((b:one)^5.0 (t:one)^10.0)^3.0 +((b:two)^5.0 (t:two)^10.0)^4.0", (Object)q.toString());
    }

    public void testStaticMethod1() throws ParseException {
        String[] fields = new String[]{"b", "t"};
        String[] queries = new String[]{"one", "two"};
        Query q = MultiFieldQueryParser.parse((String[])queries, (String[])fields, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        TestMultiFieldQueryParser.assertEquals((Object)"b:one t:two", (Object)q.toString());
        String[] queries2 = new String[]{"+one", "+two"};
        q = MultiFieldQueryParser.parse((String[])queries2, (String[])fields, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        TestMultiFieldQueryParser.assertEquals((Object)"(+b:one) (+t:two)", (Object)q.toString());
        String[] queries3 = new String[]{"one", "+two"};
        q = MultiFieldQueryParser.parse((String[])queries3, (String[])fields, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        TestMultiFieldQueryParser.assertEquals((Object)"b:one (+t:two)", (Object)q.toString());
        String[] queries4 = new String[]{"one +more", "+two"};
        q = MultiFieldQueryParser.parse((String[])queries4, (String[])fields, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        TestMultiFieldQueryParser.assertEquals((Object)"(b:one +b:more) (+t:two)", (Object)q.toString());
        String[] queries5 = new String[]{"blah"};
        TestMultiFieldQueryParser.expectThrows(IllegalArgumentException.class, () -> MultiFieldQueryParser.parse((String[])queries5, (String[])fields, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random())));
        QueryParserTestBase.QPTestAnalyzer stopA = new QueryParserTestBase.QPTestAnalyzer();
        String[] queries6 = new String[]{"((+stop))", "+((stop))"};
        q = MultiFieldQueryParser.parse((String[])queries6, (String[])fields, (Analyzer)stopA);
        TestMultiFieldQueryParser.assertEquals((Object)"", (Object)q.toString());
        String[] queries7 = new String[]{"one ((+stop)) +more", "+((stop)) +two"};
        q = MultiFieldQueryParser.parse((String[])queries7, (String[])fields, (Analyzer)stopA);
        TestMultiFieldQueryParser.assertEquals((Object)"(b:one +b:more) (+t:two)", (Object)q.toString());
    }

    public void testStaticMethod2() throws ParseException {
        String[] fields = new String[]{"b", "t"};
        BooleanClause.Occur[] flags = new BooleanClause.Occur[]{BooleanClause.Occur.MUST, BooleanClause.Occur.MUST_NOT};
        Query q = MultiFieldQueryParser.parse((String)"one", (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        TestMultiFieldQueryParser.assertEquals((Object)"+b:one -t:one", (Object)q.toString());
        q = MultiFieldQueryParser.parse((String)"one two", (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        TestMultiFieldQueryParser.assertEquals((Object)"+(b:one b:two) -(t:one t:two)", (Object)q.toString());
        TestMultiFieldQueryParser.expectThrows(IllegalArgumentException.class, () -> {
            BooleanClause.Occur[] flags2 = new BooleanClause.Occur[]{BooleanClause.Occur.MUST};
            MultiFieldQueryParser.parse((String)"blah", (String[])fields, (BooleanClause.Occur[])flags2, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        });
    }

    public void testStaticMethod2Old() throws ParseException {
        String[] fields = new String[]{"b", "t"};
        BooleanClause.Occur[] flags = new BooleanClause.Occur[]{BooleanClause.Occur.MUST, BooleanClause.Occur.MUST_NOT};
        Query q = MultiFieldQueryParser.parse((String)"one", (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        TestMultiFieldQueryParser.assertEquals((Object)"+b:one -t:one", (Object)q.toString());
        q = MultiFieldQueryParser.parse((String)"one two", (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        TestMultiFieldQueryParser.assertEquals((Object)"+(b:one b:two) -(t:one t:two)", (Object)q.toString());
        TestMultiFieldQueryParser.expectThrows(IllegalArgumentException.class, () -> {
            BooleanClause.Occur[] flags2 = new BooleanClause.Occur[]{BooleanClause.Occur.MUST};
            MultiFieldQueryParser.parse((String)"blah", (String[])fields, (BooleanClause.Occur[])flags2, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        });
    }

    public void testStaticMethod3() throws ParseException {
        String[] queries = new String[]{"one", "two", "three"};
        String[] fields = new String[]{"f1", "f2", "f3"};
        BooleanClause.Occur[] flags = new BooleanClause.Occur[]{BooleanClause.Occur.MUST, BooleanClause.Occur.MUST_NOT, BooleanClause.Occur.SHOULD};
        Query q = MultiFieldQueryParser.parse((String[])queries, (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        TestMultiFieldQueryParser.assertEquals((Object)"+f1:one -f2:two f3:three", (Object)q.toString());
        TestMultiFieldQueryParser.expectThrows(IllegalArgumentException.class, () -> {
            BooleanClause.Occur[] flags2 = new BooleanClause.Occur[]{BooleanClause.Occur.MUST};
            MultiFieldQueryParser.parse((String[])queries, (String[])fields, (BooleanClause.Occur[])flags2, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        });
    }

    public void testStaticMethod3Old() throws ParseException {
        String[] queries = new String[]{"one", "two"};
        String[] fields = new String[]{"b", "t"};
        BooleanClause.Occur[] flags = new BooleanClause.Occur[]{BooleanClause.Occur.MUST, BooleanClause.Occur.MUST_NOT};
        Query q = MultiFieldQueryParser.parse((String[])queries, (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        TestMultiFieldQueryParser.assertEquals((Object)"+b:one -t:two", (Object)q.toString());
        TestMultiFieldQueryParser.expectThrows(IllegalArgumentException.class, () -> {
            BooleanClause.Occur[] flags2 = new BooleanClause.Occur[]{BooleanClause.Occur.MUST};
            MultiFieldQueryParser.parse((String[])queries, (String[])fields, (BooleanClause.Occur[])flags2, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        });
    }

    public void testAnalyzerReturningNull() throws ParseException {
        String[] fields = new String[]{"f1", "f2", "f3"};
        MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, (Analyzer)new AnalyzerReturningNull());
        Query q = parser.parse("bla AND blo");
        TestMultiFieldQueryParser.assertEquals((Object)"+(f2:bla f3:bla) +(f2:blo f3:blo)", (Object)q.toString());
        q = parser.parse("bla*");
        TestMultiFieldQueryParser.assertEquals((Object)"f1:bla* f2:bla* f3:bla*", (Object)q.toString());
        q = parser.parse("bla~");
        TestMultiFieldQueryParser.assertEquals((Object)"f1:bla~2 f2:bla~2 f3:bla~2", (Object)q.toString());
        q = parser.parse("[a TO c]");
        TestMultiFieldQueryParser.assertEquals((Object)"f1:[a TO c] f2:[a TO c] f3:[a TO c]", (Object)q.toString());
    }

    public void testStopWordSearching() throws Exception {
        MockAnalyzer analyzer = new MockAnalyzer(TestMultiFieldQueryParser.random());
        BaseDirectoryWrapper ramDir = TestMultiFieldQueryParser.newDirectory();
        IndexWriter iw = new IndexWriter((Directory)ramDir, TestMultiFieldQueryParser.newIndexWriterConfig((Analyzer)analyzer));
        Document doc = new Document();
        doc.add((IndexableField)TestMultiFieldQueryParser.newTextField((String)"body", (String)"blah the footest blah", (Field.Store)Field.Store.NO));
        iw.addDocument((Iterable)doc);
        iw.close();
        MultiFieldQueryParser mfqp = new MultiFieldQueryParser(new String[]{"body"}, (Analyzer)analyzer);
        mfqp.setDefaultOperator(QueryParser.Operator.AND);
        Query q = mfqp.parse("the footest");
        DirectoryReader ir = DirectoryReader.open((Directory)ramDir);
        IndexSearcher is = TestMultiFieldQueryParser.newSearcher((IndexReader)ir);
        ScoreDoc[] hits = is.search((Query)q, (int)1000).scoreDocs;
        TestMultiFieldQueryParser.assertEquals((long)1L, (long)hits.length);
        ir.close();
        ramDir.close();
    }

    public void testSimpleRegex() throws ParseException {
        String[] fields = new String[]{"a", "b"};
        MultiFieldQueryParser mfqp = new MultiFieldQueryParser(fields, (Analyzer)new MockAnalyzer(TestMultiFieldQueryParser.random()));
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.setDisableCoord(true);
        bq.add((Query)new RegexpQuery(new Term("a", "[a-z][123]")), BooleanClause.Occur.SHOULD);
        bq.add((Query)new RegexpQuery(new Term("b", "[a-z][123]")), BooleanClause.Occur.SHOULD);
        TestMultiFieldQueryParser.assertEquals((Object)bq.build(), (Object)mfqp.parse("/[a-z][123]/"));
    }

    public void testSynonyms() throws ParseException {
        String[] fields = new String[]{"b", "t"};
        MultiFieldQueryParser parser = new MultiFieldQueryParser(fields, (Analyzer)new MockSynonymAnalyzer());
        Query q = parser.parse("dogs");
        TestMultiFieldQueryParser.assertEquals((Object)"Synonym(b:dog b:dogs) Synonym(t:dog t:dogs)", (Object)q.toString());
        q = parser.parse("guinea pig");
        TestMultiFieldQueryParser.assertTrue((boolean)parser.getSplitOnWhitespace());
        TestMultiFieldQueryParser.assertEquals((Object)"(b:guinea t:guinea) (b:pig t:pig)", (Object)q.toString());
        parser.setSplitOnWhitespace(false);
        q = parser.parse("guinea pig");
        TestMultiFieldQueryParser.assertFalse((boolean)parser.getSplitOnWhitespace());
        TestMultiFieldQueryParser.assertEquals((Object)"((+b:guinea +b:pig) b:cavy) ((+t:guinea +t:pig) t:cavy)", (Object)q.toString());
        parser.setSplitOnWhitespace(true);
        q = parser.parse("guinea pig");
        TestMultiFieldQueryParser.assertEquals((Object)"(b:guinea t:guinea) (b:pig t:pig)", (Object)q.toString());
    }

    private static class MockSynonymAnalyzer
    extends Analyzer {
        private MockSynonymAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new MockSynonymFilter((TokenStream)tokenizer));
        }
    }

    private static class AnalyzerReturningNull
    extends Analyzer {
        MockAnalyzer stdAnalyzer = new MockAnalyzer(LuceneTestCase.random());

        public AnalyzerReturningNull() {
            super(PER_FIELD_REUSE_STRATEGY);
        }

        protected Reader initReader(String fieldName, Reader reader) {
            if ("f1".equals(fieldName)) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                return new StringReader("");
            }
            return super.initReader(fieldName, reader);
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            return this.stdAnalyzer.createComponents(fieldName);
        }
    }
}

