/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.LuceneTestCase;

public class TestMultiPhraseQueryParsing
extends LuceneTestCase {
    public void testMultiPhraseQueryParsing() throws Exception {
        TokenAndPos[] INCR_0_QUERY_TOKENS_AND = new TokenAndPos[]{new TokenAndPos("a", 0), new TokenAndPos("1", 0), new TokenAndPos("b", 1), new TokenAndPos("1", 1), new TokenAndPos("c", 2)};
        QueryParser qp = new QueryParser("field", (Analyzer)new CannedAnalyzer(INCR_0_QUERY_TOKENS_AND));
        Query q = qp.parse("\"this text is acually ignored\"");
        TestMultiPhraseQueryParsing.assertTrue((String)"wrong query type!", (boolean)(q instanceof MultiPhraseQuery));
        MultiPhraseQuery.Builder multiPhraseQueryBuilder = new MultiPhraseQuery.Builder();
        multiPhraseQueryBuilder.add(new Term[]{new Term("field", "a"), new Term("field", "1")}, -1);
        multiPhraseQueryBuilder.add(new Term[]{new Term("field", "b"), new Term("field", "1")}, 0);
        multiPhraseQueryBuilder.add(new Term[]{new Term("field", "c")}, 1);
        TestMultiPhraseQueryParsing.assertEquals((Object)multiPhraseQueryBuilder.build(), (Object)q);
    }

    private static class CannedTokenizer
    extends Tokenizer {
        private final TokenAndPos[] tokens;
        private int upto = 0;
        private int lastPos = 0;
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

        public CannedTokenizer(TokenAndPos[] tokens) {
            this.tokens = tokens;
        }

        public final boolean incrementToken() {
            this.clearAttributes();
            if (this.upto < this.tokens.length) {
                TokenAndPos token = this.tokens[this.upto++];
                this.termAtt.setEmpty();
                this.termAtt.append(token.token);
                this.posIncrAtt.setPositionIncrement(token.pos - this.lastPos);
                this.lastPos = token.pos;
                return true;
            }
            return false;
        }

        public void reset() throws IOException {
            super.reset();
            this.upto = 0;
            this.lastPos = 0;
        }
    }

    private static class CannedAnalyzer
    extends Analyzer {
        private final TokenAndPos[] tokens;

        public CannedAnalyzer(TokenAndPos[] tokens) {
            this.tokens = tokens;
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            return new Analyzer.TokenStreamComponents((Tokenizer)new CannedTokenizer(this.tokens));
        }
    }

    private static class TokenAndPos {
        public final String token;
        public final int pos;

        public TokenAndPos(String token, int pos) {
            this.token = token;
            this.pos = pos;
        }
    }
}

