/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.classic;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockSynonymAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.CharStream;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.classic.QueryParserTokenManager;
import org.apache.lucene.queryparser.classic.Token;
import org.apache.lucene.queryparser.flexible.standard.CommonQueryParserConfiguration;
import org.apache.lucene.queryparser.util.QueryParserTestBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SynonymQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;

public class TestQueryParser
extends QueryParserTestBase {
    protected boolean splitOnWhitespace = true;

    public QueryParser getParser(Analyzer a) throws Exception {
        if (a == null) {
            a = new MockAnalyzer(TestQueryParser.random(), MockTokenizer.SIMPLE, true);
        }
        QueryParser qp = new QueryParser(this.getDefaultField(), a);
        qp.setDefaultOperator(QueryParserBase.OR_OPERATOR);
        qp.setSplitOnWhitespace(this.splitOnWhitespace);
        return qp;
    }

    @Override
    public CommonQueryParserConfiguration getParserConfig(Analyzer a) throws Exception {
        return this.getParser(a);
    }

    @Override
    public Query getQuery(String query, CommonQueryParserConfiguration cqpC) throws Exception {
        assert (cqpC != null) : "Parameter must not be null";
        assert (cqpC instanceof QueryParser) : "Parameter must be instance of QueryParser";
        QueryParser qp = (QueryParser)cqpC;
        return qp.parse(query);
    }

    @Override
    public Query getQuery(String query, Analyzer a) throws Exception {
        return this.getParser(a).parse(query);
    }

    @Override
    public boolean isQueryParserException(Exception exception) {
        return exception instanceof ParseException;
    }

    @Override
    public void setDefaultOperatorOR(CommonQueryParserConfiguration cqpC) {
        assert (cqpC instanceof QueryParser);
        QueryParser qp = (QueryParser)cqpC;
        qp.setDefaultOperator(QueryParser.Operator.OR);
    }

    @Override
    public void setDefaultOperatorAND(CommonQueryParserConfiguration cqpC) {
        assert (cqpC instanceof QueryParser);
        QueryParser qp = (QueryParser)cqpC;
        qp.setDefaultOperator(QueryParser.Operator.AND);
    }

    @Override
    public void setAnalyzeRangeTerms(CommonQueryParserConfiguration cqpC, boolean value) {
        assert (cqpC instanceof QueryParser);
        QueryParser qp = (QueryParser)cqpC;
        qp.setAnalyzeRangeTerms(value);
    }

    @Override
    public void setAutoGeneratePhraseQueries(CommonQueryParserConfiguration cqpC, boolean value) {
        assert (cqpC instanceof QueryParser);
        QueryParser qp = (QueryParser)cqpC;
        qp.setAutoGeneratePhraseQueries(value);
    }

    @Override
    public void setDateResolution(CommonQueryParserConfiguration cqpC, CharSequence field, DateTools.Resolution value) {
        assert (cqpC instanceof QueryParser);
        QueryParser qp = (QueryParser)cqpC;
        qp.setDateResolution(field.toString(), value);
    }

    @Override
    public void testDefaultOperator() throws Exception {
        QueryParser qp = this.getParser((Analyzer)new MockAnalyzer(TestQueryParser.random()));
        TestQueryParser.assertEquals((Object)QueryParserBase.OR_OPERATOR, (Object)qp.getDefaultOperator());
        this.setDefaultOperatorAND((CommonQueryParserConfiguration)qp);
        TestQueryParser.assertEquals((Object)QueryParserBase.AND_OPERATOR, (Object)qp.getDefaultOperator());
        this.setDefaultOperatorOR((CommonQueryParserConfiguration)qp);
        TestQueryParser.assertEquals((Object)QueryParserBase.OR_OPERATOR, (Object)qp.getDefaultOperator());
    }

    public void testProtectedCtors() throws Exception {
        try {
            QueryParser.class.getConstructor(CharStream.class);
            TestQueryParser.fail((String)"please switch public QueryParser(CharStream) to be protected");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            QueryParser.class.getConstructor(QueryParserTokenManager.class);
            TestQueryParser.fail((String)"please switch public QueryParser(QueryParserTokenManager) to be protected");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public void testFuzzySlopeExtendability() throws ParseException {
        QueryParser qp = new QueryParser("a", (Analyzer)new MockAnalyzer(TestQueryParser.random(), MockTokenizer.WHITESPACE, false)){

            Query handleBareFuzzy(String qfield, Token fuzzySlop, String termImage) throws ParseException {
                if (fuzzySlop.image.endsWith("\u20ac")) {
                    float fms = this.fuzzyMinSim;
                    try {
                        fms = Float.parseFloat(fuzzySlop.image.substring(1, fuzzySlop.image.length() - 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    float value = Float.parseFloat(termImage);
                    return this.getRangeQuery(qfield, Float.toString(value - fms / 2.0f), Float.toString(value + fms / 2.0f), true, true);
                }
                return super.handleBareFuzzy(qfield, fuzzySlop, termImage);
            }
        };
        TestQueryParser.assertEquals((Object)qp.parse("a:[11.95 TO 12.95]"), (Object)qp.parse("12.45~1\u20ac"));
    }

    @Override
    public void testStarParsing() throws Exception {
        final int[] type = new int[1];
        QueryParser qp = new QueryParser("field", (Analyzer)new MockAnalyzer(TestQueryParser.random(), MockTokenizer.WHITESPACE, false)){

            protected Query getWildcardQuery(String field, String termStr) {
                type[0] = 1;
                return new TermQuery(new Term(field, termStr));
            }

            protected Query getPrefixQuery(String field, String termStr) {
                type[0] = 2;
                return new TermQuery(new Term(field, termStr));
            }

            protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
                type[0] = 3;
                return super.getFieldQuery(field, queryText, quoted);
            }
        };
        TermQuery tq = (TermQuery)qp.parse("foo:zoo*");
        TestQueryParser.assertEquals((Object)"zoo", (Object)tq.getTerm().text());
        TestQueryParser.assertEquals((long)2L, (long)type[0]);
        BoostQuery bq = (BoostQuery)qp.parse("foo:zoo*^2");
        tq = (TermQuery)bq.getQuery();
        TestQueryParser.assertEquals((Object)"zoo", (Object)tq.getTerm().text());
        TestQueryParser.assertEquals((long)2L, (long)type[0]);
        TestQueryParser.assertEquals((double)bq.getBoost(), (double)2.0, (double)0.0);
        tq = (TermQuery)qp.parse("foo:*");
        TestQueryParser.assertEquals((Object)"*", (Object)tq.getTerm().text());
        TestQueryParser.assertEquals((long)1L, (long)type[0]);
        bq = (BoostQuery)qp.parse("foo:*^2");
        tq = (TermQuery)bq.getQuery();
        TestQueryParser.assertEquals((Object)"*", (Object)tq.getTerm().text());
        TestQueryParser.assertEquals((long)1L, (long)type[0]);
        TestQueryParser.assertEquals((double)bq.getBoost(), (double)2.0, (double)0.0);
        tq = (TermQuery)qp.parse("*:foo");
        TestQueryParser.assertEquals((Object)"*", (Object)tq.getTerm().field());
        TestQueryParser.assertEquals((Object)"foo", (Object)tq.getTerm().text());
        TestQueryParser.assertEquals((long)3L, (long)type[0]);
        tq = (TermQuery)qp.parse("*:*");
        TestQueryParser.assertEquals((Object)"*", (Object)tq.getTerm().field());
        TestQueryParser.assertEquals((Object)"*", (Object)tq.getTerm().text());
        TestQueryParser.assertEquals((long)1L, (long)type[0]);
        tq = (TermQuery)qp.parse("(*:*)");
        TestQueryParser.assertEquals((Object)"*", (Object)tq.getTerm().field());
        TestQueryParser.assertEquals((Object)"*", (Object)tq.getTerm().text());
        TestQueryParser.assertEquals((long)1L, (long)type[0]);
    }

    public void testCustomQueryParserWildcard() {
        TestQueryParser.expectThrows(ParseException.class, () -> new QPTestParser("contents", (Analyzer)new MockAnalyzer(TestQueryParser.random(), MockTokenizer.WHITESPACE, false)).parse("a?t"));
    }

    public void testCustomQueryParserFuzzy() throws Exception {
        TestQueryParser.expectThrows(ParseException.class, () -> new QPTestParser("contents", (Analyzer)new MockAnalyzer(TestQueryParser.random(), MockTokenizer.WHITESPACE, false)).parse("xunit~"));
    }

    @Override
    public void testNewFieldQuery() throws Exception {
        QueryParser dumb = new QueryParser("field", (Analyzer)new QueryParserTestBase.Analyzer1());
        SynonymQuery expanded = new SynonymQuery(new Term[]{new Term("field", "dogs"), new Term("field", "dog")});
        TestQueryParser.assertEquals((Object)expanded, (Object)dumb.parse("\"dogs\""));
        TestQueryParser.assertEquals((Object)expanded, (Object)dumb.parse("dogs"));
        SmartQueryParser smart = new SmartQueryParser();
        TestQueryParser.assertEquals((Object)expanded, (Object)smart.parse("dogs"));
        TermQuery unexpanded = new TermQuery(new Term("field", "dogs"));
        TestQueryParser.assertEquals((Object)unexpanded, (Object)smart.parse("\"dogs\""));
    }

    public void testSynonyms() throws Exception {
        SynonymQuery expected = new SynonymQuery(new Term[]{new Term("field", "dogs"), new Term("field", "dog")});
        QueryParser qp = new QueryParser("field", (Analyzer)new MockSynonymAnalyzer());
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("dogs"));
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\"dogs\""));
        qp.setDefaultOperator(QueryParser.Operator.AND);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("dogs"));
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\"dogs\""));
        expected = new BoostQuery((Query)expected, 2.0f);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("dogs^2"));
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\"dogs\"^2"));
    }

    public void testSynonymsPhrase() throws Exception {
        MultiPhraseQuery.Builder expectedQBuilder = new MultiPhraseQuery.Builder();
        expectedQBuilder.add(new Term("field", "old"));
        expectedQBuilder.add(new Term[]{new Term("field", "dogs"), new Term("field", "dog")});
        QueryParser qp = new QueryParser("field", (Analyzer)new MockSynonymAnalyzer());
        TestQueryParser.assertEquals((Object)expectedQBuilder.build(), (Object)qp.parse("\"old dogs\""));
        qp.setDefaultOperator(QueryParser.Operator.AND);
        TestQueryParser.assertEquals((Object)expectedQBuilder.build(), (Object)qp.parse("\"old dogs\""));
        BoostQuery expected = new BoostQuery((Query)expectedQBuilder.build(), 2.0f);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\"old dogs\"^2"));
        expectedQBuilder.setSlop(3);
        expected = new BoostQuery((Query)expectedQBuilder.build(), 2.0f);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\"old dogs\"~3^2"));
    }

    public void testCJKSynonym() throws Exception {
        SynonymQuery expected = new SynonymQuery(new Term[]{new Term("field", "\u56fd"), new Term("field", "\u570b")});
        QueryParser qp = new QueryParser("field", (Analyzer)new MockCJKSynonymAnalyzer());
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u56fd"));
        qp.setDefaultOperator(QueryParser.Operator.AND);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u56fd"));
        expected = new BoostQuery((Query)expected, 2.0f);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u56fd^2"));
    }

    public void testCJKSynonymsOR() throws Exception {
        BooleanQuery.Builder expectedB = new BooleanQuery.Builder();
        expectedB.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.SHOULD);
        SynonymQuery inner = new SynonymQuery(new Term[]{new Term("field", "\u56fd"), new Term("field", "\u570b")});
        expectedB.add((Query)inner, BooleanClause.Occur.SHOULD);
        BooleanQuery expected = expectedB.build();
        QueryParser qp = new QueryParser("field", (Analyzer)new MockCJKSynonymAnalyzer());
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u4e2d\u56fd"));
        expected = new BoostQuery((Query)expected, 2.0f);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u4e2d\u56fd^2"));
    }

    public void testCJKSynonymsOR2() throws Exception {
        BooleanQuery.Builder expectedB = new BooleanQuery.Builder();
        expectedB.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.SHOULD);
        SynonymQuery inner = new SynonymQuery(new Term[]{new Term("field", "\u56fd"), new Term("field", "\u570b")});
        expectedB.add((Query)inner, BooleanClause.Occur.SHOULD);
        SynonymQuery inner2 = new SynonymQuery(new Term[]{new Term("field", "\u56fd"), new Term("field", "\u570b")});
        expectedB.add((Query)inner2, BooleanClause.Occur.SHOULD);
        BooleanQuery expected = expectedB.build();
        QueryParser qp = new QueryParser("field", (Analyzer)new MockCJKSynonymAnalyzer());
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u4e2d\u56fd\u56fd"));
        expected = new BoostQuery((Query)expected, 2.0f);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u4e2d\u56fd\u56fd^2"));
    }

    public void testCJKSynonymsAND() throws Exception {
        BooleanQuery.Builder expectedB = new BooleanQuery.Builder();
        expectedB.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.MUST);
        SynonymQuery inner = new SynonymQuery(new Term[]{new Term("field", "\u56fd"), new Term("field", "\u570b")});
        expectedB.add((Query)inner, BooleanClause.Occur.MUST);
        BooleanQuery expected = expectedB.build();
        QueryParser qp = new QueryParser("field", (Analyzer)new MockCJKSynonymAnalyzer());
        qp.setDefaultOperator(QueryParser.Operator.AND);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u4e2d\u56fd"));
        expected = new BoostQuery((Query)expected, 2.0f);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u4e2d\u56fd^2"));
    }

    public void testCJKSynonymsAND2() throws Exception {
        BooleanQuery.Builder expectedB = new BooleanQuery.Builder();
        expectedB.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.MUST);
        SynonymQuery inner = new SynonymQuery(new Term[]{new Term("field", "\u56fd"), new Term("field", "\u570b")});
        expectedB.add((Query)inner, BooleanClause.Occur.MUST);
        SynonymQuery inner2 = new SynonymQuery(new Term[]{new Term("field", "\u56fd"), new Term("field", "\u570b")});
        expectedB.add((Query)inner2, BooleanClause.Occur.MUST);
        BooleanQuery expected = expectedB.build();
        QueryParser qp = new QueryParser("field", (Analyzer)new MockCJKSynonymAnalyzer());
        qp.setDefaultOperator(QueryParser.Operator.AND);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u4e2d\u56fd\u56fd"));
        expected = new BoostQuery((Query)expected, 2.0f);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\u4e2d\u56fd\u56fd^2"));
    }

    public void testCJKSynonymsPhrase() throws Exception {
        MultiPhraseQuery.Builder expectedQBuilder = new MultiPhraseQuery.Builder();
        expectedQBuilder.add(new Term("field", "\u4e2d"));
        expectedQBuilder.add(new Term[]{new Term("field", "\u56fd"), new Term("field", "\u570b")});
        QueryParser qp = new QueryParser("field", (Analyzer)new MockCJKSynonymAnalyzer());
        qp.setDefaultOperator(QueryParser.Operator.AND);
        TestQueryParser.assertEquals((Object)expectedQBuilder.build(), (Object)qp.parse("\"\u4e2d\u56fd\""));
        BoostQuery expected = new BoostQuery((Query)expectedQBuilder.build(), 2.0f);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\"\u4e2d\u56fd\"^2"));
        expectedQBuilder.setSlop(3);
        expected = new BoostQuery((Query)expectedQBuilder.build(), 2.0f);
        TestQueryParser.assertEquals((Object)expected, (Object)qp.parse("\"\u4e2d\u56fd\"~3^2"));
    }

    public void testWildcardMaxDeterminizedStates() throws Exception {
        QueryParser qp = new QueryParser("field", (Analyzer)new MockAnalyzer(TestQueryParser.random()));
        qp.setMaxDeterminizedStates(10);
        TestQueryParser.expectThrows(TooComplexToDeterminizeException.class, () -> qp.parse("a*aaaaaaa"));
    }

    @Override
    public void testQPA() throws Exception {
        boolean oldSplitOnWhitespace = this.splitOnWhitespace;
        this.splitOnWhitespace = false;
        this.assertQueryEquals("term phrase term", qpAnalyzer, "term phrase1 phrase2 term");
        CommonQueryParserConfiguration cqpc = this.getParserConfig(qpAnalyzer);
        this.setDefaultOperatorAND(cqpc);
        this.assertQueryEquals(cqpc, "field", "term phrase term", "+term +phrase1 +phrase2 +term");
        this.splitOnWhitespace = oldSplitOnWhitespace;
    }

    public void testMultiWordSynonyms() throws Exception {
        QueryParser dumb = new QueryParser("field", (Analyzer)new QueryParserTestBase.Analyzer1());
        dumb.setSplitOnWhitespace(false);
        TermQuery guinea = new TermQuery(new Term("field", "guinea"));
        TermQuery pig = new TermQuery(new Term("field", "pig"));
        TermQuery cavy = new TermQuery(new Term("field", "cavy"));
        BooleanQuery.Builder synonym = new BooleanQuery.Builder();
        synonym.add((Query)guinea, BooleanClause.Occur.MUST);
        synonym.add((Query)pig, BooleanClause.Occur.MUST);
        BooleanQuery guineaPig = synonym.build();
        PhraseQuery phraseGuineaPig = new PhraseQuery.Builder().add(new Term("field", "guinea")).add(new Term("field", "pig")).build();
        BooleanQuery graphQuery = new BooleanQuery.Builder().add((Query)new BooleanQuery.Builder().add((Query)guineaPig, BooleanClause.Occur.SHOULD).add((Query)cavy, BooleanClause.Occur.SHOULD).build(), BooleanClause.Occur.SHOULD).build();
        TestQueryParser.assertEquals((Object)graphQuery, (Object)dumb.parse("guinea pig"));
        SpanNearQuery spanGuineaPig = SpanNearQuery.newOrderedNearQuery((String)"field").addClause((SpanQuery)new SpanTermQuery(new Term("field", "guinea"))).addClause((SpanQuery)new SpanTermQuery(new Term("field", "pig"))).setSlop(0).build();
        SpanTermQuery spanCavy = new SpanTermQuery(new Term("field", "cavy"));
        SpanOrQuery spanPhrase = new SpanOrQuery(new SpanQuery[]{spanGuineaPig, spanCavy});
        TestQueryParser.assertEquals((Object)spanPhrase, (Object)dumb.parse("\"guinea pig\""));
        SmartQueryParser smart = new SmartQueryParser();
        smart.setSplitOnWhitespace(false);
        graphQuery = new BooleanQuery.Builder().add((Query)new BooleanQuery.Builder().add((Query)guineaPig, BooleanClause.Occur.SHOULD).add((Query)cavy, BooleanClause.Occur.SHOULD).build(), BooleanClause.Occur.SHOULD).build();
        TestQueryParser.assertEquals((Object)graphQuery, (Object)smart.parse("guinea pig"));
        TestQueryParser.assertEquals((Object)phraseGuineaPig, (Object)smart.parse("\"guinea pig\""));
        dumb.setDefaultOperator(QueryParser.Operator.AND);
        BooleanQuery graphAndQuery = new BooleanQuery.Builder().add((Query)new BooleanQuery.Builder().add((Query)guineaPig, BooleanClause.Occur.SHOULD).add((Query)cavy, BooleanClause.Occur.SHOULD).build(), BooleanClause.Occur.MUST).build();
        TestQueryParser.assertEquals((Object)graphAndQuery, (Object)dumb.parse("guinea pig"));
        graphAndQuery = new BooleanQuery.Builder().add((Query)new BooleanQuery.Builder().add((Query)guineaPig, BooleanClause.Occur.SHOULD).add((Query)cavy, BooleanClause.Occur.SHOULD).build(), BooleanClause.Occur.MUST).add((Query)cavy, BooleanClause.Occur.MUST).build();
        TestQueryParser.assertEquals((Object)graphAndQuery, (Object)dumb.parse("guinea pig cavy"));
    }

    public void testEnableGraphQueries() throws Exception {
        QueryParser dumb = new QueryParser("field", (Analyzer)new QueryParserTestBase.Analyzer1());
        dumb.setSplitOnWhitespace(false);
        dumb.setEnableGraphQueries(false);
        TermQuery guinea = new TermQuery(new Term("field", "guinea"));
        TermQuery pig = new TermQuery(new Term("field", "pig"));
        TermQuery cavy = new TermQuery(new Term("field", "cavy"));
        SynonymQuery inner = new SynonymQuery(new Term[]{new Term("field", "cavy"), new Term("field", "guinea")});
        BooleanQuery.Builder b = new BooleanQuery.Builder();
        b.add((Query)inner, BooleanClause.Occur.SHOULD);
        b.add((Query)pig, BooleanClause.Occur.SHOULD);
        BooleanQuery query = b.build();
        TestQueryParser.assertEquals((Object)query, (Object)dumb.parse("guinea pig"));
    }

    public void testOperatorsAndMultiWordSynonyms() throws Exception {
        MockSynonymAnalyzer a = new MockSynonymAnalyzer();
        boolean oldSplitOnWhitespace = this.splitOnWhitespace;
        this.splitOnWhitespace = false;
        this.assertQueryEquals("+guinea pig", (Analyzer)a, "+guinea pig");
        this.assertQueryEquals("-guinea pig", (Analyzer)a, "-guinea pig");
        this.assertQueryEquals("!guinea pig", (Analyzer)a, "-guinea pig");
        this.assertQueryEquals("guinea* pig", (Analyzer)a, "guinea* pig");
        this.assertQueryEquals("guinea? pig", (Analyzer)a, "guinea? pig");
        this.assertQueryEquals("guinea~2 pig", (Analyzer)a, "guinea~2 pig");
        this.assertQueryEquals("guinea^2 pig", (Analyzer)a, "(guinea)^2.0 pig");
        this.assertQueryEquals("guinea +pig", (Analyzer)a, "guinea +pig");
        this.assertQueryEquals("guinea -pig", (Analyzer)a, "guinea -pig");
        this.assertQueryEquals("guinea !pig", (Analyzer)a, "guinea -pig");
        this.assertQueryEquals("guinea pig*", (Analyzer)a, "guinea pig*");
        this.assertQueryEquals("guinea pig?", (Analyzer)a, "guinea pig?");
        this.assertQueryEquals("guinea pig~2", (Analyzer)a, "guinea pig~2");
        this.assertQueryEquals("guinea pig^2", (Analyzer)a, "guinea (pig)^2.0");
        this.assertQueryEquals("field:guinea pig", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("guinea field:pig", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("NOT guinea pig", (Analyzer)a, "-guinea pig");
        this.assertQueryEquals("guinea NOT pig", (Analyzer)a, "guinea -pig");
        this.assertQueryEquals("guinea pig AND dogs", (Analyzer)a, "guinea +pig +Synonym(dog dogs)");
        this.assertQueryEquals("dogs AND guinea pig", (Analyzer)a, "+Synonym(dog dogs) +guinea pig");
        this.assertQueryEquals("guinea pig && dogs", (Analyzer)a, "guinea +pig +Synonym(dog dogs)");
        this.assertQueryEquals("dogs && guinea pig", (Analyzer)a, "+Synonym(dog dogs) +guinea pig");
        this.assertQueryEquals("guinea pig OR dogs", (Analyzer)a, "guinea pig Synonym(dog dogs)");
        this.assertQueryEquals("dogs OR guinea pig", (Analyzer)a, "Synonym(dog dogs) guinea pig");
        this.assertQueryEquals("guinea pig || dogs", (Analyzer)a, "guinea pig Synonym(dog dogs)");
        this.assertQueryEquals("dogs || guinea pig", (Analyzer)a, "Synonym(dog dogs) guinea pig");
        this.assertQueryEquals("\"guinea\" pig", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("guinea \"pig\"", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("(guinea) pig", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("guinea (pig)", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("/guinea/ pig", (Analyzer)a, "/guinea/ pig");
        this.assertQueryEquals("guinea /pig/", (Analyzer)a, "guinea /pig/");
        this.assertQueryEquals("(guinea pig)", (Analyzer)a, "((+guinea +pig) cavy)");
        this.assertQueryEquals("+(guinea pig)", (Analyzer)a, "+(((+guinea +pig) cavy))");
        this.assertQueryEquals("-(guinea pig)", (Analyzer)a, "-(((+guinea +pig) cavy))");
        this.assertQueryEquals("!(guinea pig)", (Analyzer)a, "-(((+guinea +pig) cavy))");
        this.assertQueryEquals("NOT (guinea pig)", (Analyzer)a, "-(((+guinea +pig) cavy))");
        this.assertQueryEquals("(guinea pig)^2", (Analyzer)a, "(((+guinea +pig) cavy))^2.0");
        this.assertQueryEquals("field:(guinea pig)", (Analyzer)a, "((+guinea +pig) cavy)");
        this.assertQueryEquals("+small guinea pig", (Analyzer)a, "+small ((+guinea +pig) cavy)");
        this.assertQueryEquals("-small guinea pig", (Analyzer)a, "-small ((+guinea +pig) cavy)");
        this.assertQueryEquals("!small guinea pig", (Analyzer)a, "-small ((+guinea +pig) cavy)");
        this.assertQueryEquals("NOT small guinea pig", (Analyzer)a, "-small ((+guinea +pig) cavy)");
        this.assertQueryEquals("small* guinea pig", (Analyzer)a, "small* ((+guinea +pig) cavy)");
        this.assertQueryEquals("small? guinea pig", (Analyzer)a, "small? ((+guinea +pig) cavy)");
        this.assertQueryEquals("\"small\" guinea pig", (Analyzer)a, "small ((+guinea +pig) cavy)");
        this.assertQueryEquals("guinea pig +running", (Analyzer)a, "((+guinea +pig) cavy) +running");
        this.assertQueryEquals("guinea pig -running", (Analyzer)a, "((+guinea +pig) cavy) -running");
        this.assertQueryEquals("guinea pig !running", (Analyzer)a, "((+guinea +pig) cavy) -running");
        this.assertQueryEquals("guinea pig NOT running", (Analyzer)a, "((+guinea +pig) cavy) -running");
        this.assertQueryEquals("guinea pig running*", (Analyzer)a, "((+guinea +pig) cavy) running*");
        this.assertQueryEquals("guinea pig running?", (Analyzer)a, "((+guinea +pig) cavy) running?");
        this.assertQueryEquals("guinea pig \"running\"", (Analyzer)a, "((+guinea +pig) cavy) running");
        this.assertQueryEquals("\"guinea pig\"~2", (Analyzer)a, "spanOr([spanNear([guinea, pig], 0, true), cavy])");
        this.assertQueryEquals("field:\"guinea pig\"", (Analyzer)a, "spanOr([spanNear([guinea, pig], 0, true), cavy])");
        this.splitOnWhitespace = oldSplitOnWhitespace;
    }

    public void testOperatorsAndMultiWordSynonymsSplitOnWhitespace() throws Exception {
        MockSynonymAnalyzer a = new MockSynonymAnalyzer();
        boolean oldSplitOnWhitespace = this.splitOnWhitespace;
        this.splitOnWhitespace = true;
        this.assertQueryEquals("+guinea pig", (Analyzer)a, "+guinea pig");
        this.assertQueryEquals("-guinea pig", (Analyzer)a, "-guinea pig");
        this.assertQueryEquals("!guinea pig", (Analyzer)a, "-guinea pig");
        this.assertQueryEquals("guinea* pig", (Analyzer)a, "guinea* pig");
        this.assertQueryEquals("guinea? pig", (Analyzer)a, "guinea? pig");
        this.assertQueryEquals("guinea~2 pig", (Analyzer)a, "guinea~2 pig");
        this.assertQueryEquals("guinea^2 pig", (Analyzer)a, "(guinea)^2.0 pig");
        this.assertQueryEquals("guinea +pig", (Analyzer)a, "guinea +pig");
        this.assertQueryEquals("guinea -pig", (Analyzer)a, "guinea -pig");
        this.assertQueryEquals("guinea !pig", (Analyzer)a, "guinea -pig");
        this.assertQueryEquals("guinea pig*", (Analyzer)a, "guinea pig*");
        this.assertQueryEquals("guinea pig?", (Analyzer)a, "guinea pig?");
        this.assertQueryEquals("guinea pig~2", (Analyzer)a, "guinea pig~2");
        this.assertQueryEquals("guinea pig^2", (Analyzer)a, "guinea (pig)^2.0");
        this.assertQueryEquals("field:guinea pig", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("guinea field:pig", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("NOT guinea pig", (Analyzer)a, "-guinea pig");
        this.assertQueryEquals("guinea NOT pig", (Analyzer)a, "guinea -pig");
        this.assertQueryEquals("guinea pig AND dogs", (Analyzer)a, "guinea +pig +Synonym(dog dogs)");
        this.assertQueryEquals("dogs AND guinea pig", (Analyzer)a, "+Synonym(dog dogs) +guinea pig");
        this.assertQueryEquals("guinea pig && dogs", (Analyzer)a, "guinea +pig +Synonym(dog dogs)");
        this.assertQueryEquals("dogs && guinea pig", (Analyzer)a, "+Synonym(dog dogs) +guinea pig");
        this.assertQueryEquals("guinea pig OR dogs", (Analyzer)a, "guinea pig Synonym(dog dogs)");
        this.assertQueryEquals("dogs OR guinea pig", (Analyzer)a, "Synonym(dog dogs) guinea pig");
        this.assertQueryEquals("guinea pig || dogs", (Analyzer)a, "guinea pig Synonym(dog dogs)");
        this.assertQueryEquals("dogs || guinea pig", (Analyzer)a, "Synonym(dog dogs) guinea pig");
        this.assertQueryEquals("\"guinea\" pig", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("guinea \"pig\"", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("(guinea) pig", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("guinea (pig)", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("/guinea/ pig", (Analyzer)a, "/guinea/ pig");
        this.assertQueryEquals("guinea /pig/", (Analyzer)a, "guinea /pig/");
        this.assertQueryEquals("(guinea pig)", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("+(guinea pig)", (Analyzer)a, "+(guinea pig)");
        this.assertQueryEquals("-(guinea pig)", (Analyzer)a, "-(guinea pig)");
        this.assertQueryEquals("!(guinea pig)", (Analyzer)a, "-(guinea pig)");
        this.assertQueryEquals("NOT (guinea pig)", (Analyzer)a, "-(guinea pig)");
        this.assertQueryEquals("(guinea pig)^2", (Analyzer)a, "(guinea pig)^2.0");
        this.assertQueryEquals("field:(guinea pig)", (Analyzer)a, "guinea pig");
        this.assertQueryEquals("+small guinea pig", (Analyzer)a, "+small guinea pig");
        this.assertQueryEquals("-small guinea pig", (Analyzer)a, "-small guinea pig");
        this.assertQueryEquals("!small guinea pig", (Analyzer)a, "-small guinea pig");
        this.assertQueryEquals("NOT small guinea pig", (Analyzer)a, "-small guinea pig");
        this.assertQueryEquals("small* guinea pig", (Analyzer)a, "small* guinea pig");
        this.assertQueryEquals("small? guinea pig", (Analyzer)a, "small? guinea pig");
        this.assertQueryEquals("\"small\" guinea pig", (Analyzer)a, "small guinea pig");
        this.assertQueryEquals("guinea pig +running", (Analyzer)a, "guinea pig +running");
        this.assertQueryEquals("guinea pig -running", (Analyzer)a, "guinea pig -running");
        this.assertQueryEquals("guinea pig !running", (Analyzer)a, "guinea pig -running");
        this.assertQueryEquals("guinea pig NOT running", (Analyzer)a, "guinea pig -running");
        this.assertQueryEquals("guinea pig running*", (Analyzer)a, "guinea pig running*");
        this.assertQueryEquals("guinea pig running?", (Analyzer)a, "guinea pig running?");
        this.assertQueryEquals("guinea pig \"running\"", (Analyzer)a, "guinea pig running");
        this.assertQueryEquals("\"guinea pig\"~2", (Analyzer)a, "spanOr([spanNear([guinea, pig], 0, true), cavy])");
        this.assertQueryEquals("field:\"guinea pig\"", (Analyzer)a, "spanOr([spanNear([guinea, pig], 0, true), cavy])");
        this.splitOnWhitespace = oldSplitOnWhitespace;
    }

    public void testDefaultSplitOnWhitespace() throws Exception {
        QueryParser parser = new QueryParser("field", (Analyzer)new QueryParserTestBase.Analyzer1());
        TestQueryParser.assertTrue((boolean)parser.getSplitOnWhitespace());
        BooleanQuery.Builder bqBuilder = new BooleanQuery.Builder();
        bqBuilder.add((Query)new TermQuery(new Term("field", "guinea")), BooleanClause.Occur.SHOULD);
        bqBuilder.add((Query)new TermQuery(new Term("field", "pig")), BooleanClause.Occur.SHOULD);
        TestQueryParser.assertEquals((Object)bqBuilder.build(), (Object)parser.parse("guinea pig"));
        boolean oldSplitOnWhitespace = this.splitOnWhitespace;
        this.splitOnWhitespace = true;
        this.assertQueryEquals("guinea pig", (Analyzer)new MockSynonymAnalyzer(), "guinea pig");
    }

    public void test_splitOnWhitespace_with_autoGeneratePhraseQueries() {
        QueryParser qp = new QueryParser("field", (Analyzer)new MockAnalyzer(TestQueryParser.random()));
        TestQueryParser.expectThrows(IllegalArgumentException.class, () -> {
            qp.setSplitOnWhitespace(false);
            qp.setAutoGeneratePhraseQueries(true);
        });
        QueryParser qp2 = new QueryParser("field", (Analyzer)new MockAnalyzer(TestQueryParser.random()));
        TestQueryParser.expectThrows(IllegalArgumentException.class, () -> {
            qp2.setSplitOnWhitespace(true);
            qp2.setAutoGeneratePhraseQueries(true);
            qp2.setSplitOnWhitespace(false);
        });
    }

    static class MockCJKSynonymAnalyzer
    extends Analyzer {
        MockCJKSynonymAnalyzer() {
        }

        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            QueryParserTestBase.SimpleCJKTokenizer tokenizer = new QueryParserTestBase.SimpleCJKTokenizer();
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new MockCJKSynonymFilter((TokenStream)tokenizer));
        }
    }

    protected static class MockCJKSynonymFilter
    extends TokenFilter {
        CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        boolean addSynonym = false;

        public MockCJKSynonymFilter(TokenStream input) {
            super(input);
        }

        public final boolean incrementToken() throws IOException {
            if (this.addSynonym) {
                this.clearAttributes();
                this.termAtt.setEmpty().append("\u570b");
                this.posIncAtt.setPositionIncrement(0);
                this.addSynonym = false;
                return true;
            }
            if (this.input.incrementToken()) {
                this.addSynonym = this.termAtt.toString().equals("\u56fd");
                return true;
            }
            return false;
        }
    }

    private class SmartQueryParser
    extends QueryParser {
        Analyzer morePrecise;

        public SmartQueryParser() {
            super("field", (Analyzer)new QueryParserTestBase.Analyzer1());
            this.morePrecise = new QueryParserTestBase.Analyzer2();
        }

        protected Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
            if (quoted) {
                return this.newFieldQuery(this.morePrecise, field, queryText, quoted);
            }
            return super.getFieldQuery(field, queryText, quoted);
        }
    }

    public static class QPTestParser
    extends QueryParser {
        public QPTestParser(String f, Analyzer a) {
            super(f, a);
        }

        protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
            throw new ParseException("Fuzzy queries not allowed");
        }

        protected Query getWildcardQuery(String field, String termStr) throws ParseException {
            throw new ParseException("Wildcard queries not allowed");
        }
    }
}

