/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.complexPhrase;

import java.util.HashSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockSynonymAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.complexPhrase.ComplexPhraseQueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;

public class TestComplexPhraseQuery
extends LuceneTestCase {
    Directory rd;
    Analyzer analyzer;
    DocData[] docsContent = new DocData[]{new DocData("john smith", "1", "developer"), new DocData("johathon smith", "2", "developer"), new DocData("john percival smith", "3", "designer"), new DocData("jackson waits tom", "4", "project manager"), new DocData("johny perkins", "5", "orders pizza"), new DocData("hapax neverson", "6", "never matches"), new DocData("dog cigar", "7", "just for synonyms"), new DocData("dogs don't smoke cigarettes", "8", "just for synonyms")};
    private IndexSearcher searcher;
    private IndexReader reader;
    String defaultFieldName = "name";
    boolean inOrder = true;

    public void testComplexPhrases() throws Exception {
        this.checkMatches("\"john smith\"", "1");
        this.checkMatches("\"j*   smyth~\"", "1,2");
        this.checkMatches("\"(jo* -john)  smith\"", "2");
        this.checkMatches("\"jo*  smith\"~2", "1,2,3");
        this.checkMatches("\"jo* [sma TO smZ]\" ", "1,2");
        this.checkMatches("\"john\"", "1,3");
        this.checkMatches("\"(john OR johathon)  smith\"", "1,2");
        this.checkMatches("\"(jo* -john) smyth~\"", "2");
        this.checkMatches("\"john  nosuchword*\"", "");
        this.checkBadQuery("\"jo*  id:1 smith\"");
        this.checkBadQuery("\"jo* \"smith\" \"");
    }

    public void testSingleTermPhrase() throws Exception {
        this.checkMatches("\"joh*\"", "1,2,3,5");
        this.checkMatches("\"joh~\"", "1,3,5");
        this.checkMatches("\"joh*\" \"tom\"", "1,2,3,4,5");
        this.checkMatches("+\"j*\" +\"tom\"", "4");
        this.checkMatches("\"jo*\" \"[sma TO smZ]\" ", "1,2,3,5,8");
        this.checkMatches("+\"j*hn\" +\"sm*h\"", "1,3");
    }

    public void testSynonyms() throws Exception {
        this.checkMatches("\"dogs\"", "8");
        MockSynonymAnalyzer synonym = new MockSynonymAnalyzer();
        this.checkMatches("\"dogs\"", "7,8", (Analyzer)synonym);
        this.checkMatches("\"dog\"", "7", (Analyzer)synonym);
        this.checkMatches("\"dogs cigar*\"", "");
        this.checkMatches("\"dog cigar*\"", "7");
        this.checkMatches("\"dogs cigar*\"", "7", (Analyzer)synonym);
        this.checkMatches("\"dog cigar*\"", "7", (Analyzer)synonym);
        this.checkMatches("\"dogs cigar*\"~2", "7,8", (Analyzer)synonym);
        this.checkMatches("\"dog cigar*\"~2", "7", (Analyzer)synonym);
    }

    public void testUnOrderedProximitySearches() throws Exception {
        this.inOrder = true;
        this.checkMatches("\"smith jo*\"~2", "");
        this.inOrder = false;
        this.checkMatches("\"smith jo*\"~2", "1,2,3");
    }

    private void checkBadQuery(String qString) {
        ComplexPhraseQueryParser qp = new ComplexPhraseQueryParser(this.defaultFieldName, this.analyzer);
        qp.setInOrder(this.inOrder);
        TestComplexPhraseQuery.expectThrows(Throwable.class, () -> qp.parse(qString));
    }

    private void checkMatches(String qString, String expectedVals) throws Exception {
        this.checkMatches(qString, expectedVals, this.analyzer);
    }

    private void checkMatches(String qString, String expectedVals, Analyzer anAnalyzer) throws Exception {
        ComplexPhraseQueryParser qp = new ComplexPhraseQueryParser(this.defaultFieldName, anAnalyzer);
        qp.setInOrder(this.inOrder);
        qp.setFuzzyPrefixLength(1);
        Query q = qp.parse(qString);
        HashSet<String> expecteds = new HashSet<String>();
        String[] vals = expectedVals.split(",");
        for (int i = 0; i < vals.length; ++i) {
            if (vals[i].length() <= 0) continue;
            expecteds.add(vals[i]);
        }
        TopDocs td = this.searcher.search(q, 10);
        ScoreDoc[] sd = td.scoreDocs;
        for (int i = 0; i < sd.length; ++i) {
            Document doc = this.searcher.doc(sd[i].doc);
            String id = doc.get("id");
            TestComplexPhraseQuery.assertTrue((String)(qString + "matched doc#" + id + " not expected"), (boolean)expecteds.contains(id));
            expecteds.remove(id);
        }
        TestComplexPhraseQuery.assertEquals((String)(qString + " missing some matches "), (long)0L, (long)expecteds.size());
    }

    public void testFieldedQuery() throws Exception {
        this.checkMatches("name:\"john smith\"", "1");
        this.checkMatches("name:\"j*   smyth~\"", "1,2");
        this.checkMatches("role:\"developer\"", "1,2");
        this.checkMatches("role:\"p* manager\"", "4");
        this.checkMatches("role:de*", "1,2,3");
        this.checkMatches("name:\"j* smyth~\"~5", "1,2,3");
        this.checkMatches("role:\"p* manager\" AND name:jack*", "4");
        this.checkMatches("+role:developer +name:jack*", "");
        this.checkMatches("name:\"john smith\"~2 AND role:designer AND id:3", "3");
    }

    public void testToStringContainsSlop() throws Exception {
        ComplexPhraseQueryParser qp = new ComplexPhraseQueryParser(this.defaultFieldName, this.analyzer);
        int slop = TestComplexPhraseQuery.random().nextInt(31) + 1;
        String qString = "name:\"j* smyth~\"~" + slop;
        Query query = qp.parse(qString);
        TestComplexPhraseQuery.assertTrue((String)"Slop is not shown in toString()", (boolean)query.toString().endsWith("~" + slop));
        String string = "\"j* smyth~\"";
        Query q = qp.parse(string);
        TestComplexPhraseQuery.assertEquals((String)"Don't show implicit slop of zero", (Object)q.toString(), (Object)string);
    }

    public void testHashcodeEquals() throws Exception {
        ComplexPhraseQueryParser qp = new ComplexPhraseQueryParser(this.defaultFieldName, this.analyzer);
        qp.setInOrder(true);
        qp.setFuzzyPrefixLength(1);
        String qString = "\"aaa* bbb*\"";
        Query q = qp.parse(qString);
        Query q2 = qp.parse(qString);
        TestComplexPhraseQuery.assertEquals((long)q.hashCode(), (long)q2.hashCode());
        TestComplexPhraseQuery.assertEquals((Object)q, (Object)q2);
        qp.setInOrder(false);
        q2 = qp.parse(qString);
        TestComplexPhraseQuery.assertTrue((q.hashCode() != q2.hashCode() ? 1 : 0) != 0);
        TestComplexPhraseQuery.assertTrue((!q.equals((Object)q2) ? 1 : 0) != 0);
        TestComplexPhraseQuery.assertTrue((!q2.equals((Object)q) ? 1 : 0) != 0);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.analyzer = new MockAnalyzer(TestComplexPhraseQuery.random());
        this.rd = TestComplexPhraseQuery.newDirectory();
        IndexWriter w = new IndexWriter(this.rd, TestComplexPhraseQuery.newIndexWriterConfig((Analyzer)this.analyzer));
        for (int i = 0; i < this.docsContent.length; ++i) {
            Document doc = new Document();
            doc.add((IndexableField)TestComplexPhraseQuery.newTextField((String)"name", (String)this.docsContent[i].name, (Field.Store)Field.Store.YES));
            doc.add((IndexableField)TestComplexPhraseQuery.newTextField((String)"id", (String)this.docsContent[i].id, (Field.Store)Field.Store.YES));
            doc.add((IndexableField)TestComplexPhraseQuery.newTextField((String)"role", (String)this.docsContent[i].role, (Field.Store)Field.Store.YES));
            w.addDocument((Iterable)doc);
        }
        w.close();
        this.reader = DirectoryReader.open((Directory)this.rd);
        this.searcher = TestComplexPhraseQuery.newSearcher((IndexReader)this.reader);
    }

    public void tearDown() throws Exception {
        this.reader.close();
        this.rd.close();
        super.tearDown();
    }

    static class DocData {
        String name;
        String id;
        String role;

        public DocData(String name, String id, String role) {
            this.name = name;
            this.id = id;
            this.role = role;
        }
    }
}

