/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.ext;

import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.classic.TestQueryParser;
import org.apache.lucene.queryparser.ext.ExtendableQueryParser;
import org.apache.lucene.queryparser.ext.ExtensionStub;
import org.apache.lucene.queryparser.ext.Extensions;
import org.apache.lucene.queryparser.ext.ParserExtension;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class TestExtendableQueryParser
extends TestQueryParser {
    private static char[] DELIMITERS = new char[]{':', '-', '|'};

    @Override
    public QueryParser getParser(Analyzer a) throws Exception {
        return this.getParser(a, null);
    }

    public QueryParser getParser(Analyzer a, Extensions extensions) throws Exception {
        if (a == null) {
            a = new MockAnalyzer(TestExtendableQueryParser.random(), MockTokenizer.SIMPLE, true);
        }
        ExtendableQueryParser qp = extensions == null ? new ExtendableQueryParser(this.getDefaultField(), a) : new ExtendableQueryParser(this.getDefaultField(), a, extensions);
        qp.setDefaultOperator(QueryParserBase.OR_OPERATOR);
        qp.setSplitOnWhitespace(this.splitOnWhitespace);
        return qp;
    }

    public void testUnescapedExtDelimiter() throws Exception {
        Extensions ext = this.newExtensions(':');
        ext.add("testExt", (ParserExtension)new ExtensionStub());
        ExtendableQueryParser parser = (ExtendableQueryParser)this.getParser(null, ext);
        TestExtendableQueryParser.expectThrows(ParseException.class, () -> parser.parse("aField:testExt:\"foo \\& bar\""));
    }

    public void testExtFieldUnqoted() throws Exception {
        for (int i = 0; i < DELIMITERS.length; ++i) {
            Extensions ext = this.newExtensions(DELIMITERS[i]);
            ext.add("testExt", (ParserExtension)new ExtensionStub());
            ExtendableQueryParser parser = (ExtendableQueryParser)this.getParser(null, ext);
            String field = ext.buildExtensionField("testExt", "aField");
            Query query = parser.parse(String.format(Locale.ROOT, "%s:foo bar", field));
            TestExtendableQueryParser.assertTrue((String)("expected instance of BooleanQuery but was " + query.getClass()), (boolean)(query instanceof BooleanQuery));
            BooleanQuery bquery = (BooleanQuery)query;
            BooleanClause[] clauses = bquery.clauses().toArray(new BooleanClause[0]);
            TestExtendableQueryParser.assertEquals((long)2L, (long)clauses.length);
            BooleanClause booleanClause = clauses[0];
            query = booleanClause.getQuery();
            TestExtendableQueryParser.assertTrue((String)("expected instance of TermQuery but was " + query.getClass()), (boolean)(query instanceof TermQuery));
            TermQuery tquery = (TermQuery)query;
            TestExtendableQueryParser.assertEquals((Object)"aField", (Object)tquery.getTerm().field());
            TestExtendableQueryParser.assertEquals((Object)"foo", (Object)tquery.getTerm().text());
            booleanClause = clauses[1];
            query = booleanClause.getQuery();
            TestExtendableQueryParser.assertTrue((String)("expected instance of TermQuery but was " + query.getClass()), (boolean)(query instanceof TermQuery));
            tquery = (TermQuery)query;
            TestExtendableQueryParser.assertEquals((Object)this.getDefaultField(), (Object)tquery.getTerm().field());
            TestExtendableQueryParser.assertEquals((Object)"bar", (Object)tquery.getTerm().text());
        }
    }

    public void testExtDefaultField() throws Exception {
        for (int i = 0; i < DELIMITERS.length; ++i) {
            Extensions ext = this.newExtensions(DELIMITERS[i]);
            ext.add("testExt", (ParserExtension)new ExtensionStub());
            ExtendableQueryParser parser = (ExtendableQueryParser)this.getParser(null, ext);
            String field = ext.buildExtensionField("testExt");
            Query parse = parser.parse(String.format(Locale.ROOT, "%s:\"foo \\& bar\"", field));
            TestExtendableQueryParser.assertTrue((String)("expected instance of TermQuery but was " + parse.getClass()), (boolean)(parse instanceof TermQuery));
            TermQuery tquery = (TermQuery)parse;
            TestExtendableQueryParser.assertEquals((Object)this.getDefaultField(), (Object)tquery.getTerm().field());
            TestExtendableQueryParser.assertEquals((Object)"foo & bar", (Object)tquery.getTerm().text());
        }
    }

    public Extensions newExtensions(char delimiter) {
        return new Extensions(delimiter);
    }

    public void testExtField() throws Exception {
        for (int i = 0; i < DELIMITERS.length; ++i) {
            Extensions ext = this.newExtensions(DELIMITERS[i]);
            ext.add("testExt", (ParserExtension)new ExtensionStub());
            ExtendableQueryParser parser = (ExtendableQueryParser)this.getParser(null, ext);
            String field = ext.buildExtensionField("testExt", "afield");
            Query parse = parser.parse(String.format(Locale.ROOT, "%s:\"foo \\& bar\"", field));
            TestExtendableQueryParser.assertTrue((String)("expected instance of TermQuery but was " + parse.getClass()), (boolean)(parse instanceof TermQuery));
            TermQuery tquery = (TermQuery)parse;
            TestExtendableQueryParser.assertEquals((Object)"afield", (Object)tquery.getTerm().field());
            TestExtendableQueryParser.assertEquals((Object)"foo & bar", (Object)tquery.getTerm().text());
        }
    }
}

