/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.ext;

import org.apache.lucene.queryparser.ext.ExtensionStub;
import org.apache.lucene.queryparser.ext.Extensions;
import org.apache.lucene.queryparser.ext.ParserExtension;
import org.apache.lucene.util.LuceneTestCase;

public class TestExtensions
extends LuceneTestCase {
    private Extensions ext;

    public void setUp() throws Exception {
        super.setUp();
        this.ext = new Extensions();
    }

    public void testBuildExtensionField() {
        TestExtensions.assertEquals((Object)"field\\:key", (Object)this.ext.buildExtensionField("key", "field"));
        TestExtensions.assertEquals((Object)"\\:key", (Object)this.ext.buildExtensionField("key"));
        this.ext = new Extensions('.');
        TestExtensions.assertEquals((Object)"field.key", (Object)this.ext.buildExtensionField("key", "field"));
        TestExtensions.assertEquals((Object)".key", (Object)this.ext.buildExtensionField("key"));
    }

    public void testSplitExtensionField() {
        TestExtensions.assertEquals((Object)"field\\:key", (Object)this.ext.buildExtensionField("key", "field"));
        TestExtensions.assertEquals((Object)"\\:key", (Object)this.ext.buildExtensionField("key"));
        this.ext = new Extensions('.');
        TestExtensions.assertEquals((Object)"field.key", (Object)this.ext.buildExtensionField("key", "field"));
        TestExtensions.assertEquals((Object)".key", (Object)this.ext.buildExtensionField("key"));
    }

    public void testAddGetExtension() {
        ExtensionStub extension = new ExtensionStub();
        TestExtensions.assertNull((Object)this.ext.getExtension("foo"));
        this.ext.add("foo", (ParserExtension)extension);
        TestExtensions.assertSame((Object)((Object)extension), (Object)this.ext.getExtension("foo"));
        this.ext.add("foo", null);
        TestExtensions.assertNull((Object)this.ext.getExtension("foo"));
    }

    public void testGetExtDelimiter() {
        TestExtensions.assertEquals((long)58L, (long)this.ext.getExtensionFieldDelimiter());
        this.ext = new Extensions('?');
        TestExtensions.assertEquals((long)63L, (long)this.ext.getExtensionFieldDelimiter());
    }

    public void testEscapeExtension() {
        TestExtensions.assertEquals((Object)"abc\\:\\?\\{\\}\\[\\]\\\\\\(\\)\\+\\-\\!\\~", (Object)this.ext.escapeExtensionField("abc:?{}[]\\()+-!~"));
        TestExtensions.expectThrows(NullPointerException.class, () -> this.ext.escapeExtensionField(null));
    }
}

