/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.core.nodes;

import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.queryparser.flexible.core.nodes.BooleanQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.util.LuceneTestCase;

public class TestQueryNode
extends LuceneTestCase {
    public void testAddChildren() throws Exception {
        FieldQueryNode nodeA = new FieldQueryNode((CharSequence)"foo", (CharSequence)"A", 0, 1);
        FieldQueryNode nodeB = new FieldQueryNode((CharSequence)"foo", (CharSequence)"B", 1, 2);
        BooleanQueryNode bq = new BooleanQueryNode(Arrays.asList(nodeA));
        bq.add(Arrays.asList(nodeB));
        TestQueryNode.assertEquals((long)2L, (long)bq.getChildren().size());
    }

    public void testTags() throws Exception {
        FieldQueryNode node = new FieldQueryNode((CharSequence)"foo", (CharSequence)"A", 0, 1);
        node.setTag("TaG", new Object());
        TestQueryNode.assertTrue((node.getTagMap().size() > 0 ? 1 : 0) != 0);
        TestQueryNode.assertTrue((boolean)node.containsTag("tAg"));
        TestQueryNode.assertTrue((node.getTag("tAg") != null ? 1 : 0) != 0);
    }

    public void testRemoveFromParent() throws Exception {
        BooleanQueryNode booleanNode = new BooleanQueryNode(Collections.emptyList());
        FieldQueryNode fieldNode = new FieldQueryNode((CharSequence)"foo", (CharSequence)"A", 0, 1);
        TestQueryNode.assertNull((Object)fieldNode.getParent());
        booleanNode.add((QueryNode)fieldNode);
        TestQueryNode.assertNotNull((Object)fieldNode.getParent());
        fieldNode.removeFromParent();
        TestQueryNode.assertNull((Object)fieldNode.getParent());
        TestQueryNode.assertFalse((boolean)booleanNode.getChildren().contains(fieldNode));
        booleanNode.add((QueryNode)fieldNode);
        TestQueryNode.assertNotNull((Object)fieldNode.getParent());
        booleanNode.set(Collections.emptyList());
        TestQueryNode.assertNull((Object)fieldNode.getParent());
    }

    public void testRemoveChildren() throws Exception {
        BooleanQueryNode booleanNode = new BooleanQueryNode(Collections.emptyList());
        FieldQueryNode fieldNode = new FieldQueryNode((CharSequence)"foo", (CharSequence)"A", 0, 1);
        booleanNode.add((QueryNode)fieldNode);
        TestQueryNode.assertTrue((booleanNode.getChildren().size() == 1 ? 1 : 0) != 0);
        booleanNode.removeChildren((QueryNode)fieldNode);
        TestQueryNode.assertTrue((booleanNode.getChildren().size() == 0 ? 1 : 0) != 0);
        TestQueryNode.assertNull((Object)fieldNode.getParent());
    }
}

