/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.messages;

import java.util.Locale;
import org.apache.lucene.queryparser.flexible.messages.MessageImpl;
import org.apache.lucene.queryparser.flexible.messages.MessagesTestBundle;
import org.apache.lucene.queryparser.flexible.messages.NLS;
import org.apache.lucene.util.LuceneTestCase;

public class TestNLS
extends LuceneTestCase {
    public void testMessageLoading() {
        MessageImpl invalidSyntax = new MessageImpl(MessagesTestBundle.Q0001E_INVALID_SYNTAX, new Object[]{"XXX"});
        if (!Locale.getDefault().getLanguage().equals("ja")) {
            TestNLS.assertEquals((Object)"Syntax Error: XXX", (Object)invalidSyntax.getLocalizedMessage(Locale.ENGLISH));
        }
    }

    public void testMessageLoading_ja() {
        MessageImpl invalidSyntax = new MessageImpl(MessagesTestBundle.Q0001E_INVALID_SYNTAX, new Object[]{"XXX"});
        TestNLS.assertEquals((Object)"\u69cb\u6587\u30a8\u30e9\u30fc: XXX", (Object)invalidSyntax.getLocalizedMessage(Locale.JAPANESE));
    }

    public void testNLSLoading() {
        String message = NLS.getLocalizedMessage((String)MessagesTestBundle.Q0004E_INVALID_SYNTAX_ESCAPE_UNICODE_TRUNCATION, (Locale)Locale.ENGLISH);
        if (!Locale.getDefault().getLanguage().equals("ja")) {
            TestNLS.assertEquals((Object)"Truncated unicode escape sequence.", (Object)message);
        }
        message = NLS.getLocalizedMessage((String)MessagesTestBundle.Q0001E_INVALID_SYNTAX, (Locale)Locale.ENGLISH, (Object[])new Object[]{"XXX"});
        if (!Locale.getDefault().getLanguage().equals("ja")) {
            TestNLS.assertEquals((Object)"Syntax Error: XXX", (Object)message);
        }
    }

    public void testNLSLoading_ja() {
        String message = NLS.getLocalizedMessage((String)MessagesTestBundle.Q0004E_INVALID_SYNTAX_ESCAPE_UNICODE_TRUNCATION, (Locale)Locale.JAPANESE);
        TestNLS.assertEquals((Object)"\u5207\u308a\u6368\u3066\u3089\u308c\u305f\u30e6\u30cb\u30b3\u30fc\u30c9\u30fb\u30a8\u30b9\u30b1\u30fc\u30d7\u30fb\u30b7\u30fc\u30b1\u30f3\u30b9\u3002", (Object)message);
        message = NLS.getLocalizedMessage((String)MessagesTestBundle.Q0001E_INVALID_SYNTAX, (Locale)Locale.JAPANESE, (Object[])new Object[]{"XXX"});
        TestNLS.assertEquals((Object)"\u69cb\u6587\u30a8\u30e9\u30fc: XXX", (Object)message);
    }

    public void testNLSLoading_xx_XX() {
        Locale locale = new Locale("xx", "XX", "");
        String message = NLS.getLocalizedMessage((String)MessagesTestBundle.Q0004E_INVALID_SYNTAX_ESCAPE_UNICODE_TRUNCATION, (Locale)locale);
        if (!Locale.getDefault().getLanguage().equals("ja")) {
            TestNLS.assertEquals((Object)"Truncated unicode escape sequence.", (Object)message);
        }
        message = NLS.getLocalizedMessage((String)MessagesTestBundle.Q0001E_INVALID_SYNTAX, (Locale)locale, (Object[])new Object[]{"XXX"});
        if (!Locale.getDefault().getLanguage().equals("ja")) {
            TestNLS.assertEquals((Object)"Syntax Error: XXX", (Object)message);
        }
    }

    public void testMissingMessage() {
        Locale locale = Locale.ENGLISH;
        String message = NLS.getLocalizedMessage((String)MessagesTestBundle.Q0005E_MESSAGE_NOT_IN_BUNDLE, (Locale)locale);
        TestNLS.assertEquals((Object)("Message with key:Q0005E_MESSAGE_NOT_IN_BUNDLE and locale: " + locale.toLanguageTag() + " not found."), (Object)message);
    }
}

