/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.precedence;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.QueryNodeParseException;
import org.apache.lucene.queryparser.flexible.precedence.PrecedenceQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryparser.flexible.standard.parser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class TestPrecedenceQueryParser
extends LuceneTestCase {
    public static Analyzer qpAnalyzer;
    private int originalMaxClauses;

    @BeforeClass
    public static void beforeClass() {
        qpAnalyzer = new QPTestAnalyzer();
    }

    @AfterClass
    public static void afterClass() {
        qpAnalyzer = null;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.originalMaxClauses = BooleanQuery.getMaxClauseCount();
    }

    public PrecedenceQueryParser getParser(Analyzer a) throws Exception {
        if (a == null) {
            a = new MockAnalyzer(TestPrecedenceQueryParser.random(), MockTokenizer.SIMPLE, true);
        }
        PrecedenceQueryParser qp = new PrecedenceQueryParser();
        qp.setAnalyzer(a);
        qp.setDefaultOperator(StandardQueryConfigHandler.Operator.OR);
        return qp;
    }

    public Query getQuery(String query, Analyzer a) throws Exception {
        return this.getParser(a).parse(query, "field");
    }

    public void assertQueryEquals(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQuery(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestPrecedenceQueryParser.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertMatchNoDocsQuery(String queryString, Analyzer a) throws Exception {
        this.assertMatchNoDocsQuery(this.getQuery(queryString, a));
    }

    public void assertMatchNoDocsQuery(Query query) throws Exception {
        if (!(query instanceof MatchNoDocsQuery || query instanceof BooleanQuery && ((BooleanQuery)query).clauses().size() == 0)) {
            TestPrecedenceQueryParser.fail((String)("expected MatchNoDocsQuery or an empty BooleanQuery but got: " + query));
        }
    }

    public void assertWildcardQueryEquals(String query, boolean lowercase, String result) throws Exception {
        PrecedenceQueryParser qp = this.getParser(null);
        qp.setLowercaseExpandedTerms(lowercase);
        Query q = qp.parse(query, "field");
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestPrecedenceQueryParser.fail((String)("WildcardQuery /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertWildcardQueryEquals(String query, String result) throws Exception {
        PrecedenceQueryParser qp = this.getParser(null);
        Query q = qp.parse(query, "field");
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestPrecedenceQueryParser.fail((String)("WildcardQuery /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public Query getQueryDOA(String query, Analyzer a) throws Exception {
        if (a == null) {
            a = new MockAnalyzer(TestPrecedenceQueryParser.random(), MockTokenizer.SIMPLE, true);
        }
        PrecedenceQueryParser qp = new PrecedenceQueryParser();
        qp.setAnalyzer(a);
        qp.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        return qp.parse(query, "field");
    }

    public void assertQueryEqualsDOA(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQueryDOA(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestPrecedenceQueryParser.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void testSimple() throws Exception {
        this.assertQueryEquals("term term term", null, "term term term");
        this.assertQueryEquals("t\u00fcrm term term", null, "t\u00fcrm term term");
        this.assertQueryEquals("\u00fcmlaut", null, "\u00fcmlaut");
        this.assertQueryEquals("a AND b", null, "+a +b");
        this.assertQueryEquals("(a AND b)", null, "+a +b");
        this.assertQueryEquals("c OR (a AND b)", null, "c (+a +b)");
        this.assertQueryEquals("a AND NOT b", null, "+a -b");
        this.assertQueryEquals("a AND -b", null, "+a -b");
        this.assertQueryEquals("a AND !b", null, "+a -b");
        this.assertQueryEquals("a && b", null, "+a +b");
        this.assertQueryEquals("a && ! b", null, "+a -b");
        this.assertQueryEquals("a OR b", null, "a b");
        this.assertQueryEquals("a || b", null, "a b");
        this.assertQueryEquals("+term -term term", null, "+term -term term");
        this.assertQueryEquals("foo:term AND field:anotherTerm", null, "+foo:term +anotherterm");
        this.assertQueryEquals("term AND \"phrase phrase\"", null, "+term +\"phrase phrase\"");
        this.assertQueryEquals("\"hello there\"", null, "\"hello there\"");
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("a AND b", null) instanceof BooleanQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("hello", null) instanceof TermQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("\"hello there\"", null) instanceof PhraseQuery));
        this.assertQueryEquals("germ term^2.0", null, "germ (term)^2.0");
        this.assertQueryEquals("(term)^2.0", null, "(term)^2.0");
        this.assertQueryEquals("(germ term)^2.0", null, "(germ term)^2.0");
        this.assertQueryEquals("term^2.0", null, "(term)^2.0");
        this.assertQueryEquals("term^2", null, "(term)^2.0");
        this.assertQueryEquals("\"germ term\"^2.0", null, "(\"germ term\")^2.0");
        this.assertQueryEquals("\"term germ\"^2", null, "(\"term germ\")^2.0");
        this.assertQueryEquals("(foo OR bar) AND (baz OR boo)", null, "+(foo bar) +(baz boo)");
        this.assertQueryEquals("((a OR b) AND NOT c) OR d", null, "(+(a b) -c) d");
        this.assertQueryEquals("+(apple \"steve jobs\") -(foo bar baz)", null, "+(apple \"steve jobs\") -(foo bar baz)");
        this.assertQueryEquals("+title:(dog OR cat) -author:\"bob dole\"", null, "+(title:dog title:cat) -author:\"bob dole\"");
        PrecedenceQueryParser qp = new PrecedenceQueryParser();
        qp.setAnalyzer((Analyzer)new MockAnalyzer(TestPrecedenceQueryParser.random()));
        TestPrecedenceQueryParser.assertEquals((Object)StandardQueryConfigHandler.Operator.OR, (Object)qp.getDefaultOperator());
        qp.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        TestPrecedenceQueryParser.assertEquals((Object)StandardQueryConfigHandler.Operator.AND, (Object)qp.getDefaultOperator());
        qp.setDefaultOperator(StandardQueryConfigHandler.Operator.OR);
        TestPrecedenceQueryParser.assertEquals((Object)StandardQueryConfigHandler.Operator.OR, (Object)qp.getDefaultOperator());
        this.assertQueryEquals("a OR !b", null, "a -b");
        this.assertQueryEquals("a OR ! b", null, "a -b");
        this.assertQueryEquals("a OR -b", null, "a -b");
    }

    public void testPunct() throws Exception {
        MockAnalyzer a = new MockAnalyzer(TestPrecedenceQueryParser.random(), MockTokenizer.WHITESPACE, false);
        this.assertQueryEquals("a&b", (Analyzer)a, "a&b");
        this.assertQueryEquals("a&&b", (Analyzer)a, "a&&b");
        this.assertQueryEquals(".NET", (Analyzer)a, ".NET");
    }

    public void testSlop() throws Exception {
        this.assertQueryEquals("\"term germ\"~2", null, "\"term germ\"~2");
        this.assertQueryEquals("\"term germ\"~2 flork", null, "\"term germ\"~2 flork");
        this.assertQueryEquals("\"term\"~2", null, "term");
        this.assertQueryEquals("\" \"~2 germ", null, "germ");
        this.assertQueryEquals("\"term germ\"~2^2", null, "(\"term germ\"~2)^2.0");
    }

    public void testNumber() throws Exception {
        this.assertMatchNoDocsQuery("3", null);
        this.assertQueryEquals("term 1.0 1 2", null, "term");
        this.assertQueryEquals("term term1 term2", null, "term term term");
        MockAnalyzer a = new MockAnalyzer(TestPrecedenceQueryParser.random());
        this.assertQueryEquals("3", (Analyzer)a, "3");
        this.assertQueryEquals("term 1.0 1 2", (Analyzer)a, "term 1.0 1 2");
        this.assertQueryEquals("term term1 term2", (Analyzer)a, "term term1 term2");
    }

    public void testWildcard() throws Exception {
        this.assertQueryEquals("term*", null, "term*");
        this.assertQueryEquals("term*^2", null, "(term*)^2.0");
        this.assertQueryEquals("term~", null, "term~2");
        this.assertQueryEquals("term~0.7", null, "term~1");
        this.assertQueryEquals("term~^3", null, "(term~2)^3.0");
        this.assertQueryEquals("term^3~", null, "(term~2)^3.0");
        this.assertQueryEquals("term*germ", null, "term*germ");
        this.assertQueryEquals("term*germ^3", null, "(term*germ)^3.0");
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term*", null) instanceof PrefixQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term*^2", null) instanceof BoostQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(((BoostQuery)this.getQuery("term*^2", null)).getQuery() instanceof PrefixQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term~", null) instanceof FuzzyQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term~0.7", null) instanceof FuzzyQuery));
        FuzzyQuery fq = (FuzzyQuery)this.getQuery("term~0.7", null);
        TestPrecedenceQueryParser.assertEquals((long)1L, (long)fq.getMaxEdits());
        TestPrecedenceQueryParser.assertEquals((long)0L, (long)fq.getPrefixLength());
        fq = (FuzzyQuery)this.getQuery("term~", null);
        TestPrecedenceQueryParser.assertEquals((long)2L, (long)fq.getMaxEdits());
        TestPrecedenceQueryParser.assertEquals((long)0L, (long)fq.getPrefixLength());
        TestPrecedenceQueryParser.expectThrows(ParseException.class, () -> this.getQuery("term~1.1", null));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term*germ", null) instanceof WildcardQuery));
        this.assertWildcardQueryEquals("Term*", true, "term*");
        this.assertWildcardQueryEquals("term*", true, "term*");
        this.assertWildcardQueryEquals("Term*", true, "term*");
        this.assertWildcardQueryEquals("TERM*", true, "term*");
        this.assertWildcardQueryEquals("term*", false, "term*");
        this.assertWildcardQueryEquals("Term*", false, "Term*");
        this.assertWildcardQueryEquals("TERM*", false, "TERM*");
        this.assertWildcardQueryEquals("Te?m", "te?m");
        this.assertWildcardQueryEquals("te?m", true, "te?m");
        this.assertWildcardQueryEquals("Te?m", true, "te?m");
        this.assertWildcardQueryEquals("TE?M", true, "te?m");
        this.assertWildcardQueryEquals("Te?m*gerM", true, "te?m*germ");
        this.assertWildcardQueryEquals("te?m", false, "te?m");
        this.assertWildcardQueryEquals("Te?m", false, "Te?m");
        this.assertWildcardQueryEquals("TE?M", false, "TE?M");
        this.assertWildcardQueryEquals("Te?m*gerM", false, "Te?m*gerM");
        this.assertWildcardQueryEquals("Term~", "term~2");
        this.assertWildcardQueryEquals("Term~", true, "term~2");
        this.assertWildcardQueryEquals("Term~", false, "Term~2");
        this.assertWildcardQueryEquals("[A TO C]", "[a TO c]");
        this.assertWildcardQueryEquals("[A TO C]", true, "[a TO c]");
        this.assertWildcardQueryEquals("[A TO C]", false, "[A TO C]");
    }

    public void testQPA() throws Exception {
        this.assertQueryEquals("term term term", qpAnalyzer, "term term term");
        this.assertQueryEquals("term +stop term", qpAnalyzer, "term term");
        this.assertQueryEquals("term -stop term", qpAnalyzer, "term term");
        this.assertQueryEquals("drop AND stop AND roll", qpAnalyzer, "+drop +roll");
        this.assertQueryEquals("term phrase term", qpAnalyzer, "term (phrase1 phrase2) term");
        this.assertQueryEquals("term AND NOT phrase term", qpAnalyzer, "(+term -(phrase1 phrase2)) term");
        this.assertMatchNoDocsQuery("stop", qpAnalyzer);
        this.assertMatchNoDocsQuery("stop OR stop AND stop", qpAnalyzer);
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term term term", qpAnalyzer) instanceof BooleanQuery));
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("term +stop", qpAnalyzer) instanceof TermQuery));
    }

    public void testRange() throws Exception {
        this.assertQueryEquals("[ a TO z]", null, "[a TO z]");
        TestPrecedenceQueryParser.assertTrue((boolean)(this.getQuery("[ a TO z]", null) instanceof TermRangeQuery));
        this.assertQueryEquals("[ a TO z ]", null, "[a TO z]");
        this.assertQueryEquals("{ a TO z}", null, "{a TO z}");
        this.assertQueryEquals("{ a TO z }", null, "{a TO z}");
        this.assertQueryEquals("{ a TO z }^2.0", null, "({a TO z})^2.0");
        this.assertQueryEquals("[ a TO z] OR bar", null, "[a TO z] bar");
        this.assertQueryEquals("[ a TO z] AND bar", null, "+[a TO z] +bar");
        this.assertQueryEquals("( bar blar { a TO z}) ", null, "bar blar {a TO z}");
        this.assertQueryEquals("gack ( bar blar { a TO z}) ", null, "gack (bar blar {a TO z})");
    }

    private String escapeDateString(String s) {
        if (s.contains(" ")) {
            return "\"" + s + "\"";
        }
        return s;
    }

    public String getDate(String s) throws Exception {
        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
        return DateTools.dateToString((Date)df.parse(s), (DateTools.Resolution)DateTools.Resolution.DAY);
    }

    private String getLocalizedDate(int year, int month, int day, boolean extendLastDate) {
        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        calendar.set(year, month, day);
        if (extendLastDate) {
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            calendar.set(14, 999);
        }
        return df.format(calendar.getTime());
    }

    public void testDateRange() throws Exception {
        String startDate = this.getLocalizedDate(2002, 1, 1, false);
        String endDate = this.getLocalizedDate(2002, 1, 4, false);
        GregorianCalendar endDateExpected = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        endDateExpected.set(2002, 1, 4, 23, 59, 59);
        endDateExpected.set(14, 999);
        String defaultField = "default";
        String monthField = "month";
        String hourField = "hour";
        PrecedenceQueryParser qp = new PrecedenceQueryParser((Analyzer)new MockAnalyzer(TestPrecedenceQueryParser.random()));
        HashMap<String, DateTools.Resolution> fieldMap = new HashMap<String, DateTools.Resolution>();
        fieldMap.put("month", DateTools.Resolution.MONTH);
        qp.setDateResolutionMap(fieldMap);
        qp.setDateResolution(DateTools.Resolution.MILLISECOND);
        fieldMap.put("hour", DateTools.Resolution.HOUR);
        qp.setDateResolutionMap(fieldMap);
        this.assertDateRangeQueryEquals(qp, "default", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.MILLISECOND);
        this.assertDateRangeQueryEquals(qp, "month", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.MONTH);
        this.assertDateRangeQueryEquals(qp, "hour", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.HOUR);
    }

    private String getDate(String s, DateTools.Resolution resolution) throws Exception {
        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
        return this.getDate(df.parse(s), resolution);
    }

    private String getDate(Date d, DateTools.Resolution resolution) {
        return DateTools.dateToString((Date)d, (DateTools.Resolution)resolution);
    }

    public void assertQueryEquals(PrecedenceQueryParser qp, String field, String query, String result) throws Exception {
        Query q = qp.parse(query, field);
        String s = q.toString(field);
        if (!s.equals(result)) {
            TestPrecedenceQueryParser.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertDateRangeQueryEquals(PrecedenceQueryParser qp, String field, String startDate, String endDate, Date endDateInclusive, DateTools.Resolution resolution) throws Exception {
        this.assertQueryEquals(qp, field, field + ":[" + this.escapeDateString(startDate) + " TO " + this.escapeDateString(endDate) + "]", "[" + this.getDate(startDate, resolution) + " TO " + this.getDate(endDateInclusive, resolution) + "]");
        this.assertQueryEquals(qp, field, field + ":{" + this.escapeDateString(startDate) + " TO " + this.escapeDateString(endDate) + "}", "{" + this.getDate(startDate, resolution) + " TO " + this.getDate(endDate, resolution) + "}");
    }

    public void testEscaped() throws Exception {
        MockAnalyzer a = new MockAnalyzer(TestPrecedenceQueryParser.random(), MockTokenizer.WHITESPACE, false);
        this.assertQueryEquals("a\\-b:c", (Analyzer)a, "a-b:c");
        this.assertQueryEquals("a\\+b:c", (Analyzer)a, "a+b:c");
        this.assertQueryEquals("a\\:b:c", (Analyzer)a, "a:b:c");
        this.assertQueryEquals("a\\\\b:c", (Analyzer)a, "a\\b:c");
        this.assertQueryEquals("a:b\\-c", (Analyzer)a, "a:b-c");
        this.assertQueryEquals("a:b\\+c", (Analyzer)a, "a:b+c");
        this.assertQueryEquals("a:b\\:c", (Analyzer)a, "a:b:c");
        this.assertQueryEquals("a:b\\\\c", (Analyzer)a, "a:b\\c");
        this.assertQueryEquals("a:b\\-c*", (Analyzer)a, "a:b-c*");
        this.assertQueryEquals("a:b\\+c*", (Analyzer)a, "a:b+c*");
        this.assertQueryEquals("a:b\\:c*", (Analyzer)a, "a:b:c*");
        this.assertQueryEquals("a:b\\\\c*", (Analyzer)a, "a:b\\c*");
        this.assertQueryEquals("a:b\\-?c", (Analyzer)a, "a:b-?c");
        this.assertQueryEquals("a:b\\+?c", (Analyzer)a, "a:b+?c");
        this.assertQueryEquals("a:b\\:?c", (Analyzer)a, "a:b:?c");
        this.assertQueryEquals("a:b\\\\?c", (Analyzer)a, "a:b\\?c");
        this.assertQueryEquals("a:b\\-c~", (Analyzer)a, "a:b-c~2");
        this.assertQueryEquals("a:b\\+c~", (Analyzer)a, "a:b+c~2");
        this.assertQueryEquals("a:b\\:c~", (Analyzer)a, "a:b:c~2");
        this.assertQueryEquals("a:b\\\\c~", (Analyzer)a, "a:b\\c~2");
        this.assertQueryEquals("[ a\\- TO a\\+ ]", null, "[a- TO a+]");
        this.assertQueryEquals("[ a\\: TO a\\~ ]", null, "[a: TO a~]");
        this.assertQueryEquals("[ a\\\\ TO a\\* ]", null, "[a\\ TO a*]");
    }

    public void testTabNewlineCarriageReturn() throws Exception {
        this.assertQueryEqualsDOA("+weltbank +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\r+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\r\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r\n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r \n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\t+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \t+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \t +worlbank", null, "+weltbank +worlbank");
    }

    public void testSimpleDAO() throws Exception {
        this.assertQueryEqualsDOA("term term term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term +term term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term term +term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term +term +term", null, "+term +term +term");
        this.assertQueryEqualsDOA("-term term term", null, "-term +term +term");
    }

    public void testBoost() throws Exception {
        CharacterRunAutomaton stopSet = new CharacterRunAutomaton(Automata.makeString((String)"on"));
        MockAnalyzer oneStopAnalyzer = new MockAnalyzer(TestPrecedenceQueryParser.random(), MockTokenizer.SIMPLE, true, stopSet);
        PrecedenceQueryParser qp = new PrecedenceQueryParser();
        qp.setAnalyzer((Analyzer)oneStopAnalyzer);
        Query q = qp.parse("on^1.0", "field");
        TestPrecedenceQueryParser.assertNotNull((Object)q);
        q = qp.parse("\"hello\"^2.0", "field");
        TestPrecedenceQueryParser.assertNotNull((Object)q);
        TestPrecedenceQueryParser.assertEquals((double)((BoostQuery)q).getBoost(), (double)2.0, (double)0.5);
        q = qp.parse("hello^2.0", "field");
        TestPrecedenceQueryParser.assertNotNull((Object)q);
        TestPrecedenceQueryParser.assertEquals((double)((BoostQuery)q).getBoost(), (double)2.0, (double)0.5);
        q = qp.parse("\"on\"^1.0", "field");
        TestPrecedenceQueryParser.assertNotNull((Object)q);
        q = this.getParser((Analyzer)new MockAnalyzer(TestPrecedenceQueryParser.random(), MockTokenizer.SIMPLE, true, MockTokenFilter.ENGLISH_STOPSET)).parse("the^3", "field");
        TestPrecedenceQueryParser.assertNotNull((Object)q);
    }

    public void testException() throws Exception {
        TestPrecedenceQueryParser.expectThrows(QueryNodeParseException.class, () -> this.assertQueryEquals("\"some phrase", null, "abc"));
    }

    public void testBooleanQuery() throws Exception {
        BooleanQuery.setMaxClauseCount((int)2);
        TestPrecedenceQueryParser.expectThrows(QueryNodeException.class, () -> this.getParser((Analyzer)new MockAnalyzer(TestPrecedenceQueryParser.random(), MockTokenizer.WHITESPACE, false)).parse("one two three", "field"));
    }

    public void testNOT() throws Exception {
        MockAnalyzer a = new MockAnalyzer(TestPrecedenceQueryParser.random(), MockTokenizer.WHITESPACE, false);
        this.assertQueryEquals("NOT foo AND bar", (Analyzer)a, "-foo +bar");
    }

    public void testPrecedence() throws Exception {
        PrecedenceQueryParser parser = this.getParser((Analyzer)new MockAnalyzer(TestPrecedenceQueryParser.random(), MockTokenizer.WHITESPACE, false));
        Query query1 = parser.parse("A AND B OR C AND D", "field");
        Query query2 = parser.parse("(A AND B) OR (C AND D)", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A OR B C", "field");
        query2 = parser.parse("(A B) C", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A AND B C", "field");
        query2 = parser.parse("(+A +B) C", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A AND NOT B", "field");
        query2 = parser.parse("+A -B", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A OR NOT B", "field");
        query2 = parser.parse("A -B", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A OR NOT B AND C", "field");
        query2 = parser.parse("A (-B +C)", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        parser.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        query1 = parser.parse("A AND B OR C AND D", "field");
        query2 = parser.parse("(A AND B) OR (C AND D)", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A AND B C", "field");
        query2 = parser.parse("(A B) C", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A AND B C", "field");
        query2 = parser.parse("(+A +B) C", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A AND NOT B", "field");
        query2 = parser.parse("+A -B", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
        query1 = parser.parse("A AND NOT B OR C", "field");
        query2 = parser.parse("(+A -B) OR C", "field");
        TestPrecedenceQueryParser.assertEquals((Object)query1, (Object)query2);
    }

    public void tearDown() throws Exception {
        BooleanQuery.setMaxClauseCount((int)this.originalMaxClauses);
        super.tearDown();
    }

    public static final class QPTestAnalyzer
    extends Analyzer {
        public final Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new QPTestFilter((TokenStream)tokenizer));
        }
    }

    public static final class QPTestFilter
    extends TokenFilter {
        private boolean inPhrase = false;
        private int savedStart = 0;
        private int savedEnd = 0;
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);

        public QPTestFilter(TokenStream in) {
            super(in);
        }

        public boolean incrementToken() throws IOException {
            if (this.inPhrase) {
                this.inPhrase = false;
                this.termAtt.setEmpty().append("phrase2");
                this.offsetAtt.setOffset(this.savedStart, this.savedEnd);
                return true;
            }
            while (this.input.incrementToken()) {
                if (this.termAtt.toString().equals("phrase")) {
                    this.inPhrase = true;
                    this.savedStart = this.offsetAtt.startOffset();
                    this.savedEnd = this.offsetAtt.endOffset();
                    this.termAtt.setEmpty().append("phrase1");
                    this.offsetAtt.setOffset(this.savedStart, this.savedEnd);
                    return true;
                }
                if (this.termAtt.toString().equals("stop")) continue;
                return true;
            }
            return false;
        }

        public void reset() throws IOException {
            super.reset();
            this.inPhrase = false;
            this.savedStart = 0;
            this.savedEnd = 0;
        }
    }
}

