/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.spans;

import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.config.QueryConfigHandler;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.parser.SyntaxParser;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessor;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorPipeline;
import org.apache.lucene.queryparser.flexible.spans.SpansQueryConfigHandler;
import org.apache.lucene.queryparser.flexible.spans.SpansQueryTreeBuilder;
import org.apache.lucene.queryparser.flexible.spans.SpansValidatorQueryNodeProcessor;
import org.apache.lucene.queryparser.flexible.spans.UniqueFieldQueryNodeProcessor;
import org.apache.lucene.queryparser.flexible.standard.parser.StandardSyntaxParser;
import org.apache.lucene.queryparser.flexible.standard.processors.WildcardQueryNodeProcessor;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.LuceneTestCase;

public class TestSpanQueryParser
extends LuceneTestCase {
    private QueryNodeProcessorPipeline spanProcessorPipeline;
    private SpansQueryConfigHandler spanQueryConfigHandler;
    private SpansQueryTreeBuilder spansQueryTreeBuilder;
    private SyntaxParser queryParser = new StandardSyntaxParser();

    public void setUp() throws Exception {
        super.setUp();
        this.spanProcessorPipeline = new QueryNodeProcessorPipeline();
        this.spanQueryConfigHandler = new SpansQueryConfigHandler();
        this.spansQueryTreeBuilder = new SpansQueryTreeBuilder();
        this.spanProcessorPipeline.setQueryConfigHandler((QueryConfigHandler)this.spanQueryConfigHandler);
        this.spanProcessorPipeline.add((QueryNodeProcessor)new WildcardQueryNodeProcessor());
        this.spanProcessorPipeline.add((QueryNodeProcessor)new SpansValidatorQueryNodeProcessor());
        this.spanProcessorPipeline.add((QueryNodeProcessor)new UniqueFieldQueryNodeProcessor());
    }

    public SpanQuery getSpanQuery(CharSequence query) throws QueryNodeException {
        return this.getSpanQuery("", query);
    }

    public SpanQuery getSpanQuery(String uniqueField, CharSequence query) throws QueryNodeException {
        this.spanQueryConfigHandler.set(SpansQueryConfigHandler.UNIQUE_FIELD, uniqueField);
        QueryNode queryTree = this.queryParser.parse(query, (CharSequence)"defaultField");
        queryTree = this.spanProcessorPipeline.process(queryTree);
        return this.spansQueryTreeBuilder.build(queryTree);
    }

    public void testTermSpans() throws Exception {
        TestSpanQueryParser.assertEquals((Object)this.getSpanQuery("field:term").toString(), (Object)"term");
        TestSpanQueryParser.assertEquals((Object)this.getSpanQuery("term").toString(), (Object)"term");
        TestSpanQueryParser.assertTrue((boolean)(this.getSpanQuery("field:term") instanceof SpanTermQuery));
        TestSpanQueryParser.assertTrue((boolean)(this.getSpanQuery("term") instanceof SpanTermQuery));
    }

    public void testUniqueField() throws Exception {
        TestSpanQueryParser.assertEquals((Object)this.getSpanQuery("field", "term").toString(), (Object)"field:term");
        TestSpanQueryParser.assertEquals((Object)this.getSpanQuery("field", "field:term").toString(), (Object)"field:term");
        TestSpanQueryParser.assertEquals((Object)this.getSpanQuery("field", "anotherField:term").toString(), (Object)"field:term");
    }

    public void testOrSpans() throws Exception {
        TestSpanQueryParser.assertEquals((Object)this.getSpanQuery("term1 term2").toString(), (Object)"spanOr([term1, term2])");
        TestSpanQueryParser.assertEquals((Object)this.getSpanQuery("term1 OR term2").toString(), (Object)"spanOr([term1, term2])");
        TestSpanQueryParser.assertTrue((boolean)(this.getSpanQuery("term1 term2") instanceof SpanOrQuery));
        TestSpanQueryParser.assertTrue((boolean)(this.getSpanQuery("term1 term2") instanceof SpanOrQuery));
    }

    public void testQueryValidator() throws QueryNodeException {
        TestSpanQueryParser.expectThrows(QueryNodeException.class, () -> this.getSpanQuery("term*"));
        TestSpanQueryParser.expectThrows(QueryNodeException.class, () -> this.getSpanQuery("[a TO z]"));
        TestSpanQueryParser.expectThrows(QueryNodeException.class, () -> this.getSpanQuery("a~0.5"));
        TestSpanQueryParser.expectThrows(QueryNodeException.class, () -> this.getSpanQuery("a^0.5"));
        TestSpanQueryParser.expectThrows(QueryNodeException.class, () -> this.getSpanQuery("\"a b\""));
        TestSpanQueryParser.expectThrows(QueryNodeException.class, () -> this.getSpanQuery("(a b)"));
        TestSpanQueryParser.expectThrows(QueryNodeException.class, () -> this.getSpanQuery("a AND b"));
    }
}

