/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.spans;

import org.apache.lucene.queryparser.flexible.core.config.QueryConfigHandler;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessor;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorPipeline;
import org.apache.lucene.queryparser.flexible.spans.SpansQueryConfigHandler;
import org.apache.lucene.queryparser.flexible.spans.SpansQueryTreeBuilder;
import org.apache.lucene.queryparser.flexible.spans.SpansValidatorQueryNodeProcessor;
import org.apache.lucene.queryparser.flexible.spans.UniqueFieldQueryNodeProcessor;
import org.apache.lucene.queryparser.flexible.standard.parser.StandardSyntaxParser;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.util.LuceneTestCase;

public class TestSpanQueryParserSimpleSample
extends LuceneTestCase {
    public void testBasicDemo() throws Exception {
        StandardSyntaxParser queryParser = new StandardSyntaxParser();
        QueryNode queryTree = queryParser.parse((CharSequence)"body:text", null);
        SpansQueryConfigHandler spanQueryConfigHandler = new SpansQueryConfigHandler();
        spanQueryConfigHandler.set(SpansQueryConfigHandler.UNIQUE_FIELD, "index");
        QueryNodeProcessorPipeline spanProcessorPipeline = new QueryNodeProcessorPipeline((QueryConfigHandler)spanQueryConfigHandler);
        spanProcessorPipeline.add((QueryNodeProcessor)new SpansValidatorQueryNodeProcessor());
        spanProcessorPipeline.add((QueryNodeProcessor)new UniqueFieldQueryNodeProcessor());
        if (VERBOSE) {
            System.out.println(queryTree);
        }
        queryTree = spanProcessorPipeline.process(queryTree);
        if (VERBOSE) {
            System.out.println(queryTree);
        }
        SpansQueryTreeBuilder spansQueryTreeBuilder = new SpansQueryTreeBuilder();
        SpanQuery spanquery = spansQueryTreeBuilder.build(queryTree);
        TestSpanQueryParserSimpleSample.assertTrue((boolean)(spanquery instanceof SpanTermQuery));
        TestSpanQueryParserSimpleSample.assertEquals((Object)spanquery.toString(), (Object)"index:text");
    }
}

