/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.spans;

import java.util.List;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.config.QueryConfigHandler;
import org.apache.lucene.queryparser.flexible.core.nodes.FieldableNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryparser.flexible.spans.SpansQueryConfigHandler;

public class UniqueFieldQueryNodeProcessor
extends QueryNodeProcessorImpl {
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        if (node instanceof FieldableNode) {
            FieldableNode fieldNode = (FieldableNode)node;
            QueryConfigHandler queryConfig = this.getQueryConfigHandler();
            if (queryConfig == null) {
                throw new IllegalArgumentException("A config handler is expected by the processor UniqueFieldQueryNodeProcessor!");
            }
            if (!queryConfig.has(SpansQueryConfigHandler.UNIQUE_FIELD)) {
                throw new IllegalArgumentException("UniqueFieldAttribute should be defined in the config handler!");
            }
            String uniqueField = (String)queryConfig.get(SpansQueryConfigHandler.UNIQUE_FIELD);
            fieldNode.setField((CharSequence)uniqueField);
        }
        return node;
    }

    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

