/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard;

import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LegacyDoubleField;
import org.apache.lucene.document.LegacyFloatField;
import org.apache.lucene.document.LegacyIntField;
import org.apache.lucene.document.LegacyLongField;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.RandomIndexWriter;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.parser.EscapeQuerySyntax;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.LegacyNumericConfig;
import org.apache.lucene.queryparser.flexible.standard.config.NumberDateFormat;
import org.apache.lucene.queryparser.flexible.standard.parser.EscapeQuerySyntaxImpl;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLegacyNumericQueryParser
extends LuceneTestCase {
    private static final int[] DATE_STYLES = new int[]{0, 1, 2, 3};
    private static final int PRECISION_STEP = 8;
    private static final String FIELD_NAME = "field";
    private static Locale LOCALE;
    private static TimeZone TIMEZONE;
    private static Map<String, Number> RANDOM_NUMBER_MAP;
    private static EscapeQuerySyntax ESCAPER;
    private static final String DATE_FIELD_NAME = "date";
    private static int DATE_STYLE;
    private static int TIME_STYLE;
    private static Analyzer ANALYZER;
    private static NumberFormat NUMBER_FORMAT;
    private static StandardQueryParser qp;
    private static NumberDateFormat DATE_FORMAT;
    private static Directory directory;
    private static IndexReader reader;
    private static IndexSearcher searcher;

    private static boolean checkDateFormatSanity(DateFormat dateFormat, long date) {
        try {
            return date == dateFormat.parse(dateFormat.format(new Date(date))).getTime();
        }
        catch (ParseException e) {
            return false;
        }
    }

    @BeforeClass
    public static void beforeClass() throws Exception {
        int randomInt;
        float randomFloat;
        double randomDouble;
        long randomLong;
        long randomDate;
        SimpleDateFormat dateFormat;
        ANALYZER = new MockAnalyzer(TestLegacyNumericQueryParser.random());
        qp = new StandardQueryParser(ANALYZER);
        HashMap<String, Number> randomNumberMap = new HashMap<String, Number>();
        int count = 0;
        do {
            if (count > 100) {
                TestLegacyNumericQueryParser.fail((String)"This test has problems to find a sane random DateFormat/NumberFormat. Stopped trying after 100 iterations.");
            }
            boolean dateFormatSanityCheckPass = true;
            LOCALE = TestLegacyNumericQueryParser.randomLocale((Random)TestLegacyNumericQueryParser.random());
            TIMEZONE = TestLegacyNumericQueryParser.randomTimeZone((Random)TestLegacyNumericQueryParser.random());
            DATE_STYLE = TestLegacyNumericQueryParser.randomDateStyle(TestLegacyNumericQueryParser.random());
            TIME_STYLE = TestLegacyNumericQueryParser.randomDateStyle(TestLegacyNumericQueryParser.random());
            dateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(DATE_STYLE, TIME_STYLE, LOCALE);
            dateFormat.applyPattern(dateFormat.toPattern() + " G s Z yyyy");
            dateFormat.setTimeZone(TIMEZONE);
            DATE_FORMAT = new NumberDateFormat((DateFormat)dateFormat);
            do {
                randomDate = TestLegacyNumericQueryParser.random().nextLong();
                randomDate %= 3400000000000L;
                randomDate = randomDate / 1000L * 1000L;
            } while ((randomDate = Math.abs(randomDate)) == 0L);
            dateFormatSanityCheckPass &= TestLegacyNumericQueryParser.checkDateFormatSanity(dateFormat, randomDate);
            dateFormatSanityCheckPass &= TestLegacyNumericQueryParser.checkDateFormatSanity(dateFormat, 0L);
            ++count;
        } while (!(dateFormatSanityCheckPass &= TestLegacyNumericQueryParser.checkDateFormatSanity(dateFormat, -randomDate)));
        NUMBER_FORMAT = NumberFormat.getNumberInstance(LOCALE);
        NUMBER_FORMAT.setMaximumFractionDigits((TestLegacyNumericQueryParser.random().nextInt() & 0x14) + 1);
        NUMBER_FORMAT.setMinimumFractionDigits((TestLegacyNumericQueryParser.random().nextInt() & 0x14) + 1);
        NUMBER_FORMAT.setMaximumIntegerDigits((TestLegacyNumericQueryParser.random().nextInt() & 0x14) + 1);
        NUMBER_FORMAT.setMinimumIntegerDigits((TestLegacyNumericQueryParser.random().nextInt() & 0x14) + 1);
        while ((randomLong = TestLegacyNumericQueryParser.normalizeNumber(Math.abs(TestLegacyNumericQueryParser.random().nextLong())).longValue()) == 0L) {
        }
        while ((randomDouble = TestLegacyNumericQueryParser.normalizeNumber(Math.abs(TestLegacyNumericQueryParser.random().nextDouble())).doubleValue()) == 0.0) {
        }
        while ((randomFloat = TestLegacyNumericQueryParser.normalizeNumber(Float.valueOf(Math.abs(TestLegacyNumericQueryParser.random().nextFloat()))).floatValue()) == 0.0f) {
        }
        while ((randomInt = TestLegacyNumericQueryParser.normalizeNumber(Math.abs(TestLegacyNumericQueryParser.random().nextInt())).intValue()) == 0) {
        }
        randomNumberMap.put(FieldType.LegacyNumericType.LONG.name(), randomLong);
        randomNumberMap.put(FieldType.LegacyNumericType.INT.name(), randomInt);
        randomNumberMap.put(FieldType.LegacyNumericType.FLOAT.name(), Float.valueOf(randomFloat));
        randomNumberMap.put(FieldType.LegacyNumericType.DOUBLE.name(), randomDouble);
        randomNumberMap.put(DATE_FIELD_NAME, randomDate);
        RANDOM_NUMBER_MAP = Collections.unmodifiableMap(randomNumberMap);
        directory = TestLegacyNumericQueryParser.newDirectory();
        RandomIndexWriter writer = new RandomIndexWriter(TestLegacyNumericQueryParser.random(), directory, TestLegacyNumericQueryParser.newIndexWriterConfig((Analyzer)new MockAnalyzer(TestLegacyNumericQueryParser.random())).setMaxBufferedDocs(TestUtil.nextInt((Random)TestLegacyNumericQueryParser.random(), (int)50, (int)1000)).setMergePolicy((MergePolicy)TestLegacyNumericQueryParser.newLogMergePolicy()));
        Document doc = new Document();
        HashMap<String, LegacyNumericConfig> numericConfigMap = new HashMap<String, LegacyNumericConfig>();
        HashMap<String, Field> numericFieldMap = new HashMap<String, Field>();
        qp.setLegacyNumericConfigMap(numericConfigMap);
        for (FieldType.LegacyNumericType type : FieldType.LegacyNumericType.values()) {
            LegacyIntField field;
            numericConfigMap.put(type.name(), new LegacyNumericConfig(8, NUMBER_FORMAT, type));
            FieldType ft = new FieldType(LegacyIntField.TYPE_NOT_STORED);
            ft.setNumericType(type);
            ft.setStored(true);
            ft.setNumericPrecisionStep(8);
            ft.freeze();
            switch (type) {
                case INT: {
                    field = new LegacyIntField(type.name(), 0, ft);
                    break;
                }
                case FLOAT: {
                    field = new LegacyFloatField(type.name(), 0.0f, ft);
                    break;
                }
                case LONG: {
                    field = new LegacyLongField(type.name(), 0L, ft);
                    break;
                }
                case DOUBLE: {
                    field = new LegacyDoubleField(type.name(), 0.0, ft);
                    break;
                }
                default: {
                    TestLegacyNumericQueryParser.fail();
                    field = null;
                }
            }
            numericFieldMap.put(type.name(), (Field)field);
            doc.add((IndexableField)field);
        }
        numericConfigMap.put(DATE_FIELD_NAME, new LegacyNumericConfig(8, (NumberFormat)DATE_FORMAT, FieldType.LegacyNumericType.LONG));
        FieldType ft = new FieldType(LegacyLongField.TYPE_NOT_STORED);
        ft.setStored(true);
        ft.setNumericPrecisionStep(8);
        LegacyLongField dateField = new LegacyLongField(DATE_FIELD_NAME, 0L, ft);
        numericFieldMap.put(DATE_FIELD_NAME, (Field)dateField);
        doc.add((IndexableField)dateField);
        for (NumberType numberType : NumberType.values()) {
            TestLegacyNumericQueryParser.setFieldValues(numberType, numericFieldMap);
            if (VERBOSE) {
                System.out.println("Indexing document: " + doc);
            }
            writer.addDocument((Iterable)doc);
        }
        reader = writer.getReader();
        searcher = TestLegacyNumericQueryParser.newSearcher((IndexReader)reader);
        writer.close();
    }

    private static Number getNumberType(NumberType numberType, String fieldName) {
        if (numberType == null) {
            return null;
        }
        switch (numberType) {
            case POSITIVE: {
                return RANDOM_NUMBER_MAP.get(fieldName);
            }
            case NEGATIVE: {
                Number number = RANDOM_NUMBER_MAP.get(fieldName);
                if (FieldType.LegacyNumericType.LONG.name().equals(fieldName) || DATE_FIELD_NAME.equals(fieldName)) {
                    number = -number.longValue();
                } else if (FieldType.LegacyNumericType.DOUBLE.name().equals(fieldName)) {
                    number = -number.doubleValue();
                } else if (FieldType.LegacyNumericType.FLOAT.name().equals(fieldName)) {
                    number = Float.valueOf(-number.floatValue());
                } else if (FieldType.LegacyNumericType.INT.name().equals(fieldName)) {
                    number = -number.intValue();
                } else {
                    throw new IllegalArgumentException("field name not found: " + fieldName);
                }
                return number;
            }
        }
        return 0;
    }

    private static void setFieldValues(NumberType numberType, HashMap<String, Field> numericFieldMap) {
        Number number = TestLegacyNumericQueryParser.getNumberType(numberType, FieldType.LegacyNumericType.DOUBLE.name());
        numericFieldMap.get(FieldType.LegacyNumericType.DOUBLE.name()).setDoubleValue(number.doubleValue());
        number = TestLegacyNumericQueryParser.getNumberType(numberType, FieldType.LegacyNumericType.INT.name());
        numericFieldMap.get(FieldType.LegacyNumericType.INT.name()).setIntValue(number.intValue());
        number = TestLegacyNumericQueryParser.getNumberType(numberType, FieldType.LegacyNumericType.LONG.name());
        numericFieldMap.get(FieldType.LegacyNumericType.LONG.name()).setLongValue(number.longValue());
        number = TestLegacyNumericQueryParser.getNumberType(numberType, FieldType.LegacyNumericType.FLOAT.name());
        numericFieldMap.get(FieldType.LegacyNumericType.FLOAT.name()).setFloatValue(number.floatValue());
        number = TestLegacyNumericQueryParser.getNumberType(numberType, DATE_FIELD_NAME);
        numericFieldMap.get(DATE_FIELD_NAME).setLongValue(number.longValue());
    }

    private static int randomDateStyle(Random random) {
        return DATE_STYLES[random.nextInt(DATE_STYLES.length)];
    }

    @Test
    public void testInclusiveNumericRange() throws Exception {
        this.assertRangeQuery(NumberType.ZERO, NumberType.ZERO, true, true, 1);
        this.assertRangeQuery(NumberType.ZERO, NumberType.POSITIVE, true, true, 2);
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.ZERO, true, true, 2);
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.POSITIVE, true, true, 3);
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.NEGATIVE, true, true, 1);
    }

    @Test
    public void testInclusiveLowerNumericRange() throws Exception {
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.ZERO, false, true, 1);
        this.assertRangeQuery(NumberType.ZERO, NumberType.POSITIVE, false, true, 1);
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.POSITIVE, false, true, 2);
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.NEGATIVE, false, true, 0);
    }

    @Test
    public void testInclusiveUpperNumericRange() throws Exception {
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.ZERO, true, false, 1);
        this.assertRangeQuery(NumberType.ZERO, NumberType.POSITIVE, true, false, 1);
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.POSITIVE, true, false, 2);
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.NEGATIVE, true, false, 0);
    }

    @Test
    public void testExclusiveNumericRange() throws Exception {
        this.assertRangeQuery(NumberType.ZERO, NumberType.ZERO, false, false, 0);
        this.assertRangeQuery(NumberType.ZERO, NumberType.POSITIVE, false, false, 0);
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.ZERO, false, false, 0);
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.POSITIVE, false, false, 1);
        this.assertRangeQuery(NumberType.NEGATIVE, NumberType.NEGATIVE, false, false, 0);
    }

    @Test
    public void testOpenRangeNumericQuery() throws Exception {
        this.assertOpenRangeQuery(NumberType.ZERO, "<", 1);
        this.assertOpenRangeQuery(NumberType.POSITIVE, "<", 2);
        this.assertOpenRangeQuery(NumberType.NEGATIVE, "<", 0);
        this.assertOpenRangeQuery(NumberType.ZERO, "<=", 2);
        this.assertOpenRangeQuery(NumberType.POSITIVE, "<=", 3);
        this.assertOpenRangeQuery(NumberType.NEGATIVE, "<=", 1);
        this.assertOpenRangeQuery(NumberType.ZERO, ">", 1);
        this.assertOpenRangeQuery(NumberType.POSITIVE, ">", 0);
        this.assertOpenRangeQuery(NumberType.NEGATIVE, ">", 2);
        this.assertOpenRangeQuery(NumberType.ZERO, ">=", 2);
        this.assertOpenRangeQuery(NumberType.POSITIVE, ">=", 1);
        this.assertOpenRangeQuery(NumberType.NEGATIVE, ">=", 3);
        this.assertOpenRangeQuery(NumberType.NEGATIVE, "=", 1);
        this.assertOpenRangeQuery(NumberType.ZERO, "=", 1);
        this.assertOpenRangeQuery(NumberType.POSITIVE, "=", 1);
        this.assertRangeQuery(NumberType.NEGATIVE, null, true, true, 3);
        this.assertRangeQuery(NumberType.NEGATIVE, null, false, true, 2);
        this.assertRangeQuery(NumberType.POSITIVE, null, true, false, 1);
        this.assertRangeQuery(NumberType.ZERO, null, false, false, 1);
        this.assertRangeQuery(null, NumberType.POSITIVE, true, true, 3);
        this.assertRangeQuery(null, NumberType.POSITIVE, true, false, 2);
        this.assertRangeQuery(null, NumberType.NEGATIVE, false, true, 1);
        this.assertRangeQuery(null, NumberType.ZERO, false, false, 1);
        this.assertRangeQuery(null, null, false, false, 3);
        this.assertRangeQuery(null, null, true, true, 3);
    }

    @Test
    public void testSimpleNumericQuery() throws Exception {
        this.assertSimpleQuery(NumberType.ZERO, 1);
        this.assertSimpleQuery(NumberType.POSITIVE, 1);
        this.assertSimpleQuery(NumberType.NEGATIVE, 1);
    }

    public void assertRangeQuery(NumberType lowerType, NumberType upperType, boolean lowerInclusive, boolean upperInclusive, int expectedDocCount) throws QueryNodeException, IOException {
        StringBuilder sb = new StringBuilder();
        String lowerInclusiveStr = lowerInclusive ? "[" : "{";
        String upperInclusiveStr = upperInclusive ? "]" : "}";
        for (FieldType.LegacyNumericType type : FieldType.LegacyNumericType.values()) {
            String lowerStr = TestLegacyNumericQueryParser.numberToString(TestLegacyNumericQueryParser.getNumberType(lowerType, type.name()));
            String upperStr = TestLegacyNumericQueryParser.numberToString(TestLegacyNumericQueryParser.getNumberType(upperType, type.name()));
            sb.append("+").append(type.name()).append(':').append(lowerInclusiveStr).append('\"').append(lowerStr).append("\" TO \"").append(upperStr).append('\"').append(upperInclusiveStr).append(' ');
        }
        Number lowerDateNumber = TestLegacyNumericQueryParser.getNumberType(lowerType, DATE_FIELD_NAME);
        Number upperDateNumber = TestLegacyNumericQueryParser.getNumberType(upperType, DATE_FIELD_NAME);
        String lowerDateStr = lowerDateNumber != null ? ESCAPER.escape((CharSequence)DATE_FORMAT.format((Object)new Date(lowerDateNumber.longValue())), LOCALE, EscapeQuerySyntax.Type.STRING).toString() : "*";
        String upperDateStr = upperDateNumber != null ? ESCAPER.escape((CharSequence)DATE_FORMAT.format((Object)new Date(upperDateNumber.longValue())), LOCALE, EscapeQuerySyntax.Type.STRING).toString() : "*";
        sb.append("+").append(DATE_FIELD_NAME).append(':').append(lowerInclusiveStr).append('\"').append(lowerDateStr).append("\" TO \"").append(upperDateStr).append('\"').append(upperInclusiveStr);
        this.testQuery(sb.toString(), expectedDocCount);
    }

    public void assertOpenRangeQuery(NumberType boundType, String operator, int expectedDocCount) throws QueryNodeException, IOException {
        StringBuilder sb = new StringBuilder();
        for (FieldType.LegacyNumericType type : FieldType.LegacyNumericType.values()) {
            String boundStr = TestLegacyNumericQueryParser.numberToString(TestLegacyNumericQueryParser.getNumberType(boundType, type.name()));
            sb.append("+").append(type.name()).append(operator).append('\"').append(boundStr).append('\"').append(' ');
        }
        String boundDateStr = ESCAPER.escape((CharSequence)DATE_FORMAT.format((Object)new Date(TestLegacyNumericQueryParser.getNumberType(boundType, DATE_FIELD_NAME).longValue())), LOCALE, EscapeQuerySyntax.Type.STRING).toString();
        sb.append("+").append(DATE_FIELD_NAME).append(operator).append('\"').append(boundDateStr).append('\"');
        this.testQuery(sb.toString(), expectedDocCount);
    }

    public void assertSimpleQuery(NumberType numberType, int expectedDocCount) throws QueryNodeException, IOException {
        StringBuilder sb = new StringBuilder();
        for (FieldType.LegacyNumericType type : FieldType.LegacyNumericType.values()) {
            String numberStr = TestLegacyNumericQueryParser.numberToString(TestLegacyNumericQueryParser.getNumberType(numberType, type.name()));
            sb.append('+').append(type.name()).append(":\"").append(numberStr).append("\" ");
        }
        String dateStr = ESCAPER.escape((CharSequence)DATE_FORMAT.format((Object)new Date(TestLegacyNumericQueryParser.getNumberType(numberType, DATE_FIELD_NAME).longValue())), LOCALE, EscapeQuerySyntax.Type.STRING).toString();
        sb.append('+').append(DATE_FIELD_NAME).append(":\"").append(dateStr).append('\"');
        this.testQuery(sb.toString(), expectedDocCount);
    }

    private void testQuery(String queryStr, int expectedDocCount) throws QueryNodeException, IOException {
        if (VERBOSE) {
            System.out.println("Parsing: " + queryStr);
        }
        Query query = qp.parse(queryStr, FIELD_NAME);
        if (VERBOSE) {
            System.out.println("Querying: " + query);
        }
        TopDocs topDocs = searcher.search(query, 1000);
        String msg = "Query <" + queryStr + "> retrieved " + topDocs.totalHits + " document(s), " + expectedDocCount + " document(s) expected.";
        if (VERBOSE) {
            System.out.println(msg);
        }
        TestLegacyNumericQueryParser.assertEquals((String)msg, (long)expectedDocCount, (long)topDocs.totalHits);
    }

    private static String numberToString(Number number) {
        return number == null ? "*" : ESCAPER.escape((CharSequence)NUMBER_FORMAT.format(number), LOCALE, EscapeQuerySyntax.Type.STRING).toString();
    }

    private static Number normalizeNumber(Number number) throws ParseException {
        return NUMBER_FORMAT.parse(NUMBER_FORMAT.format(number));
    }

    @AfterClass
    public static void afterClass() throws Exception {
        searcher = null;
        reader.close();
        reader = null;
        directory.close();
        directory = null;
        qp = null;
        LOCALE = null;
        TIMEZONE = null;
        NUMBER_FORMAT = null;
        DATE_FORMAT = null;
        ESCAPER = null;
    }

    static {
        ESCAPER = new EscapeQuerySyntaxImpl();
        directory = null;
        reader = null;
        searcher = null;
    }

    private static enum NumberType {
        NEGATIVE,
        ZERO,
        POSITIVE;

    }
}

