/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard;

import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.util.LuceneTestCase;

public class TestMultiAnalyzerQPHelper
extends LuceneTestCase {
    private static int multiToken = 0;

    public void testMultiAnalyzer() throws QueryNodeException {
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer((Analyzer)new MultiAnalyzer());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"foo", (Object)qp.parse("foo", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"foo", (Object)qp.parse("\"foo\"", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"foo foobar", (Object)qp.parse("foo foobar", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"\"foo foobar\"", (Object)qp.parse("\"foo foobar\"", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"\"foo foobar blah\"", (Object)qp.parse("\"foo foobar blah\"", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"(multi multi2) foo", (Object)qp.parse("multi foo", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"foo (multi multi2)", (Object)qp.parse("foo multi", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"(multi multi2) (multi multi2)", (Object)qp.parse("multi multi", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"+(foo (multi multi2)) +(bar (multi multi2))", (Object)qp.parse("+(foo multi) +(bar multi)", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"+(foo (multi multi2)) field:\"bar (multi multi2)\"", (Object)qp.parse("+(foo multi) field:\"bar multi\"", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"\"(multi multi2) foo\"", (Object)qp.parse("\"multi foo\"", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"\"foo (multi multi2)\"", (Object)qp.parse("\"foo multi\"", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"\"foo (multi multi2) foobar (multi multi2)\"", (Object)qp.parse("\"foo multi foobar multi\"", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"(field:multi field:multi2) field:foo", (Object)qp.parse("field:multi field:foo", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"field:\"(multi multi2) foo\"", (Object)qp.parse("field:\"multi foo\"", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"triplemulti multi3 multi2", (Object)qp.parse("triplemulti", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"foo (triplemulti multi3 multi2) foobar", (Object)qp.parse("foo triplemulti foobar", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"\"(multi multi2) foo\"~10", (Object)qp.parse("\"multi foo\"~10", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"(\"(multi multi2) foo\")^2.0", (Object)qp.parse("\"multi foo\"^2", "").toString());
        qp.setPhraseSlop(99);
        TestMultiAnalyzerQPHelper.assertEquals((Object)"\"(multi multi2) foo\"~99 bar", (Object)qp.parse("\"multi foo\" bar", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"\"(multi multi2) foo\"~99 \"foo bar\"~2", (Object)qp.parse("\"multi foo\" \"foo bar\"~2", "").toString());
        qp.setPhraseSlop(0);
        qp.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        TestMultiAnalyzerQPHelper.assertEquals((Object)"+(multi multi2) +foo", (Object)qp.parse("multi foo", "").toString());
    }

    public void testPosIncrementAnalyzer() throws QueryNodeException {
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer((Analyzer)new PosIncrementAnalyzer());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"quick brown", (Object)qp.parse("the quick brown", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"\"? quick brown\"", (Object)qp.parse("\"the quick brown\"", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"quick brown fox", (Object)qp.parse("the quick brown fox", "").toString());
        TestMultiAnalyzerQPHelper.assertEquals((Object)"\"? quick brown fox\"", (Object)qp.parse("\"the quick brown fox\"", "").toString());
    }

    private static class TestPosIncrementFilter
    extends TokenFilter {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

        public TestPosIncrementFilter(TokenStream in) {
            super(in);
        }

        public final boolean incrementToken() throws IOException {
            while (this.input.incrementToken()) {
                if (this.termAtt.toString().equals("the")) continue;
                if (this.termAtt.toString().equals("quick")) {
                    this.posIncrAtt.setPositionIncrement(2);
                    return true;
                }
                this.posIncrAtt.setPositionIncrement(1);
                return true;
            }
            return false;
        }
    }

    private static class PosIncrementAnalyzer
    extends Analyzer {
        private PosIncrementAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer result = new MockTokenizer(MockTokenizer.WHITESPACE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)result, (TokenStream)new TestPosIncrementFilter((TokenStream)result));
        }
    }

    private static final class TestFilter
    extends TokenFilter {
        private String prevType;
        private int prevStartOffset;
        private int prevEndOffset;
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);

        public TestFilter(TokenStream in) {
            super(in);
        }

        public final boolean incrementToken() throws IOException {
            if (multiToken > 0) {
                this.termAtt.setEmpty().append("multi" + (multiToken + 1));
                this.offsetAtt.setOffset(this.prevStartOffset, this.prevEndOffset);
                this.typeAtt.setType(this.prevType);
                this.posIncrAtt.setPositionIncrement(0);
                multiToken--;
                return true;
            }
            boolean next = this.input.incrementToken();
            if (!next) {
                return false;
            }
            this.prevType = this.typeAtt.type();
            this.prevStartOffset = this.offsetAtt.startOffset();
            this.prevEndOffset = this.offsetAtt.endOffset();
            String text = this.termAtt.toString();
            if (text.equals("triplemulti")) {
                multiToken = 2;
                return true;
            }
            if (text.equals("multi")) {
                multiToken = 1;
                return true;
            }
            return true;
        }

        public void reset() throws IOException {
            super.reset();
            this.prevType = null;
            this.prevStartOffset = 0;
            this.prevEndOffset = 0;
        }
    }

    private static class MultiAnalyzer
    extends Analyzer {
        private MultiAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer result = new MockTokenizer(MockTokenizer.WHITESPACE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)result, (TokenStream)new TestFilter((TokenStream)result));
        }
    }
}

