/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard;

import java.io.Closeable;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.TestQPHelper;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;

public class TestMultiFieldQPHelper
extends LuceneTestCase {
    public void testStopwordsParsing() throws Exception {
        this.assertStopQueryEquals("one", "b:one t:one");
        this.assertStopQueryEquals("one stop", "b:one t:one");
        this.assertStopQueryEquals("one (stop)", "b:one t:one");
        this.assertStopQueryEquals("one ((stop))", "b:one t:one");
        this.assertStopQueryIsMatchNoDocsQuery("stop");
        this.assertStopQueryIsMatchNoDocsQuery("(stop)");
        this.assertStopQueryIsMatchNoDocsQuery("((stop))");
    }

    private void assertStopQueryIsMatchNoDocsQuery(String qtxt) throws Exception {
        CharSequence[] fields = new String[]{"b", "t"};
        BooleanClause.Occur[] occur = new BooleanClause.Occur[]{BooleanClause.Occur.SHOULD, BooleanClause.Occur.SHOULD};
        TestQPHelper.QPTestAnalyzer a = new TestQPHelper.QPTestAnalyzer();
        StandardQueryParser mfqp = new StandardQueryParser();
        mfqp.setMultiFields(fields);
        mfqp.setAnalyzer((Analyzer)a);
        Query q = mfqp.parse(qtxt, null);
        TestMultiFieldQPHelper.assertTrue((boolean)(q instanceof MatchNoDocsQuery));
    }

    private void assertStopQueryEquals(String qtxt, String expectedRes) throws Exception {
        CharSequence[] fields = new String[]{"b", "t"};
        BooleanClause.Occur[] occur = new BooleanClause.Occur[]{BooleanClause.Occur.SHOULD, BooleanClause.Occur.SHOULD};
        TestQPHelper.QPTestAnalyzer a = new TestQPHelper.QPTestAnalyzer();
        StandardQueryParser mfqp = new StandardQueryParser();
        mfqp.setMultiFields(fields);
        mfqp.setAnalyzer((Analyzer)a);
        Query q = mfqp.parse(qtxt, null);
        TestMultiFieldQPHelper.assertEquals((Object)expectedRes, (Object)q.toString().trim());
        q = QueryParserUtil.parse((String)qtxt, (String[])fields, (BooleanClause.Occur[])occur, (Analyzer)a);
        TestMultiFieldQPHelper.assertEquals((Object)expectedRes, (Object)q.toString().trim());
    }

    public void testSimple() throws Exception {
        CharSequence[] fields = new String[]{"b", "t"};
        StandardQueryParser mfqp = new StandardQueryParser();
        mfqp.setMultiFields(fields);
        mfqp.setAnalyzer((Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        Query q = mfqp.parse("one", null);
        TestMultiFieldQPHelper.assertEquals((Object)"b:one t:one", (Object)q.toString());
        q = mfqp.parse("one two", null);
        TestMultiFieldQPHelper.assertEquals((Object)"(b:one t:one) (b:two t:two)", (Object)q.toString());
        q = mfqp.parse("+one +two", null);
        TestMultiFieldQPHelper.assertEquals((Object)"+(b:one t:one) +(b:two t:two)", (Object)q.toString());
        q = mfqp.parse("+one -two -three", null);
        TestMultiFieldQPHelper.assertEquals((Object)"+(b:one t:one) -(b:two t:two) -(b:three t:three)", (Object)q.toString());
        q = mfqp.parse("one^2 two", null);
        TestMultiFieldQPHelper.assertEquals((Object)"(b:one t:one)^2.0 (b:two t:two)", (Object)q.toString());
        q = mfqp.parse("one~ two", null);
        TestMultiFieldQPHelper.assertEquals((Object)"(b:one~2 t:one~2) (b:two t:two)", (Object)q.toString());
        q = mfqp.parse("one~0.8 two^2", null);
        TestMultiFieldQPHelper.assertEquals((Object)"(b:one~0 t:one~0) (b:two t:two)^2.0", (Object)q.toString());
        q = mfqp.parse("one* two*", null);
        TestMultiFieldQPHelper.assertEquals((Object)"(b:one* t:one*) (b:two* t:two*)", (Object)q.toString());
        q = mfqp.parse("[a TO c] two", null);
        TestMultiFieldQPHelper.assertEquals((Object)"(b:[a TO c] t:[a TO c]) (b:two t:two)", (Object)q.toString());
        q = mfqp.parse("w?ldcard", null);
        TestMultiFieldQPHelper.assertEquals((Object)"b:w?ldcard t:w?ldcard", (Object)q.toString());
        q = mfqp.parse("\"foo bar\"", null);
        TestMultiFieldQPHelper.assertEquals((Object)"b:\"foo bar\" t:\"foo bar\"", (Object)q.toString());
        q = mfqp.parse("\"aa bb cc\" \"dd ee\"", null);
        TestMultiFieldQPHelper.assertEquals((Object)"(b:\"aa bb cc\" t:\"aa bb cc\") (b:\"dd ee\" t:\"dd ee\")", (Object)q.toString());
        q = mfqp.parse("\"foo bar\"~4", null);
        TestMultiFieldQPHelper.assertEquals((Object)"b:\"foo bar\"~4 t:\"foo bar\"~4", (Object)q.toString());
        q = mfqp.parse("b:\"foo bar\"~4", null);
        TestMultiFieldQPHelper.assertEquals((Object)"b:\"foo bar\"~4", (Object)q.toString());
        q = mfqp.parse("one f:two", null);
        TestMultiFieldQPHelper.assertEquals((Object)"(b:one t:one) f:two", (Object)q.toString());
        mfqp.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        q = mfqp.parse("one two", null);
        TestMultiFieldQPHelper.assertEquals((Object)"+(b:one t:one) +(b:two t:two)", (Object)q.toString());
        q = mfqp.parse("\"aa bb cc\" \"dd ee\"", null);
        TestMultiFieldQPHelper.assertEquals((Object)"+(b:\"aa bb cc\" t:\"aa bb cc\") +(b:\"dd ee\" t:\"dd ee\")", (Object)q.toString());
    }

    public void testBoostsSimple() throws Exception {
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("b", Float.valueOf(5.0f));
        boosts.put("t", Float.valueOf(10.0f));
        CharSequence[] fields = new String[]{"b", "t"};
        StandardQueryParser mfqp = new StandardQueryParser();
        mfqp.setMultiFields(fields);
        mfqp.setFieldsBoost(boosts);
        mfqp.setAnalyzer((Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        Query q = mfqp.parse("one", null);
        TestMultiFieldQPHelper.assertEquals((Object)"(b:one)^5.0 (t:one)^10.0", (Object)q.toString());
        q = mfqp.parse("one AND two", null);
        TestMultiFieldQPHelper.assertEquals((Object)"+((b:one)^5.0 (t:one)^10.0) +((b:two)^5.0 (t:two)^10.0)", (Object)q.toString());
        q = mfqp.parse("one OR two", null);
        TestMultiFieldQPHelper.assertEquals((Object)"((b:one)^5.0 (t:one)^10.0) ((b:two)^5.0 (t:two)^10.0)", (Object)q.toString());
        q = mfqp.parse("one AND two AND foo:test", null);
        TestMultiFieldQPHelper.assertEquals((Object)"+((b:one)^5.0 (t:one)^10.0) +((b:two)^5.0 (t:two)^10.0) +foo:test", (Object)q.toString());
        q = mfqp.parse("one^3 AND two^4", null);
        TestMultiFieldQPHelper.assertEquals((Object)"+((b:one)^5.0 (t:one)^10.0)^3.0 +((b:two)^5.0 (t:two)^10.0)^4.0", (Object)q.toString());
    }

    public void testStaticMethod1() throws QueryNodeException {
        String[] fields = new String[]{"b", "t"};
        String[] queries = new String[]{"one", "two"};
        Query q = QueryParserUtil.parse((String[])queries, (String[])fields, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        TestMultiFieldQPHelper.assertEquals((Object)"b:one t:two", (Object)q.toString());
        String[] queries2 = new String[]{"+one", "+two"};
        q = QueryParserUtil.parse((String[])queries2, (String[])fields, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        TestMultiFieldQPHelper.assertEquals((Object)"b:one t:two", (Object)q.toString());
        String[] queries3 = new String[]{"one", "+two"};
        q = QueryParserUtil.parse((String[])queries3, (String[])fields, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        TestMultiFieldQPHelper.assertEquals((Object)"b:one t:two", (Object)q.toString());
        String[] queries4 = new String[]{"one +more", "+two"};
        q = QueryParserUtil.parse((String[])queries4, (String[])fields, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        TestMultiFieldQPHelper.assertEquals((Object)"(b:one +b:more) t:two", (Object)q.toString());
        String[] queries5 = new String[]{"blah"};
        TestMultiFieldQPHelper.expectThrows(IllegalArgumentException.class, () -> QueryParserUtil.parse((String[])queries5, (String[])fields, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random())));
        TestQPHelper.QPTestAnalyzer stopA = new TestQPHelper.QPTestAnalyzer();
        String[] queries6 = new String[]{"((+stop))", "+((stop))"};
        q = QueryParserUtil.parse((String[])queries6, (String[])fields, (Analyzer)stopA);
        TestMultiFieldQPHelper.assertEquals((Object)"MatchNoDocsQuery(\"\") MatchNoDocsQuery(\"\")", (Object)q.toString());
        String[] queries7 = new String[]{"one ((+stop)) +more", "+((stop)) +two"};
        q = QueryParserUtil.parse((String[])queries7, (String[])fields, (Analyzer)stopA);
        TestMultiFieldQPHelper.assertEquals((Object)"(b:one +b:more) (+t:two)", (Object)q.toString());
    }

    public void testStaticMethod2() throws QueryNodeException {
        String[] fields = new String[]{"b", "t"};
        BooleanClause.Occur[] flags = new BooleanClause.Occur[]{BooleanClause.Occur.MUST, BooleanClause.Occur.MUST_NOT};
        Query q = QueryParserUtil.parse((String)"one", (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        TestMultiFieldQPHelper.assertEquals((Object)"+b:one -t:one", (Object)q.toString());
        q = QueryParserUtil.parse((String)"one two", (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        TestMultiFieldQPHelper.assertEquals((Object)"+(b:one b:two) -(t:one t:two)", (Object)q.toString());
        TestMultiFieldQPHelper.expectThrows(IllegalArgumentException.class, () -> {
            BooleanClause.Occur[] flags2 = new BooleanClause.Occur[]{BooleanClause.Occur.MUST};
            QueryParserUtil.parse((String)"blah", (String[])fields, (BooleanClause.Occur[])flags2, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        });
    }

    public void testStaticMethod2Old() throws QueryNodeException {
        CharSequence[] fields = new String[]{"b", "t"};
        BooleanClause.Occur[] flags = new BooleanClause.Occur[]{BooleanClause.Occur.MUST, BooleanClause.Occur.MUST_NOT};
        StandardQueryParser parser = new StandardQueryParser();
        parser.setMultiFields(fields);
        parser.setAnalyzer((Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        Query q = QueryParserUtil.parse((String)"one", (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        TestMultiFieldQPHelper.assertEquals((Object)"+b:one -t:one", (Object)q.toString());
        q = QueryParserUtil.parse((String)"one two", (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        TestMultiFieldQPHelper.assertEquals((Object)"+(b:one b:two) -(t:one t:two)", (Object)q.toString());
        TestMultiFieldQPHelper.expectThrows(IllegalArgumentException.class, () -> TestMultiFieldQPHelper.lambda$testStaticMethod2Old$2((String[])fields));
    }

    public void testStaticMethod3() throws QueryNodeException {
        String[] queries = new String[]{"one", "two", "three"};
        String[] fields = new String[]{"f1", "f2", "f3"};
        BooleanClause.Occur[] flags = new BooleanClause.Occur[]{BooleanClause.Occur.MUST, BooleanClause.Occur.MUST_NOT, BooleanClause.Occur.SHOULD};
        Query q = QueryParserUtil.parse((String[])queries, (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        TestMultiFieldQPHelper.assertEquals((Object)"+f1:one -f2:two f3:three", (Object)q.toString());
        TestMultiFieldQPHelper.expectThrows(IllegalArgumentException.class, () -> {
            BooleanClause.Occur[] flags2 = new BooleanClause.Occur[]{BooleanClause.Occur.MUST};
            QueryParserUtil.parse((String[])queries, (String[])fields, (BooleanClause.Occur[])flags2, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        });
    }

    public void testStaticMethod3Old() throws QueryNodeException {
        String[] queries = new String[]{"one", "two"};
        String[] fields = new String[]{"b", "t"};
        BooleanClause.Occur[] flags = new BooleanClause.Occur[]{BooleanClause.Occur.MUST, BooleanClause.Occur.MUST_NOT};
        Query q = QueryParserUtil.parse((String[])queries, (String[])fields, (BooleanClause.Occur[])flags, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        TestMultiFieldQPHelper.assertEquals((Object)"+b:one -t:two", (Object)q.toString());
        TestMultiFieldQPHelper.expectThrows(IllegalArgumentException.class, () -> {
            BooleanClause.Occur[] flags2 = new BooleanClause.Occur[]{BooleanClause.Occur.MUST};
            QueryParserUtil.parse((String[])queries, (String[])fields, (BooleanClause.Occur[])flags2, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
        });
    }

    public void testAnalyzerReturningNull() throws QueryNodeException {
        CharSequence[] fields = new String[]{"f1", "f2", "f3"};
        StandardQueryParser parser = new StandardQueryParser();
        parser.setMultiFields(fields);
        parser.setAnalyzer((Analyzer)new AnalyzerReturningNull());
        Query q = parser.parse("bla AND blo", null);
        TestMultiFieldQPHelper.assertEquals((Object)"+(f2:bla f3:bla) +(f2:blo f3:blo)", (Object)q.toString());
        q = parser.parse("bla*", null);
        TestMultiFieldQPHelper.assertEquals((Object)"f1:bla* f2:bla* f3:bla*", (Object)q.toString());
        q = parser.parse("bla~", null);
        TestMultiFieldQPHelper.assertEquals((Object)"f1:bla~2 f2:bla~2 f3:bla~2", (Object)q.toString());
        q = parser.parse("[a TO c]", null);
        TestMultiFieldQPHelper.assertEquals((Object)"f1:[a TO c] f2:[a TO c] f3:[a TO c]", (Object)q.toString());
    }

    public void testStopWordSearching() throws Exception {
        MockAnalyzer analyzer = new MockAnalyzer(TestMultiFieldQPHelper.random());
        BaseDirectoryWrapper ramDir = TestMultiFieldQPHelper.newDirectory();
        IndexWriter iw = new IndexWriter((Directory)ramDir, TestMultiFieldQPHelper.newIndexWriterConfig((Analyzer)analyzer));
        Document doc = new Document();
        doc.add((IndexableField)TestMultiFieldQPHelper.newTextField((String)"body", (String)"blah the footest blah", (Field.Store)Field.Store.NO));
        iw.addDocument((Iterable)doc);
        iw.close();
        StandardQueryParser mfqp = new StandardQueryParser();
        mfqp.setMultiFields((CharSequence[])new String[]{"body"});
        mfqp.setAnalyzer((Analyzer)analyzer);
        mfqp.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        Query q = mfqp.parse("the footest", null);
        DirectoryReader ir = DirectoryReader.open((Directory)ramDir);
        IndexSearcher is = TestMultiFieldQPHelper.newSearcher((IndexReader)ir);
        ScoreDoc[] hits = is.search((Query)q, (int)1000).scoreDocs;
        TestMultiFieldQPHelper.assertEquals((long)1L, (long)hits.length);
        ir.close();
        ramDir.close();
    }

    private static /* synthetic */ void lambda$testStaticMethod2Old$2(String[] fields) throws Throwable {
        BooleanClause.Occur[] flags2 = new BooleanClause.Occur[]{BooleanClause.Occur.MUST};
        QueryParserUtil.parse((String)"blah", (String[])fields, (BooleanClause.Occur[])flags2, (Analyzer)new MockAnalyzer(TestMultiFieldQPHelper.random()));
    }

    private static class AnalyzerReturningNull
    extends Analyzer {
        MockAnalyzer stdAnalyzer = new MockAnalyzer(LuceneTestCase.random());

        public AnalyzerReturningNull() {
            super(PER_FIELD_REUSE_STRATEGY);
        }

        protected Reader initReader(String fieldName, Reader reader) {
            if ("f1".equals(fieldName)) {
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader});
                return new StringReader("");
            }
            return super.initReader(fieldName, reader);
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            return this.stdAnalyzer.createComponents(fieldName);
        }
    }
}

