/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard;

import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import org.apache.lucene.util.LuceneTestCase;

public class TestPointQueryParser
extends LuceneTestCase {
    public void testIntegers() throws Exception {
        StandardQueryParser parser = new StandardQueryParser();
        HashMap<String, PointsConfig> pointsConfig = new HashMap<String, PointsConfig>();
        pointsConfig.put("intField", new PointsConfig(NumberFormat.getIntegerInstance(Locale.ROOT), Integer.class));
        parser.setPointsConfigMap(pointsConfig);
        TestPointQueryParser.assertEquals((Object)IntPoint.newRangeQuery((String)"intField", (int)1, (int)3), (Object)parser.parse("intField:[1 TO 3]", "body"));
        TestPointQueryParser.assertEquals((Object)IntPoint.newRangeQuery((String)"intField", (int)1, (int)1), (Object)parser.parse("intField:1", "body"));
    }

    public void testLongs() throws Exception {
        StandardQueryParser parser = new StandardQueryParser();
        HashMap<String, PointsConfig> pointsConfig = new HashMap<String, PointsConfig>();
        pointsConfig.put("longField", new PointsConfig(NumberFormat.getIntegerInstance(Locale.ROOT), Long.class));
        parser.setPointsConfigMap(pointsConfig);
        TestPointQueryParser.assertEquals((Object)LongPoint.newRangeQuery((String)"longField", (long)1L, (long)3L), (Object)parser.parse("longField:[1 TO 3]", "body"));
        TestPointQueryParser.assertEquals((Object)LongPoint.newRangeQuery((String)"longField", (long)1L, (long)1L), (Object)parser.parse("longField:1", "body"));
    }

    public void testFloats() throws Exception {
        StandardQueryParser parser = new StandardQueryParser();
        HashMap<String, PointsConfig> pointsConfig = new HashMap<String, PointsConfig>();
        pointsConfig.put("floatField", new PointsConfig(NumberFormat.getNumberInstance(Locale.ROOT), Float.class));
        parser.setPointsConfigMap(pointsConfig);
        TestPointQueryParser.assertEquals((Object)FloatPoint.newRangeQuery((String)"floatField", (float)1.5f, (float)3.6f), (Object)parser.parse("floatField:[1.5 TO 3.6]", "body"));
        TestPointQueryParser.assertEquals((Object)FloatPoint.newRangeQuery((String)"floatField", (float)1.5f, (float)1.5f), (Object)parser.parse("floatField:1.5", "body"));
    }

    public void testDoubles() throws Exception {
        StandardQueryParser parser = new StandardQueryParser();
        HashMap<String, PointsConfig> pointsConfig = new HashMap<String, PointsConfig>();
        pointsConfig.put("doubleField", new PointsConfig(NumberFormat.getNumberInstance(Locale.ROOT), Double.class));
        parser.setPointsConfigMap(pointsConfig);
        TestPointQueryParser.assertEquals((Object)DoublePoint.newRangeQuery((String)"doubleField", (double)1.5, (double)3.6), (Object)parser.parse("doubleField:[1.5 TO 3.6]", "body"));
        TestPointQueryParser.assertEquals((Object)DoublePoint.newRangeQuery((String)"doubleField", (double)1.5, (double)1.5), (Object)parser.parse("doubleField:1.5", "body"));
    }
}

