/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.messages.QueryParserMessages;
import org.apache.lucene.queryparser.flexible.core.nodes.FuzzyQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessor;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorPipeline;
import org.apache.lucene.queryparser.flexible.messages.Message;
import org.apache.lucene.queryparser.flexible.messages.MessageImpl;
import org.apache.lucene.queryparser.flexible.standard.QueryParserUtil;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryparser.flexible.standard.nodes.WildcardQueryNode;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Ignore;

public class TestQPHelper
extends LuceneTestCase {
    public static Analyzer qpAnalyzer;
    private int originalMaxClauses;

    @BeforeClass
    public static void beforeClass() {
        qpAnalyzer = new QPTestAnalyzer();
    }

    @AfterClass
    public static void afterClass() {
        qpAnalyzer = null;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.originalMaxClauses = BooleanQuery.getMaxClauseCount();
    }

    public StandardQueryParser getParser(Analyzer a) throws Exception {
        if (a == null) {
            a = new MockAnalyzer(TestQPHelper.random(), MockTokenizer.SIMPLE, true);
        }
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer(a);
        qp.setDefaultOperator(StandardQueryConfigHandler.Operator.OR);
        return qp;
    }

    public Query getQuery(String query, Analyzer a) throws Exception {
        return this.getParser(a).parse(query, "field");
    }

    public Query getQueryAllowLeadingWildcard(String query, Analyzer a) throws Exception {
        StandardQueryParser parser = this.getParser(a);
        parser.setAllowLeadingWildcard(true);
        return parser.parse(query, "field");
    }

    public void assertQueryEquals(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQuery(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestQPHelper.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertMatchNoDocsQuery(String queryString, Analyzer a) throws Exception {
        this.assertMatchNoDocsQuery(this.getQuery(queryString, a));
    }

    public void assertMatchNoDocsQuery(Query query) throws Exception {
        if (!(query instanceof MatchNoDocsQuery || query instanceof BooleanQuery && ((BooleanQuery)query).clauses().size() == 0)) {
            TestQPHelper.fail((String)("expected MatchNoDocsQuery or an empty BooleanQuery but got: " + query));
        }
    }

    public void assertQueryEqualsAllowLeadingWildcard(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQueryAllowLeadingWildcard(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestQPHelper.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertQueryEquals(StandardQueryParser qp, String field, String query, String result) throws Exception {
        Query q = qp.parse(query, field);
        String s = q.toString(field);
        if (!s.equals(result)) {
            TestQPHelper.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertEscapedQueryEquals(String query, Analyzer a, String result) throws Exception {
        String escapedQuery = QueryParserUtil.escape((String)query);
        if (!escapedQuery.equals(result)) {
            TestQPHelper.fail((String)("Query /" + query + "/ yielded /" + escapedQuery + "/, expecting /" + result + "/"));
        }
    }

    public void assertWildcardQueryEquals(String query, boolean lowercase, String result, boolean allowLeadingWildcard) throws Exception {
        StandardQueryParser qp = this.getParser(null);
        qp.setLowercaseExpandedTerms(lowercase);
        qp.setAllowLeadingWildcard(allowLeadingWildcard);
        Query q = qp.parse(query, "field");
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestQPHelper.fail((String)("WildcardQuery /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertWildcardQueryEquals(String query, boolean lowercase, String result) throws Exception {
        this.assertWildcardQueryEquals(query, lowercase, result, false);
    }

    public void assertWildcardQueryEquals(String query, String result) throws Exception {
        StandardQueryParser qp = this.getParser(null);
        Query q = qp.parse(query, "field");
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestQPHelper.fail((String)("WildcardQuery /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public Query getQueryDOA(String query, Analyzer a) throws Exception {
        if (a == null) {
            a = new MockAnalyzer(TestQPHelper.random(), MockTokenizer.SIMPLE, true);
        }
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer(a);
        qp.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        return qp.parse(query, "field");
    }

    public void assertQueryEqualsDOA(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQueryDOA(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            TestQPHelper.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void testConstantScoreAutoRewrite() throws Exception {
        StandardQueryParser qp = new StandardQueryParser((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false));
        Query q = qp.parse("foo*bar", "field");
        TestQPHelper.assertTrue((boolean)(q instanceof WildcardQuery));
        TestQPHelper.assertEquals((Object)MultiTermQuery.CONSTANT_SCORE_REWRITE, (Object)((MultiTermQuery)q).getRewriteMethod());
        q = qp.parse("foo*", "field");
        TestQPHelper.assertTrue((boolean)(q instanceof PrefixQuery));
        TestQPHelper.assertEquals((Object)MultiTermQuery.CONSTANT_SCORE_REWRITE, (Object)((MultiTermQuery)q).getRewriteMethod());
        q = qp.parse("[a TO z]", "field");
        TestQPHelper.assertTrue((boolean)(q instanceof TermRangeQuery));
        TestQPHelper.assertEquals((Object)MultiTermQuery.CONSTANT_SCORE_REWRITE, (Object)((MultiTermQuery)q).getRewriteMethod());
    }

    public void testCJK() throws Exception {
        this.assertQueryEquals("term\u3000term\u3000term", null, "term term term");
        this.assertQueryEqualsAllowLeadingWildcard("??\u3000??\u3000??", null, "?? ?? ??");
    }

    public void testCJKTerm() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "\u56fd")), BooleanClause.Occur.SHOULD);
        TestQPHelper.assertEquals((Object)expected.build(), (Object)this.getQuery("\u4e2d\u56fd", analyzer));
        expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.MUST);
        BooleanQuery.Builder inner = new BooleanQuery.Builder();
        inner.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.SHOULD);
        inner.add((Query)new TermQuery(new Term("field", "\u56fd")), BooleanClause.Occur.SHOULD);
        expected.add((Query)inner.build(), BooleanClause.Occur.MUST);
        TestQPHelper.assertEquals((Object)expected.build(), (Object)this.getQuery("\u4e2d AND \u4e2d\u56fd", new SimpleCJKAnalyzer()));
    }

    public void testCJKBoostedTerm() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        BooleanQuery.Builder expectedB = new BooleanQuery.Builder();
        expectedB.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.SHOULD);
        expectedB.add((Query)new TermQuery(new Term("field", "\u56fd")), BooleanClause.Occur.SHOULD);
        BooleanQuery expected = expectedB.build();
        expected = new BoostQuery((Query)expected, 0.5f);
        TestQPHelper.assertEquals((Object)expected, (Object)this.getQuery("\u4e2d\u56fd^0.5", analyzer));
    }

    public void testCJKPhrase() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        PhraseQuery expected = new PhraseQuery("field", new String[]{"\u4e2d", "\u56fd"});
        TestQPHelper.assertEquals((Object)expected, (Object)this.getQuery("\"\u4e2d\u56fd\"", analyzer));
    }

    public void testCJKBoostedPhrase() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        PhraseQuery expected = new PhraseQuery("field", new String[]{"\u4e2d", "\u56fd"});
        expected = new BoostQuery((Query)expected, 0.5f);
        TestQPHelper.assertEquals((Object)expected, (Object)this.getQuery("\"\u4e2d\u56fd\"^0.5", analyzer));
    }

    public void testCJKSloppyPhrase() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        PhraseQuery expected = new PhraseQuery(3, "field", new String[]{"\u4e2d", "\u56fd"});
        TestQPHelper.assertEquals((Object)expected, (Object)this.getQuery("\"\u4e2d\u56fd\"~3", analyzer));
    }

    public void testSimple() throws Exception {
        this.assertQueryEquals("field=a", null, "a");
        this.assertQueryEquals("\"term germ\"~2", null, "\"term germ\"~2");
        this.assertQueryEquals("term term term", null, "term term term");
        this.assertQueryEquals("t\ufffdrm term term", (Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false), "t\ufffdrm term term");
        this.assertQueryEquals("\ufffdmlaut", (Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false), "\ufffdmlaut");
        this.assertQueryEquals("a AND b", null, "+a +b");
        this.assertQueryEquals("(a AND b)", null, "+a +b");
        this.assertQueryEquals("c OR (a AND b)", null, "c (+a +b)");
        this.assertQueryEquals("a AND NOT b", null, "+a -b");
        this.assertQueryEquals("a AND -b", null, "+a -b");
        this.assertQueryEquals("a AND !b", null, "+a -b");
        this.assertQueryEquals("a && b", null, "+a +b");
        this.assertQueryEquals("a && ! b", null, "+a -b");
        this.assertQueryEquals("a OR b", null, "a b");
        this.assertQueryEquals("a || b", null, "a b");
        this.assertQueryEquals("a OR !b", null, "a -b");
        this.assertQueryEquals("a OR ! b", null, "a -b");
        this.assertQueryEquals("a OR -b", null, "a -b");
        this.assertQueryEquals("+term -term term", null, "+term -term term");
        this.assertQueryEquals("foo:term AND field:anotherTerm", null, "+foo:term +anotherterm");
        this.assertQueryEquals("term AND \"phrase phrase\"", null, "+term +\"phrase phrase\"");
        this.assertQueryEquals("\"hello there\"", null, "\"hello there\"");
        TestQPHelper.assertTrue((boolean)(this.getQuery("a AND b", null) instanceof BooleanQuery));
        TestQPHelper.assertTrue((boolean)(this.getQuery("hello", null) instanceof TermQuery));
        TestQPHelper.assertTrue((boolean)(this.getQuery("\"hello there\"", null) instanceof PhraseQuery));
        this.assertQueryEquals("germ term^2.0", null, "germ (term)^2.0");
        this.assertQueryEquals("(term)^2.0", null, "(term)^2.0");
        this.assertQueryEquals("(germ term)^2.0", null, "(germ term)^2.0");
        this.assertQueryEquals("term^2.0", null, "(term)^2.0");
        this.assertQueryEquals("term^2", null, "(term)^2.0");
        this.assertQueryEquals("\"germ term\"^2.0", null, "(\"germ term\")^2.0");
        this.assertQueryEquals("\"term germ\"^2", null, "(\"term germ\")^2.0");
        this.assertQueryEquals("(foo OR bar) AND (baz OR boo)", null, "+(foo bar) +(baz boo)");
        this.assertQueryEquals("((a OR b) AND NOT c) OR d", null, "(+(a b) -c) d");
        this.assertQueryEquals("+(apple \"steve jobs\") -(foo bar baz)", null, "+(apple \"steve jobs\") -(foo bar baz)");
        this.assertQueryEquals("+title:(dog OR cat) -author:\"bob dole\"", null, "+(title:dog title:cat) -author:\"bob dole\"");
    }

    public void testPunct() throws Exception {
        MockAnalyzer a = new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false);
        this.assertQueryEquals("a&b", (Analyzer)a, "a&b");
        this.assertQueryEquals("a&&b", (Analyzer)a, "a&&b");
        this.assertQueryEquals(".NET", (Analyzer)a, ".NET");
    }

    public void testGroup() throws Exception {
        this.assertQueryEquals("!(a AND b) OR c", null, "-(+a +b) c");
        this.assertQueryEquals("!(a AND b) AND c", null, "-(+a +b) +c");
        this.assertQueryEquals("((a AND b) AND c)", null, "+(+a +b) +c");
        this.assertQueryEquals("(a AND b) AND c", null, "+(+a +b) +c");
        this.assertQueryEquals("b !(a AND b)", null, "b -(+a +b)");
        this.assertQueryEquals("(a AND b)^4 OR c", null, "(+a +b)^4.0 c");
    }

    public void testSlop() throws Exception {
        this.assertQueryEquals("\"term germ\"~2", null, "\"term germ\"~2");
        this.assertQueryEquals("\"term germ\"~2 flork", null, "\"term germ\"~2 flork");
        this.assertQueryEquals("\"term\"~2", null, "term");
        this.assertQueryEquals("\" \"~2 germ", null, "germ");
        this.assertQueryEquals("\"term germ\"~2^2", null, "(\"term germ\"~2)^2.0");
    }

    public void testNumber() throws Exception {
        this.assertMatchNoDocsQuery("3", null);
        this.assertQueryEquals("term 1.0 1 2", null, "term");
        this.assertQueryEquals("term term1 term2", null, "term term term");
        MockAnalyzer a = new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false);
        this.assertQueryEquals("3", (Analyzer)a, "3");
        this.assertQueryEquals("term 1.0 1 2", (Analyzer)a, "term 1.0 1 2");
        this.assertQueryEquals("term term1 term2", (Analyzer)a, "term term1 term2");
    }

    public void testLeadingNegation() throws Exception {
        this.assertQueryEquals("-term", null, "-term");
        this.assertQueryEquals("!term", null, "-term");
        this.assertQueryEquals("NOT term", null, "-term");
    }

    public void testNegationInParentheses() throws Exception {
        this.assertQueryEquals("(-a)", null, "-a");
        this.assertQueryEquals("(!a)", null, "-a");
        this.assertQueryEquals("(NOT a)", null, "-a");
        this.assertQueryEquals("a (!b)", null, "a (-b)");
        this.assertQueryEquals("+a +(!b)", null, "+a +(-b)");
        this.assertQueryEquals("a AND (!b)", null, "+a +(-b)");
        this.assertQueryEquals("a (NOT b)", null, "a (-b)");
        this.assertQueryEquals("a AND (NOT b)", null, "+a +(-b)");
    }

    public void testWildcard() throws Exception {
        this.assertQueryEquals("term*", null, "term*");
        this.assertQueryEquals("term*^2", null, "(term*)^2.0");
        this.assertQueryEquals("term~", null, "term~2");
        this.assertQueryEquals("term~0.7", null, "term~1");
        this.assertQueryEquals("term~^3", null, "(term~2)^3.0");
        this.assertQueryEquals("term^3~", null, "(term~2)^3.0");
        this.assertQueryEquals("term*germ", null, "term*germ");
        this.assertQueryEquals("term*germ^3", null, "(term*germ)^3.0");
        TestQPHelper.assertTrue((boolean)(this.getQuery("term*", null) instanceof PrefixQuery));
        TestQPHelper.assertTrue((boolean)(this.getQuery("term*^2", null) instanceof BoostQuery));
        TestQPHelper.assertTrue((boolean)(((BoostQuery)this.getQuery("term*^2", null)).getQuery() instanceof PrefixQuery));
        TestQPHelper.assertTrue((boolean)(this.getQuery("term~", null) instanceof FuzzyQuery));
        TestQPHelper.assertTrue((boolean)(this.getQuery("term~0.7", null) instanceof FuzzyQuery));
        FuzzyQuery fq = (FuzzyQuery)this.getQuery("term~0.7", null);
        TestQPHelper.assertEquals((long)1L, (long)fq.getMaxEdits());
        TestQPHelper.assertEquals((long)0L, (long)fq.getPrefixLength());
        fq = (FuzzyQuery)this.getQuery("term~", null);
        TestQPHelper.assertEquals((long)2L, (long)fq.getMaxEdits());
        TestQPHelper.assertEquals((long)0L, (long)fq.getPrefixLength());
        this.assertQueryNodeException("term~1.1");
        TestQPHelper.assertTrue((boolean)(this.getQuery("term*germ", null) instanceof WildcardQuery));
        this.assertWildcardQueryEquals("Term*", true, "term*");
        this.assertWildcardQueryEquals("term*", true, "term*");
        this.assertWildcardQueryEquals("Term*", true, "term*");
        this.assertWildcardQueryEquals("TERM*", true, "term*");
        this.assertWildcardQueryEquals("term*", false, "term*");
        this.assertWildcardQueryEquals("Term*", false, "Term*");
        this.assertWildcardQueryEquals("TERM*", false, "TERM*");
        this.assertWildcardQueryEquals("Te?m", "te?m");
        this.assertWildcardQueryEquals("te?m", true, "te?m");
        this.assertWildcardQueryEquals("Te?m", true, "te?m");
        this.assertWildcardQueryEquals("TE?M", true, "te?m");
        this.assertWildcardQueryEquals("Te?m*gerM", true, "te?m*germ");
        this.assertWildcardQueryEquals("te?m", false, "te?m");
        this.assertWildcardQueryEquals("Te?m", false, "Te?m");
        this.assertWildcardQueryEquals("TE?M", false, "TE?M");
        this.assertWildcardQueryEquals("Te?m*gerM", false, "Te?m*gerM");
        this.assertWildcardQueryEquals("Term~", "term~2");
        this.assertWildcardQueryEquals("Term~", true, "term~2");
        this.assertWildcardQueryEquals("Term~", false, "Term~2");
        this.assertWildcardQueryEquals("[A TO C]", "[a TO c]");
        this.assertWildcardQueryEquals("[A TO C]", true, "[a TO c]");
        this.assertWildcardQueryEquals("[A TO C]", false, "[A TO C]");
        TestQPHelper.expectThrows(QueryNodeException.class, () -> this.assertWildcardQueryEquals("*Term", true, "*term"));
        TestQPHelper.expectThrows(QueryNodeException.class, () -> this.assertWildcardQueryEquals("?Term", true, "?term"));
        this.assertWildcardQueryEquals("*Term", true, "*term", true);
        this.assertWildcardQueryEquals("?Term", true, "?term", true);
    }

    public void testLeadingWildcardType() throws Exception {
        StandardQueryParser qp = this.getParser(null);
        qp.setAllowLeadingWildcard(true);
        TestQPHelper.assertEquals(WildcardQuery.class, qp.parse("t*erm*", "field").getClass());
        TestQPHelper.assertEquals(WildcardQuery.class, qp.parse("?term*", "field").getClass());
        TestQPHelper.assertEquals(WildcardQuery.class, qp.parse("*term*", "field").getClass());
    }

    public void testQPA() throws Exception {
        this.assertQueryEquals("term term^3.0 term", qpAnalyzer, "term (term)^3.0 term");
        this.assertQueryEquals("term stop^3.0 term", qpAnalyzer, "term term");
        this.assertQueryEquals("term term term", qpAnalyzer, "term term term");
        this.assertQueryEquals("term +stop term", qpAnalyzer, "term term");
        this.assertQueryEquals("term -stop term", qpAnalyzer, "term term");
        this.assertQueryEquals("drop AND (stop) AND roll", qpAnalyzer, "+drop +roll");
        this.assertQueryEquals("term +(stop) term", qpAnalyzer, "term term");
        this.assertQueryEquals("term -(stop) term", qpAnalyzer, "term term");
        this.assertQueryEquals("drop AND stop AND roll", qpAnalyzer, "+drop +roll");
        this.assertQueryEquals("term phrase term", qpAnalyzer, "term (phrase1 phrase2) term");
        this.assertQueryEquals("term AND NOT phrase term", qpAnalyzer, "+term -(phrase1 phrase2) term");
        this.assertMatchNoDocsQuery("stop^3", qpAnalyzer);
        this.assertMatchNoDocsQuery("stop", qpAnalyzer);
        this.assertMatchNoDocsQuery("(stop)^3", qpAnalyzer);
        this.assertMatchNoDocsQuery("((stop))^3", qpAnalyzer);
        this.assertMatchNoDocsQuery("(stop^3)", qpAnalyzer);
        this.assertMatchNoDocsQuery("((stop)^3)", qpAnalyzer);
        this.assertMatchNoDocsQuery("(stop)", qpAnalyzer);
        this.assertMatchNoDocsQuery("((stop))", qpAnalyzer);
        TestQPHelper.assertTrue((boolean)(this.getQuery("term term term", qpAnalyzer) instanceof BooleanQuery));
        TestQPHelper.assertTrue((boolean)(this.getQuery("term +stop", qpAnalyzer) instanceof TermQuery));
    }

    public void testRange() throws Exception {
        this.assertQueryEquals("[ a TO z]", null, "[a TO z]");
        TestQPHelper.assertEquals((Object)MultiTermQuery.CONSTANT_SCORE_REWRITE, (Object)((TermRangeQuery)this.getQuery("[ a TO z]", null)).getRewriteMethod());
        StandardQueryParser qp = new StandardQueryParser();
        qp.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
        TestQPHelper.assertEquals((Object)MultiTermQuery.SCORING_BOOLEAN_REWRITE, (Object)((TermRangeQuery)qp.parse("[ a TO z]", "field")).getRewriteMethod());
        this.assertQueryEquals("[ a TO * ]", null, "[a TO *]");
        this.assertQueryEquals("[ * TO z ]", null, "[* TO z]");
        this.assertQueryEquals("[ * TO * ]", null, "[* TO *]");
        this.assertQueryEquals("field>=a", null, "[a TO *]");
        this.assertQueryEquals("field>a", null, "{a TO *]");
        this.assertQueryEquals("field<=a", null, "[* TO a]");
        this.assertQueryEquals("field<a", null, "[* TO a}");
        this.assertQueryEquals("{ a TO z ]", null, "{a TO z]");
        this.assertQueryEquals("[ a TO z }", null, "[a TO z}");
        this.assertQueryEquals("{ a TO * ]", null, "{a TO *]");
        this.assertQueryEquals("[ * TO z }", null, "[* TO z}");
        this.assertQueryEquals("[ a TO z ]", null, "[a TO z]");
        this.assertQueryEquals("{ a TO z}", null, "{a TO z}");
        this.assertQueryEquals("{ a TO z }", null, "{a TO z}");
        this.assertQueryEquals("{ a TO z }^2.0", null, "({a TO z})^2.0");
        this.assertQueryEquals("[ a TO z] OR bar", null, "[a TO z] bar");
        this.assertQueryEquals("[ a TO z] AND bar", null, "+[a TO z] +bar");
        this.assertQueryEquals("( bar blar { a TO z}) ", null, "bar blar {a TO z}");
        this.assertQueryEquals("gack ( bar blar { a TO z}) ", null, "gack (bar blar {a TO z})");
    }

    private String getDate(String s, DateTools.Resolution resolution) throws Exception {
        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
        return this.getDate(df.parse(s), resolution);
    }

    private String getDate(Date d, DateTools.Resolution resolution) {
        return DateTools.dateToString((Date)d, (DateTools.Resolution)resolution);
    }

    private String escapeDateString(String s) {
        if (s.contains(" ")) {
            return "\"" + s + "\"";
        }
        return s;
    }

    private String getLocalizedDate(int year, int month, int day) {
        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        calendar.clear();
        calendar.set(year, month, day);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return df.format(calendar.getTime());
    }

    public void testDateRange() throws Exception {
        String startDate = this.getLocalizedDate(2002, 1, 1);
        String endDate = this.getLocalizedDate(2002, 1, 4);
        GregorianCalendar endDateExpected = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        endDateExpected.clear();
        endDateExpected.set(2002, 1, 4, 23, 59, 59);
        endDateExpected.set(14, 999);
        String defaultField = "default";
        String monthField = "month";
        String hourField = "hour";
        StandardQueryParser qp = new StandardQueryParser();
        HashMap<String, DateTools.Resolution> dateRes = new HashMap<String, DateTools.Resolution>();
        dateRes.put("month", DateTools.Resolution.MONTH);
        qp.setDateResolutionMap(dateRes);
        qp.setDateResolution(DateTools.Resolution.MILLISECOND);
        dateRes.put("hour", DateTools.Resolution.HOUR);
        qp.setDateResolutionMap(dateRes);
        this.assertDateRangeQueryEquals(qp, "default", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.MILLISECOND);
        this.assertDateRangeQueryEquals(qp, "month", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.MONTH);
        this.assertDateRangeQueryEquals(qp, "hour", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.HOUR);
    }

    public void assertDateRangeQueryEquals(StandardQueryParser qp, String field, String startDate, String endDate, Date endDateInclusive, DateTools.Resolution resolution) throws Exception {
        this.assertQueryEquals(qp, field, field + ":[" + this.escapeDateString(startDate) + " TO " + this.escapeDateString(endDate) + "]", "[" + this.getDate(startDate, resolution) + " TO " + this.getDate(endDateInclusive, resolution) + "]");
        this.assertQueryEquals(qp, field, field + ":{" + this.escapeDateString(startDate) + " TO " + this.escapeDateString(endDate) + "}", "{" + this.getDate(startDate, resolution) + " TO " + this.getDate(endDate, resolution) + "}");
    }

    public void testEscaped() throws Exception {
        MockAnalyzer a = new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false);
        this.assertQueryEquals("\\*", (Analyzer)a, "*");
        this.assertQueryEquals("\\a", (Analyzer)a, "a");
        this.assertQueryEquals("a\\-b:c", (Analyzer)a, "a-b:c");
        this.assertQueryEquals("a\\+b:c", (Analyzer)a, "a+b:c");
        this.assertQueryEquals("a\\:b:c", (Analyzer)a, "a:b:c");
        this.assertQueryEquals("a\\\\b:c", (Analyzer)a, "a\\b:c");
        this.assertQueryEquals("a:b\\-c", (Analyzer)a, "a:b-c");
        this.assertQueryEquals("a:b\\+c", (Analyzer)a, "a:b+c");
        this.assertQueryEquals("a:b\\:c", (Analyzer)a, "a:b:c");
        this.assertQueryEquals("a:b\\\\c", (Analyzer)a, "a:b\\c");
        this.assertQueryEquals("a:b\\-c*", (Analyzer)a, "a:b-c*");
        this.assertQueryEquals("a:b\\+c*", (Analyzer)a, "a:b+c*");
        this.assertQueryEquals("a:b\\:c*", (Analyzer)a, "a:b:c*");
        this.assertQueryEquals("a:b\\\\c*", (Analyzer)a, "a:b\\c*");
        this.assertQueryEquals("a:b\\-?c", (Analyzer)a, "a:b-?c");
        this.assertQueryEquals("a:b\\+?c", (Analyzer)a, "a:b+?c");
        this.assertQueryEquals("a:b\\:?c", (Analyzer)a, "a:b:?c");
        this.assertQueryEquals("a:b\\\\?c", (Analyzer)a, "a:b\\?c");
        this.assertQueryEquals("a:b\\-c~", (Analyzer)a, "a:b-c~2");
        this.assertQueryEquals("a:b\\+c~", (Analyzer)a, "a:b+c~2");
        this.assertQueryEquals("a:b\\:c~", (Analyzer)a, "a:b:c~2");
        this.assertQueryEquals("a:b\\\\c~", (Analyzer)a, "a:b\\c~2");
        this.assertQueryEquals("[ a\\- TO a\\+ ]", null, "[a- TO a+]");
        this.assertQueryEquals("[ a\\: TO a\\~ ]", null, "[a: TO a~]");
        this.assertQueryEquals("[ a\\\\ TO a\\* ]", null, "[a\\ TO a*]");
        this.assertQueryEquals("[\"c\\:\\\\temp\\\\\\~foo0.txt\" TO \"c\\:\\\\temp\\\\\\~foo9.txt\"]", (Analyzer)a, "[c:\\temp\\~foo0.txt TO c:\\temp\\~foo9.txt]");
        this.assertQueryEquals("a\\\\\\+b", (Analyzer)a, "a\\+b");
        this.assertQueryEquals("a \\\"b c\\\" d", (Analyzer)a, "a \"b c\" d");
        this.assertQueryEquals("\"a \\\"b c\\\" d\"", (Analyzer)a, "\"a \"b c\" d\"");
        this.assertQueryEquals("\"a \\+b c d\"", (Analyzer)a, "\"a +b c d\"");
        this.assertQueryEquals("c\\:\\\\temp\\\\\\~foo.txt", (Analyzer)a, "c:\\temp\\~foo.txt");
        this.assertQueryNodeException("XY\\");
        this.assertQueryEquals("a\\u0062c", (Analyzer)a, "abc");
        this.assertQueryEquals("XY\\u005a", (Analyzer)a, "XYZ");
        this.assertQueryEquals("XY\\u005A", (Analyzer)a, "XYZ");
        this.assertQueryEquals("\"a \\\\\\u0028\\u0062\\\" c\"", (Analyzer)a, "\"a \\(b\" c\"");
        this.assertQueryNodeException("XY\\u005G");
        this.assertQueryNodeException("XY\\u005");
        this.assertQueryEquals("(item:\\\\ item:ABCD\\\\)", (Analyzer)a, "item:\\ item:ABCD\\");
        this.assertQueryNodeException("(item:\\\\ item:ABCD\\\\))");
        this.assertQueryEquals("\\*", (Analyzer)a, "*");
        this.assertQueryEquals("\\\\", (Analyzer)a, "\\");
        this.assertQueryNodeException("\\");
        this.assertQueryEquals("(\"a\\\\\") or (\"b\")", (Analyzer)a, "a\\ or b");
    }

    public void testQueryStringEscaping() throws Exception {
        MockAnalyzer a = new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false);
        this.assertEscapedQueryEquals("a-b:c", (Analyzer)a, "a\\-b\\:c");
        this.assertEscapedQueryEquals("a+b:c", (Analyzer)a, "a\\+b\\:c");
        this.assertEscapedQueryEquals("a:b:c", (Analyzer)a, "a\\:b\\:c");
        this.assertEscapedQueryEquals("a\\b:c", (Analyzer)a, "a\\\\b\\:c");
        this.assertEscapedQueryEquals("a:b-c", (Analyzer)a, "a\\:b\\-c");
        this.assertEscapedQueryEquals("a:b+c", (Analyzer)a, "a\\:b\\+c");
        this.assertEscapedQueryEquals("a:b:c", (Analyzer)a, "a\\:b\\:c");
        this.assertEscapedQueryEquals("a:b\\c", (Analyzer)a, "a\\:b\\\\c");
        this.assertEscapedQueryEquals("a:b-c*", (Analyzer)a, "a\\:b\\-c\\*");
        this.assertEscapedQueryEquals("a:b+c*", (Analyzer)a, "a\\:b\\+c\\*");
        this.assertEscapedQueryEquals("a:b:c*", (Analyzer)a, "a\\:b\\:c\\*");
        this.assertEscapedQueryEquals("a:b\\\\c*", (Analyzer)a, "a\\:b\\\\\\\\c\\*");
        this.assertEscapedQueryEquals("a:b-?c", (Analyzer)a, "a\\:b\\-\\?c");
        this.assertEscapedQueryEquals("a:b+?c", (Analyzer)a, "a\\:b\\+\\?c");
        this.assertEscapedQueryEquals("a:b:?c", (Analyzer)a, "a\\:b\\:\\?c");
        this.assertEscapedQueryEquals("a:b?c", (Analyzer)a, "a\\:b\\?c");
        this.assertEscapedQueryEquals("a:b-c~", (Analyzer)a, "a\\:b\\-c\\~");
        this.assertEscapedQueryEquals("a:b+c~", (Analyzer)a, "a\\:b\\+c\\~");
        this.assertEscapedQueryEquals("a:b:c~", (Analyzer)a, "a\\:b\\:c\\~");
        this.assertEscapedQueryEquals("a:b\\c~", (Analyzer)a, "a\\:b\\\\c\\~");
        this.assertEscapedQueryEquals("[ a - TO a+ ]", null, "\\[ a \\- TO a\\+ \\]");
        this.assertEscapedQueryEquals("[ a : TO a~ ]", null, "\\[ a \\: TO a\\~ \\]");
        this.assertEscapedQueryEquals("[ a\\ TO a* ]", null, "\\[ a\\\\ TO a\\* \\]");
        this.assertEscapedQueryEquals("|| abc ||", (Analyzer)a, "\\|\\| abc \\|\\|");
        this.assertEscapedQueryEquals("&& abc &&", (Analyzer)a, "\\&\\& abc \\&\\&");
    }

    @Ignore(value="flexible queryparser shouldn't escape wildcard terms")
    public void testEscapedWildcard() throws Exception {
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false));
        WildcardQuery q = new WildcardQuery(new Term("field", "foo\\?ba?r"));
        TestQPHelper.assertEquals((Object)q, (Object)qp.parse("foo\\?ba?r", "field"));
    }

    public void testTabNewlineCarriageReturn() throws Exception {
        this.assertQueryEqualsDOA("+weltbank +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\r+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\r\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r\n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r \n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\t+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \t+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \t +worlbank", null, "+weltbank +worlbank");
    }

    public void testSimpleDAO() throws Exception {
        this.assertQueryEqualsDOA("term term term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term +term term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term term +term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term +term +term", null, "+term +term +term");
        this.assertQueryEqualsDOA("-term term term", null, "-term +term +term");
    }

    public void testBoost() throws Exception {
        CharacterRunAutomaton stopSet = new CharacterRunAutomaton(Automata.makeString((String)"on"));
        MockAnalyzer oneStopAnalyzer = new MockAnalyzer(TestQPHelper.random(), MockTokenizer.SIMPLE, true, stopSet);
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer((Analyzer)oneStopAnalyzer);
        Query q = qp.parse("on^1.0", "field");
        TestQPHelper.assertNotNull((Object)q);
        q = qp.parse("\"hello\"^2.0", "field");
        TestQPHelper.assertNotNull((Object)q);
        TestQPHelper.assertEquals((double)((BoostQuery)q).getBoost(), (double)2.0, (double)0.5);
        q = qp.parse("hello^2.0", "field");
        TestQPHelper.assertNotNull((Object)q);
        TestQPHelper.assertEquals((double)((BoostQuery)q).getBoost(), (double)2.0, (double)0.5);
        q = qp.parse("\"on\"^1.0", "field");
        TestQPHelper.assertNotNull((Object)q);
        StandardQueryParser qp2 = new StandardQueryParser();
        qp2.setAnalyzer((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.SIMPLE, true, MockTokenFilter.ENGLISH_STOPSET));
        q = qp2.parse("the^3", "field");
        TestQPHelper.assertNotNull((Object)q);
        this.assertMatchNoDocsQuery(q);
        TestQPHelper.assertFalse((boolean)(q instanceof BoostQuery));
    }

    public void assertQueryNodeException(String queryString) throws Exception {
        TestQPHelper.expectThrows(QueryNodeException.class, () -> this.getQuery(queryString, null));
    }

    public void testException() throws Exception {
        this.assertQueryNodeException("*leadingWildcard");
        this.assertQueryNodeException("\"some phrase");
        this.assertQueryNodeException("(foo bar");
        this.assertQueryNodeException("foo bar))");
        this.assertQueryNodeException("field:term:with:colon some more terms");
        this.assertQueryNodeException("(sub query)^5.0^2.0 plus more");
        this.assertQueryNodeException("secret AND illegal) AND access:confidential");
    }

    public void testCustomQueryParserWildcard() {
        TestQPHelper.expectThrows(QueryNodeException.class, () -> new QPTestParser((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false)).parse("a?t", "contents"));
    }

    public void testCustomQueryParserFuzzy() throws Exception {
        TestQPHelper.expectThrows(QueryNodeException.class, () -> new QPTestParser((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false)).parse("xunit~", "contents"));
    }

    public void testBooleanQuery() throws Exception {
        BooleanQuery.setMaxClauseCount((int)2);
        TestQPHelper.expectThrows(QueryNodeException.class, () -> {
            StandardQueryParser qp = new StandardQueryParser();
            qp.setAnalyzer((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false));
            qp.parse("one two three", "field");
        });
    }

    public void testPrecedence() throws Exception {
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false));
        Query query1 = qp.parse("A AND B OR C AND D", "field");
        Query query2 = qp.parse("+A +B +C +D", "field");
        TestQPHelper.assertEquals((Object)query1, (Object)query2);
    }

    public void testStarParsing() throws Exception {
    }

    public void testRegexps() throws Exception {
        StandardQueryParser qp = new StandardQueryParser();
        String df = "field";
        RegexpQuery q = new RegexpQuery(new Term("field", "[a-z][123]"));
        TestQPHelper.assertEquals((Object)q, (Object)qp.parse("/[a-z][123]/", "field"));
        qp.setLowercaseExpandedTerms(true);
        TestQPHelper.assertEquals((Object)q, (Object)qp.parse("/[A-Z][123]/", "field"));
        TestQPHelper.assertEquals((Object)new BoostQuery((Query)q, 0.5f), (Object)qp.parse("/[A-Z][123]/^0.5", "field"));
        qp.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
        q.setRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
        TestQPHelper.assertEquals((Object)new BoostQuery((Query)q, 0.5f), (Object)qp.parse("/[A-Z][123]/^0.5", "field"));
        TestQPHelper.assertEquals((Object)MultiTermQuery.SCORING_BOOLEAN_REWRITE, (Object)((RegexpQuery)((BoostQuery)qp.parse("/[A-Z][123]/^0.5", "field")).getQuery()).getRewriteMethod());
        qp.setMultiTermRewriteMethod(MultiTermQuery.CONSTANT_SCORE_REWRITE);
        RegexpQuery escaped = new RegexpQuery(new Term("field", "[a-z]\\/[123]"));
        TestQPHelper.assertEquals((Object)escaped, (Object)qp.parse("/[a-z]\\/[123]/", "field"));
        RegexpQuery escaped2 = new RegexpQuery(new Term("field", "[a-z]\\*[123]"));
        TestQPHelper.assertEquals((Object)escaped2, (Object)qp.parse("/[a-z]\\*[123]/", "field"));
        BooleanQuery.Builder complex = new BooleanQuery.Builder();
        complex.add((Query)new RegexpQuery(new Term("field", "[a-z]\\/[123]")), BooleanClause.Occur.MUST);
        complex.add((Query)new TermQuery(new Term("path", "/etc/init.d/")), BooleanClause.Occur.MUST);
        complex.add((Query)new TermQuery(new Term("field", "/etc/init[.]d/lucene/")), BooleanClause.Occur.SHOULD);
        TestQPHelper.assertEquals((Object)complex.build(), (Object)qp.parse("/[a-z]\\/[123]/ AND path:\"/etc/init.d/\" OR \"/etc\\/init\\[.\\]d/lucene/\" ", "field"));
        RegexpQuery re = new RegexpQuery(new Term("field", "http.*"));
        TestQPHelper.assertEquals((Object)re, (Object)qp.parse("field:/http.*/", "field"));
        TestQPHelper.assertEquals((Object)re, (Object)qp.parse("/http.*/", "field"));
        re = new RegexpQuery(new Term("field", "http~0.5"));
        TestQPHelper.assertEquals((Object)re, (Object)qp.parse("field:/http~0.5/", "field"));
        TestQPHelper.assertEquals((Object)re, (Object)qp.parse("/http~0.5/", "field"));
        re = new RegexpQuery(new Term("field", "boo"));
        TestQPHelper.assertEquals((Object)re, (Object)qp.parse("field:/boo/", "field"));
        TestQPHelper.assertEquals((Object)re, (Object)qp.parse("/boo/", "field"));
        TestQPHelper.assertEquals((Object)new TermQuery(new Term("field", "/boo/")), (Object)qp.parse("\"/boo/\"", "field"));
        TestQPHelper.assertEquals((Object)new TermQuery(new Term("field", "/boo/")), (Object)qp.parse("\\/boo\\/", "field"));
        BooleanQuery.Builder two = new BooleanQuery.Builder();
        two.add((Query)new RegexpQuery(new Term("field", "foo")), BooleanClause.Occur.SHOULD);
        two.add((Query)new RegexpQuery(new Term("field", "bar")), BooleanClause.Occur.SHOULD);
        TestQPHelper.assertEquals((Object)two.build(), (Object)qp.parse("field:/foo/ field:/bar/", "field"));
        TestQPHelper.assertEquals((Object)two.build(), (Object)qp.parse("/foo/ /bar/", "field"));
    }

    public void testStopwords() throws Exception {
        StandardQueryParser qp = new StandardQueryParser();
        CharacterRunAutomaton stopSet = new CharacterRunAutomaton(new RegExp("the|foo").toAutomaton());
        qp.setAnalyzer((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.SIMPLE, true, stopSet));
        Query result = qp.parse("a:the OR a:foo", "a");
        TestQPHelper.assertNotNull((String)"result is null and it shouldn't be", (Object)result);
        TestQPHelper.assertTrue((String)"result is not a MatchNoDocsQuery", (boolean)(result instanceof MatchNoDocsQuery));
        result = qp.parse("a:woo OR a:the", "a");
        TestQPHelper.assertNotNull((String)"result is null and it shouldn't be", (Object)result);
        TestQPHelper.assertTrue((String)"result is not a TermQuery", (boolean)(result instanceof TermQuery));
        result = qp.parse("(fieldX:xxxxx OR fieldy:xxxxxxxx)^2 AND (fieldx:the OR fieldy:foo)", "a");
        BooleanQuery expected = new BooleanQuery.Builder().add((Query)new TermQuery(new Term("fieldX", "xxxxx")), BooleanClause.Occur.SHOULD).add((Query)new TermQuery(new Term("fieldy", "xxxxxxxx")), BooleanClause.Occur.SHOULD).build();
        expected = new BoostQuery((Query)expected, 2.0f);
        TestQPHelper.assertEquals((Object)expected, (Object)result);
    }

    public void testPositionIncrement() throws Exception {
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.SIMPLE, true, MockTokenFilter.ENGLISH_STOPSET));
        qp.setEnablePositionIncrements(true);
        String qtxt = "\"the words in poisitions pos02578 are stopped in this phrasequery\"";
        int[] expectedPositions = new int[]{1, 3, 4, 6, 9};
        PhraseQuery pq = (PhraseQuery)qp.parse(qtxt, "a");
        Term[] t = pq.getTerms();
        int[] pos = pq.getPositions();
        for (int i = 0; i < t.length; ++i) {
            TestQPHelper.assertEquals((String)("term " + i + " = " + t[i] + " has wrong term-position!"), (long)expectedPositions[i], (long)pos[i]);
        }
    }

    public void testMatchAllDocs() throws Exception {
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false));
        TestQPHelper.assertEquals((Object)new MatchAllDocsQuery(), (Object)qp.parse("*:*", "field"));
        TestQPHelper.assertEquals((Object)new MatchAllDocsQuery(), (Object)qp.parse("(*:*)", "field"));
        BooleanQuery bq = (BooleanQuery)qp.parse("+*:* -*:*", "field");
        for (BooleanClause c : bq) {
            TestQPHelper.assertTrue((c.getQuery().getClass() == MatchAllDocsQuery.class ? 1 : 0) != 0);
        }
    }

    private void assertHits(int expected, String query, IndexSearcher is) throws IOException, QueryNodeException {
        StandardQueryParser qp = new StandardQueryParser();
        qp.setAnalyzer((Analyzer)new MockAnalyzer(TestQPHelper.random(), MockTokenizer.WHITESPACE, false));
        qp.setLocale(Locale.ENGLISH);
        Query q = qp.parse(query, "date");
        ScoreDoc[] hits = is.search((Query)q, (int)1000).scoreDocs;
        TestQPHelper.assertEquals((long)expected, (long)hits.length);
    }

    public void tearDown() throws Exception {
        BooleanQuery.setMaxClauseCount((int)this.originalMaxClauses);
        super.tearDown();
    }

    public void testMultiPhraseQuery() throws Exception {
        BaseDirectoryWrapper dir = TestQPHelper.newDirectory();
        IndexWriter w = new IndexWriter((Directory)dir, TestQPHelper.newIndexWriterConfig((Analyzer)new CannedAnalyzer()));
        Document doc = new Document();
        doc.add((IndexableField)TestQPHelper.newTextField((String)"field", (String)"", (Field.Store)Field.Store.NO));
        w.addDocument((Iterable)doc);
        DirectoryReader r = DirectoryReader.open((IndexWriter)w);
        IndexSearcher s = TestQPHelper.newSearcher((IndexReader)r);
        Query q = new StandardQueryParser((Analyzer)new CannedAnalyzer()).parse("\"a\"", "field");
        TestQPHelper.assertTrue((boolean)(q instanceof MultiPhraseQuery));
        TestQPHelper.assertEquals((long)1L, (long)s.search((Query)q, (int)10).totalHits);
        r.close();
        w.close();
        dir.close();
    }

    public void testRegexQueryParsing() throws Exception {
        CharSequence[] fields = new String[]{"b", "t"};
        StandardQueryParser parser = new StandardQueryParser();
        parser.setMultiFields(fields);
        parser.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
        parser.setAnalyzer((Analyzer)new MockAnalyzer(TestQPHelper.random()));
        BooleanQuery.Builder exp = new BooleanQuery.Builder();
        exp.add(new BooleanClause((Query)new RegexpQuery(new Term("b", "ab.+")), BooleanClause.Occur.SHOULD));
        exp.add(new BooleanClause((Query)new RegexpQuery(new Term("t", "ab.+")), BooleanClause.Occur.SHOULD));
        TestQPHelper.assertEquals((Object)exp.build(), (Object)parser.parse("/ab.+/", null));
        RegexpQuery regexpQueryexp = new RegexpQuery(new Term("test", "[abc]?[0-9]"));
        TestQPHelper.assertEquals((Object)regexpQueryexp, (Object)parser.parse("test:/[abc]?[0-9]/", null));
    }

    private static class CannedAnalyzer
    extends Analyzer {
        private CannedAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String ignored) {
            return new Analyzer.TokenStreamComponents((Tokenizer)new CannedTokenizer());
        }
    }

    private static class CannedTokenizer
    extends Tokenizer {
        private int upto = 0;
        private final PositionIncrementAttribute posIncr = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private final CharTermAttribute term = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

        public boolean incrementToken() {
            this.clearAttributes();
            if (this.upto == 4) {
                return false;
            }
            if (this.upto == 0) {
                this.posIncr.setPositionIncrement(1);
                this.term.setEmpty().append("a");
            } else if (this.upto == 1) {
                this.posIncr.setPositionIncrement(1);
                this.term.setEmpty().append("b");
            } else if (this.upto == 2) {
                this.posIncr.setPositionIncrement(0);
                this.term.setEmpty().append("c");
            } else {
                this.posIncr.setPositionIncrement(0);
                this.term.setEmpty().append("d");
            }
            ++this.upto;
            return true;
        }

        public void reset() throws IOException {
            super.reset();
            this.upto = 0;
        }
    }

    private static class SimpleCJKAnalyzer
    extends Analyzer {
        private SimpleCJKAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            return new Analyzer.TokenStreamComponents((Tokenizer)new SimpleCJKTokenizer());
        }
    }

    private static class SimpleCJKTokenizer
    extends Tokenizer {
        private CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

        public boolean incrementToken() throws IOException {
            int ch = this.input.read();
            if (ch < 0) {
                return false;
            }
            this.clearAttributes();
            this.termAtt.setEmpty().append((char)ch);
            return true;
        }
    }

    public static class QPTestParser
    extends StandardQueryParser {
        public QPTestParser(Analyzer a) {
            ((QueryNodeProcessorPipeline)this.getQueryNodeProcessor()).add((QueryNodeProcessor)new QPTestParserQueryNodeProcessor());
            this.setAnalyzer(a);
        }

        private static class QPTestParserQueryNodeProcessor
        extends QueryNodeProcessorImpl {
            private QPTestParserQueryNodeProcessor() {
            }

            protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
                return node;
            }

            protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
                if (node instanceof WildcardQueryNode || node instanceof FuzzyQueryNode) {
                    throw new QueryNodeException((Message)new MessageImpl(QueryParserMessages.EMPTY_MESSAGE));
                }
                return node;
            }

            protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
                return children;
            }
        }
    }

    public static final class QPTestAnalyzer
    extends Analyzer {
        public final Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new QPTestFilter((TokenStream)tokenizer));
        }
    }

    public static final class QPTestFilter
    extends TokenFilter {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private boolean inPhrase = false;
        private int savedStart = 0;
        private int savedEnd = 0;

        public QPTestFilter(TokenStream in) {
            super(in);
        }

        public boolean incrementToken() throws IOException {
            if (this.inPhrase) {
                this.inPhrase = false;
                this.clearAttributes();
                this.termAtt.setEmpty().append("phrase2");
                this.offsetAtt.setOffset(this.savedStart, this.savedEnd);
                return true;
            }
            while (this.input.incrementToken()) {
                if (this.termAtt.toString().equals("phrase")) {
                    this.inPhrase = true;
                    this.savedStart = this.offsetAtt.startOffset();
                    this.savedEnd = this.offsetAtt.endOffset();
                    this.termAtt.setEmpty().append("phrase1");
                    this.offsetAtt.setOffset(this.savedStart, this.savedEnd);
                    return true;
                }
                if (this.termAtt.toString().equals("stop")) continue;
                return true;
            }
            return false;
        }

        public void reset() throws IOException {
            super.reset();
            this.inPhrase = false;
            this.savedStart = 0;
            this.savedEnd = 0;
        }
    }
}

