/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.CommonQueryParserConfiguration;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryparser.util.QueryParserTestBase;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class TestStandardQP
extends QueryParserTestBase {
    public StandardQueryParser getParser(Analyzer a) throws Exception {
        if (a == null) {
            a = new MockAnalyzer(TestStandardQP.random(), MockTokenizer.SIMPLE, true);
        }
        StandardQueryParser qp = new StandardQueryParser(a);
        qp.setDefaultOperator(StandardQueryConfigHandler.Operator.OR);
        return qp;
    }

    public Query parse(String query, StandardQueryParser qp) throws Exception {
        return qp.parse(query, this.getDefaultField());
    }

    @Override
    public CommonQueryParserConfiguration getParserConfig(Analyzer a) throws Exception {
        return this.getParser(a);
    }

    @Override
    public Query getQuery(String query, CommonQueryParserConfiguration cqpC) throws Exception {
        assert (cqpC != null) : "Parameter must not be null";
        assert (cqpC instanceof StandardQueryParser) : "Parameter must be instance of StandardQueryParser";
        StandardQueryParser qp = (StandardQueryParser)cqpC;
        return this.parse(query, qp);
    }

    @Override
    public Query getQuery(String query, Analyzer a) throws Exception {
        return this.parse(query, this.getParser(a));
    }

    @Override
    public boolean isQueryParserException(Exception exception) {
        return exception instanceof QueryNodeException;
    }

    @Override
    public void setDefaultOperatorOR(CommonQueryParserConfiguration cqpC) {
        assert (cqpC instanceof StandardQueryParser);
        StandardQueryParser qp = (StandardQueryParser)cqpC;
        qp.setDefaultOperator(StandardQueryConfigHandler.Operator.OR);
    }

    @Override
    public void setDefaultOperatorAND(CommonQueryParserConfiguration cqpC) {
        assert (cqpC instanceof StandardQueryParser);
        StandardQueryParser qp = (StandardQueryParser)cqpC;
        qp.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
    }

    @Override
    public void setAnalyzeRangeTerms(CommonQueryParserConfiguration cqpC, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAutoGeneratePhraseQueries(CommonQueryParserConfiguration cqpC, boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDateResolution(CommonQueryParserConfiguration cqpC, CharSequence field, DateTools.Resolution value) {
        assert (cqpC instanceof StandardQueryParser);
        StandardQueryParser qp = (StandardQueryParser)cqpC;
        qp.getDateResolutionMap().put(field, value);
    }

    @Override
    public void testOperatorVsWhitespace() throws Exception {
        Analyzer a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer(MockTokenizer.WHITESPACE, false));
            }
        };
        this.assertQueryEquals("a - b", a, "a -b");
        this.assertQueryEquals("a + b", a, "a +b");
        this.assertQueryEquals("a ! b", a, "a -b");
    }

    @Override
    public void testRangeWithPhrase() throws Exception {
        this.assertQueryEquals("[\\* TO \"*\"]", null, "[\\* TO *]");
    }

    @Override
    public void testEscapedVsQuestionMarkAsWildcard() throws Exception {
        MockAnalyzer a = new MockAnalyzer(TestStandardQP.random(), MockTokenizer.WHITESPACE, false);
        this.assertQueryEquals("a:b\\-?c", (Analyzer)a, "a:b-?c");
        this.assertQueryEquals("a:b\\+?c", (Analyzer)a, "a:b+?c");
        this.assertQueryEquals("a:b\\:?c", (Analyzer)a, "a:b:?c");
        this.assertQueryEquals("a:b\\\\?c", (Analyzer)a, "a:b\\?c");
    }

    @Override
    public void testEscapedWildcard() throws Exception {
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(TestStandardQP.random(), MockTokenizer.WHITESPACE, false));
        WildcardQuery q = new WildcardQuery(new Term("field", "foo?ba?r"));
        TestStandardQP.assertEquals((Object)q, (Object)this.getQuery("foo\\?ba?r", qp));
    }

    @Override
    public void testCollatedRange() throws Exception {
        TestStandardQP.expectThrows(UnsupportedOperationException.class, () -> {
            this.setAnalyzeRangeTerms((CommonQueryParserConfiguration)this.getParser(null), true);
            super.testCollatedRange();
        });
    }

    @Override
    public void testAutoGeneratePhraseQueriesOn() throws Exception {
        TestStandardQP.expectThrows(UnsupportedOperationException.class, () -> {
            this.setAutoGeneratePhraseQueries((CommonQueryParserConfiguration)this.getParser(null), true);
            super.testAutoGeneratePhraseQueriesOn();
        });
    }

    @Override
    public void testStarParsing() throws Exception {
    }

    @Override
    public void testDefaultOperator() throws Exception {
        StandardQueryParser qp = this.getParser((Analyzer)new MockAnalyzer(TestStandardQP.random()));
        TestStandardQP.assertEquals((Object)StandardQueryConfigHandler.Operator.OR, (Object)qp.getDefaultOperator());
        this.setDefaultOperatorAND((CommonQueryParserConfiguration)qp);
        TestStandardQP.assertEquals((Object)StandardQueryConfigHandler.Operator.AND, (Object)qp.getDefaultOperator());
        this.setDefaultOperatorOR((CommonQueryParserConfiguration)qp);
        TestStandardQP.assertEquals((Object)StandardQueryConfigHandler.Operator.OR, (Object)qp.getDefaultOperator());
    }

    @Override
    public void testNewFieldQuery() throws Exception {
        StandardQueryParser dumb = this.getParser(new QueryParserTestBase.Analyzer1());
        BooleanQuery.Builder expanded = new BooleanQuery.Builder();
        expanded.setDisableCoord(true);
        expanded.add((Query)new TermQuery(new Term("field", "dogs")), BooleanClause.Occur.SHOULD);
        expanded.add((Query)new TermQuery(new Term("field", "dog")), BooleanClause.Occur.SHOULD);
        TestStandardQP.assertEquals((Object)expanded.build(), (Object)dumb.parse("\"dogs\"", "field"));
        TestStandardQP.assertEquals((Object)expanded.build(), (Object)dumb.parse("dogs", "field"));
    }

    @Override
    public void testQPA() throws Exception {
        super.testQPA();
        this.assertQueryEquals("term phrase term", qpAnalyzer, "term (phrase1 phrase2) term");
        CommonQueryParserConfiguration cqpc = this.getParserConfig(qpAnalyzer);
        this.setDefaultOperatorAND(cqpc);
        this.assertQueryEquals(cqpc, "field", "term phrase term", "+term +(+phrase1 +phrase2) +term");
    }
}

