/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.simple;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.TestUtil;

public class TestSimpleQueryParser
extends LuceneTestCase {
    private Query parse(String text) {
        MockAnalyzer analyzer = new MockAnalyzer(TestSimpleQueryParser.random());
        SimpleQueryParser parser = new SimpleQueryParser((Analyzer)analyzer, "field");
        parser.setDefaultOperator(BooleanClause.Occur.MUST);
        return parser.parse(text);
    }

    private Query parse(String text, int flags) {
        MockAnalyzer analyzer = new MockAnalyzer(TestSimpleQueryParser.random());
        SimpleQueryParser parser = new SimpleQueryParser((Analyzer)analyzer, Collections.singletonMap("field", Float.valueOf(1.0f)), flags);
        parser.setDefaultOperator(BooleanClause.Occur.MUST);
        return parser.parse(text);
    }

    public void testTerm() throws Exception {
        TermQuery expected = new TermQuery(new Term("field", "foobar"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("foobar"));
    }

    public void testFuzzy() throws Exception {
        TermQuery regular = new TermQuery(new Term("field", "foobar"));
        FuzzyQuery expected = new FuzzyQuery(new Term("field", "foobar"), 2);
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("foobar~2"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("foobar~"));
        TestSimpleQueryParser.assertEquals((Object)regular, (Object)this.parse("foobar~a"));
        TestSimpleQueryParser.assertEquals((Object)regular, (Object)this.parse("foobar~1a"));
        BooleanQuery.Builder bool = new BooleanQuery.Builder();
        FuzzyQuery fuzzy = new FuzzyQuery(new Term("field", "foo"), 2);
        bool.add((Query)fuzzy, BooleanClause.Occur.MUST);
        bool.add((Query)new TermQuery(new Term("field", "bar")), BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)bool.build(), (Object)this.parse("foo~21 bar"));
    }

    public void testPhrase() throws Exception {
        PhraseQuery expected = new PhraseQuery("field", new String[]{"foo", "bar"});
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\"foo bar\""));
    }

    public void testPhraseWithSlop() throws Exception {
        PhraseQuery expectedWithSlop = new PhraseQuery(2, "field", new String[]{"foo", "bar"});
        TestSimpleQueryParser.assertEquals((Object)expectedWithSlop, (Object)this.parse("\"foo bar\"~2"));
        PhraseQuery expectedWithMultiDigitSlop = new PhraseQuery(10, "field", new String[]{"foo", "bar"});
        TestSimpleQueryParser.assertEquals((Object)expectedWithMultiDigitSlop, (Object)this.parse("\"foo bar\"~10"));
        PhraseQuery expectedNoSlop = new PhraseQuery("field", new String[]{"foo", "bar"});
        TestSimpleQueryParser.assertEquals((String)"Ignore trailing tilde with no slop", (Object)expectedNoSlop, (Object)this.parse("\"foo bar\"~"));
        TestSimpleQueryParser.assertEquals((String)"Ignore non-numeric trailing slop", (Object)expectedNoSlop, (Object)this.parse("\"foo bar\"~a"));
        TestSimpleQueryParser.assertEquals((String)"Ignore non-numeric trailing slop", (Object)expectedNoSlop, (Object)this.parse("\"foo bar\"~1a"));
        TestSimpleQueryParser.assertEquals((String)"Ignore negative trailing slop", (Object)expectedNoSlop, (Object)this.parse("\"foo bar\"~-1"));
        PhraseQuery pq = new PhraseQuery(12, "field", new String[]{"foo", "bar"});
        BooleanQuery.Builder expectedBoolean = new BooleanQuery.Builder();
        expectedBoolean.add((Query)pq, BooleanClause.Occur.MUST);
        expectedBoolean.add((Query)new TermQuery(new Term("field", "baz")), BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)expectedBoolean.build(), (Object)this.parse("\"foo bar\"~12 baz"));
    }

    public void testPrefix() throws Exception {
        PrefixQuery expected = new PrefixQuery(new Term("field", "foobar"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("foobar*"));
    }

    public void testAND() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "foo")), BooleanClause.Occur.MUST);
        expected.add((Query)new TermQuery(new Term("field", "bar")), BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("foo+bar"));
    }

    public void testANDPhrase() throws Exception {
        PhraseQuery phrase1 = new PhraseQuery("field", new String[]{"foo", "bar"});
        PhraseQuery phrase2 = new PhraseQuery("field", new String[]{"star", "wars"});
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)phrase1, BooleanClause.Occur.MUST);
        expected.add((Query)phrase2, BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("\"foo bar\"+\"star wars\""));
    }

    public void testANDImplicit() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "foo")), BooleanClause.Occur.MUST);
        expected.add((Query)new TermQuery(new Term("field", "bar")), BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("foo bar"));
    }

    public void testOR() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "foo")), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "bar")), BooleanClause.Occur.SHOULD);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("foo|bar"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("foo||bar"));
    }

    public void testORImplicit() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "foo")), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "bar")), BooleanClause.Occur.SHOULD);
        SimpleQueryParser parser = new SimpleQueryParser((Analyzer)new MockAnalyzer(TestSimpleQueryParser.random()), "field");
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)parser.parse("foo bar"));
    }

    public void testORPhrase() throws Exception {
        PhraseQuery phrase1 = new PhraseQuery("field", new String[]{"foo", "bar"});
        PhraseQuery phrase2 = new PhraseQuery("field", new String[]{"star", "wars"});
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)phrase1, BooleanClause.Occur.SHOULD);
        expected.add((Query)phrase2, BooleanClause.Occur.SHOULD);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("\"foo bar\"|\"star wars\""));
    }

    public void testNOT() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "foo")), BooleanClause.Occur.MUST_NOT);
        expected.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("-foo"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("-(foo)"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("---foo"));
    }

    public void testCrazyPrefixes1() throws Exception {
        PrefixQuery expected = new PrefixQuery(new Term("field", "st*ar"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("st*ar*"));
    }

    public void testCrazyPrefixes2() throws Exception {
        PrefixQuery expected = new PrefixQuery(new Term("field", "st*ar\\*"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("st*ar\\\\**"));
    }

    public void testTermInDisguise() throws Exception {
        TermQuery expected = new TermQuery(new Term("field", "st*ar\\*"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("sT*Ar\\\\\\*"));
    }

    public void testGarbageTerm() throws Exception {
        TermQuery expected = new TermQuery(new Term("field", "star"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("star"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("star\n"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("star\r"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("star\t"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("star("));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("star)"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("star\""));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\t \r\n\nstar   \n \r \t "));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("- + \"\" - star \\"));
    }

    public void testGarbageEmpty() throws Exception {
        MatchNoDocsQuery expected = new MatchNoDocsQuery();
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse(""));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("  "));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("  "));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\\ "));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\\ \\ "));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\"\""));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\" \""));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\" \"|\" \""));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("(\" \"|\" \")"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\" \" \" \""));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("(\" \" \" \")"));
    }

    public void testGarbageAND() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.MUST);
        expected.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star wars"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star+wars"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("     star     wars   "));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("     star +    wars   "));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("  |     star + + |   wars   "));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("  |     star + + |   wars   \\"));
    }

    public void testGarbageOR() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.SHOULD);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star|wars"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("     star |    wars   "));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("  |     star | + |   wars   "));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("  +     star | + +   wars   \\"));
    }

    public void testGarbageNOT() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.MUST_NOT);
        expected.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("-star"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("---star"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("- -star -"));
    }

    public void testGarbagePhrase() throws Exception {
        PhraseQuery expected = new PhraseQuery("field", new String[]{"star", "wars"});
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\"star wars\""));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\"star wars\\ \""));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("\"\" | \"star wars\""));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("          \"star wars\"        \"\"\\"));
    }

    public void testGarbageSubquery() throws Exception {
        TermQuery expected = new TermQuery(new Term("field", "star"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("(star)"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("(star))"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("((star)"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("     -()(star)        \n\n\r     "));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parse("| + - ( + - |      star    \n      ) \n"));
    }

    public void testCompoundAnd() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.MUST);
        expected.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.MUST);
        expected.add((Query)new TermQuery(new Term("field", "empire")), BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star wars empire"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star+wars + empire"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse(" | --star wars empire \n\\"));
    }

    public void testCompoundOr() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "empire")), BooleanClause.Occur.SHOULD);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star|wars|empire"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star|wars | empire"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse(" | --star|wars|empire \n\\"));
    }

    public void testComplex00() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        BooleanQuery.Builder inner = new BooleanQuery.Builder();
        inner.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.SHOULD);
        inner.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.SHOULD);
        expected.add((Query)inner.build(), BooleanClause.Occur.MUST);
        expected.add((Query)new TermQuery(new Term("field", "empire")), BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star|wars empire"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star|wars + empire"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star| + wars + ----empire |"));
    }

    public void testComplex01() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        BooleanQuery.Builder inner = new BooleanQuery.Builder();
        inner.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.MUST);
        inner.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.MUST);
        expected.add((Query)inner.build(), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "empire")), BooleanClause.Occur.SHOULD);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star wars | empire"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star + wars|empire"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star + | wars | ----empire +"));
    }

    public void testComplex02() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        BooleanQuery.Builder inner = new BooleanQuery.Builder();
        inner.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.MUST);
        inner.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.MUST);
        expected.add((Query)inner.build(), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "empire")), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "strikes")), BooleanClause.Occur.SHOULD);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star wars | empire | strikes"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star + wars|empire | strikes"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star + | wars | ----empire | + --strikes \\"));
    }

    public void testComplex03() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        BooleanQuery.Builder inner = new BooleanQuery.Builder();
        BooleanQuery.Builder inner2 = new BooleanQuery.Builder();
        inner2.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.MUST);
        inner2.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.MUST);
        inner.add((Query)inner2.build(), BooleanClause.Occur.SHOULD);
        inner.add((Query)new TermQuery(new Term("field", "empire")), BooleanClause.Occur.SHOULD);
        inner.add((Query)new TermQuery(new Term("field", "strikes")), BooleanClause.Occur.SHOULD);
        expected.add((Query)inner.build(), BooleanClause.Occur.MUST);
        expected.add((Query)new TermQuery(new Term("field", "back")), BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star wars | empire | strikes back"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star + wars|empire | strikes + back"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star + | wars | ----empire | + --strikes + | --back \\"));
    }

    public void testComplex04() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        BooleanQuery.Builder inner = new BooleanQuery.Builder();
        BooleanQuery.Builder inner2 = new BooleanQuery.Builder();
        inner.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.MUST);
        inner.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.MUST);
        inner2.add((Query)new TermQuery(new Term("field", "strikes")), BooleanClause.Occur.MUST);
        inner2.add((Query)new TermQuery(new Term("field", "back")), BooleanClause.Occur.MUST);
        expected.add((Query)inner.build(), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "empire")), BooleanClause.Occur.SHOULD);
        expected.add((Query)inner2.build(), BooleanClause.Occur.SHOULD);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("(star wars) | empire | (strikes back)"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("(star + wars) |empire | (strikes + back)"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("(star + | wars |) | ----empire | + --(strikes + | --back) \\"));
    }

    public void testComplex05() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        BooleanQuery.Builder inner1 = new BooleanQuery.Builder();
        BooleanQuery.Builder inner2 = new BooleanQuery.Builder();
        BooleanQuery.Builder inner3 = new BooleanQuery.Builder();
        BooleanQuery.Builder inner4 = new BooleanQuery.Builder();
        inner1.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.MUST);
        inner1.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.MUST);
        inner2.add((Query)new TermQuery(new Term("field", "empire")), BooleanClause.Occur.SHOULD);
        inner3.add((Query)new TermQuery(new Term("field", "strikes")), BooleanClause.Occur.MUST);
        inner3.add((Query)new TermQuery(new Term("field", "back")), BooleanClause.Occur.MUST);
        inner4.add((Query)new TermQuery(new Term("field", "jarjar")), BooleanClause.Occur.MUST_NOT);
        inner4.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.SHOULD);
        inner3.add((Query)inner4.build(), BooleanClause.Occur.MUST);
        inner2.add((Query)inner3.build(), BooleanClause.Occur.SHOULD);
        expected.add((Query)inner1.build(), BooleanClause.Occur.SHOULD);
        expected.add((Query)inner2.build(), BooleanClause.Occur.SHOULD);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("(star wars) | (empire | (strikes back -jarjar))"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("(star + wars) |(empire | (strikes + back -jarjar) () )"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("(star + | wars |) | --(--empire | + --(strikes + | --back + -jarjar) \"\" ) \""));
    }

    public void testComplex06() throws Exception {
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        BooleanQuery.Builder inner1 = new BooleanQuery.Builder();
        BooleanQuery.Builder inner2 = new BooleanQuery.Builder();
        BooleanQuery.Builder inner3 = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "star")), BooleanClause.Occur.MUST);
        inner1.add((Query)new TermQuery(new Term("field", "wars")), BooleanClause.Occur.SHOULD);
        inner3.add((Query)new TermQuery(new Term("field", "empire")), BooleanClause.Occur.SHOULD);
        inner3.add((Query)new TermQuery(new Term("field", "strikes")), BooleanClause.Occur.SHOULD);
        inner2.add((Query)inner3.build(), BooleanClause.Occur.MUST);
        inner2.add((Query)new TermQuery(new Term("field", "back")), BooleanClause.Occur.MUST);
        inner2.add((Query)new TermQuery(new Term("field", "jar+|jar")), BooleanClause.Occur.MUST);
        inner1.add((Query)inner2.build(), BooleanClause.Occur.SHOULD);
        expected.add((Query)inner1.build(), BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star (wars | (empire | strikes back jar\\+\\|jar))"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star + (wars |(empire | strikes + back jar\\+\\|jar) () )"));
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("star + (| wars | | --(--empire | + --strikes + | --back + jar\\+\\|jar) \"\" ) \""));
    }

    public void testWeightedTerm() throws Exception {
        LinkedHashMap<String, Float> weights = new LinkedHashMap<String, Float>();
        weights.put("field0", Float.valueOf(5.0f));
        weights.put("field1", Float.valueOf(10.0f));
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.setDisableCoord(true);
        TermQuery field0 = new TermQuery(new Term("field0", "foo"));
        field0 = new BoostQuery((Query)field0, 5.0f);
        expected.add((Query)field0, BooleanClause.Occur.SHOULD);
        TermQuery field1 = new TermQuery(new Term("field1", "foo"));
        field1 = new BoostQuery((Query)field1, 10.0f);
        expected.add((Query)field1, BooleanClause.Occur.SHOULD);
        MockAnalyzer analyzer = new MockAnalyzer(TestSimpleQueryParser.random());
        SimpleQueryParser parser = new SimpleQueryParser((Analyzer)analyzer, weights);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)parser.parse("foo"));
    }

    public void testWeightedOR() throws Exception {
        LinkedHashMap<String, Float> weights = new LinkedHashMap<String, Float>();
        weights.put("field0", Float.valueOf(5.0f));
        weights.put("field1", Float.valueOf(10.0f));
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        BooleanQuery.Builder foo = new BooleanQuery.Builder();
        foo.setDisableCoord(true);
        TermQuery field0 = new TermQuery(new Term("field0", "foo"));
        field0 = new BoostQuery((Query)field0, 5.0f);
        foo.add((Query)field0, BooleanClause.Occur.SHOULD);
        TermQuery field1 = new TermQuery(new Term("field1", "foo"));
        field1 = new BoostQuery((Query)field1, 10.0f);
        foo.add((Query)field1, BooleanClause.Occur.SHOULD);
        expected.add((Query)foo.build(), BooleanClause.Occur.SHOULD);
        BooleanQuery.Builder bar = new BooleanQuery.Builder();
        bar.setDisableCoord(true);
        field0 = new TermQuery(new Term("field0", "bar"));
        field0 = new BoostQuery((Query)field0, 5.0f);
        bar.add((Query)field0, BooleanClause.Occur.SHOULD);
        field1 = new TermQuery(new Term("field1", "bar"));
        field1 = new BoostQuery((Query)field1, 10.0f);
        bar.add((Query)field1, BooleanClause.Occur.SHOULD);
        expected.add((Query)bar.build(), BooleanClause.Occur.SHOULD);
        MockAnalyzer analyzer = new MockAnalyzer(TestSimpleQueryParser.random());
        SimpleQueryParser parser = new SimpleQueryParser((Analyzer)analyzer, weights);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)parser.parse("foo|bar"));
    }

    private Query parseKeyword(String text, int flags) {
        MockAnalyzer analyzer = new MockAnalyzer(TestSimpleQueryParser.random(), MockTokenizer.KEYWORD, false);
        SimpleQueryParser parser = new SimpleQueryParser((Analyzer)analyzer, Collections.singletonMap("field", Float.valueOf(1.0f)), flags);
        return parser.parse(text);
    }

    public void testDisablePhrase() {
        TermQuery expected = new TermQuery(new Term("field", "\"test\""));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("\"test\"", -17));
    }

    public void testDisablePrefix() {
        TermQuery expected = new TermQuery(new Term("field", "test*"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("test*", -9));
    }

    public void testDisableAND() {
        TermQuery expected = new TermQuery(new Term("field", "foo+bar"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("foo+bar", -2));
        expected = new TermQuery(new Term("field", "+foo+bar"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("+foo+bar", -2));
    }

    public void testDisableOR() {
        TermQuery expected = new TermQuery(new Term("field", "foo|bar"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("foo|bar", -5));
        expected = new TermQuery(new Term("field", "|foo|bar"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("|foo|bar", -5));
    }

    public void testDisableNOT() {
        TermQuery expected = new TermQuery(new Term("field", "-foo"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("-foo", -3));
    }

    public void testDisablePrecedence() {
        TermQuery expected = new TermQuery(new Term("field", "(foo)"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("(foo)", -33));
        expected = new TermQuery(new Term("field", ")foo("));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword(")foo(", -33));
    }

    public void testDisableEscape() {
        TermQuery expected = new TermQuery(new Term("field", "foo\\bar"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("foo\\bar", -65));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("(foo\\bar)", -65));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("\"foo\\bar\"", -65));
    }

    public void testDisableWhitespace() {
        TermQuery expected = new TermQuery(new Term("field", "foo foo"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("foo foo", -129));
        expected = new TermQuery(new Term("field", " foo foo\n "));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword(" foo foo\n ", -129));
        expected = new TermQuery(new Term("field", "\t\tfoo foo foo"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("\t\tfoo foo foo", -129));
    }

    public void testDisableFuzziness() {
        TermQuery expected = new TermQuery(new Term("field", "foo~1"));
        TestSimpleQueryParser.assertEquals((Object)expected, (Object)this.parseKeyword("foo~1", -257));
    }

    public void testDisableSlop() {
        PhraseQuery expectedPhrase = new PhraseQuery("field", new String[]{"foo", "bar"});
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)expectedPhrase, BooleanClause.Occur.MUST);
        expected.add((Query)new TermQuery(new Term("field", "~2")), BooleanClause.Occur.MUST);
        TestSimpleQueryParser.assertEquals((Object)expected.build(), (Object)this.parse("\"foo bar\"~2", -513));
    }

    public void testRandomQueries() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            String query = TestUtil.randomUnicodeString((Random)TestSimpleQueryParser.random());
            this.parse(query);
            this.parseKeyword(query, TestUtil.nextInt((Random)TestSimpleQueryParser.random(), (int)0, (int)1024));
        }
    }

    public void testRandomQueries2() throws Exception {
        char[] chars = new char[]{'a', '1', '|', '&', ' ', '(', ')', '\"', '-', '~'};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 1000; ++i) {
            sb.setLength(0);
            int queryLength = TestSimpleQueryParser.random().nextInt(20);
            for (int j = 0; j < queryLength; ++j) {
                sb.append(chars[TestSimpleQueryParser.random().nextInt(chars.length)]);
            }
            this.parse(sb.toString());
            this.parseKeyword(sb.toString(), TestUtil.nextInt((Random)TestSimpleQueryParser.random(), (int)0, (int)1024));
        }
    }

    public void testStarBecomesMatchAll() throws Exception {
        Query q = this.parse("*");
        TestSimpleQueryParser.assertEquals((Object)q, (Object)new MatchAllDocsQuery());
        q = this.parse(" *   ");
        TestSimpleQueryParser.assertEquals((Object)q, (Object)new MatchAllDocsQuery());
    }
}

