/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.surround.query;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queryparser.surround.parser.QueryParser;
import org.apache.lucene.queryparser.surround.query.BasicQueryFactory;
import org.apache.lucene.queryparser.surround.query.SingleFieldTestDb;
import org.apache.lucene.queryparser.surround.query.SrndQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.store.Directory;
import org.junit.Assert;

public class BooleanQueryTst {
    String queryText;
    final int[] expectedDocNrs;
    SingleFieldTestDb dBase;
    String fieldName;
    Assert testCase;
    BasicQueryFactory qf;
    boolean verbose = true;

    public BooleanQueryTst(String queryText, int[] expectedDocNrs, SingleFieldTestDb dBase, String fieldName, Assert testCase, BasicQueryFactory qf) {
        this.queryText = queryText;
        this.expectedDocNrs = expectedDocNrs;
        this.dBase = dBase;
        this.fieldName = fieldName;
        this.testCase = testCase;
        this.qf = qf;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTest() throws Exception {
        if (this.verbose) {
            System.out.println("");
            System.out.println("Query: " + this.queryText);
        }
        SrndQuery lq = QueryParser.parse((String)this.queryText);
        Query query = lq.makeLuceneQueryField(this.fieldName, this.qf);
        TestCollector tc = new TestCollector();
        DirectoryReader reader = DirectoryReader.open((Directory)this.dBase.getDb());
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        try {
            searcher.search(query, (Collector)tc);
        }
        finally {
            reader.close();
        }
        tc.checkNrHits();
    }

    class TestCollector
    extends SimpleCollector {
        int totalMatched = 0;
        boolean[] encountered;
        private Scorer scorer = null;
        private int docBase = 0;

        TestCollector() {
            this.encountered = new boolean[BooleanQueryTst.this.expectedDocNrs.length];
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.docBase = context.docBase;
        }

        public void collect(int docNr) throws IOException {
            int i;
            float score = this.scorer.score();
            docNr += this.docBase;
            Assert.assertTrue((String)(BooleanQueryTst.this.queryText + ": positive score"), ((double)score > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((String)(BooleanQueryTst.this.queryText + ": too many hits"), (this.totalMatched < BooleanQueryTst.this.expectedDocNrs.length ? 1 : 0) != 0);
            for (i = 0; i < BooleanQueryTst.this.expectedDocNrs.length; ++i) {
                if (this.encountered[i] || BooleanQueryTst.this.expectedDocNrs[i] != docNr) continue;
                this.encountered[i] = true;
                break;
            }
            if (i == BooleanQueryTst.this.expectedDocNrs.length) {
                Assert.assertTrue((String)(BooleanQueryTst.this.queryText + ": doc nr for hit not expected: " + docNr), (boolean)false);
            }
            ++this.totalMatched;
        }

        public boolean needsScores() {
            return true;
        }

        void checkNrHits() {
            Assert.assertEquals((String)(BooleanQueryTst.this.queryText + ": nr of hits"), (long)BooleanQueryTst.this.expectedDocNrs.length, (long)this.totalMatched);
        }
    }
}

