/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.surround.query;

import org.apache.lucene.queryparser.surround.parser.ParseException;
import org.apache.lucene.queryparser.surround.parser.QueryParser;
import org.apache.lucene.queryparser.surround.query.SrndQuery;

public class ExceptionQueryTst {
    private String queryText;
    private boolean verbose;

    public ExceptionQueryTst(String queryText, boolean verbose) {
        this.queryText = queryText;
        this.verbose = verbose;
    }

    public void doTest(StringBuilder failQueries) {
        boolean pass = false;
        SrndQuery lq = null;
        try {
            lq = QueryParser.parse((String)this.queryText);
            if (this.verbose) {
                System.out.println("Query: " + this.queryText + "\nParsed as: " + lq.toString());
            }
        }
        catch (ParseException e) {
            if (this.verbose) {
                System.out.println("Parse exception for query:\n" + this.queryText + "\n" + e.getMessage());
            }
            pass = true;
        }
        if (!pass) {
            failQueries.append(this.queryText);
            failQueries.append("\nParsed as: ");
            failQueries.append(lq.toString());
            failQueries.append("\n");
        }
    }

    public static String getFailQueries(String[] exceptionQueries, boolean verbose) {
        StringBuilder failQueries = new StringBuilder();
        for (int i = 0; i < exceptionQueries.length; ++i) {
            new ExceptionQueryTst(exceptionQueries[i], verbose).doTest(failQueries);
        }
        return failQueries.toString();
    }
}

