/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.surround.query;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.RAMDirectory;

public class SingleFieldTestDb {
    private Directory db;
    private String[] docs;
    private String fieldName;

    public SingleFieldTestDb(Random random, String[] documents, String fName) {
        try {
            this.db = new MockDirectoryWrapper(random, (Directory)new RAMDirectory());
            this.docs = documents;
            this.fieldName = fName;
            IndexWriter writer = new IndexWriter(this.db, new IndexWriterConfig((Analyzer)new MockAnalyzer(random)));
            for (int j = 0; j < this.docs.length; ++j) {
                Document d = new Document();
                d.add((IndexableField)new TextField(this.fieldName, this.docs[j], Field.Store.NO));
                writer.addDocument((Iterable)d);
            }
            writer.close();
        }
        catch (IOException ioe) {
            throw new Error(ioe);
        }
    }

    Directory getDb() {
        return this.db;
    }

    String[] getDocs() {
        return this.docs;
    }

    String getFieldname() {
        return this.fieldName;
    }
}

