/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.surround.query;

import org.apache.lucene.queryparser.surround.parser.QueryParser;
import org.apache.lucene.queryparser.surround.query.BasicQueryFactory;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.junit.Test;

public class SrndQueryTest
extends LuceneTestCase {
    void checkEqualParsings(String s1, String s2) throws Exception {
        String fieldName = "foo";
        BasicQueryFactory qf = new BasicQueryFactory(16);
        Query lq1 = QueryParser.parse((String)s1).makeLuceneQueryField(fieldName, qf);
        Query lq2 = QueryParser.parse((String)s2).makeLuceneQueryField(fieldName, qf);
        QueryUtils.checkEqual((Query)lq1, (Query)lq2);
    }

    @Test
    public void testHashEquals() throws Exception {
        this.checkEqualParsings("word1 w word2", " word1  w  word2 ");
        this.checkEqualParsings("2N(w1,w2,w3)", " 2N(w1, w2 , w3)");
        this.checkEqualParsings("abc?", " abc? ");
        this.checkEqualParsings("w*rd?", " w*rd?");
    }
}

