/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.util;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockSynonymFilter;
import org.apache.lucene.analysis.MockTokenFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.QueryParserBase;
import org.apache.lucene.queryparser.classic.TestQueryParser;
import org.apache.lucene.queryparser.flexible.standard.CommonQueryParserConfiguration;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.RegExp;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class QueryParserTestBase
extends LuceneTestCase {
    public static Analyzer qpAnalyzer;
    private int originalMaxClauses;
    private String defaultField = "field";

    @BeforeClass
    public static void beforeClass() {
        qpAnalyzer = new QPTestAnalyzer();
    }

    @AfterClass
    public static void afterClass() {
        qpAnalyzer = null;
    }

    protected String getDefaultField() {
        return this.defaultField;
    }

    protected void setDefaultField(String defaultField) {
        this.defaultField = defaultField;
    }

    public void setUp() throws Exception {
        super.setUp();
        this.originalMaxClauses = BooleanQuery.getMaxClauseCount();
    }

    public abstract CommonQueryParserConfiguration getParserConfig(Analyzer var1) throws Exception;

    public abstract void setDefaultOperatorOR(CommonQueryParserConfiguration var1);

    public abstract void setDefaultOperatorAND(CommonQueryParserConfiguration var1);

    public abstract void setAnalyzeRangeTerms(CommonQueryParserConfiguration var1, boolean var2);

    public abstract void setAutoGeneratePhraseQueries(CommonQueryParserConfiguration var1, boolean var2);

    public abstract void setDateResolution(CommonQueryParserConfiguration var1, CharSequence var2, DateTools.Resolution var3);

    public abstract Query getQuery(String var1, CommonQueryParserConfiguration var2) throws Exception;

    public abstract Query getQuery(String var1, Analyzer var2) throws Exception;

    public abstract boolean isQueryParserException(Exception var1);

    public Query getQuery(String query) throws Exception {
        return this.getQuery(query, (Analyzer)null);
    }

    public void assertQueryEquals(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQuery(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            QueryParserTestBase.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertMatchNoDocsQuery(String queryString, Analyzer a) throws Exception {
        this.assertMatchNoDocsQuery(this.getQuery(queryString, a));
    }

    public void assertMatchNoDocsQuery(Query query) throws Exception {
        if (!(query instanceof MatchNoDocsQuery || query instanceof BooleanQuery && ((BooleanQuery)query).clauses().size() == 0)) {
            QueryParserTestBase.fail((String)("expected MatchNoDocsQuery or an empty BooleanQuery but got: " + query));
        }
    }

    public void assertQueryEquals(CommonQueryParserConfiguration cqpC, String field, String query, String result) throws Exception {
        Query q = this.getQuery(query, cqpC);
        String s = q.toString(field);
        if (!s.equals(result)) {
            QueryParserTestBase.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertEscapedQueryEquals(String query, Analyzer a, String result) throws Exception {
        String escapedQuery = QueryParserBase.escape((String)query);
        if (!escapedQuery.equals(result)) {
            QueryParserTestBase.fail((String)("Query /" + query + "/ yielded /" + escapedQuery + "/, expecting /" + result + "/"));
        }
    }

    public void assertWildcardQueryEquals(String query, boolean lowercase, String result, boolean allowLeadingWildcard) throws Exception {
        CommonQueryParserConfiguration cqpC = this.getParserConfig(null);
        cqpC.setLowercaseExpandedTerms(lowercase);
        cqpC.setAllowLeadingWildcard(allowLeadingWildcard);
        Query q = this.getQuery(query, cqpC);
        String s = q.toString("field");
        if (!s.equals(result)) {
            QueryParserTestBase.fail((String)("WildcardQuery /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void assertWildcardQueryEquals(String query, boolean lowercase, String result) throws Exception {
        this.assertWildcardQueryEquals(query, lowercase, result, false);
    }

    public void assertWildcardQueryEquals(String query, String result) throws Exception {
        Query q = this.getQuery(query);
        String s = q.toString("field");
        if (!s.equals(result)) {
            QueryParserTestBase.fail((String)("WildcardQuery /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public Query getQueryDOA(String query, Analyzer a) throws Exception {
        if (a == null) {
            a = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.SIMPLE, true);
        }
        CommonQueryParserConfiguration qp = this.getParserConfig(a);
        this.setDefaultOperatorAND(qp);
        return this.getQuery(query, qp);
    }

    public void assertQueryEqualsDOA(String query, Analyzer a, String result) throws Exception {
        Query q = this.getQueryDOA(query, a);
        String s = q.toString("field");
        if (!s.equals(result)) {
            QueryParserTestBase.fail((String)("Query /" + query + "/ yielded /" + s + "/, expecting /" + result + "/"));
        }
    }

    public void testCJK() throws Exception {
        this.assertQueryEquals("term\u3000term\u3000term", null, "term term term");
        this.assertQueryEquals("\u7528\u8a9e\u3000\u7528\u8a9e\u3000\u7528\u8a9e", null, "\u7528\u8a9e \u7528\u8a9e \u7528\u8a9e");
    }

    public void testCJKTerm() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        BooleanQuery.Builder expected = new BooleanQuery.Builder();
        expected.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.SHOULD);
        expected.add((Query)new TermQuery(new Term("field", "\u56fd")), BooleanClause.Occur.SHOULD);
        QueryParserTestBase.assertEquals((Object)expected.build(), (Object)this.getQuery("\u4e2d\u56fd", analyzer));
    }

    public void testCJKBoostedTerm() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        BooleanQuery.Builder expectedB = new BooleanQuery.Builder();
        expectedB.add((Query)new TermQuery(new Term("field", "\u4e2d")), BooleanClause.Occur.SHOULD);
        expectedB.add((Query)new TermQuery(new Term("field", "\u56fd")), BooleanClause.Occur.SHOULD);
        BooleanQuery expected = expectedB.build();
        expected = new BoostQuery((Query)expected, 0.5f);
        QueryParserTestBase.assertEquals((Object)expected, (Object)this.getQuery("\u4e2d\u56fd^0.5", analyzer));
    }

    public void testCJKPhrase() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        PhraseQuery expected = new PhraseQuery("field", new String[]{"\u4e2d", "\u56fd"});
        QueryParserTestBase.assertEquals((Object)expected, (Object)this.getQuery("\"\u4e2d\u56fd\"", analyzer));
    }

    public void testCJKBoostedPhrase() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        PhraseQuery expected = new PhraseQuery("field", new String[]{"\u4e2d", "\u56fd"});
        expected = new BoostQuery((Query)expected, 0.5f);
        QueryParserTestBase.assertEquals((Object)expected, (Object)this.getQuery("\"\u4e2d\u56fd\"^0.5", analyzer));
    }

    public void testCJKSloppyPhrase() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        PhraseQuery expected = new PhraseQuery(3, "field", new String[]{"\u4e2d", "\u56fd"});
        QueryParserTestBase.assertEquals((Object)expected, (Object)this.getQuery("\"\u4e2d\u56fd\"~3", analyzer));
    }

    public void testAutoGeneratePhraseQueriesOn() throws Exception {
        SimpleCJKAnalyzer analyzer = new SimpleCJKAnalyzer();
        PhraseQuery expected = new PhraseQuery("field", new String[]{"\u4e2d", "\u56fd"});
        CommonQueryParserConfiguration qp = this.getParserConfig(analyzer);
        if (qp instanceof QueryParser) {
            ((QueryParser)qp).setSplitOnWhitespace(true);
        }
        this.setAutoGeneratePhraseQueries(qp, true);
        QueryParserTestBase.assertEquals((Object)expected, (Object)this.getQuery("\u4e2d\u56fd", qp));
    }

    public void testSimple() throws Exception {
        this.assertQueryEquals("term term term", null, "term term term");
        this.assertQueryEquals("t\u00fcrm term term", (Analyzer)new MockAnalyzer(QueryParserTestBase.random()), "t\u00fcrm term term");
        this.assertQueryEquals("\u00fcmlaut", (Analyzer)new MockAnalyzer(QueryParserTestBase.random()), "\u00fcmlaut");
        this.assertQueryEquals("a AND b", null, "+a +b");
        this.assertQueryEquals("(a AND b)", null, "+a +b");
        this.assertQueryEquals("c OR (a AND b)", null, "c (+a +b)");
        this.assertQueryEquals("a AND NOT b", null, "+a -b");
        this.assertQueryEquals("a AND -b", null, "+a -b");
        this.assertQueryEquals("a AND !b", null, "+a -b");
        this.assertQueryEquals("a && b", null, "+a +b");
        this.assertQueryEquals("a OR b", null, "a b");
        this.assertQueryEquals("a || b", null, "a b");
        this.assertQueryEquals("a OR !b", null, "a -b");
        this.assertQueryEquals("a OR -b", null, "a -b");
        this.assertQueryEquals("+term -term term", null, "+term -term term");
        this.assertQueryEquals("foo:term AND field:anotherTerm", null, "+foo:term +anotherterm");
        this.assertQueryEquals("term AND \"phrase phrase\"", null, "+term +\"phrase phrase\"");
        this.assertQueryEquals("\"hello there\"", null, "\"hello there\"");
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("a AND b") instanceof BooleanQuery));
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("hello") instanceof TermQuery));
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("\"hello there\"") instanceof PhraseQuery));
        this.assertQueryEquals("germ term^2.0", null, "germ (term)^2.0");
        this.assertQueryEquals("(term)^2.0", null, "(term)^2.0");
        this.assertQueryEquals("(germ term)^2.0", null, "(germ term)^2.0");
        this.assertQueryEquals("term^2.0", null, "(term)^2.0");
        this.assertQueryEquals("term^2", null, "(term)^2.0");
        this.assertQueryEquals("\"germ term\"^2.0", null, "(\"germ term\")^2.0");
        this.assertQueryEquals("\"term germ\"^2", null, "(\"term germ\")^2.0");
        this.assertQueryEquals("(foo OR bar) AND (baz OR boo)", null, "+(foo bar) +(baz boo)");
        this.assertQueryEquals("((a OR b) AND NOT c) OR d", null, "(+(a b) -c) d");
        this.assertQueryEquals("+(apple \"steve jobs\") -(foo bar baz)", null, "+(apple \"steve jobs\") -(foo bar baz)");
        this.assertQueryEquals("+title:(dog OR cat) -author:\"bob dole\"", null, "+(title:dog title:cat) -author:\"bob dole\"");
    }

    public abstract void testDefaultOperator() throws Exception;

    public void testOperatorVsWhitespace() throws Exception {
        Analyzer a = new Analyzer(){

            public Analyzer.TokenStreamComponents createComponents(String fieldName) {
                return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer(MockTokenizer.WHITESPACE, false));
            }
        };
        this.assertQueryEquals("a - b", a, "a - b");
        this.assertQueryEquals("a + b", a, "a + b");
        this.assertQueryEquals("a ! b", a, "a ! b");
    }

    public void testPunct() throws Exception {
        MockAnalyzer a = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false);
        this.assertQueryEquals("a&b", (Analyzer)a, "a&b");
        this.assertQueryEquals("a&&b", (Analyzer)a, "a&&b");
        this.assertQueryEquals(".NET", (Analyzer)a, ".NET");
    }

    public void testSlop() throws Exception {
        this.assertQueryEquals("\"term germ\"~2", null, "\"term germ\"~2");
        this.assertQueryEquals("\"term germ\"~2 flork", null, "\"term germ\"~2 flork");
        this.assertQueryEquals("\"term\"~2", null, "term");
        this.assertQueryEquals("\" \"~2 germ", null, "germ");
        this.assertQueryEquals("\"term germ\"~2^2", null, "(\"term germ\"~2)^2.0");
    }

    public void testNumber() throws Exception {
        this.assertMatchNoDocsQuery("3", null);
        this.assertQueryEquals("term 1.0 1 2", null, "term");
        this.assertQueryEquals("term term1 term2", null, "term term term");
        MockAnalyzer a = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, true);
        this.assertQueryEquals("3", (Analyzer)a, "3");
        this.assertQueryEquals("term 1.0 1 2", (Analyzer)a, "term 1.0 1 2");
        this.assertQueryEquals("term term1 term2", (Analyzer)a, "term term1 term2");
    }

    public void testWildcard() throws Exception {
        block5: {
            block4: {
                this.assertQueryEquals("term*", null, "term*");
                this.assertQueryEquals("term*^2", null, "(term*)^2.0");
                this.assertQueryEquals("term~", null, "term~2");
                this.assertQueryEquals("term~1", null, "term~1");
                this.assertQueryEquals("term~0.7", null, "term~1");
                this.assertQueryEquals("term~^3", null, "(term~2)^3.0");
                this.assertQueryEquals("term^3~", null, "(term~2)^3.0");
                this.assertQueryEquals("term*germ", null, "term*germ");
                this.assertQueryEquals("term*germ^3", null, "(term*germ)^3.0");
                QueryParserTestBase.assertTrue((boolean)(this.getQuery("term*") instanceof PrefixQuery));
                QueryParserTestBase.assertTrue((boolean)(this.getQuery("term*^2") instanceof BoostQuery));
                QueryParserTestBase.assertTrue((boolean)(((BoostQuery)this.getQuery("term*^2")).getQuery() instanceof PrefixQuery));
                QueryParserTestBase.assertTrue((boolean)(this.getQuery("term~") instanceof FuzzyQuery));
                QueryParserTestBase.assertTrue((boolean)(this.getQuery("term~0.7") instanceof FuzzyQuery));
                FuzzyQuery fq = (FuzzyQuery)this.getQuery("term~0.7");
                QueryParserTestBase.assertEquals((long)1L, (long)fq.getMaxEdits());
                QueryParserTestBase.assertEquals((long)0L, (long)fq.getPrefixLength());
                fq = (FuzzyQuery)this.getQuery("term~");
                QueryParserTestBase.assertEquals((long)2L, (long)fq.getMaxEdits());
                QueryParserTestBase.assertEquals((long)0L, (long)fq.getPrefixLength());
                this.assertParseException("term~1.1");
                QueryParserTestBase.assertTrue((boolean)(this.getQuery("term*germ") instanceof WildcardQuery));
                this.assertWildcardQueryEquals("Term*", true, "term*");
                this.assertWildcardQueryEquals("term*", true, "term*");
                this.assertWildcardQueryEquals("Term*", true, "term*");
                this.assertWildcardQueryEquals("TERM*", true, "term*");
                this.assertWildcardQueryEquals("term*", false, "term*");
                this.assertWildcardQueryEquals("Term*", false, "Term*");
                this.assertWildcardQueryEquals("TERM*", false, "TERM*");
                this.assertWildcardQueryEquals("Te?m", "te?m");
                this.assertWildcardQueryEquals("te?m", true, "te?m");
                this.assertWildcardQueryEquals("Te?m", true, "te?m");
                this.assertWildcardQueryEquals("TE?M", true, "te?m");
                this.assertWildcardQueryEquals("Te?m*gerM", true, "te?m*germ");
                this.assertWildcardQueryEquals("te?m", false, "te?m");
                this.assertWildcardQueryEquals("Te?m", false, "Te?m");
                this.assertWildcardQueryEquals("TE?M", false, "TE?M");
                this.assertWildcardQueryEquals("Te?m*gerM", false, "Te?m*gerM");
                this.assertWildcardQueryEquals("Term~", "term~2");
                this.assertWildcardQueryEquals("Term~", true, "term~2");
                this.assertWildcardQueryEquals("Term~", false, "Term~2");
                this.assertWildcardQueryEquals("[A TO C]", "[a TO c]");
                this.assertWildcardQueryEquals("[A TO C]", true, "[a TO c]");
                this.assertWildcardQueryEquals("[A TO C]", false, "[A TO C]");
                try {
                    this.assertWildcardQueryEquals("*Term", true, "*term");
                }
                catch (Exception pe) {
                    if (this.isQueryParserException(pe)) break block4;
                    QueryParserTestBase.fail();
                }
            }
            try {
                this.assertWildcardQueryEquals("?Term", true, "?term");
                QueryParserTestBase.fail();
            }
            catch (Exception pe) {
                if (this.isQueryParserException(pe)) break block5;
                QueryParserTestBase.fail();
            }
        }
        this.assertWildcardQueryEquals("*Term", true, "*term", true);
        this.assertWildcardQueryEquals("?Term", true, "?term", true);
    }

    public void testLeadingWildcardType() throws Exception {
        CommonQueryParserConfiguration cqpC = this.getParserConfig(null);
        cqpC.setAllowLeadingWildcard(true);
        QueryParserTestBase.assertEquals(WildcardQuery.class, this.getQuery("t*erm*", cqpC).getClass());
        QueryParserTestBase.assertEquals(WildcardQuery.class, this.getQuery("?term*", cqpC).getClass());
        QueryParserTestBase.assertEquals(WildcardQuery.class, this.getQuery("*term*", cqpC).getClass());
    }

    public void testQPA() throws Exception {
        this.assertQueryEquals("term term^3.0 term", qpAnalyzer, "term (term)^3.0 term");
        this.assertQueryEquals("term stop^3.0 term", qpAnalyzer, "term term");
        this.assertQueryEquals("term term term", qpAnalyzer, "term term term");
        this.assertQueryEquals("term +stop term", qpAnalyzer, "term term");
        this.assertQueryEquals("term -stop term", qpAnalyzer, "term term");
        this.assertQueryEquals("drop AND (stop) AND roll", qpAnalyzer, "+drop +roll");
        this.assertQueryEquals("term +(stop) term", qpAnalyzer, "term term");
        this.assertQueryEquals("term -(stop) term", qpAnalyzer, "term term");
        this.assertQueryEquals("drop AND stop AND roll", qpAnalyzer, "+drop +roll");
        this.assertQueryEquals("term AND NOT phrase term", qpAnalyzer, "+term -(phrase1 phrase2) term");
        this.assertMatchNoDocsQuery("stop^3", qpAnalyzer);
        this.assertMatchNoDocsQuery("stop", qpAnalyzer);
        this.assertMatchNoDocsQuery("(stop)^3", qpAnalyzer);
        this.assertMatchNoDocsQuery("((stop))^3", qpAnalyzer);
        this.assertMatchNoDocsQuery("(stop^3)", qpAnalyzer);
        this.assertMatchNoDocsQuery("((stop)^3)", qpAnalyzer);
        this.assertMatchNoDocsQuery("(stop)", qpAnalyzer);
        this.assertMatchNoDocsQuery("((stop))", qpAnalyzer);
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("term term term", qpAnalyzer) instanceof BooleanQuery));
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("term +stop", qpAnalyzer) instanceof TermQuery));
        CommonQueryParserConfiguration cqpc = this.getParserConfig(qpAnalyzer);
        this.setDefaultOperatorAND(cqpc);
        this.assertQueryEquals(cqpc, "field", "phrase", "+phrase1 +phrase2");
    }

    public void testRange() throws Exception {
        this.assertQueryEquals("[ a TO z]", null, "[a TO z]");
        this.assertQueryEquals("[ a TO z}", null, "[a TO z}");
        this.assertQueryEquals("{ a TO z]", null, "{a TO z]");
        QueryParserTestBase.assertEquals((Object)MultiTermQuery.CONSTANT_SCORE_REWRITE, (Object)((TermRangeQuery)this.getQuery("[ a TO z]")).getRewriteMethod());
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.SIMPLE, true));
        qp.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
        QueryParserTestBase.assertEquals((Object)MultiTermQuery.SCORING_BOOLEAN_REWRITE, (Object)((TermRangeQuery)this.getQuery("[ a TO z]", qp)).getRewriteMethod());
        this.assertQueryEquals("[ a TO * ]", null, "[a TO *]");
        this.assertQueryEquals("[ * TO z ]", null, "[* TO z]");
        this.assertQueryEquals("[ * TO * ]", null, "[* TO *]");
        this.assertQueryEquals("{ a TO z ]", null, "{a TO z]");
        this.assertQueryEquals("[ a TO z }", null, "[a TO z}");
        this.assertQueryEquals("{ a TO * ]", null, "{a TO *]");
        this.assertQueryEquals("[ * TO z }", null, "[* TO z}");
        this.assertQueryEquals("[ a TO z ]", null, "[a TO z]");
        this.assertQueryEquals("{ a TO z}", null, "{a TO z}");
        this.assertQueryEquals("{ a TO z }", null, "{a TO z}");
        this.assertQueryEquals("{ a TO z }^2.0", null, "({a TO z})^2.0");
        this.assertQueryEquals("[ a TO z] OR bar", null, "[a TO z] bar");
        this.assertQueryEquals("[ a TO z] AND bar", null, "+[a TO z] +bar");
        this.assertQueryEquals("( bar blar { a TO z}) ", null, "bar blar {a TO z}");
        this.assertQueryEquals("gack ( bar blar { a TO z}) ", null, "gack (bar blar {a TO z})");
        this.assertQueryEquals("[* TO Z]", null, "[* TO z]");
        this.assertQueryEquals("[A TO *]", null, "[a TO *]");
        this.assertQueryEquals("[* TO *]", null, "[* TO *]");
    }

    public void testRangeWithPhrase() throws Exception {
        this.assertQueryEquals("[\\* TO \"*\"]", null, "[\\* TO \\*]");
        this.assertQueryEquals("[\"*\" TO *]", null, "[\\* TO *]");
    }

    public void testRangeQueryEndpointTO() throws Exception {
        MockAnalyzer a = new MockAnalyzer(QueryParserTestBase.random());
        this.assertQueryEquals("[to TO to]", (Analyzer)a, "[to TO to]");
        this.assertQueryEquals("[to TO TO]", (Analyzer)a, "[to TO to]");
        this.assertQueryEquals("[TO TO to]", (Analyzer)a, "[to TO to]");
        this.assertQueryEquals("[TO TO TO]", (Analyzer)a, "[to TO to]");
        this.assertQueryEquals("[\"TO\" TO \"TO\"]", (Analyzer)a, "[to TO to]");
        this.assertQueryEquals("[\"TO\" TO TO]", (Analyzer)a, "[to TO to]");
        this.assertQueryEquals("[TO TO \"TO\"]", (Analyzer)a, "[to TO to]");
        this.assertQueryEquals("[to TO xx]", (Analyzer)a, "[to TO xx]");
        this.assertQueryEquals("[\"TO\" TO xx]", (Analyzer)a, "[to TO xx]");
        this.assertQueryEquals("[TO TO xx]", (Analyzer)a, "[to TO xx]");
        this.assertQueryEquals("[xx TO to]", (Analyzer)a, "[xx TO to]");
        this.assertQueryEquals("[xx TO \"TO\"]", (Analyzer)a, "[xx TO to]");
        this.assertQueryEquals("[xx TO TO]", (Analyzer)a, "[xx TO to]");
    }

    public void testRangeQueryRequiresTO() throws Exception {
        MockAnalyzer a = new MockAnalyzer(QueryParserTestBase.random());
        this.assertQueryEquals("{A TO B}", (Analyzer)a, "{a TO b}");
        this.assertQueryEquals("[A TO B}", (Analyzer)a, "[a TO b}");
        this.assertQueryEquals("{A TO B]", (Analyzer)a, "{a TO b]");
        this.assertQueryEquals("[A TO B]", (Analyzer)a, "[a TO b]");
        Class exceptionClass = this instanceof TestQueryParser ? ParseException.class : org.apache.lucene.queryparser.flexible.standard.parser.ParseException.class;
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("{A B}"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("[A B}"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("{A B]"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("[A B]"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("{TO B}"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("[TO B}"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("{TO B]"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("[TO B]"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("{A TO}"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("[A TO}"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("{A TO]"));
        QueryParserTestBase.expectThrows(exceptionClass, () -> this.getQuery("[A TO]"));
    }

    private String escapeDateString(String s) {
        if (s.indexOf(" ") > -1) {
            return "\"" + s + "\"";
        }
        return s;
    }

    private String getDate(String s, DateTools.Resolution resolution) throws Exception {
        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
        return this.getDate(df.parse(s), resolution);
    }

    private String getDate(Date d, DateTools.Resolution resolution) {
        return DateTools.dateToString((Date)d, (DateTools.Resolution)resolution);
    }

    private String getLocalizedDate(int year, int month, int day) {
        DateFormat df = DateFormat.getDateInstance(3, Locale.getDefault());
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        calendar.clear();
        calendar.set(year, month, day);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return df.format(calendar.getTime());
    }

    public void testDateRange() throws Exception {
        String startDate = this.getLocalizedDate(2002, 1, 1);
        String endDate = this.getLocalizedDate(2002, 1, 4);
        GregorianCalendar endDateExpected = new GregorianCalendar(TimeZone.getDefault(), Locale.getDefault());
        endDateExpected.clear();
        endDateExpected.set(2002, 1, 4, 23, 59, 59);
        endDateExpected.set(14, 999);
        String defaultField = "default";
        String monthField = "month";
        String hourField = "hour";
        MockAnalyzer a = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.SIMPLE, true);
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)a);
        this.setDateResolution(qp, "month", DateTools.Resolution.MONTH);
        qp.setDateResolution(DateTools.Resolution.MILLISECOND);
        this.setDateResolution(qp, "hour", DateTools.Resolution.HOUR);
        this.assertDateRangeQueryEquals(qp, "default", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.MILLISECOND);
        this.assertDateRangeQueryEquals(qp, "month", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.MONTH);
        this.assertDateRangeQueryEquals(qp, "hour", startDate, endDate, endDateExpected.getTime(), DateTools.Resolution.HOUR);
    }

    public void assertDateRangeQueryEquals(CommonQueryParserConfiguration cqpC, String field, String startDate, String endDate, Date endDateInclusive, DateTools.Resolution resolution) throws Exception {
        this.assertQueryEquals(cqpC, field, field + ":[" + this.escapeDateString(startDate) + " TO " + this.escapeDateString(endDate) + "]", "[" + this.getDate(startDate, resolution) + " TO " + this.getDate(endDateInclusive, resolution) + "]");
        this.assertQueryEquals(cqpC, field, field + ":{" + this.escapeDateString(startDate) + " TO " + this.escapeDateString(endDate) + "}", "{" + this.getDate(startDate, resolution) + " TO " + this.getDate(endDate, resolution) + "}");
    }

    public void testEscaped() throws Exception {
        MockAnalyzer a = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false);
        this.assertQueryEquals("\\a", (Analyzer)a, "a");
        this.assertQueryEquals("a\\-b:c", (Analyzer)a, "a-b:c");
        this.assertQueryEquals("a\\+b:c", (Analyzer)a, "a+b:c");
        this.assertQueryEquals("a\\:b:c", (Analyzer)a, "a:b:c");
        this.assertQueryEquals("a\\\\b:c", (Analyzer)a, "a\\b:c");
        this.assertQueryEquals("a:b\\-c", (Analyzer)a, "a:b-c");
        this.assertQueryEquals("a:b\\+c", (Analyzer)a, "a:b+c");
        this.assertQueryEquals("a:b\\:c", (Analyzer)a, "a:b:c");
        this.assertQueryEquals("a:b\\\\c", (Analyzer)a, "a:b\\c");
        this.assertQueryEquals("a:b\\-c*", (Analyzer)a, "a:b-c*");
        this.assertQueryEquals("a:b\\+c*", (Analyzer)a, "a:b+c*");
        this.assertQueryEquals("a:b\\:c*", (Analyzer)a, "a:b:c*");
        this.assertQueryEquals("a:b\\\\c*", (Analyzer)a, "a:b\\c*");
        this.assertQueryEquals("a:b\\-c~", (Analyzer)a, "a:b-c~2");
        this.assertQueryEquals("a:b\\+c~", (Analyzer)a, "a:b+c~2");
        this.assertQueryEquals("a:b\\:c~", (Analyzer)a, "a:b:c~2");
        this.assertQueryEquals("a:b\\\\c~", (Analyzer)a, "a:b\\c~2");
        this.assertQueryEquals("[ a\\- TO a\\+ ]", null, "[a- TO a+]");
        this.assertQueryEquals("[ a\\: TO a\\~ ]", null, "[a: TO a~]");
        this.assertQueryEquals("[ a\\\\ TO a\\* ]", null, "[a\\ TO a*]");
        this.assertQueryEquals("[\"c\\:\\\\temp\\\\\\~foo0.txt\" TO \"c\\:\\\\temp\\\\\\~foo9.txt\"]", (Analyzer)a, "[c:\\temp\\~foo0.txt TO c:\\temp\\~foo9.txt]");
        this.assertQueryEquals("a\\\\\\+b", (Analyzer)a, "a\\+b");
        this.assertQueryEquals("a \\\"b c\\\" d", (Analyzer)a, "a \"b c\" d");
        this.assertQueryEquals("\"a \\\"b c\\\" d\"", (Analyzer)a, "\"a \"b c\" d\"");
        this.assertQueryEquals("\"a \\+b c d\"", (Analyzer)a, "\"a +b c d\"");
        this.assertQueryEquals("c\\:\\\\temp\\\\\\~foo.txt", (Analyzer)a, "c:\\temp\\~foo.txt");
        this.assertParseException("XY\\");
        this.assertQueryEquals("a\\u0062c", (Analyzer)a, "abc");
        this.assertQueryEquals("XY\\u005a", (Analyzer)a, "XYZ");
        this.assertQueryEquals("XY\\u005A", (Analyzer)a, "XYZ");
        this.assertQueryEquals("\"a \\\\\\u0028\\u0062\\\" c\"", (Analyzer)a, "\"a \\(b\" c\"");
        this.assertParseException("XY\\u005G");
        this.assertParseException("XY\\u005");
        this.assertQueryEquals("(item:\\\\ item:ABCD\\\\)", (Analyzer)a, "item:\\ item:ABCD\\");
        this.assertParseException("(item:\\\\ item:ABCD\\\\))");
        this.assertQueryEquals("\\*", (Analyzer)a, "*");
        this.assertQueryEquals("\\\\", (Analyzer)a, "\\");
        this.assertParseException("\\");
        this.assertQueryEquals("(\"a\\\\\") or (\"b\")", (Analyzer)a, "a\\ or b");
    }

    public void testEscapedVsQuestionMarkAsWildcard() throws Exception {
        MockAnalyzer a = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false);
        this.assertQueryEquals("a:b\\-?c", (Analyzer)a, "a:b\\-?c");
        this.assertQueryEquals("a:b\\+?c", (Analyzer)a, "a:b\\+?c");
        this.assertQueryEquals("a:b\\:?c", (Analyzer)a, "a:b\\:?c");
        this.assertQueryEquals("a:b\\\\?c", (Analyzer)a, "a:b\\\\?c");
    }

    public void testQueryStringEscaping() throws Exception {
        MockAnalyzer a = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false);
        this.assertEscapedQueryEquals("a-b:c", (Analyzer)a, "a\\-b\\:c");
        this.assertEscapedQueryEquals("a+b:c", (Analyzer)a, "a\\+b\\:c");
        this.assertEscapedQueryEquals("a:b:c", (Analyzer)a, "a\\:b\\:c");
        this.assertEscapedQueryEquals("a\\b:c", (Analyzer)a, "a\\\\b\\:c");
        this.assertEscapedQueryEquals("a:b-c", (Analyzer)a, "a\\:b\\-c");
        this.assertEscapedQueryEquals("a:b+c", (Analyzer)a, "a\\:b\\+c");
        this.assertEscapedQueryEquals("a:b:c", (Analyzer)a, "a\\:b\\:c");
        this.assertEscapedQueryEquals("a:b\\c", (Analyzer)a, "a\\:b\\\\c");
        this.assertEscapedQueryEquals("a:b-c*", (Analyzer)a, "a\\:b\\-c\\*");
        this.assertEscapedQueryEquals("a:b+c*", (Analyzer)a, "a\\:b\\+c\\*");
        this.assertEscapedQueryEquals("a:b:c*", (Analyzer)a, "a\\:b\\:c\\*");
        this.assertEscapedQueryEquals("a:b\\\\c*", (Analyzer)a, "a\\:b\\\\\\\\c\\*");
        this.assertEscapedQueryEquals("a:b-?c", (Analyzer)a, "a\\:b\\-\\?c");
        this.assertEscapedQueryEquals("a:b+?c", (Analyzer)a, "a\\:b\\+\\?c");
        this.assertEscapedQueryEquals("a:b:?c", (Analyzer)a, "a\\:b\\:\\?c");
        this.assertEscapedQueryEquals("a:b?c", (Analyzer)a, "a\\:b\\?c");
        this.assertEscapedQueryEquals("a:b-c~", (Analyzer)a, "a\\:b\\-c\\~");
        this.assertEscapedQueryEquals("a:b+c~", (Analyzer)a, "a\\:b\\+c\\~");
        this.assertEscapedQueryEquals("a:b:c~", (Analyzer)a, "a\\:b\\:c\\~");
        this.assertEscapedQueryEquals("a:b\\c~", (Analyzer)a, "a\\:b\\\\c\\~");
        this.assertEscapedQueryEquals("[ a - TO a+ ]", null, "\\[ a \\- TO a\\+ \\]");
        this.assertEscapedQueryEquals("[ a : TO a~ ]", null, "\\[ a \\: TO a\\~ \\]");
        this.assertEscapedQueryEquals("[ a\\ TO a* ]", null, "\\[ a\\\\ TO a\\* \\]");
        this.assertEscapedQueryEquals("|| abc ||", (Analyzer)a, "\\|\\| abc \\|\\|");
        this.assertEscapedQueryEquals("&& abc &&", (Analyzer)a, "\\&\\& abc \\&\\&");
    }

    public void testTabNewlineCarriageReturn() throws Exception {
        this.assertQueryEqualsDOA("+weltbank +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\r+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\r\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r\n+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r\n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \r \n +worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("+weltbank\t+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \t+worlbank", null, "+weltbank +worlbank");
        this.assertQueryEqualsDOA("weltbank \t +worlbank", null, "+weltbank +worlbank");
    }

    public void testSimpleDAO() throws Exception {
        this.assertQueryEqualsDOA("term term term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term +term term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term term +term", null, "+term +term +term");
        this.assertQueryEqualsDOA("term +term +term", null, "+term +term +term");
        this.assertQueryEqualsDOA("-term term term", null, "-term +term +term");
    }

    public void testBoost() throws Exception {
        CharacterRunAutomaton stopWords = new CharacterRunAutomaton(Automata.makeString((String)"on"));
        MockAnalyzer oneStopAnalyzer = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.SIMPLE, true, stopWords);
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)oneStopAnalyzer);
        Query q = this.getQuery("on^1.0", qp);
        QueryParserTestBase.assertNotNull((Object)q);
        q = this.getQuery("\"hello\"^2.0", qp);
        QueryParserTestBase.assertNotNull((Object)q);
        QueryParserTestBase.assertEquals((double)((BoostQuery)q).getBoost(), (double)2.0, (double)0.5);
        q = this.getQuery("hello^2.0", qp);
        QueryParserTestBase.assertNotNull((Object)q);
        QueryParserTestBase.assertEquals((double)((BoostQuery)q).getBoost(), (double)2.0, (double)0.5);
        q = this.getQuery("\"on\"^1.0", qp);
        QueryParserTestBase.assertNotNull((Object)q);
        MockAnalyzer a2 = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.SIMPLE, true, MockTokenFilter.ENGLISH_STOPSET);
        CommonQueryParserConfiguration qp2 = this.getParserConfig((Analyzer)a2);
        q = this.getQuery("the^3", qp2);
        QueryParserTestBase.assertNotNull((Object)q);
        this.assertMatchNoDocsQuery(q);
        QueryParserTestBase.assertFalse((boolean)(q instanceof BoostQuery));
    }

    public void assertParseException(String queryString) throws Exception {
        block2: {
            try {
                this.getQuery(queryString);
            }
            catch (Exception expected) {
                if (!this.isQueryParserException(expected)) break block2;
                return;
            }
        }
        QueryParserTestBase.fail((String)"ParseException expected, not thrown");
    }

    public void assertParseException(String queryString, Analyzer a) throws Exception {
        block2: {
            try {
                this.getQuery(queryString, a);
            }
            catch (Exception expected) {
                if (!this.isQueryParserException(expected)) break block2;
                return;
            }
        }
        QueryParserTestBase.fail((String)"ParseException expected, not thrown");
    }

    public void testException() throws Exception {
        this.assertParseException("\"some phrase");
        this.assertParseException("(foo bar");
        this.assertParseException("foo bar))");
        this.assertParseException("field:term:with:colon some more terms");
        this.assertParseException("(sub query)^5.0^2.0 plus more");
        this.assertParseException("secret AND illegal) AND access:confidential");
    }

    public void testBooleanQuery() throws Exception {
        BooleanQuery.setMaxClauseCount((int)2);
        MockAnalyzer purWhitespaceAnalyzer = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false);
        this.assertParseException("one two three", (Analyzer)purWhitespaceAnalyzer);
    }

    public void testPrecedence() throws Exception {
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false));
        Query query1 = this.getQuery("A AND B OR C AND D", qp);
        Query query2 = this.getQuery("+A +B +C +D", qp);
        QueryParserTestBase.assertEquals((Object)query1, (Object)query2);
    }

    public abstract void testStarParsing() throws Exception;

    public void testEscapedWildcard() throws Exception {
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false));
        WildcardQuery q = new WildcardQuery(new Term("field", "foo\\?ba?r"));
        QueryParserTestBase.assertEquals((Object)q, (Object)this.getQuery("foo\\?ba?r", qp));
    }

    public void testRegexps() throws Exception {
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false));
        RegexpQuery q = new RegexpQuery(new Term("field", "[a-z][123]"));
        QueryParserTestBase.assertEquals((Object)q, (Object)this.getQuery("/[a-z][123]/", qp));
        qp.setLowercaseExpandedTerms(true);
        QueryParserTestBase.assertEquals((Object)q, (Object)this.getQuery("/[A-Z][123]/", qp));
        QueryParserTestBase.assertEquals((Object)new BoostQuery((Query)q, 0.5f), (Object)this.getQuery("/[A-Z][123]/^0.5", qp));
        qp.setMultiTermRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
        q.setRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_REWRITE);
        QueryParserTestBase.assertTrue((boolean)(this.getQuery("/[A-Z][123]/^0.5", qp) instanceof BoostQuery));
        QueryParserTestBase.assertTrue((boolean)(((BoostQuery)this.getQuery("/[A-Z][123]/^0.5", qp)).getQuery() instanceof RegexpQuery));
        QueryParserTestBase.assertEquals((Object)MultiTermQuery.SCORING_BOOLEAN_REWRITE, (Object)((RegexpQuery)((BoostQuery)this.getQuery("/[A-Z][123]/^0.5", qp)).getQuery()).getRewriteMethod());
        QueryParserTestBase.assertEquals((Object)new BoostQuery((Query)q, 0.5f), (Object)this.getQuery("/[A-Z][123]/^0.5", qp));
        qp.setMultiTermRewriteMethod(MultiTermQuery.CONSTANT_SCORE_REWRITE);
        RegexpQuery escaped = new RegexpQuery(new Term("field", "[a-z]\\/[123]"));
        QueryParserTestBase.assertEquals((Object)escaped, (Object)this.getQuery("/[a-z]\\/[123]/", qp));
        RegexpQuery escaped2 = new RegexpQuery(new Term("field", "[a-z]\\*[123]"));
        QueryParserTestBase.assertEquals((Object)escaped2, (Object)this.getQuery("/[a-z]\\*[123]/", qp));
        BooleanQuery.Builder complex = new BooleanQuery.Builder();
        complex.add((Query)new RegexpQuery(new Term("field", "[a-z]\\/[123]")), BooleanClause.Occur.MUST);
        complex.add((Query)new TermQuery(new Term("path", "/etc/init.d/")), BooleanClause.Occur.MUST);
        complex.add((Query)new TermQuery(new Term("field", "/etc/init[.]d/lucene/")), BooleanClause.Occur.SHOULD);
        QueryParserTestBase.assertEquals((Object)complex.build(), (Object)this.getQuery("/[a-z]\\/[123]/ AND path:\"/etc/init.d/\" OR \"/etc\\/init\\[.\\]d/lucene/\" ", qp));
        RegexpQuery re = new RegexpQuery(new Term("field", "http.*"));
        QueryParserTestBase.assertEquals((Object)re, (Object)this.getQuery("field:/http.*/", qp));
        QueryParserTestBase.assertEquals((Object)re, (Object)this.getQuery("/http.*/", qp));
        re = new RegexpQuery(new Term("field", "http~0.5"));
        QueryParserTestBase.assertEquals((Object)re, (Object)this.getQuery("field:/http~0.5/", qp));
        QueryParserTestBase.assertEquals((Object)re, (Object)this.getQuery("/http~0.5/", qp));
        re = new RegexpQuery(new Term("field", "boo"));
        QueryParserTestBase.assertEquals((Object)re, (Object)this.getQuery("field:/boo/", qp));
        QueryParserTestBase.assertEquals((Object)re, (Object)this.getQuery("/boo/", qp));
        QueryParserTestBase.assertEquals((Object)new TermQuery(new Term("field", "/boo/")), (Object)this.getQuery("\"/boo/\"", qp));
        QueryParserTestBase.assertEquals((Object)new TermQuery(new Term("field", "/boo/")), (Object)this.getQuery("\\/boo\\/", qp));
        BooleanQuery.Builder two = new BooleanQuery.Builder();
        two.add((Query)new RegexpQuery(new Term("field", "foo")), BooleanClause.Occur.SHOULD);
        two.add((Query)new RegexpQuery(new Term("field", "bar")), BooleanClause.Occur.SHOULD);
        QueryParserTestBase.assertEquals((Object)two.build(), (Object)this.getQuery("field:/foo/ field:/bar/", qp));
        QueryParserTestBase.assertEquals((Object)two.build(), (Object)this.getQuery("/foo/ /bar/", qp));
    }

    public void testStopwords() throws Exception {
        CharacterRunAutomaton stopSet = new CharacterRunAutomaton(new RegExp("the|foo").toAutomaton());
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.SIMPLE, true, stopSet));
        Query result = this.getQuery("field:the OR field:foo", qp);
        QueryParserTestBase.assertNotNull((String)"result is null and it shouldn't be", (Object)result);
        QueryParserTestBase.assertTrue((String)"result is not a BooleanQuery", (result instanceof BooleanQuery || result instanceof MatchNoDocsQuery ? 1 : 0) != 0);
        if (result instanceof BooleanQuery) {
            QueryParserTestBase.assertEquals((long)0L, (long)((BooleanQuery)result).clauses().size());
        }
        result = this.getQuery("field:woo OR field:the", qp);
        QueryParserTestBase.assertNotNull((String)"result is null and it shouldn't be", (Object)result);
        QueryParserTestBase.assertTrue((String)"result is not a TermQuery", (boolean)(result instanceof TermQuery));
        result = this.getQuery("(fieldX:xxxxx OR fieldy:xxxxxxxx)^2 AND (fieldx:the OR fieldy:foo)", qp);
        QueryParserTestBase.assertNotNull((String)"result is null and it shouldn't be", (Object)result);
        QueryParserTestBase.assertTrue((String)"result is not a BoostQuery", (boolean)(result instanceof BoostQuery));
        result = ((BoostQuery)result).getQuery();
        QueryParserTestBase.assertTrue((String)"result is not a BooleanQuery", (boolean)(result instanceof BooleanQuery));
        if (VERBOSE) {
            System.out.println("Result: " + result);
        }
        QueryParserTestBase.assertTrue((String)(((BooleanQuery)result).clauses().size() + " does not equal: " + 2), (((BooleanQuery)result).clauses().size() == 2 ? 1 : 0) != 0);
    }

    public void testPositionIncrement() throws Exception {
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.SIMPLE, true, MockTokenFilter.ENGLISH_STOPSET));
        qp.setEnablePositionIncrements(true);
        String qtxt = "\"the words in poisitions pos02578 are stopped in this phrasequery\"";
        int[] expectedPositions = new int[]{1, 3, 4, 6, 9};
        PhraseQuery pq = (PhraseQuery)this.getQuery(qtxt, qp);
        Term[] t = pq.getTerms();
        int[] pos = pq.getPositions();
        for (int i = 0; i < t.length; ++i) {
            QueryParserTestBase.assertEquals((String)("term " + i + " = " + t[i] + " has wrong term-position!"), (long)expectedPositions[i], (long)pos[i]);
        }
    }

    public void testMatchAllDocs() throws Exception {
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false));
        QueryParserTestBase.assertEquals((Object)new MatchAllDocsQuery(), (Object)this.getQuery("*:*", qp));
        QueryParserTestBase.assertEquals((Object)new MatchAllDocsQuery(), (Object)this.getQuery("(*:*)", qp));
        BooleanQuery bq = (BooleanQuery)this.getQuery("+*:* -*:*", qp);
        QueryParserTestBase.assertEquals((long)2L, (long)bq.clauses().size());
        for (BooleanClause clause : bq) {
            QueryParserTestBase.assertTrue((boolean)(clause.getQuery() instanceof MatchAllDocsQuery));
        }
    }

    private void assertHits(int expected, String query, IndexSearcher is) throws Exception {
        String oldDefaultField = this.getDefaultField();
        this.setDefaultField("date");
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false));
        qp.setLocale(Locale.ENGLISH);
        Query q = this.getQuery(query, qp);
        ScoreDoc[] hits = is.search((Query)q, (int)1000).scoreDocs;
        QueryParserTestBase.assertEquals((long)expected, (long)hits.length);
        this.setDefaultField(oldDefaultField);
    }

    public void tearDown() throws Exception {
        BooleanQuery.setMaxClauseCount((int)this.originalMaxClauses);
        super.tearDown();
    }

    public void testPositionIncrements() throws Exception {
        BaseDirectoryWrapper dir = QueryParserTestBase.newDirectory();
        MockAnalyzer a = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.SIMPLE, true, MockTokenFilter.ENGLISH_STOPSET);
        IndexWriter w = new IndexWriter((Directory)dir, QueryParserTestBase.newIndexWriterConfig((Analyzer)a));
        Document doc = new Document();
        doc.add((IndexableField)QueryParserTestBase.newTextField((String)"field", (String)"the wizard of ozzy", (Field.Store)Field.Store.NO));
        w.addDocument((Iterable)doc);
        DirectoryReader r = DirectoryReader.open((IndexWriter)w);
        w.close();
        IndexSearcher s = QueryParserTestBase.newSearcher((IndexReader)r);
        Query q = this.getQuery("\"wizard of ozzy\"", (Analyzer)a);
        QueryParserTestBase.assertEquals((long)1L, (long)s.search((Query)q, (int)1).totalHits);
        r.close();
        dir.close();
    }

    public abstract void testNewFieldQuery() throws Exception;

    public void testCollatedRange() throws Exception {
        CommonQueryParserConfiguration qp = this.getParserConfig(new MockCollationAnalyzer());
        this.setAnalyzeRangeTerms(qp, true);
        TermRangeQuery expected = TermRangeQuery.newStringRange((String)this.getDefaultField(), (String)"collatedabc", (String)"collateddef", (boolean)true, (boolean)true);
        Query actual = this.getQuery("[abc TO def]", qp);
        QueryParserTestBase.assertEquals((Object)expected, (Object)actual);
    }

    public void testDistanceAsEditsParsing() throws Exception {
        FuzzyQuery q = (FuzzyQuery)this.getQuery("foobar~2", (Analyzer)new MockAnalyzer(QueryParserTestBase.random()));
        QueryParserTestBase.assertEquals((long)2L, (long)q.getMaxEdits());
    }

    public void testPhraseQueryToString() throws Exception {
        MockAnalyzer analyzer = new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.SIMPLE, true, MockTokenFilter.ENGLISH_STOPSET);
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)analyzer);
        qp.setEnablePositionIncrements(true);
        PhraseQuery q = (PhraseQuery)this.getQuery("\"this hi this is a test is\"", qp);
        QueryParserTestBase.assertEquals((Object)"field:\"? hi ? ? ? test\"", (Object)q.toString());
    }

    public void testParseWildcardAndPhraseQueries() throws Exception {
        Query q;
        int j;
        int i;
        String field = "content";
        String oldDefaultField = this.getDefaultField();
        this.setDefaultField(field);
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random()));
        qp.setAllowLeadingWildcard(true);
        String[][] prefixQueries = new String[][]{{"a*", "ab*", "abc*"}, {"h*", "hi*", "hij*", "\\\\7*"}, {"o*", "op*", "opq*", "\\\\\\\\*"}};
        String[][] wildcardQueries = new String[][]{{"*a*", "*ab*", "*abc**", "ab*e*", "*g?", "*f?1", "abc**"}, {"*h*", "*hi*", "*hij**", "hi*k*", "*n?", "*m?1", "hij**"}, {"*o*", "*op*", "*opq**", "op*q*", "*u?", "*t?1", "opq**"}};
        for (i = 0; i < prefixQueries.length; ++i) {
            for (j = 0; j < prefixQueries[i].length; ++j) {
                String queryString = prefixQueries[i][j];
                q = this.getQuery(queryString, qp);
                QueryParserTestBase.assertEquals(PrefixQuery.class, q.getClass());
            }
        }
        for (i = 0; i < wildcardQueries.length; ++i) {
            for (j = 0; j < wildcardQueries[i].length; ++j) {
                String qtxt = wildcardQueries[i][j];
                q = this.getQuery(qtxt, qp);
                QueryParserTestBase.assertEquals(WildcardQuery.class, q.getClass());
            }
        }
        this.setDefaultField(oldDefaultField);
    }

    public void testPhraseQueryPositionIncrements() throws Exception {
        CharacterRunAutomaton stopStopList = new CharacterRunAutomaton(new RegExp("[sS][tT][oO][pP]").toAutomaton());
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random(), MockTokenizer.WHITESPACE, false, stopStopList));
        qp.setEnablePositionIncrements(true);
        PhraseQuery.Builder phraseQuery = new PhraseQuery.Builder();
        phraseQuery.add(new Term("field", "1"));
        phraseQuery.add(new Term("field", "2"), 2);
        QueryParserTestBase.assertEquals((Object)phraseQuery.build(), (Object)this.getQuery("\"1 stop 2\"", qp));
    }

    public void testMatchAllQueryParsing() throws Exception {
        String oldDefaultField = this.getDefaultField();
        this.setDefaultField("key");
        CommonQueryParserConfiguration qp = this.getParserConfig((Analyzer)new MockAnalyzer(QueryParserTestBase.random()));
        QueryParserTestBase.assertEquals((Object)new MatchAllDocsQuery(), (Object)this.getQuery(new MatchAllDocsQuery().toString(), qp));
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        query = new BoostQuery((Query)query, 2.3f);
        QueryParserTestBase.assertEquals((Object)query, (Object)this.getQuery(query.toString(), qp));
        this.setDefaultField(oldDefaultField);
    }

    public void testNestedAndClausesFoo() throws Exception {
        String query = "(field1:[1 TO *] AND field1:[* TO 2]) AND field2:(z)";
        BooleanQuery.Builder q = new BooleanQuery.Builder();
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        bq.add((Query)TermRangeQuery.newStringRange((String)"field1", (String)"1", null, (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        bq.add((Query)TermRangeQuery.newStringRange((String)"field1", null, (String)"2", (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        q.add((Query)bq.build(), BooleanClause.Occur.MUST);
        q.add((Query)new TermQuery(new Term("field2", "z")), BooleanClause.Occur.MUST);
        QueryParserTestBase.assertEquals((Object)q.build(), (Object)this.getQuery(query, (Analyzer)new MockAnalyzer(QueryParserTestBase.random())));
    }

    private static class MockCollationAnalyzer
    extends Analyzer {
        private MockCollationAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new MockCollationFilter((TokenStream)tokenizer));
        }

        protected TokenStream normalize(String fieldName, TokenStream in) {
            return new MockCollationFilter(in);
        }
    }

    private static class MockCollationFilter
    extends TokenFilter {
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

        protected MockCollationFilter(TokenStream input) {
            super(input);
        }

        public boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                String term = this.termAtt.toString();
                this.termAtt.setEmpty().append("collated").append(term);
                return true;
            }
            return false;
        }
    }

    protected static class Analyzer2
    extends Analyzer {
        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            return new Analyzer.TokenStreamComponents((Tokenizer)new MockTokenizer(MockTokenizer.WHITESPACE, true));
        }
    }

    protected static class Analyzer1
    extends Analyzer {
        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new MockSynonymFilter((TokenStream)tokenizer));
        }
    }

    private static class SimpleCJKAnalyzer
    extends Analyzer {
        private SimpleCJKAnalyzer() {
        }

        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            return new Analyzer.TokenStreamComponents((Tokenizer)new SimpleCJKTokenizer());
        }
    }

    protected static class SimpleCJKTokenizer
    extends Tokenizer {
        private CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

        public final boolean incrementToken() throws IOException {
            int ch = this.input.read();
            if (ch < 0) {
                return false;
            }
            this.clearAttributes();
            this.termAtt.setEmpty().append((char)ch);
            return true;
        }
    }

    public static final class QPTestAnalyzer
    extends Analyzer {
        public Analyzer.TokenStreamComponents createComponents(String fieldName) {
            MockTokenizer tokenizer = new MockTokenizer(MockTokenizer.SIMPLE, true);
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new QPTestFilter((TokenStream)tokenizer));
        }
    }

    public static final class QPTestFilter
    extends TokenFilter {
        CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        boolean inPhrase = false;
        int savedStart = 0;
        int savedEnd = 0;

        public QPTestFilter(TokenStream in) {
            super(in);
        }

        public boolean incrementToken() throws IOException {
            if (this.inPhrase) {
                this.inPhrase = false;
                this.clearAttributes();
                this.termAtt.append("phrase2");
                this.offsetAtt.setOffset(this.savedStart, this.savedEnd);
                return true;
            }
            while (this.input.incrementToken()) {
                if (this.termAtt.toString().equals("phrase")) {
                    this.inPhrase = true;
                    this.savedStart = this.offsetAtt.startOffset();
                    this.savedEnd = this.offsetAtt.endOffset();
                    this.termAtt.setEmpty().append("phrase1");
                    this.offsetAtt.setOffset(this.savedStart, this.savedEnd);
                    return true;
                }
                if (this.termAtt.toString().equals("stop")) continue;
                return true;
            }
            return false;
        }
    }
}

