/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LegacyIntField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.xml.TestCoreParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.LuceneTestCase;

class CoreParserTestIndexData
implements Closeable {
    final Directory dir;
    final IndexReader reader;
    final IndexSearcher searcher;

    CoreParserTestIndexData(Analyzer analyzer) throws Exception {
        BufferedReader d = new BufferedReader(new InputStreamReader(TestCoreParser.class.getResourceAsStream("reuters21578.txt"), StandardCharsets.US_ASCII));
        this.dir = LuceneTestCase.newDirectory();
        IndexWriter writer = new IndexWriter(this.dir, LuceneTestCase.newIndexWriterConfig((Analyzer)analyzer));
        String line = d.readLine();
        while (line != null) {
            int endOfDate = line.indexOf(9);
            String date = line.substring(0, endOfDate).trim();
            String content = line.substring(endOfDate).trim();
            Document doc = new Document();
            doc.add((IndexableField)LuceneTestCase.newTextField((String)"date", (String)date, (Field.Store)Field.Store.YES));
            doc.add((IndexableField)LuceneTestCase.newTextField((String)"contents", (String)content, (Field.Store)Field.Store.YES));
            doc.add((IndexableField)new LegacyIntField("date2", Integer.parseInt(date), Field.Store.NO));
            doc.add((IndexableField)new IntPoint("date3", new int[]{Integer.parseInt(date)}));
            writer.addDocument((Iterable)doc);
            line = d.readLine();
        }
        d.close();
        writer.close();
        this.reader = DirectoryReader.open((Directory)this.dir);
        this.searcher = LuceneTestCase.newSearcher((IndexReader)this.reader, (boolean)false);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.dir.close();
    }
}

