/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.xml;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenFilter;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.xml.CoreParser;
import org.apache.lucene.queryparser.xml.CoreParserTestIndexData;
import org.apache.lucene.queryparser.xml.ParserException;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.LuceneTestCase;
import org.junit.AfterClass;
import org.xml.sax.SAXException;

public class TestCoreParser
extends LuceneTestCase {
    private static final String defaultField = "contents";
    private static Analyzer analyzer;
    private static CoreParser coreParser;
    private static CoreParserTestIndexData indexData;

    protected Analyzer newAnalyzer() {
        return new MockAnalyzer(TestCoreParser.random(), MockTokenizer.WHITESPACE, true, MockTokenFilter.ENGLISH_STOPSET);
    }

    protected CoreParser newCoreParser(String defaultField, Analyzer analyzer) {
        return new CoreParser(defaultField, analyzer);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (indexData != null) {
            indexData.close();
            indexData = null;
        }
        coreParser = null;
        analyzer = null;
    }

    public void testTermQueryXML() throws ParserException, IOException {
        Query q = this.parse("TermQuery.xml");
        this.dumpResults("TermQuery", q, 5);
    }

    public void test_DOCTYPE_TermQueryXML() throws ParserException, IOException {
        SAXException saxe = (SAXException)LuceneTestCase.expectThrows(ParserException.class, SAXException.class, () -> this.parse("DOCTYPE_TermQuery.xml"));
        TestCoreParser.assertTrue((boolean)saxe.getMessage().startsWith("External Entity resolving unsupported:"));
    }

    public void test_ENTITY_TermQueryXML() throws ParserException, IOException {
        SAXException saxe = (SAXException)LuceneTestCase.expectThrows(ParserException.class, SAXException.class, () -> this.parse("ENTITY_TermQuery.xml"));
        TestCoreParser.assertTrue((boolean)saxe.getMessage().startsWith("External Entity resolving unsupported:"));
    }

    public void testTermQueryEmptyXML() throws ParserException, IOException {
        this.parseShouldFail("TermQueryEmpty.xml", "TermQuery has no text");
    }

    public void testTermsQueryXML() throws ParserException, IOException {
        Query q = this.parse("TermsQuery.xml");
        this.dumpResults("TermsQuery", q, 5);
    }

    public void testBooleanQueryXML() throws ParserException, IOException {
        Query q = this.parse("BooleanQuery.xml");
        this.dumpResults("BooleanQuery", q, 5);
    }

    public void testDisjunctionMaxQueryXML() throws ParserException, IOException {
        Query q = this.parse("DisjunctionMaxQuery.xml");
        TestCoreParser.assertTrue((boolean)(q instanceof DisjunctionMaxQuery));
        DisjunctionMaxQuery d = (DisjunctionMaxQuery)q;
        TestCoreParser.assertEquals((double)0.0, (double)d.getTieBreakerMultiplier(), (double)1.0E-4f);
        TestCoreParser.assertEquals((long)2L, (long)d.getDisjuncts().size());
        DisjunctionMaxQuery ndq = (DisjunctionMaxQuery)d.getDisjuncts().get(1);
        TestCoreParser.assertEquals((double)1.2f, (double)ndq.getTieBreakerMultiplier(), (double)1.0E-4f);
        TestCoreParser.assertEquals((long)1L, (long)ndq.getDisjuncts().size());
    }

    public void testRangeQueryXML() throws ParserException, IOException {
        Query q = this.parse("RangeQuery.xml");
        this.dumpResults("RangeQuery", q, 5);
    }

    public void testUserQueryXML() throws ParserException, IOException {
        Query q = this.parse("UserInputQuery.xml");
        this.dumpResults("UserInput with Filter", q, 5);
    }

    public void testCustomFieldUserQueryXML() throws ParserException, IOException {
        Query q = this.parse("UserInputQueryCustomField.xml");
        int h = this.searcher().search((Query)q, (int)1000).totalHits;
        TestCoreParser.assertEquals((String)"UserInputQueryCustomField should produce 0 result ", (long)0L, (long)h);
    }

    public void testBoostingTermQueryXML() throws Exception {
        Query q = this.parse("BoostingTermQuery.xml");
        this.dumpResults("BoostingTermQuery", q, 5);
    }

    public void testSpanTermXML() throws Exception {
        Query q = this.parse("SpanQuery.xml");
        this.dumpResults("Span Query", q, 5);
        SpanQuery sq = this.parseAsSpan("SpanQuery.xml");
        this.dumpResults("Span Query", (Query)sq, 5);
        TestCoreParser.assertEquals((Object)q, (Object)sq);
    }

    public void testConstantScoreQueryXML() throws Exception {
        Query q = this.parse("ConstantScoreQuery.xml");
        this.dumpResults("ConstantScoreQuery", q, 5);
    }

    public void testMatchAllDocsPlusFilterXML() throws ParserException, IOException {
        Query q = this.parse("MatchAllDocsQuery.xml");
        this.dumpResults("MatchAllDocsQuery with range filter", q, 5);
    }

    public void testNestedBooleanQuery() throws ParserException, IOException {
        Query q = this.parse("NestedBooleanQuery.xml");
        this.dumpResults("Nested Boolean query", q, 5);
    }

    public void testNumericRangeQueryXML() throws ParserException, IOException {
        Query q = this.parse("LegacyNumericRangeQuery.xml");
        this.dumpResults("LegacyNumericRangeQuery", q, 5);
    }

    public void testNumericRangeQueryXMLWithoutLowerTerm() throws ParserException, IOException {
        Query q = this.parse("LegacyNumericRangeQueryWithoutLowerTerm.xml");
        this.dumpResults("LegacyNumericRangeQueryWithoutLowerTerm", q, 5);
    }

    public void testNumericRangeQueryXMLWithoutUpperTerm() throws ParserException, IOException {
        Query q = this.parse("LegacyNumericRangeQueryWithoutUpperTerm.xml");
        this.dumpResults("LegacyNumericRangeQueryWithoutUpperTerm", q, 5);
    }

    public void testNumericRangeQueryXMLWithoutRange() throws ParserException, IOException {
        Query q = this.parse("LegacyNumericRangeQueryWithoutRange.xml");
        this.dumpResults("LegacyNumericRangeQueryWithoutRange", q, 5);
    }

    public void testPointRangeQuery() throws ParserException, IOException {
        Query q = this.parse("PointRangeQuery.xml");
        this.dumpResults("PointRangeQuery", q, 5);
    }

    public void testPointRangeQueryWithoutLowerTerm() throws ParserException, IOException {
        Query q = this.parse("PointRangeQueryWithoutLowerTerm.xml");
        this.dumpResults("PointRangeQueryWithoutLowerTerm", q, 5);
    }

    public void testPointRangeQueryWithoutUpperTerm() throws ParserException, IOException {
        Query q = this.parse("PointRangeQueryWithoutUpperTerm.xml");
        this.dumpResults("PointRangeQueryWithoutUpperTerm", q, 5);
    }

    public void testPointRangeQueryWithoutRange() throws ParserException, IOException {
        Query q = this.parse("PointRangeQueryWithoutRange.xml");
        this.dumpResults("PointRangeQueryWithoutRange", q, 5);
    }

    protected String defaultField() {
        return defaultField;
    }

    protected Analyzer analyzer() {
        if (analyzer == null) {
            analyzer = this.newAnalyzer();
        }
        return analyzer;
    }

    protected CoreParser coreParser() {
        if (coreParser == null) {
            coreParser = this.newCoreParser(defaultField, this.analyzer());
        }
        return coreParser;
    }

    private CoreParserTestIndexData indexData() {
        if (indexData == null) {
            try {
                indexData = new CoreParserTestIndexData(this.analyzer());
            }
            catch (Exception e) {
                TestCoreParser.fail((String)("caught Exception " + e));
            }
        }
        return indexData;
    }

    protected IndexReader reader() {
        return this.indexData().reader;
    }

    protected IndexSearcher searcher() {
        return this.indexData().searcher;
    }

    protected void parseShouldFail(String xmlFileName, String expectedParserExceptionMessage) throws IOException {
        Query q = null;
        ParserException pe = null;
        try {
            q = this.parse(xmlFileName);
        }
        catch (ParserException e) {
            pe = e;
        }
        TestCoreParser.assertNull((String)("for " + xmlFileName + " unexpectedly got " + q), (Object)q);
        TestCoreParser.assertNotNull((String)("expected a ParserException for " + xmlFileName), (Object)((Object)pe));
        TestCoreParser.assertEquals((String)("expected different ParserException for " + xmlFileName), (Object)expectedParserExceptionMessage, (Object)pe.getMessage());
    }

    protected Query parse(String xmlFileName) throws ParserException, IOException {
        return this.implParse(xmlFileName, false);
    }

    protected SpanQuery parseAsSpan(String xmlFileName) throws ParserException, IOException {
        return (SpanQuery)this.implParse(xmlFileName, true);
    }

    private Query implParse(String xmlFileName, boolean span) throws ParserException, IOException {
        try (InputStream xmlStream = TestCoreParser.class.getResourceAsStream(xmlFileName);){
            TestCoreParser.assertNotNull((String)("Test XML file " + xmlFileName + " cannot be found"), (Object)xmlStream);
            if (span) {
                SpanQuery spanQuery = this.coreParser().parseAsSpanQuery(xmlStream);
                return spanQuery;
            }
            Query query = this.coreParser().parse(xmlStream);
            return query;
        }
    }

    protected Query rewrite(Query q) throws IOException {
        return q.rewrite(this.reader());
    }

    protected void dumpResults(String qType, Query q, int numDocs) throws IOException {
        boolean producedResults;
        if (VERBOSE) {
            System.out.println("TEST: qType=" + qType + " numDocs=" + numDocs + " " + q.getClass().getCanonicalName() + " query=" + q);
        }
        IndexSearcher searcher = this.searcher();
        TopDocs hits = searcher.search(q, numDocs);
        boolean bl = producedResults = hits.totalHits > 0;
        if (!producedResults) {
            System.out.println("TEST: qType=" + qType + " numDocs=" + numDocs + " " + q.getClass().getCanonicalName() + " query=" + q);
        }
        if (VERBOSE) {
            ScoreDoc[] scoreDocs = hits.scoreDocs;
            for (int i = 0; i < Math.min(numDocs, hits.totalHits); ++i) {
                Document ldoc = searcher.doc(scoreDocs[i].doc);
                System.out.println("[" + ldoc.get("date") + "]" + ldoc.get(defaultField));
            }
            System.out.println();
        }
        TestCoreParser.assertTrue((String)(qType + " produced no results"), (boolean)producedResults);
    }
}

